/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.recovery;

import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.Log_utilsKt;
import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.common.extensions.CollectionExtensionsKt;
import com.jetbrains.toolbox.common.io.FileSize;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.ChannelBackupEntry;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.recovery.RecoveryManager;
import com.jetbrains.toolbox.tools.recovery.State;
import com.jetbrains.toolbox.tools.recovery.StateFile;
import java.io.Closeable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ExceptionsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.datetime.Clock;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nRecoveryManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecoveryManagerImpl.kt\ncom/jetbrains/toolbox/tools/recovery/RecoveryManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 catching.kt\ncom/jetbrains/toolbox/common/concurrent/CatchingKt\n+ 5 Okio.kt\nokio/Okio__OkioKt\n+ 6 FileSystem.kt\nokio/FileSystem\n+ 7 OkioStreams.kt\nkotlinx/serialization/json/okio/OkioStreamsKt\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,217:1\n774#2:218\n865#2,2:219\n774#2:221\n865#2,2:222\n1563#2:224\n1634#2,3:225\n1563#2:228\n1634#2,3:229\n1869#2,2:232\n1208#2,2:234\n1236#2,4:236\n1634#2,3:240\n1617#2,9:244\n1869#2:253\n1870#2:286\n1626#2:287\n1563#2:290\n1634#2,3:291\n1#3:243\n1#3:285\n7#4,2:254\n9#4,5:280\n66#5:256\n52#5,4:258\n60#5,10:264\n56#5,3:274\n71#5,3:277\n67#6:257\n68#6:262\n78#7:263\n1321#8,2:288\n*S KotlinDebug\n*F\n+ 1 RecoveryManagerImpl.kt\ncom/jetbrains/toolbox/tools/recovery/RecoveryManagerImpl\n*L\n42#1:218\n42#1:219,2\n44#1:221\n44#1:222,2\n50#1:224\n50#1:225,3\n51#1:228\n51#1:229,3\n52#1:232,2\n54#1:234,2\n54#1:236,4\n55#1:240,3\n67#1:244,9\n67#1:253\n67#1:286\n67#1:287\n48#1:290\n48#1:291,3\n67#1:285\n68#1:254,2\n68#1:280,5\n70#1:256\n70#1:258,4\n70#1:264,10\n70#1:274,3\n70#1:277,3\n70#1:257\n70#1:262\n70#1:263\n197#1:288,2\n*E\n"})
public final class RecoveryManagerImpl
implements ChannelStateWorker<ChannelState.Recovering>,
RecoveryManager {
    @NotNull
    private final Path directory;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ConcurrentHashMap<Path, StateFile> parsedStateFiles;

    public RecoveryManagerImpl(@NotNull Path directory, @NotNull FileSystem fileSystem, @NotNull FileUtils fileUtils, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.directory = directory;
        this.fileSystem = fileSystem;
        this.fileUtils = fileUtils;
        this.clock = clock;
        this.parsedStateFiles = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public KClass<ChannelState.Recovering> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.Recovering.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<Path> retain(@NotNull Collection<Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        List retainedUnpackedDirectories = CollectionsKt.emptyList();
        try {
            void destination$iv;
            void $this$mapTo$iv;
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv;
            Iterable $this$forEach$iv;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object object2;
            void $this$mapTo$iv$iv2;
            StateFile it;
            Iterable $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            List list2 = this.fileSystem.listOrNull(this.directory);
            if (list2 == null || (list2 = (List)CollectionExtensionsKt.getNullIfEmpty((Collection)list2)) == null) {
                Set set2 = SetsKt.emptySet();
                return set2;
            }
            List allFiles = list2;
            Iterable $this$filter$iv = allFiles;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Path it2 = (Path)element$iv$iv;
                boolean bl = false;
                if (!(StringsKt.endsWith$default((String)it2.name(), (String)".state.json", (boolean)false, (int)2, null) && this.fileSystem.metadata(it2).isRegularFile())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List stateFiles = (List)destination$iv$iv;
            List<StateFile> parsedFiles = this.parse(stateFiles);
            Iterable $this$filter$iv2 = parsedFiles;
            boolean $i$f$filter2 = false;
            Iterable $i$f$filterTo22 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (StateFile)element$iv$iv;
                boolean bl = false;
                if (!paths.contains(it.getState().getInstallationDirectory())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List retained = (List)destination$iv$iv2;
            if (retained.isEmpty()) {
                Logger.INSTANCE.info(RecoveryManagerImpl::retain$lambda$2);
            } else {
                Logger.INSTANCE.warn(() -> RecoveryManagerImpl.retain$lambda$3(retained));
            }
            Iterable $this$map$iv2 = retained;
            boolean $i$f$map22 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (StateFile)item$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl = false;
                object2.add(it.getState().getUnpackedDirectory());
            }
            retainedUnpackedDirectories = (List)destination$iv$iv2;
            Iterable $i$f$map22 = retained;
            object2 = allFiles;
            boolean $i$f$map32 = false;
            destination$iv$iv2 = $this$map$iv;
            Object destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                StateFile bl = (StateFile)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl2 = false;
                object.add(it3.getPath());
            }
            List obsoleteFiles = CollectionsKt.minus(object2, (Iterable)((List)destination$iv$iv3));
            $this$map$iv = obsoleteFiles;
            FileSystem $i$f$map32 = this.fileSystem;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path p0 = (Path)element$iv;
                boolean bl = false;
                $i$f$map32.delete(p0);
            }
            $this$forEach$iv = parsedFiles;
            object2 = this.parsedStateFiles;
            boolean $i$f$associateBy22 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv3 = $this$associateBy$iv;
            Map destination$iv$iv4 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it4;
                StateFile bl2 = (StateFile)element$iv$iv;
                object = destination$iv$iv4;
                boolean bl = false;
                object.put(it4.getState().getInstallationDirectory(), element$iv$iv);
            }
            ((ConcurrentHashMap)object2).putAll(destination$iv$iv4);
            $this$associateBy$iv = retained;
            Collection $i$f$associateBy22 = new LinkedHashSet();
            boolean $i$f$mapTo3 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it5;
                StateFile $i$f$associateByTo2 = (StateFile)item$iv;
                object2 = destination$iv;
                boolean bl = false;
                object2.add(it5.getState().getInstallationDirectory());
            }
            Set set3 = (Set)destination$iv;
            return set3;
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to parse recovery data");
            Set set4 = SetsKt.emptySet();
            return set4;
        }
        finally {
            this.fileUtils.retain(retainedUnpackedDirectories);
        }
    }

    @Override
    @Nullable
    public StateFile getStateFile(@NotNull Path installationDirectory) {
        StateFile stateFile;
        Intrinsics.checkNotNullParameter((Object)installationDirectory, (String)"installationDirectory");
        StateFile stateFile2 = this.parsedStateFiles.get(installationDirectory);
        if (stateFile2 != null) {
            StateFile stateFile3;
            StateFile it = stateFile3 = stateFile2;
            boolean bl = false;
            stateFile = this.fileSystem.exists(it.getPath()) ? stateFile3 : null;
        } else {
            stateFile = null;
        }
        return stateFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List<StateFile> parse(List<Path> stateFiles) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = stateFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            StateFile it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path stateFile = (Path)element$iv$iv;
            boolean bl2 = false;
            boolean $i$f$catching = false;
            try {
                State state2;
                Throwable thrown$iv$iv;
                block20: {
                    void this_$iv;
                    boolean bl3 = false;
                    FileSystem fileSystem = this.fileSystem;
                    Path file$iv = stateFile;
                    boolean bl4 = false;
                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
                    boolean $i$f$use = false;
                    thrown$iv$iv = null;
                    try {
                        void $this$decodeFromBufferedSource$iv;
                        BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                        boolean bl5 = false;
                        BufferedSource $this$parse_u24lambda_u240_u240_u240 = it$iv;
                        boolean bl6 = false;
                        Json json2 = JsonKt.getJsonx();
                        BufferedSource source$iv = $this$parse_u24lambda_u240_u240_u240;
                        boolean $i$f$decodeFromBufferedSource = false;
                        $this$decodeFromBufferedSource$iv.getSerializersModule();
                        state2 = (State)OkioStreamsKt.decodeFromBufferedSource((Json)$this$decodeFromBufferedSource$iv, (DeserializationStrategy)((DeserializationStrategy)State.Companion.serializer()), (BufferedSource)source$iv);
                    }
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv = t$iv$iv;
                            state2 = null;
                            break block20;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            block21: {
                                try {
                                    Closeable closeable = $this$use$iv$iv;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv$iv2) {
                                    if (thrown$iv$iv == null) {
                                        thrown$iv$iv = t$iv$iv2;
                                        break block21;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                }
                State result$iv$iv = state2;
                Throwable throwable = thrown$iv$iv;
                if (throwable != null) {
                    throw throwable;
                }
                State state3 = result$iv$iv;
                object = Result.constructor-impl((Object)new StateFile(stateFile, state3));
            }
            catch (CancellationException c$iv) {
                throw c$iv;
            }
            catch (Throwable t$iv) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)t$iv));
            }
            Object object2 = object;
            if (Result.exceptionOrNull-impl((Object)object2) != null) {
                Throwable throwable;
                Throwable it = throwable;
                boolean bl7 = false;
                Logger.INSTANCE.error(it, "Parsing of '" + stateFile + "' has failed.");
            }
            if ((StateFile)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.Recovering state2, @NotNull Continuation<? super ChannelEvent> $completion) {
        return Log_utilsKt.withAppendedLogPrefix(state2.getChannel().getInstallationDirectory().toString(), (Function2)new Function2<CoroutineScope, Continuation<? super ChannelEvent>, Object>(this, state2, null){
            int label;
            final /* synthetic */ RecoveryManagerImpl this$0;
            final /* synthetic */ ChannelState.Recovering $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        stateFile = (StateFile)RecoveryManagerImpl.access$getParsedStateFiles$p(this.this$0).get(this.$state.getChannel().getInstallationDirectory());
                        if (stateFile != null) ** GOTO lbl11
                        Logger.INSTANCE.error((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(), ()Ljava/lang/String;)());
                        v0 = new ChannelEvent.Failed(null, 1, null);
                        ** GOTO lbl66
lbl11:
                        // 1 sources

                        try {
                            unpackedDirectory = stateFile.getState().getUnpackedDirectory();
                            stage = RecoveryManagerImpl.access$recoverFrom(this.this$0, stateFile.getState());
                            v1 = Logger.INSTANCE;
                            v2 = stage;
                            if (v2 != null) {
                                var6_6 = v2;
                                var15_8 = v1;
                                $i$a$-let-RecoveryManagerImpl$handle$2$2 = false;
                                v3 = " (stage='" + (ChannelEvent.ResumeInstallation.Stage)it + "')";
                                v1 = var15_8;
                            } else {
                                v3 = v4 = null;
                            }
                            if (v3 == null) {
                                v4 = "";
                            }
                            v1.info("Proceed to the tool installation" + v4);
                            backupDirectory = stateFile.getState().getBackupDirectory();
                            v5 = backupExists = backupDirectory != null && RecoveryManagerImpl.access$getFileSystem$p(this.this$0).exists(backupDirectory) != false;
                            if (stage == ChannelEvent.ResumeInstallation.Stage.MoveFinished || RecoveryManagerImpl.access$getFileSystem$p(this.this$0).exists(unpackedDirectory)) ** GOTO lbl38
                            Logger.INSTANCE.error("Unpacked directory '" + unpackedDirectory + "' is missing.");
                            if (!backupExists) {
                                $i$a$-check-RecoveryManagerImpl$handle$2$3 = false;
                                $i$a$-check-RecoveryManagerImpl$handle$2$3 = "Neither unpacked directory, nor backup contains files.";
                                throw new IllegalStateException($i$a$-check-RecoveryManagerImpl$handle$2$3.toString());
                            }
                            v6 = new ChannelEvent.ResumeInstallation(this.$state.getChannel(), backupDirectory, stateFile.getState().getBuild(), stage);
                            ** GOTO lbl59
lbl38:
                            // 1 sources

                            backupOptions = this.$state.getChannel().getBackupOptions();
                            if (stage == null || !backupExists) ** GOTO lbl-1000
                            $this$none$iv = backupOptions.getEntries();
                            $i$f$none = false;
                            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl45
                            v7 = true;
                            ** GOTO lbl52
lbl45:
                            // 2 sources

                            for (T element$iv : $this$none$iv) {
                                it = (ChannelBackupEntry)element$iv;
                                $i$a$-none-RecoveryManagerImpl$handle$2$channel$1 = false;
                                if (!Intrinsics.areEqual((Object)it.getDirectory(), (Object)backupDirectory)) continue;
                                v7 = false;
                                ** GOTO lbl52
                            }
                            v7 = true;
lbl52:
                            // 3 sources

                            if (v7) {
                                Logger.INSTANCE.info("Added a backup entry '" + backupDirectory + "'");
                                v8 = Channel.copy$default(this.$state.getChannel(), null, null, null, false, backupOptions.copy(SetsKt.plus(backupOptions.getEntries(), (Object)new ChannelBackupEntry(backupDirectory, this.$state.getTool().getBuildNumber-Y_E1uuk(), RecoveryManagerImpl.access$getClock$p(this.this$0).now(), null))), false, null, false, null, null, null, false, 4079, null);
                            } else lbl-1000:
                            // 2 sources

                            {
                                v8 = this.$state.getChannel();
                            }
                            channel = v8;
                            v6 = new ChannelEvent.ResumeInstallation(channel, stateFile.getState().getUnpackedDirectory(), stateFile.getState().getBuild(), stage);
lbl59:
                            // 2 sources

                            var3_3 = v6;
                        }
                        catch (Exception e) {
                            Logger.INSTANCE.error((Throwable)e, "Failed to recover a tool. Removing the state file '" + stateFile.getPath() + "'.");
                            RecoveryManagerImpl.access$getFileSystem$p(this.this$0).delete(stateFile.getPath());
                            var3_3 = new ChannelEvent.Failed(null, 1, null);
                        }
                        v0 = var3_3;
lbl66:
                        // 2 sources

                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ChannelEvent> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0() {
                return "No state file found for the tool.";
            }
        }, $completion);
    }

    private final ChannelEvent.ResumeInstallation.Stage recoverFrom(State state2) {
        ChannelEvent.ResumeInstallation.Stage stage;
        Path toolDirectory = state2.getInstallationDirectory();
        Path unpackedDirectory = state2.getUnpackedDirectory();
        Path backupDirectory = state2.getBackupDirectory();
        DirectoryState toolDirectoryState = this.getState(toolDirectory);
        DirectoryState unpackedDirectoryState = this.getState(unpackedDirectory);
        Path path2 = backupDirectory;
        DirectoryState backupDirectoryState = path2 != null ? this.getState(path2) : null;
        Logger.INSTANCE.warn("Tool is in '" + state2.getPhase() + "' state\n  toolDirectory='" + toolDirectory + "', state=" + toolDirectoryState + "\n  unpackedDirectory='" + unpackedDirectory + "', state=" + unpackedDirectoryState + "\n  backupDirectory='" + backupDirectory + "', state=" + backupDirectoryState + "\n");
        switch (WhenMappings.$EnumSwitchMapping$0[state2.getPhase().ordinal()]) {
            case 1: {
                stage = null;
                break;
            }
            case 2: {
                if (toolDirectoryState instanceof DirectoryState.Existing) {
                    if (backupDirectory == null) {
                        Logger.INSTANCE.warn("Uninstallation was interrupted. Removing the previous version.");
                        this.fileSystem.deleteRecursively(toolDirectory);
                    } else {
                        DirectoryState directoryState = backupDirectoryState;
                        if (directoryState == null || Intrinsics.areEqual((Object)directoryState, (Object)DirectoryState.Missing.INSTANCE)) {
                            Logger.INSTANCE.info("Backup directory '" + backupDirectory + "' is missing.");
                            return null;
                        }
                        if (directoryState instanceof DirectoryState.Existing) {
                            if (((DirectoryState.Existing)toolDirectoryState).getTotalSize-WN0b6rc() >= ((DirectoryState.Existing)backupDirectoryState).getTotalSize-WN0b6rc()) {
                                Logger.INSTANCE.warn("Backup at '" + backupDirectory + "' is incomplete, removing it.");
                                this.fileSystem.deleteRecursively(backupDirectory);
                                return null;
                            }
                            Logger.INSTANCE.warn("Backup at '" + backupDirectory + "' is complete. Removing the previous version of the tool.");
                            this.fileSystem.deleteRecursively(toolDirectory);
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                stage = this.backupFinished(backupDirectory);
                break;
            }
            case 3: {
                stage = this.backupFinished(backupDirectory);
                break;
            }
            case 4: {
                Logger.INSTANCE.warn("Tool installation was interrupted.");
                if (unpackedDirectoryState instanceof DirectoryState.Missing) {
                    return this.moveFinished();
                }
                stage = ChannelEvent.ResumeInstallation.Stage.BackupFinished;
                break;
            }
            case 5: {
                stage = this.moveFinished();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return stage;
    }

    private final ChannelEvent.ResumeInstallation.Stage backupFinished(Path backupDirectory) {
        if (backupDirectory != null) {
            Logger.INSTANCE.info("Tool backup is complete.");
        } else {
            Logger.INSTANCE.info("The previous version is removed.");
        }
        return ChannelEvent.ResumeInstallation.Stage.BackupFinished;
    }

    private final ChannelEvent.ResumeInstallation.Stage moveFinished() {
        Logger.INSTANCE.info("Tool directory contains a new version. However, some integrations might not function as expected.");
        return ChannelEvent.ResumeInstallation.Stage.MoveFinished;
    }

    private final DirectoryState getState(Path $this$getState) {
        DirectoryState directoryState;
        if (!this.fileSystem.exists($this$getState)) {
            directoryState = DirectoryState.Missing.INSTANCE;
        } else {
            int directories = 0;
            int files = 0;
            Sequence $this$forEach$iv = this.fileSystem.listRecursively($this$getState);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int n;
                Path it = (Path)element$iv;
                boolean bl = false;
                FileMetadata fileMetadata2 = this.fileSystem.metadataOrNull(it);
                boolean bl2 = fileMetadata2 != null ? fileMetadata2.isDirectory() : false;
                if (bl2) {
                    n = directories;
                    directories = n + 1;
                    continue;
                }
                n = files;
                files = n + 1;
            }
            long l = FileSystemExtKt.calculateSizeRecursively(this.fileSystem, $this$getState);
            int n = directories;
            int n2 = files;
            directoryState = new DirectoryState.Existing(n2, n, l, null);
        }
        return directoryState;
    }

    private static final String retain$lambda$2() {
        return "Recovery directory is not empty. Cleaning it.";
    }

    /*
     * WARNING - void declaration
     */
    private static final String retain$lambda$3(List $retained) {
        Collection<Path> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $retained;
        int n = $retained.size();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StateFile stateFile = (StateFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getState().getInstallationDirectory());
        }
        collection = (List)destination$iv$iv;
        return "Recovery directory is not empty. The following " + n + " tool(s) may be corrupted: " + (List)collection;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getParsedStateFiles$p(RecoveryManagerImpl $this) {
        return $this.parsedStateFiles;
    }

    public static final /* synthetic */ ChannelEvent.ResumeInstallation.Stage access$recoverFrom(RecoveryManagerImpl $this, State state2) {
        return $this.recoverFrom(state2);
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(RecoveryManagerImpl $this) {
        return $this.fileSystem;
    }

    public static final /* synthetic */ Clock access$getClock$p(RecoveryManagerImpl $this) {
        return $this.clock;
    }

    private static sealed interface DirectoryState {

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static final class Existing
        implements DirectoryState {
            private final int files;
            private final int directories;
            private final long totalSize;

            private Existing(int files, int directories, long totalSize) {
                this.files = files;
                this.directories = directories;
                this.totalSize = totalSize;
            }

            public final long getTotalSize-WN0b6rc() {
                return this.totalSize;
            }

            @NotNull
            public String toString() {
                return "Existing(files=" + this.files + ", directories=" + this.directories + ", totalSize=" + FileSize.toString-impl(this.totalSize) + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.files);
                result2 = result2 * 31 + Integer.hashCode(this.directories);
                result2 = result2 * 31 + FileSize.hashCode-impl(this.totalSize);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Existing)) {
                    return false;
                }
                Existing existing = (Existing)other;
                if (this.files != existing.files) {
                    return false;
                }
                if (this.directories != existing.directories) {
                    return false;
                }
                return FileSize.equals-impl0(this.totalSize, existing.totalSize);
            }

            public /* synthetic */ Existing(int files, int directories, long totalSize, DefaultConstructorMarker $constructor_marker) {
                this(files, directories, totalSize);
            }
        }

        public static final class Missing
        implements DirectoryState {
            @NotNull
            public static final Missing INSTANCE = new Missing();

            private Missing() {
            }

            @NotNull
            public String toString() {
                return "Missing";
            }

            public int hashCode() {
                return 1719574392;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Missing)) {
                    return false;
                }
                Missing cfr_ignored_0 = (Missing)other;
                return true;
            }
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.Phase.values().length];
            try {
                nArray[State.Phase.Init.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Phase.BackupStarted.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Phase.BackupFinished.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Phase.MoveStarted.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Phase.MoveFinished.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

