/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.provider;

import com.jetbrains.toolbox.tools.model.licensing.SalesCode;
import com.jetbrains.toolbox.tools.provider.ProductLicense;
import com.jetbrains.toolbox.tools.provider.ProductLicenseProviderKt;
import com.jetbrains.toolbox.tools.provider.ProductLicenses;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProductLicenses {
    @NotNull
    private final List<ProductLicense> list;
    @NotNull
    private final Set<SalesCode> codes;
    private final boolean app;
    private final boolean dul;

    public ProductLicenses(@NotNull List<ProductLicense> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        this.list = list2;
        this.codes = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.list), (Function1)codes.1.INSTANCE));
        this.app = this.codes.contains(SalesCode.box-impl(ProductLicenseProviderKt.access$getAppSalesCode$p()));
        this.dul = this.codes.contains(SalesCode.box-impl(ProductLicenseProviderKt.access$getDulSalesCode$p()));
    }

    @NotNull
    public final List<ProductLicense> getList() {
        return this.list;
    }

    public final boolean getApp() {
        return this.app;
    }

    public final boolean getDul() {
        return this.dul;
    }

    @NotNull
    public String toString() {
        return "ProductLicenses(list=" + this.list + ")";
    }

    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProductLicenses)) {
            return false;
        }
        ProductLicenses productLicenses = (ProductLicenses)other;
        return Intrinsics.areEqual(this.list, productLicenses.list);
    }
}

