/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.process.workers;

import com.jetbrains.toolbox.tools.ToolProcessStateWorker;
import com.jetbrains.toolbox.tools.launcher.ProcessLauncher;
import com.jetbrains.toolbox.tools.model.ToolProcessEvent;
import com.jetbrains.toolbox.tools.model.ToolProcessState;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nDiscoveringViaStatusStateWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscoveringViaStatusStateWorker.kt\ncom/jetbrains/toolbox/tools/process/workers/DiscoveringViaStatusStateWorker\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,36:1\n375#2:37\n*S KotlinDebug\n*F\n+ 1 DiscoveringViaStatusStateWorker.kt\ncom/jetbrains/toolbox/tools/process/workers/DiscoveringViaStatusStateWorker\n*L\n29#1:37\n*E\n"})
public final class DiscoveringViaStatusStateWorker
implements ToolProcessStateWorker<ToolProcessState.DiscoveringViaStatus> {
    @NotNull
    private final ProcessLauncher processLauncher;

    public DiscoveringViaStatusStateWorker(@NotNull ProcessLauncher processLauncher) {
        Intrinsics.checkNotNullParameter((Object)processLauncher, (String)"processLauncher");
        this.processLauncher = processLauncher;
    }

    @Override
    @NotNull
    public KClass<ToolProcessState.DiscoveringViaStatus> getState() {
        return Reflection.getOrCreateKotlinClass(ToolProcessState.DiscoveringViaStatus.class);
    }

    @Override
    @Nullable
    public Object handle(@NotNull ToolProcessState.DiscoveringViaStatus state2, @NotNull Continuation<? super ToolProcessEvent> $completion) {
        try {
            Logger.INSTANCE.debug("Discovered process (built-in server) " + state2.getPid-MOBmICs() + ", attempting to attach");
            ProcessHandle processHandle = this.processLauncher.attach(state2.getPid-MOBmICs());
            if (processHandle == null) {
                DiscoveringViaStatusStateWorker $this$handle_u24lambda_u240 = this;
                boolean bl = false;
                Logger.INSTANCE.debug("No process associated with pid " + state2.getPid-MOBmICs() + " found");
                return new ToolProcessEvent.Failure(new IllegalStateException("No process associated with pid " + state2.getPid-MOBmICs() + " found"));
            }
            ProcessHandle handle2 = processHandle;
            long pid = state2.getPid-MOBmICs();
            String channelId = state2.getChannelId-5CZByfs();
            return new ToolProcessEvent.Attach(handle2, pid, channelId, null);
        }
        catch (Exception e) {
            boolean $i$f$currentCoroutineContext = false;
            JobKt.ensureActive((CoroutineContext)$completion.getContext());
            Logger.INSTANCE.warn((Throwable)e, "Attaching to discovered process " + state2.getPid-MOBmICs() + " wasn't successful");
            return new ToolProcessEvent.Failure(e);
        }
    }
}

