/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.notifications;

import com.jetbrains.toolbox.AppRestartInhibitor;
import com.jetbrains.toolbox.Notifications;
import com.jetbrains.toolbox.common.TransitionEvent;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.UninstallResultKt;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.EphemeralToolKt;
import com.jetbrains.toolbox.tools.model.State;
import java.util.Collection;
import kotlin.KotlinNothingValueException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.SharedFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class ChannelStateChangedNotifier {
    @NotNull
    private final SharedFlow<TransitionEvent<State, ChannelEvent>> events;
    @NotNull
    private final Notifications notifications;
    @NotNull
    private final I18n i18n;
    @NotNull
    private final AppRestartInhibitor appRestartInhibitor;

    public ChannelStateChangedNotifier(@NotNull SharedFlow<TransitionEvent<State, ChannelEvent>> events, @NotNull Notifications notifications, @NotNull I18n i18n, @NotNull AppRestartInhibitor appRestartInhibitor, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)notifications, (String)"notifications");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)appRestartInhibitor, (String)"appRestartInhibitor");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.events = events;
        this.notifications = notifications;
        this.i18n = i18n;
        this.appRestartInhibitor = appRestartInhibitor;
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ChannelStateChangedNotifier this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.events.collect(new FlowCollector(){

                            public final Object emit(TransitionEvent<State, ChannelEvent> transitionEvent, Continuation<? super Unit> $completion) {
                                State previous = transitionEvent.component1();
                                State next2 = transitionEvent.component2();
                                ChannelEvent event = transitionEvent.component3();
                                if (next2 instanceof State.PrepareInstallationFailed) {
                                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"error", (Object)LocalizableStringExKt.localize(((State.PrepareInstallationFailed)next2).getReason(), this$0.i18n))};
                                    Object object = this$0.notifications.showErrorMessage(this$0.i18n.tr("Failed to install tool: {{error}}", pairArray), $completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                                if (!(previous instanceof ChannelState.SelfUpdate || next2 instanceof ChannelState.SelfUpdatePending || !EphemeralToolKt.getHidden(next2.getTool()) || event instanceof ChannelEvent.InstallFailed && next2 instanceof ChannelState.InstallationUnsuccessful)) {
                                    return Unit.INSTANCE;
                                }
                                String toolName = next2.getTool().getToolName() + " " + next2.getTool().getVersionName();
                                ChannelEvent channelEvent = event;
                                if (channelEvent instanceof ChannelEvent.Installed) {
                                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolName)};
                                    Object object = this$0.notifications.showInfoMessage(this$0.i18n.tr("{{toolName}} installed", pairArray), $completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                                if (channelEvent instanceof ChannelEvent.Request.Cancel) {
                                    if (next2 instanceof ChannelState.InstallationUnsuccessful) {
                                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolName)};
                                        Object object = this$0.notifications.showErrorMessage(this$0.i18n.tr("{{toolName}} installation cancelled", pairArray), $completion);
                                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            return object;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                } else {
                                    if (channelEvent instanceof ChannelEvent.InstallFailed) {
                                        if (next2 instanceof ChannelState.InstallationUnsuccessful) {
                                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolName), TuplesKt.to((Object)"error", (Object)LocalizableStringExKt.localize(((ChannelEvent.InstallFailed)event).getReason().getExplanation(), this$0.i18n))};
                                            Object object = this$0.notifications.showErrorMessage(this$0.i18n.tr("Failed to install {{toolName}}: {{error}}", pairArray), $completion);
                                            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                return object;
                                            }
                                            return Unit.INSTANCE;
                                        }
                                        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolName), TuplesKt.to((Object)"error", (Object)LocalizableStringExKt.localize(((ChannelEvent.InstallFailed)event).getReason().getExplanation(), this$0.i18n))};
                                        Object object = this$0.notifications.showErrorMessage(this$0.i18n.tr("Cannot update {{toolName}}: {{error}}", pairArray), $completion);
                                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            return object;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                    if (channelEvent instanceof ChannelEvent.Failed) {
                                        State state2 = previous;
                                        if (!(state2 instanceof ChannelState.ConfiguringAfterUpdate || state2 instanceof ChannelState.ConfiguringAfterInstall || state2 instanceof ChannelState.ApplyingConfigurator || state2 instanceof ChannelState.ConfigurationPending || state2 instanceof ChannelState.PatchDownloading)) {
                                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolName), TuplesKt.to((Object)"error", (Object)LocalizableStringExKt.localize(((ChannelEvent.Failed)event).getError(), this$0.i18n))};
                                            Object object = this$0.notifications.showErrorMessage(this$0.i18n.tr("Cannot update {{toolName}}: {{error}}", pairArray), $completion);
                                            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                return object;
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    } else if (channelEvent instanceof ChannelEvent.UninstallFailed) {
                                        if (next2 instanceof ChannelState.PendingInstantUpdate) {
                                            ChannelState.PendingInstantUpdate pendingInstantUpdate = previous instanceof ChannelState.PendingInstantUpdate ? (ChannelState.PendingInstantUpdate)previous : null;
                                            if (Intrinsics.areEqual((Object)(pendingInstantUpdate != null ? pendingInstantUpdate.getReason() : null), (Object)UninstallResult.Success.INSTANCE)) {
                                                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolName)};
                                                Object object = this$0.notifications.showInfoMessage(this$0.i18n.tr("{{toolName}} is ready to update. Close it to continue.", pairArray), $completion);
                                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                    return object;
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        if (previous instanceof ChannelState.Uninstalling) {
                                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"toolName", (Object)toolName), TuplesKt.to((Object)"error", (Object)UninstallResultKt.localize(((ChannelEvent.UninstallFailed)event).getReason(), toolName, this$0.i18n))};
                                            Object object = this$0.notifications.showErrorMessage(this$0.i18n.tr("Cannot uninstall {{toolName}}: {{error}}", pairArray), $completion);
                                            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                return object;
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    } else if (channelEvent instanceof ChannelEvent.Unpacked && next2 instanceof ChannelState.SelfUpdatePending && (!((ChannelState.SelfUpdatePending)next2).getChannel().getAutoUpdate() || !((Collection)this$0.appRestartInhibitor.getRestartBlockedBy().getValue()).isEmpty())) {
                                        Object object = this$0.notifications.showInfoMessage(this$0.i18n.tr("Toolbox App update is ready to install"), $completion);
                                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                            return object;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }
}

