/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.model;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.tools.model.AvailableBuild;
import com.jetbrains.toolbox.tools.model.AvailableTool;
import com.jetbrains.toolbox.tools.model.AvailableTool$;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolPatch;
import com.jetbrains.toolbox.tools.model.ToolPatch$;
import com.jetbrains.toolbox.tools.model.ToolWithVersions$;
import com.jetbrains.toolbox.tools.model.VersionWithBuilds;
import com.jetbrains.toolbox.tools.model.VersionWithBuilds$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.LinkedHashSetSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SourceDebugExtension(value={"SMAP\nToolWithVersions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWithVersions.kt\ncom/jetbrains/toolbox/tools/model/ToolWithVersions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n1491#2:36\n1516#2,3:37\n1519#2,3:47\n774#2:51\n865#2,2:52\n1999#2,14:54\n1516#2,6:68\n774#2:74\n865#2,2:75\n1999#2,14:77\n382#3,7:40\n1#4:50\n*S KotlinDebug\n*F\n+ 1 ToolWithVersions.kt\ncom/jetbrains/toolbox/tools/model/ToolWithVersions\n*L\n18#1:36\n18#1:37,3\n18#1:47,3\n22#1:51\n22#1:52,2\n22#1:54,14\n18#1:68,6\n22#1:74\n22#1:75,2\n22#1:77,14\n18#1:40,7\n*E\n"})
public final class ToolWithVersions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AvailableTool tool;
    @NotNull
    private final List<VersionWithBuilds> versions;
    @NotNull
    private final Set<ToolPatch> patches;
    @NotNull
    private final Lazy patchesGroupedByFrom$delegate;
    @NotNull
    private final Lazy stableVersionWithBuilds$delegate;
    @NotNull
    private final Lazy stableToolBuild$delegate;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public ToolWithVersions(@NotNull AvailableTool tool, @NotNull List<VersionWithBuilds> versions, @NotNull Set<ToolPatch> patches) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Intrinsics.checkNotNullParameter(patches, (String)"patches");
        this.tool = tool;
        this.versions = versions;
        this.patches = patches;
        this.patchesGroupedByFrom$delegate = LazyKt.lazy(() -> ToolWithVersions.patchesGroupedByFrom_delegate$lambda$0(this));
        this.stableVersionWithBuilds$delegate = LazyKt.lazy(() -> ToolWithVersions.stableVersionWithBuilds_delegate$lambda$0(this));
        this.stableToolBuild$delegate = LazyKt.lazy(() -> ToolWithVersions.stableToolBuild_delegate$lambda$0(this));
    }

    @NotNull
    public final AvailableTool getTool() {
        return this.tool;
    }

    @NotNull
    public final List<VersionWithBuilds> getVersions() {
        return this.versions;
    }

    @NotNull
    public final Set<ToolPatch> getPatches() {
        return this.patches;
    }

    @NotNull
    public final Map<BuildNumber, List<ToolPatch>> getPatchesGroupedByFrom() {
        Lazy lazy = this.patchesGroupedByFrom$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final VersionWithBuilds getStableVersionWithBuilds() {
        Lazy lazy = this.stableVersionWithBuilds$delegate;
        return (VersionWithBuilds)lazy.getValue();
    }

    @NotNull
    public final ToolBuild getStableToolBuild() {
        Lazy lazy = this.stableToolBuild$delegate;
        return (ToolBuild)lazy.getValue();
    }

    @NotNull
    public final Sequence<ToolBuild> asToolBuildSequence() {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.versions), arg_0 -> ToolWithVersions.asToolBuildSequence$lambda$0(this, arg_0));
    }

    @NotNull
    public final AvailableTool component1() {
        return this.tool;
    }

    @NotNull
    public final List<VersionWithBuilds> component2() {
        return this.versions;
    }

    @NotNull
    public final Set<ToolPatch> component3() {
        return this.patches;
    }

    @NotNull
    public final ToolWithVersions copy(@NotNull AvailableTool tool, @NotNull List<VersionWithBuilds> versions, @NotNull Set<ToolPatch> patches) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter(versions, (String)"versions");
        Intrinsics.checkNotNullParameter(patches, (String)"patches");
        return new ToolWithVersions(tool, versions, patches);
    }

    public static /* synthetic */ ToolWithVersions copy$default(ToolWithVersions toolWithVersions, AvailableTool availableTool2, List list2, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            availableTool2 = toolWithVersions.tool;
        }
        if ((n & 2) != 0) {
            list2 = toolWithVersions.versions;
        }
        if ((n & 4) != 0) {
            set2 = toolWithVersions.patches;
        }
        return toolWithVersions.copy(availableTool2, list2, set2);
    }

    @NotNull
    public String toString() {
        return "ToolWithVersions(tool=" + this.tool + ", versions=" + this.versions + ", patches=" + this.patches + ")";
    }

    public int hashCode() {
        int result2 = this.tool.hashCode();
        result2 = result2 * 31 + ((Object)this.versions).hashCode();
        result2 = result2 * 31 + ((Object)this.patches).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolWithVersions)) {
            return false;
        }
        ToolWithVersions toolWithVersions = (ToolWithVersions)other;
        if (!Intrinsics.areEqual((Object)this.tool, (Object)toolWithVersions.tool)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.versions, toolWithVersions.versions)) {
            return false;
        }
        return Intrinsics.areEqual(this.patches, toolWithVersions.patches);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$tools_api(ToolWithVersions self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output2.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)AvailableTool$.serializer.INSTANCE, (Object)self.tool);
        output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), self.versions);
        output2.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.patches);
    }

    public /* synthetic */ ToolWithVersions(int seen0, AvailableTool tool, List versions, Set patches, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.tool = tool;
        this.versions = versions;
        this.patches = patches;
        this.patchesGroupedByFrom$delegate = LazyKt.lazy(() -> ToolWithVersions._init_$lambda$0(this));
        this.stableVersionWithBuilds$delegate = LazyKt.lazy(() -> ToolWithVersions._init_$lambda$1(this));
        this.stableToolBuild$delegate = LazyKt.lazy(() -> ToolWithVersions._init_$lambda$2(this));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map patchesGroupedByFrom_delegate$lambda$0(ToolWithVersions this$0) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this$0.patches;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            ToolPatch it = (ToolPatch)element$iv$iv;
            boolean bl = false;
            BuildNumber key$iv$iv = BuildNumber.box-impl(it.getBuildNumberFrom-Y_E1uuk());
            Map map2 = destination$iv$iv;
            BuildNumber key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final VersionWithBuilds stableVersionWithBuilds_delegate$lambda$0(ToolWithVersions this$0) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterator iterator2 = ((Iterable)this$0.versions).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        VersionWithBuilds it422 = (VersionWithBuilds)iterator2.next();
        boolean bl = false;
        int it422 = it422.getVersion().getQuality().getOrder();
        while (iterator2.hasNext()) {
            VersionWithBuilds it32 = (VersionWithBuilds)iterator2.next();
            $i$a$-minOf-ToolWithVersions$stableVersionWithBuilds$2$stableOrder$1 = false;
            int it32 = it32.getVersion().getQuality().getOrder();
            if (it422 <= it32) continue;
            it422 = it32;
        }
        int stableOrder = it422;
        Iterable $this$filter$iv = this$0.versions;
        boolean $i$f$filter = false;
        Iterable it422 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VersionWithBuilds it = (VersionWithBuilds)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getVersion().getQuality().getOrder() == stableOrder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                VersionWithBuilds it = (VersionWithBuilds)maxElem$iv;
                boolean bl3 = false;
                Comparable maxValue$iv = BuildNumber.box-impl(it.getLatestBuild().getId-Y_E1uuk());
                do {
                    Object e$iv = iterator$iv.next();
                    VersionWithBuilds it2 = (VersionWithBuilds)e$iv;
                    $i$a$-maxByOrNull-ToolWithVersions$stableVersionWithBuilds$2$2 = false;
                    Comparable v$iv = BuildNumber.box-impl(it2.getLatestBuild().getId-Y_E1uuk());
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    private static final ToolBuild stableToolBuild_delegate$lambda$0(ToolWithVersions this$0) {
        return new ToolBuild(this$0.tool, this$0.getStableVersionWithBuilds().getVersion(), this$0.getStableVersionWithBuilds().getLatestBuild());
    }

    private static final Sequence asToolBuildSequence$lambda$0(ToolWithVersions this$0, VersionWithBuilds versionWithBuilds) {
        Intrinsics.checkNotNullParameter((Object)versionWithBuilds, (String)"versionWithBuilds");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)versionWithBuilds.getBuilds()), arg_0 -> ToolWithVersions.asToolBuildSequence$lambda$0$0(this$0, versionWithBuilds, arg_0));
    }

    private static final ToolBuild asToolBuildSequence$lambda$0$0(ToolWithVersions this$0, VersionWithBuilds $versionWithBuilds, AvailableBuild build2) {
        Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
        return new ToolBuild(this$0.tool, $versionWithBuilds.getVersion(), build2);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map _init_$lambda$0(ToolWithVersions this$0) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this$0.patches;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            ToolPatch it = (ToolPatch)element$iv$iv;
            boolean bl = false;
            BuildNumber key$iv$iv = BuildNumber.box-impl(it.getBuildNumberFrom-Y_E1uuk());
            Map map2 = destination$iv$iv;
            BuildNumber key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final VersionWithBuilds _init_$lambda$1(ToolWithVersions this$0) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterator iterator2 = ((Iterable)this$0.versions).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        VersionWithBuilds it422 = (VersionWithBuilds)iterator2.next();
        boolean bl = false;
        int it422 = it422.getVersion().getQuality().getOrder();
        while (iterator2.hasNext()) {
            VersionWithBuilds it32 = (VersionWithBuilds)iterator2.next();
            $i$a$-minOf-ToolWithVersions$stableVersionWithBuilds$2$stableOrder$1 = false;
            int it32 = it32.getVersion().getQuality().getOrder();
            if (it422 <= it32) continue;
            it422 = it32;
        }
        int stableOrder = it422;
        Iterable $this$filter$iv = this$0.versions;
        boolean $i$f$filter = false;
        Iterable it422 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VersionWithBuilds it = (VersionWithBuilds)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getVersion().getQuality().getOrder() == stableOrder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                VersionWithBuilds it = (VersionWithBuilds)maxElem$iv;
                boolean bl3 = false;
                Comparable maxValue$iv = BuildNumber.box-impl(it.getLatestBuild().getId-Y_E1uuk());
                do {
                    Object e$iv = iterator$iv.next();
                    VersionWithBuilds it2 = (VersionWithBuilds)e$iv;
                    $i$a$-maxByOrNull-ToolWithVersions$stableVersionWithBuilds$2$2 = false;
                    Comparable v$iv = BuildNumber.box-impl(it2.getLatestBuild().getId-Y_E1uuk());
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    private static final ToolBuild _init_$lambda$2(ToolWithVersions this$0) {
        return new ToolBuild(this$0.tool, this$0.getStableVersionWithBuilds().getVersion(), this$0.getStableVersionWithBuilds().getLatestBuild());
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)VersionWithBuilds$.serializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new LinkedHashSetSerializer((KSerializer)ToolPatch$.serializer.INSTANCE))};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ToolWithVersions> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Factory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }
    }
}

