/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.model;

import com.jetbrains.toolbox.tools.model.Freshness;
import com.jetbrains.toolbox.tools.model.FreshnessPeriod$;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.serializers.InstantIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
public final class FreshnessPeriod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Freshness freshness;
    @NotNull
    private final Instant until;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public FreshnessPeriod(@NotNull Freshness freshness, @NotNull Instant until) {
        Intrinsics.checkNotNullParameter((Object)((Object)freshness), (String)"freshness");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        this.freshness = freshness;
        this.until = until;
    }

    @NotNull
    public final Freshness getFreshness() {
        return this.freshness;
    }

    @NotNull
    public final Instant getUntil() {
        return this.until;
    }

    public final boolean isFresh() {
        if (this.freshness == Freshness.Installed) {
            return false;
        }
        return this.until.compareTo(Clock.System.INSTANCE.now()) > 0;
    }

    public final boolean canBeUpgradedTo(@NotNull Freshness targetFreshness) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetFreshness), (String)"targetFreshness");
        return this.isFresh() ? this.freshness.getDays().getDays() > targetFreshness.getDays().getDays() : false;
    }

    @NotNull
    public final Freshness component1() {
        return this.freshness;
    }

    @NotNull
    public final Instant component2() {
        return this.until;
    }

    @NotNull
    public final FreshnessPeriod copy(@NotNull Freshness freshness, @NotNull Instant until) {
        Intrinsics.checkNotNullParameter((Object)((Object)freshness), (String)"freshness");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        return new FreshnessPeriod(freshness, until);
    }

    public static /* synthetic */ FreshnessPeriod copy$default(FreshnessPeriod freshnessPeriod, Freshness freshness, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            freshness = freshnessPeriod.freshness;
        }
        if ((n & 2) != 0) {
            instant = freshnessPeriod.until;
        }
        return freshnessPeriod.copy(freshness, instant);
    }

    @NotNull
    public String toString() {
        return "FreshnessPeriod(freshness=" + this.freshness + ", until=" + this.until + ")";
    }

    public int hashCode() {
        int result2 = this.freshness.hashCode();
        result2 = result2 * 31 + this.until.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FreshnessPeriod)) {
            return false;
        }
        FreshnessPeriod freshnessPeriod = (FreshnessPeriod)other;
        if (this.freshness != freshnessPeriod.freshness) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.until, (Object)freshnessPeriod.until);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$tools_api(FreshnessPeriod self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output2.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), (Object)self.freshness);
        output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)InstantIso8601Serializer.INSTANCE, (Object)self.until);
    }

    public /* synthetic */ FreshnessPeriod(int seen0, Freshness freshness, Instant until, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.freshness = freshness;
        this.until = until;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"com.jetbrains.toolbox.tools.model.Freshness", (Enum[])Freshness.values())), null};
        $childSerializers = lazyArray;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<FreshnessPeriod> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

