/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.model;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.filesystem.WorkingCopy;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.ChangeOptions;
import com.jetbrains.toolbox.tools.model.Channel;
import com.jetbrains.toolbox.tools.model.EphemeralTool;
import com.jetbrains.toolbox.tools.model.FailedUpdate;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolReconfigurator;
import com.jetbrains.toolbox.tools.model.ToolTerminator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ChannelEvent
permits Abandon, Completed, Copied, Detected, DirectoryMissing, Downloaded, Eligible, Failed, InstallFailed, Installed, InstantUpdateFailed, NotEligible, PatchingFailed, PatchingSuccessful, Preinstalled, PreparedForInstantUpdate, Queueable, Recovery, Refreshed, Request.Install, ResumeInstallation, ToolInstanceChanged, UninstallFailed, Uninstalled, Unpacked, UpdatePostponed, VerificationFailed, VerificationSuccessful, WaitForUserAction {

    public static final class Abandon
    implements ChannelEvent {
        @NotNull
        public static final Abandon INSTANCE = new Abandon();

        private Abandon() {
        }

        @NotNull
        public String toString() {
            return "Abandon";
        }

        public int hashCode() {
            return 84902454;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Abandon)) {
                return false;
            }
            Abandon cfr_ignored_0 = (Abandon)other;
            return true;
        }
    }

    public static final class Completed
    implements ChannelEvent {
        @NotNull
        private final Channel channel;
        @NotNull
        private final InstalledTool tool;

        public Completed(@NotNull Channel channel, @NotNull InstalledTool tool) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            this.channel = channel;
            this.tool = tool;
        }

        @NotNull
        public final Channel getChannel() {
            return this.channel;
        }

        @NotNull
        public final InstalledTool getTool() {
            return this.tool;
        }

        @NotNull
        public String toString() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "()";
        }

        @NotNull
        public final Channel component1() {
            return this.channel;
        }

        @NotNull
        public final InstalledTool component2() {
            return this.tool;
        }

        @NotNull
        public final Completed copy(@NotNull Channel channel, @NotNull InstalledTool tool) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            return new Completed(channel, tool);
        }

        public static /* synthetic */ Completed copy$default(Completed completed, Channel channel, InstalledTool installedTool2, int n, Object object) {
            if ((n & 1) != 0) {
                channel = completed.channel;
            }
            if ((n & 2) != 0) {
                installedTool2 = completed.tool;
            }
            return completed.copy(channel, installedTool2);
        }

        public int hashCode() {
            int result2 = this.channel.hashCode();
            result2 = result2 * 31 + this.tool.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Completed)) {
                return false;
            }
            Completed completed = (Completed)other;
            if (!Intrinsics.areEqual((Object)this.channel, (Object)completed.channel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tool, (Object)completed.tool);
        }
    }

    public static final class ConfigurationOnClosedToolRequired
    implements Queueable {
        @NotNull
        private final ToolTerminator terminator;
        @NotNull
        private final ToolReconfigurator configurator;

        public ConfigurationOnClosedToolRequired(@NotNull ToolTerminator terminator, @NotNull ToolReconfigurator configurator) {
            Intrinsics.checkNotNullParameter((Object)terminator, (String)"terminator");
            Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
            this.terminator = terminator;
            this.configurator = configurator;
        }

        @NotNull
        public final ToolTerminator getTerminator() {
            return this.terminator;
        }

        @NotNull
        public final ToolReconfigurator getConfigurator() {
            return this.configurator;
        }

        @NotNull
        public final ToolTerminator component1() {
            return this.terminator;
        }

        @NotNull
        public final ToolReconfigurator component2() {
            return this.configurator;
        }

        @NotNull
        public final ConfigurationOnClosedToolRequired copy(@NotNull ToolTerminator terminator, @NotNull ToolReconfigurator configurator) {
            Intrinsics.checkNotNullParameter((Object)terminator, (String)"terminator");
            Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
            return new ConfigurationOnClosedToolRequired(terminator, configurator);
        }

        public static /* synthetic */ ConfigurationOnClosedToolRequired copy$default(ConfigurationOnClosedToolRequired configurationOnClosedToolRequired, ToolTerminator toolTerminator, ToolReconfigurator toolReconfigurator, int n, Object object) {
            if ((n & 1) != 0) {
                toolTerminator = configurationOnClosedToolRequired.terminator;
            }
            if ((n & 2) != 0) {
                toolReconfigurator = configurationOnClosedToolRequired.configurator;
            }
            return configurationOnClosedToolRequired.copy(toolTerminator, toolReconfigurator);
        }

        @NotNull
        public String toString() {
            return "ConfigurationOnClosedToolRequired(terminator=" + this.terminator + ", configurator=" + this.configurator + ")";
        }

        public int hashCode() {
            int result2 = this.terminator.hashCode();
            result2 = result2 * 31 + this.configurator.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfigurationOnClosedToolRequired)) {
                return false;
            }
            ConfigurationOnClosedToolRequired configurationOnClosedToolRequired = (ConfigurationOnClosedToolRequired)other;
            if (!Intrinsics.areEqual((Object)this.terminator, (Object)configurationOnClosedToolRequired.terminator)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configurator, (Object)configurationOnClosedToolRequired.configurator);
        }
    }

    public static final class ConfigurationRequired
    implements Queueable {
        @NotNull
        private final ToolReconfigurator configurator;

        public ConfigurationRequired(@NotNull ToolReconfigurator configurator) {
            Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
            this.configurator = configurator;
        }

        @NotNull
        public final ToolReconfigurator getConfigurator() {
            return this.configurator;
        }

        @NotNull
        public final ToolReconfigurator component1() {
            return this.configurator;
        }

        @NotNull
        public final ConfigurationRequired copy(@NotNull ToolReconfigurator configurator) {
            Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
            return new ConfigurationRequired(configurator);
        }

        public static /* synthetic */ ConfigurationRequired copy$default(ConfigurationRequired configurationRequired, ToolReconfigurator toolReconfigurator, int n, Object object) {
            if ((n & 1) != 0) {
                toolReconfigurator = configurationRequired.configurator;
            }
            return configurationRequired.copy(toolReconfigurator);
        }

        @NotNull
        public String toString() {
            return "ConfigurationRequired(configurator=" + this.configurator + ")";
        }

        public int hashCode() {
            return this.configurator.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfigurationRequired)) {
                return false;
            }
            ConfigurationRequired configurationRequired = (ConfigurationRequired)other;
            return Intrinsics.areEqual((Object)this.configurator, (Object)configurationRequired.configurator);
        }
    }

    public static final class Copied
    implements ChannelEvent {
        @NotNull
        private final Channel channel;
        @NotNull
        private final InstalledTool tool;

        public Copied(@NotNull Channel channel, @NotNull InstalledTool tool) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            this.channel = channel;
            this.tool = tool;
        }

        @NotNull
        public final Channel getChannel() {
            return this.channel;
        }

        @NotNull
        public final InstalledTool getTool() {
            return this.tool;
        }

        @NotNull
        public final Channel component1() {
            return this.channel;
        }

        @NotNull
        public final InstalledTool component2() {
            return this.tool;
        }

        @NotNull
        public final Copied copy(@NotNull Channel channel, @NotNull InstalledTool tool) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            return new Copied(channel, tool);
        }

        public static /* synthetic */ Copied copy$default(Copied copied2, Channel channel, InstalledTool installedTool2, int n, Object object) {
            if ((n & 1) != 0) {
                channel = copied2.channel;
            }
            if ((n & 2) != 0) {
                installedTool2 = copied2.tool;
            }
            return copied2.copy(channel, installedTool2);
        }

        @NotNull
        public String toString() {
            return "Copied(channel=" + this.channel + ", tool=" + this.tool + ")";
        }

        public int hashCode() {
            int result2 = this.channel.hashCode();
            result2 = result2 * 31 + this.tool.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Copied)) {
                return false;
            }
            Copied copied2 = (Copied)other;
            if (!Intrinsics.areEqual((Object)this.channel, (Object)copied2.channel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tool, (Object)copied2.tool);
        }
    }

    public static final class Detected
    implements ChannelEvent {
        @NotNull
        public static final Detected INSTANCE = new Detected();

        private Detected() {
        }

        @NotNull
        public String toString() {
            return "Detected";
        }

        public int hashCode() {
            return -1826366751;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Detected)) {
                return false;
            }
            Detected cfr_ignored_0 = (Detected)other;
            return true;
        }
    }

    public static final class DirectoryMissing
    implements ChannelEvent {
        @NotNull
        public static final DirectoryMissing INSTANCE = new DirectoryMissing();

        private DirectoryMissing() {
        }

        @NotNull
        public String toString() {
            return "DirectoryMissing";
        }

        public int hashCode() {
            return 1568885656;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DirectoryMissing)) {
                return false;
            }
            DirectoryMissing cfr_ignored_0 = (DirectoryMissing)other;
            return true;
        }
    }

    public static final class Downloaded
    implements ChannelEvent {
        @NotNull
        private final List<Path> files;

        public Downloaded(@NotNull List<Path> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.files = files;
        }

        @NotNull
        public final List<Path> getFiles() {
            return this.files;
        }

        public Downloaded(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this(CollectionsKt.listOf((Object)file));
        }

        @NotNull
        public final List<Path> component1() {
            return this.files;
        }

        @NotNull
        public final Downloaded copy(@NotNull List<Path> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            return new Downloaded(files);
        }

        public static /* synthetic */ Downloaded copy$default(Downloaded downloaded, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = downloaded.files;
            }
            return downloaded.copy(list2);
        }

        @NotNull
        public String toString() {
            return "Downloaded(files=" + this.files + ")";
        }

        public int hashCode() {
            return ((Object)this.files).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Downloaded)) {
                return false;
            }
            Downloaded downloaded = (Downloaded)other;
            return Intrinsics.areEqual(this.files, downloaded.files);
        }
    }

    public static final class Eligible
    implements ChannelEvent {
        @NotNull
        private final InstalledTool tool;
        @NotNull
        private final ToolInstance updatedToolInstance;

        public Eligible(@NotNull InstalledTool tool, @NotNull ToolInstance updatedToolInstance) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)updatedToolInstance, (String)"updatedToolInstance");
            this.tool = tool;
            this.updatedToolInstance = updatedToolInstance;
        }

        @NotNull
        public final InstalledTool getTool() {
            return this.tool;
        }

        @NotNull
        public final ToolInstance getUpdatedToolInstance() {
            return this.updatedToolInstance;
        }

        @NotNull
        public final InstalledTool component1() {
            return this.tool;
        }

        @NotNull
        public final ToolInstance component2() {
            return this.updatedToolInstance;
        }

        @NotNull
        public final Eligible copy(@NotNull InstalledTool tool, @NotNull ToolInstance updatedToolInstance) {
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)updatedToolInstance, (String)"updatedToolInstance");
            return new Eligible(tool, updatedToolInstance);
        }

        public static /* synthetic */ Eligible copy$default(Eligible eligible, InstalledTool installedTool2, ToolInstance toolInstance, int n, Object object) {
            if ((n & 1) != 0) {
                installedTool2 = eligible.tool;
            }
            if ((n & 2) != 0) {
                toolInstance = eligible.updatedToolInstance;
            }
            return eligible.copy(installedTool2, toolInstance);
        }

        @NotNull
        public String toString() {
            return "Eligible(tool=" + this.tool + ", updatedToolInstance=" + this.updatedToolInstance + ")";
        }

        public int hashCode() {
            int result2 = this.tool.hashCode();
            result2 = result2 * 31 + this.updatedToolInstance.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Eligible)) {
                return false;
            }
            Eligible eligible = (Eligible)other;
            if (!Intrinsics.areEqual((Object)this.tool, (Object)eligible.tool)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.updatedToolInstance, (Object)eligible.updatedToolInstance);
        }
    }

    public static final class Failed
    implements ChannelEvent {
        @NotNull
        private final LocalizableString error;

        public Failed(@NotNull LocalizableString error2) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            this.error = error2;
        }

        public /* synthetic */ Failed(LocalizableString localizableString, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                localizableString = LocalizableStringExKt.notr("");
            }
            this(localizableString);
        }

        @NotNull
        public final LocalizableString getError() {
            return this.error;
        }

        @NotNull
        public final LocalizableString component1() {
            return this.error;
        }

        @NotNull
        public final Failed copy(@NotNull LocalizableString error2) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            return new Failed(error2);
        }

        public static /* synthetic */ Failed copy$default(Failed failed, LocalizableString localizableString, int n, Object object) {
            if ((n & 1) != 0) {
                localizableString = failed.error;
            }
            return failed.copy(localizableString);
        }

        @NotNull
        public String toString() {
            return "Failed(error=" + this.error + ")";
        }

        public int hashCode() {
            return this.error.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failed)) {
                return false;
            }
            Failed failed = (Failed)other;
            return Intrinsics.areEqual((Object)this.error, (Object)failed.error);
        }

        public Failed() {
            this(null, 1, null);
        }
    }

    public static final class InstallFailed
    implements ChannelEvent {
        @NotNull
        private final FailedUpdate.Reason reason;

        public InstallFailed(@NotNull FailedUpdate.Reason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.reason = reason;
        }

        @NotNull
        public final FailedUpdate.Reason getReason() {
            return this.reason;
        }

        @NotNull
        public final FailedUpdate.Reason component1() {
            return this.reason;
        }

        @NotNull
        public final InstallFailed copy(@NotNull FailedUpdate.Reason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new InstallFailed(reason);
        }

        public static /* synthetic */ InstallFailed copy$default(InstallFailed installFailed, FailedUpdate.Reason reason, int n, Object object) {
            if ((n & 1) != 0) {
                reason = installFailed.reason;
            }
            return installFailed.copy(reason);
        }

        @NotNull
        public String toString() {
            return "InstallFailed(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InstallFailed)) {
                return false;
            }
            InstallFailed installFailed = (InstallFailed)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)installFailed.reason);
        }
    }

    public static final class Installed
    implements ChannelEvent {
        @NotNull
        private final ToolInstance toolInstance;

        public Installed(@NotNull ToolInstance toolInstance) {
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            this.toolInstance = toolInstance;
        }

        @NotNull
        public final ToolInstance getToolInstance() {
            return this.toolInstance;
        }

        @NotNull
        public String toString() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "()";
        }

        @NotNull
        public final ToolInstance component1() {
            return this.toolInstance;
        }

        @NotNull
        public final Installed copy(@NotNull ToolInstance toolInstance) {
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            return new Installed(toolInstance);
        }

        public static /* synthetic */ Installed copy$default(Installed installed2, ToolInstance toolInstance, int n, Object object) {
            if ((n & 1) != 0) {
                toolInstance = installed2.toolInstance;
            }
            return installed2.copy(toolInstance);
        }

        public int hashCode() {
            return this.toolInstance.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Installed)) {
                return false;
            }
            Installed installed2 = (Installed)other;
            return Intrinsics.areEqual((Object)this.toolInstance, (Object)installed2.toolInstance);
        }
    }

    public static final class InstantUpdateFailed
    implements ChannelEvent {
        @NotNull
        private final Path unpackedToolDirectory;
        @NotNull
        private final FailedUpdate.Reason reason;

        public InstantUpdateFailed(@NotNull Path unpackedToolDirectory, @NotNull FailedUpdate.Reason reason) {
            Intrinsics.checkNotNullParameter((Object)unpackedToolDirectory, (String)"unpackedToolDirectory");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.unpackedToolDirectory = unpackedToolDirectory;
            this.reason = reason;
        }

        @NotNull
        public final Path getUnpackedToolDirectory() {
            return this.unpackedToolDirectory;
        }

        @NotNull
        public final FailedUpdate.Reason getReason() {
            return this.reason;
        }

        @NotNull
        public final Path component1() {
            return this.unpackedToolDirectory;
        }

        @NotNull
        public final FailedUpdate.Reason component2() {
            return this.reason;
        }

        @NotNull
        public final InstantUpdateFailed copy(@NotNull Path unpackedToolDirectory, @NotNull FailedUpdate.Reason reason) {
            Intrinsics.checkNotNullParameter((Object)unpackedToolDirectory, (String)"unpackedToolDirectory");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new InstantUpdateFailed(unpackedToolDirectory, reason);
        }

        public static /* synthetic */ InstantUpdateFailed copy$default(InstantUpdateFailed instantUpdateFailed, Path path2, FailedUpdate.Reason reason, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = instantUpdateFailed.unpackedToolDirectory;
            }
            if ((n & 2) != 0) {
                reason = instantUpdateFailed.reason;
            }
            return instantUpdateFailed.copy(path2, reason);
        }

        @NotNull
        public String toString() {
            return "InstantUpdateFailed(unpackedToolDirectory=" + this.unpackedToolDirectory + ", reason=" + this.reason + ")";
        }

        public int hashCode() {
            int result2 = this.unpackedToolDirectory.hashCode();
            result2 = result2 * 31 + this.reason.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InstantUpdateFailed)) {
                return false;
            }
            InstantUpdateFailed instantUpdateFailed = (InstantUpdateFailed)other;
            if (!Intrinsics.areEqual((Object)this.unpackedToolDirectory, (Object)instantUpdateFailed.unpackedToolDirectory)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)instantUpdateFailed.reason);
        }
    }

    public static sealed interface MultiQueueable
    extends Queueable
    permits ToolInstanceChangeRequired {
    }

    public static final class NotEligible
    implements ChannelEvent {
        @NotNull
        public static final NotEligible INSTANCE = new NotEligible();

        private NotEligible() {
        }

        @NotNull
        public String toString() {
            return "NotEligible";
        }

        public int hashCode() {
            return 43430155;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotEligible)) {
                return false;
            }
            NotEligible cfr_ignored_0 = (NotEligible)other;
            return true;
        }
    }

    public static final class PatchingFailed
    implements ChannelEvent {
        @NotNull
        public static final PatchingFailed INSTANCE = new PatchingFailed();

        private PatchingFailed() {
        }

        @NotNull
        public String toString() {
            return "PatchingFailed";
        }

        public int hashCode() {
            return -715548522;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PatchingFailed)) {
                return false;
            }
            PatchingFailed cfr_ignored_0 = (PatchingFailed)other;
            return true;
        }
    }

    public static final class PatchingSuccessful
    implements ChannelEvent {
        @NotNull
        private final Path directory;

        public PatchingSuccessful(@NotNull Path directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            this.directory = directory;
        }

        @NotNull
        public final Path getDirectory() {
            return this.directory;
        }

        @NotNull
        public final Path component1() {
            return this.directory;
        }

        @NotNull
        public final PatchingSuccessful copy(@NotNull Path directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return new PatchingSuccessful(directory);
        }

        public static /* synthetic */ PatchingSuccessful copy$default(PatchingSuccessful patchingSuccessful, Path path2, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = patchingSuccessful.directory;
            }
            return patchingSuccessful.copy(path2);
        }

        @NotNull
        public String toString() {
            return "PatchingSuccessful(directory=" + this.directory + ")";
        }

        public int hashCode() {
            return this.directory.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PatchingSuccessful)) {
                return false;
            }
            PatchingSuccessful patchingSuccessful = (PatchingSuccessful)other;
            return Intrinsics.areEqual((Object)this.directory, (Object)patchingSuccessful.directory);
        }
    }

    public static final class Preinstalled
    implements ChannelEvent {
        @NotNull
        private final Channel channel;
        @NotNull
        private final InstalledTool tool;
        @NotNull
        private final ChangeOptions changeOptions;

        public Preinstalled(@NotNull Channel channel, @NotNull InstalledTool tool, @NotNull ChangeOptions changeOptions) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)changeOptions, (String)"changeOptions");
            this.channel = channel;
            this.tool = tool;
            this.changeOptions = changeOptions;
        }

        @NotNull
        public final Channel getChannel() {
            return this.channel;
        }

        @NotNull
        public final InstalledTool getTool() {
            return this.tool;
        }

        @NotNull
        public final ChangeOptions getChangeOptions() {
            return this.changeOptions;
        }

        @NotNull
        public final Channel component1() {
            return this.channel;
        }

        @NotNull
        public final InstalledTool component2() {
            return this.tool;
        }

        @NotNull
        public final ChangeOptions component3() {
            return this.changeOptions;
        }

        @NotNull
        public final Preinstalled copy(@NotNull Channel channel, @NotNull InstalledTool tool, @NotNull ChangeOptions changeOptions) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)changeOptions, (String)"changeOptions");
            return new Preinstalled(channel, tool, changeOptions);
        }

        public static /* synthetic */ Preinstalled copy$default(Preinstalled preinstalled, Channel channel, InstalledTool installedTool2, ChangeOptions changeOptions, int n, Object object) {
            if ((n & 1) != 0) {
                channel = preinstalled.channel;
            }
            if ((n & 2) != 0) {
                installedTool2 = preinstalled.tool;
            }
            if ((n & 4) != 0) {
                changeOptions = preinstalled.changeOptions;
            }
            return preinstalled.copy(channel, installedTool2, changeOptions);
        }

        @NotNull
        public String toString() {
            return "Preinstalled(channel=" + this.channel + ", tool=" + this.tool + ", changeOptions=" + this.changeOptions + ")";
        }

        public int hashCode() {
            int result2 = this.channel.hashCode();
            result2 = result2 * 31 + this.tool.hashCode();
            result2 = result2 * 31 + this.changeOptions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Preinstalled)) {
                return false;
            }
            Preinstalled preinstalled = (Preinstalled)other;
            if (!Intrinsics.areEqual((Object)this.channel, (Object)preinstalled.channel)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tool, (Object)preinstalled.tool)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.changeOptions, (Object)preinstalled.changeOptions);
        }
    }

    public static final class PreparedForInstantUpdate
    implements ChannelEvent {
        @NotNull
        private final ToolInstance updatedToolInstance;
        @NotNull
        private final List<WorkingCopy> workingCopiesToApply;
        @NotNull
        private final List<WorkingCopy> workingCopiesToDiscard;

        public PreparedForInstantUpdate(@NotNull ToolInstance updatedToolInstance, @NotNull List<WorkingCopy> workingCopiesToApply, @NotNull List<WorkingCopy> workingCopiesToDiscard) {
            Intrinsics.checkNotNullParameter((Object)updatedToolInstance, (String)"updatedToolInstance");
            Intrinsics.checkNotNullParameter(workingCopiesToApply, (String)"workingCopiesToApply");
            Intrinsics.checkNotNullParameter(workingCopiesToDiscard, (String)"workingCopiesToDiscard");
            this.updatedToolInstance = updatedToolInstance;
            this.workingCopiesToApply = workingCopiesToApply;
            this.workingCopiesToDiscard = workingCopiesToDiscard;
        }

        @NotNull
        public final ToolInstance getUpdatedToolInstance() {
            return this.updatedToolInstance;
        }

        @NotNull
        public final List<WorkingCopy> getWorkingCopiesToApply() {
            return this.workingCopiesToApply;
        }

        @NotNull
        public final List<WorkingCopy> getWorkingCopiesToDiscard() {
            return this.workingCopiesToDiscard;
        }

        @NotNull
        public final ToolInstance component1() {
            return this.updatedToolInstance;
        }

        @NotNull
        public final List<WorkingCopy> component2() {
            return this.workingCopiesToApply;
        }

        @NotNull
        public final List<WorkingCopy> component3() {
            return this.workingCopiesToDiscard;
        }

        @NotNull
        public final PreparedForInstantUpdate copy(@NotNull ToolInstance updatedToolInstance, @NotNull List<WorkingCopy> workingCopiesToApply, @NotNull List<WorkingCopy> workingCopiesToDiscard) {
            Intrinsics.checkNotNullParameter((Object)updatedToolInstance, (String)"updatedToolInstance");
            Intrinsics.checkNotNullParameter(workingCopiesToApply, (String)"workingCopiesToApply");
            Intrinsics.checkNotNullParameter(workingCopiesToDiscard, (String)"workingCopiesToDiscard");
            return new PreparedForInstantUpdate(updatedToolInstance, workingCopiesToApply, workingCopiesToDiscard);
        }

        public static /* synthetic */ PreparedForInstantUpdate copy$default(PreparedForInstantUpdate preparedForInstantUpdate, ToolInstance toolInstance, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                toolInstance = preparedForInstantUpdate.updatedToolInstance;
            }
            if ((n & 2) != 0) {
                list2 = preparedForInstantUpdate.workingCopiesToApply;
            }
            if ((n & 4) != 0) {
                list3 = preparedForInstantUpdate.workingCopiesToDiscard;
            }
            return preparedForInstantUpdate.copy(toolInstance, list2, list3);
        }

        @NotNull
        public String toString() {
            return "PreparedForInstantUpdate(updatedToolInstance=" + this.updatedToolInstance + ", workingCopiesToApply=" + this.workingCopiesToApply + ", workingCopiesToDiscard=" + this.workingCopiesToDiscard + ")";
        }

        public int hashCode() {
            int result2 = this.updatedToolInstance.hashCode();
            result2 = result2 * 31 + ((Object)this.workingCopiesToApply).hashCode();
            result2 = result2 * 31 + ((Object)this.workingCopiesToDiscard).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PreparedForInstantUpdate)) {
                return false;
            }
            PreparedForInstantUpdate preparedForInstantUpdate = (PreparedForInstantUpdate)other;
            if (!Intrinsics.areEqual((Object)this.updatedToolInstance, (Object)preparedForInstantUpdate.updatedToolInstance)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.workingCopiesToApply, preparedForInstantUpdate.workingCopiesToApply)) {
                return false;
            }
            return Intrinsics.areEqual(this.workingCopiesToDiscard, preparedForInstantUpdate.workingCopiesToDiscard);
        }
    }

    public static sealed interface Queueable
    extends ChannelEvent
    permits ConfigurationOnClosedToolRequired, ConfigurationRequired, MultiQueueable, Refresh, Request {
    }

    public static final class Recovery
    implements ChannelEvent {
        @NotNull
        public static final Recovery INSTANCE = new Recovery();

        private Recovery() {
        }

        @NotNull
        public String toString() {
            return "Recovery";
        }

        public int hashCode() {
            return 621233140;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Recovery)) {
                return false;
            }
            Recovery cfr_ignored_0 = (Recovery)other;
            return true;
        }
    }

    public static final class Refresh
    implements Queueable {
        @NotNull
        public static final Refresh INSTANCE = new Refresh();

        private Refresh() {
        }

        @NotNull
        public String toString() {
            return "Refresh";
        }

        public int hashCode() {
            return -1916778852;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Refresh)) {
                return false;
            }
            Refresh cfr_ignored_0 = (Refresh)other;
            return true;
        }
    }

    public static final class Refreshed
    implements ChannelEvent {
        @NotNull
        private final ToolInstance toolInstance;
        @NotNull
        private final ChangeOptions changeOptions;

        public Refreshed(@NotNull ToolInstance toolInstance, @NotNull ChangeOptions changeOptions) {
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            Intrinsics.checkNotNullParameter((Object)changeOptions, (String)"changeOptions");
            this.toolInstance = toolInstance;
            this.changeOptions = changeOptions;
        }

        @NotNull
        public final ToolInstance getToolInstance() {
            return this.toolInstance;
        }

        @NotNull
        public final ChangeOptions getChangeOptions() {
            return this.changeOptions;
        }

        @NotNull
        public String toString() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(changeOptions=" + this.changeOptions + ")";
        }

        @NotNull
        public final ToolInstance component1() {
            return this.toolInstance;
        }

        @NotNull
        public final ChangeOptions component2() {
            return this.changeOptions;
        }

        @NotNull
        public final Refreshed copy(@NotNull ToolInstance toolInstance, @NotNull ChangeOptions changeOptions) {
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            Intrinsics.checkNotNullParameter((Object)changeOptions, (String)"changeOptions");
            return new Refreshed(toolInstance, changeOptions);
        }

        public static /* synthetic */ Refreshed copy$default(Refreshed refreshed, ToolInstance toolInstance, ChangeOptions changeOptions, int n, Object object) {
            if ((n & 1) != 0) {
                toolInstance = refreshed.toolInstance;
            }
            if ((n & 2) != 0) {
                changeOptions = refreshed.changeOptions;
            }
            return refreshed.copy(toolInstance, changeOptions);
        }

        public int hashCode() {
            int result2 = this.toolInstance.hashCode();
            result2 = result2 * 31 + this.changeOptions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Refreshed)) {
                return false;
            }
            Refreshed refreshed = (Refreshed)other;
            if (!Intrinsics.areEqual((Object)this.toolInstance, (Object)refreshed.toolInstance)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.changeOptions, (Object)refreshed.changeOptions);
        }
    }

    public static sealed interface Request
    extends Queueable {

        public static final class Cancel
        implements Request {
            @NotNull
            public static final Cancel INSTANCE = new Cancel();

            private Cancel() {
            }

            @NotNull
            public String toString() {
                return "Cancel";
            }

            public int hashCode() {
                return 1155031032;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Cancel)) {
                    return false;
                }
                Cancel cfr_ignored_0 = (Cancel)other;
                return true;
            }
        }

        public static final class Downgrade
        implements Request {
            @NotNull
            public static final Downgrade INSTANCE = new Downgrade();

            private Downgrade() {
            }

            @NotNull
            public String toString() {
                return "Downgrade";
            }

            public int hashCode() {
                return -916806089;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Downgrade)) {
                    return false;
                }
                Downgrade cfr_ignored_0 = (Downgrade)other;
                return true;
            }
        }

        public static final class Install
        implements ChannelEvent {
            @NotNull
            private final Channel channel;
            @NotNull
            private final EphemeralTool tool;
            @NotNull
            private final ChangeOptions changeOptions;
            @NotNull
            private final ToolBuild build;

            public Install(@NotNull Channel channel, @NotNull EphemeralTool tool, @NotNull ChangeOptions changeOptions, @NotNull ToolBuild build2) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                Intrinsics.checkNotNullParameter((Object)changeOptions, (String)"changeOptions");
                Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
                this.channel = channel;
                this.tool = tool;
                this.changeOptions = changeOptions;
                this.build = build2;
            }

            @NotNull
            public final Channel getChannel() {
                return this.channel;
            }

            @NotNull
            public final EphemeralTool getTool() {
                return this.tool;
            }

            @NotNull
            public final ChangeOptions getChangeOptions() {
                return this.changeOptions;
            }

            @NotNull
            public final ToolBuild getBuild() {
                return this.build;
            }

            @NotNull
            public final Channel component1() {
                return this.channel;
            }

            @NotNull
            public final EphemeralTool component2() {
                return this.tool;
            }

            @NotNull
            public final ChangeOptions component3() {
                return this.changeOptions;
            }

            @NotNull
            public final ToolBuild component4() {
                return this.build;
            }

            @NotNull
            public final Install copy(@NotNull Channel channel, @NotNull EphemeralTool tool, @NotNull ChangeOptions changeOptions, @NotNull ToolBuild build2) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                Intrinsics.checkNotNullParameter((Object)changeOptions, (String)"changeOptions");
                Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
                return new Install(channel, tool, changeOptions, build2);
            }

            public static /* synthetic */ Install copy$default(Install install2, Channel channel, EphemeralTool ephemeralTool, ChangeOptions changeOptions, ToolBuild toolBuild2, int n, Object object) {
                if ((n & 1) != 0) {
                    channel = install2.channel;
                }
                if ((n & 2) != 0) {
                    ephemeralTool = install2.tool;
                }
                if ((n & 4) != 0) {
                    changeOptions = install2.changeOptions;
                }
                if ((n & 8) != 0) {
                    toolBuild2 = install2.build;
                }
                return install2.copy(channel, ephemeralTool, changeOptions, toolBuild2);
            }

            @NotNull
            public String toString() {
                return "Install(channel=" + this.channel + ", tool=" + this.tool + ", changeOptions=" + this.changeOptions + ", build=" + this.build + ")";
            }

            public int hashCode() {
                int result2 = this.channel.hashCode();
                result2 = result2 * 31 + this.tool.hashCode();
                result2 = result2 * 31 + this.changeOptions.hashCode();
                result2 = result2 * 31 + this.build.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Install)) {
                    return false;
                }
                Install install2 = (Install)other;
                if (!Intrinsics.areEqual((Object)this.channel, (Object)install2.channel)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.tool, (Object)install2.tool)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.changeOptions, (Object)install2.changeOptions)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.build, (Object)install2.build);
            }
        }

        public static final class ResetSettings
        implements Request {
            @NotNull
            public static final ResetSettings INSTANCE = new ResetSettings();

            private ResetSettings() {
            }

            @NotNull
            public String toString() {
                return "ResetSettings";
            }

            public int hashCode() {
                return 1775321940;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ResetSettings)) {
                    return false;
                }
                ResetSettings cfr_ignored_0 = (ResetSettings)other;
                return true;
            }
        }

        public static final class Uninstall
        implements Request {
            @NotNull
            public static final Uninstall INSTANCE = new Uninstall();

            private Uninstall() {
            }

            @NotNull
            public String toString() {
                return "Uninstall";
            }

            public int hashCode() {
                return 1444388516;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Uninstall)) {
                    return false;
                }
                Uninstall cfr_ignored_0 = (Uninstall)other;
                return true;
            }
        }

        public static final class Update
        implements Request {
            private final boolean autoUpdate;

            public Update(boolean autoUpdate) {
                this.autoUpdate = autoUpdate;
            }

            public final boolean getAutoUpdate() {
                return this.autoUpdate;
            }

            public final boolean component1() {
                return this.autoUpdate;
            }

            @NotNull
            public final Update copy(boolean autoUpdate) {
                return new Update(autoUpdate);
            }

            public static /* synthetic */ Update copy$default(Update update2, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = update2.autoUpdate;
                }
                return update2.copy(bl);
            }

            @NotNull
            public String toString() {
                return "Update(autoUpdate=" + this.autoUpdate + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.autoUpdate);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Update)) {
                    return false;
                }
                Update update2 = (Update)other;
                return this.autoUpdate == update2.autoUpdate;
            }
        }

        public static final class UpdateTo
        implements Request {
            @NotNull
            private final ToolBuild toolBuild;

            public UpdateTo(@NotNull ToolBuild toolBuild2) {
                Intrinsics.checkNotNullParameter((Object)toolBuild2, (String)"toolBuild");
                this.toolBuild = toolBuild2;
            }

            @NotNull
            public final ToolBuild getToolBuild() {
                return this.toolBuild;
            }

            @NotNull
            public final ToolBuild component1() {
                return this.toolBuild;
            }

            @NotNull
            public final UpdateTo copy(@NotNull ToolBuild toolBuild2) {
                Intrinsics.checkNotNullParameter((Object)toolBuild2, (String)"toolBuild");
                return new UpdateTo(toolBuild2);
            }

            public static /* synthetic */ UpdateTo copy$default(UpdateTo updateTo, ToolBuild toolBuild2, int n, Object object) {
                if ((n & 1) != 0) {
                    toolBuild2 = updateTo.toolBuild;
                }
                return updateTo.copy(toolBuild2);
            }

            @NotNull
            public String toString() {
                return "UpdateTo(toolBuild=" + this.toolBuild + ")";
            }

            public int hashCode() {
                return this.toolBuild.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UpdateTo)) {
                    return false;
                }
                UpdateTo updateTo = (UpdateTo)other;
                return Intrinsics.areEqual((Object)this.toolBuild, (Object)updateTo.toolBuild);
            }
        }

        public static final class UpdateToSkipped
        implements Request {
            @NotNull
            public static final UpdateToSkipped INSTANCE = new UpdateToSkipped();

            private UpdateToSkipped() {
            }

            @NotNull
            public String toString() {
                return "UpdateToSkipped";
            }

            public int hashCode() {
                return 1659245998;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UpdateToSkipped)) {
                    return false;
                }
                UpdateToSkipped cfr_ignored_0 = (UpdateToSkipped)other;
                return true;
            }
        }
    }

    public static final class ResumeInstallation
    implements ChannelEvent {
        @NotNull
        private final Channel channel;
        @NotNull
        private final Path unpackedDirectory;
        @NotNull
        private final ToolBuild build;
        @Nullable
        private final Stage stage;

        public ResumeInstallation(@NotNull Channel channel, @NotNull Path unpackedDirectory, @NotNull ToolBuild build2, @Nullable Stage stage) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)unpackedDirectory, (String)"unpackedDirectory");
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            this.channel = channel;
            this.unpackedDirectory = unpackedDirectory;
            this.build = build2;
            this.stage = stage;
        }

        @NotNull
        public final Channel getChannel() {
            return this.channel;
        }

        @NotNull
        public final Path getUnpackedDirectory() {
            return this.unpackedDirectory;
        }

        @NotNull
        public final ToolBuild getBuild() {
            return this.build;
        }

        @Nullable
        public final Stage getStage() {
            return this.stage;
        }

        @NotNull
        public final Channel component1() {
            return this.channel;
        }

        @NotNull
        public final Path component2() {
            return this.unpackedDirectory;
        }

        @NotNull
        public final ToolBuild component3() {
            return this.build;
        }

        @Nullable
        public final Stage component4() {
            return this.stage;
        }

        @NotNull
        public final ResumeInstallation copy(@NotNull Channel channel, @NotNull Path unpackedDirectory, @NotNull ToolBuild build2, @Nullable Stage stage) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            Intrinsics.checkNotNullParameter((Object)unpackedDirectory, (String)"unpackedDirectory");
            Intrinsics.checkNotNullParameter((Object)build2, (String)"build");
            return new ResumeInstallation(channel, unpackedDirectory, build2, stage);
        }

        public static /* synthetic */ ResumeInstallation copy$default(ResumeInstallation resumeInstallation, Channel channel, Path path2, ToolBuild toolBuild2, Stage stage, int n, Object object) {
            if ((n & 1) != 0) {
                channel = resumeInstallation.channel;
            }
            if ((n & 2) != 0) {
                path2 = resumeInstallation.unpackedDirectory;
            }
            if ((n & 4) != 0) {
                toolBuild2 = resumeInstallation.build;
            }
            if ((n & 8) != 0) {
                stage = resumeInstallation.stage;
            }
            return resumeInstallation.copy(channel, path2, toolBuild2, stage);
        }

        @NotNull
        public String toString() {
            return "ResumeInstallation(channel=" + this.channel + ", unpackedDirectory=" + this.unpackedDirectory + ", build=" + this.build + ", stage=" + this.stage + ")";
        }

        public int hashCode() {
            int result2 = this.channel.hashCode();
            result2 = result2 * 31 + this.unpackedDirectory.hashCode();
            result2 = result2 * 31 + this.build.hashCode();
            result2 = result2 * 31 + (this.stage == null ? 0 : this.stage.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResumeInstallation)) {
                return false;
            }
            ResumeInstallation resumeInstallation = (ResumeInstallation)other;
            if (!Intrinsics.areEqual((Object)this.channel, (Object)resumeInstallation.channel)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.unpackedDirectory, (Object)resumeInstallation.unpackedDirectory)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.build, (Object)resumeInstallation.build)) {
                return false;
            }
            return this.stage == resumeInstallation.stage;
        }

        public static final class Stage
        extends Enum<Stage> {
            public static final /* enum */ Stage BackupFinished = new Stage();
            public static final /* enum */ Stage MoveFinished = new Stage();
            private static final /* synthetic */ Stage[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Stage[] values() {
                return (Stage[])$VALUES.clone();
            }

            public static Stage valueOf(String value2) {
                return Enum.valueOf(Stage.class, value2);
            }

            @NotNull
            public static EnumEntries<Stage> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = stageArray = new Stage[]{Stage.BackupFinished, Stage.MoveFinished};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    public static final class ToolInstanceChangeRequired
    implements MultiQueueable {
        @NotNull
        private final Function1<ToolInstance, ToolInstance> update;

        public ToolInstanceChangeRequired(@NotNull Function1<? super ToolInstance, ToolInstance> update2) {
            Intrinsics.checkNotNullParameter(update2, (String)"update");
            this.update = update2;
        }

        @NotNull
        public final Function1<ToolInstance, ToolInstance> getUpdate() {
            return this.update;
        }

        @NotNull
        public final Function1<ToolInstance, ToolInstance> component1() {
            return this.update;
        }

        @NotNull
        public final ToolInstanceChangeRequired copy(@NotNull Function1<? super ToolInstance, ToolInstance> update2) {
            Intrinsics.checkNotNullParameter(update2, (String)"update");
            return new ToolInstanceChangeRequired(update2);
        }

        public static /* synthetic */ ToolInstanceChangeRequired copy$default(ToolInstanceChangeRequired toolInstanceChangeRequired, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = toolInstanceChangeRequired.update;
            }
            return toolInstanceChangeRequired.copy(function1);
        }

        @NotNull
        public String toString() {
            return "ToolInstanceChangeRequired(update=" + this.update + ")";
        }

        public int hashCode() {
            return this.update.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToolInstanceChangeRequired)) {
                return false;
            }
            ToolInstanceChangeRequired toolInstanceChangeRequired = (ToolInstanceChangeRequired)other;
            return Intrinsics.areEqual(this.update, toolInstanceChangeRequired.update);
        }
    }

    public static final class ToolInstanceChanged
    implements ChannelEvent {
        @NotNull
        private final ToolInstance toolInstance;

        public ToolInstanceChanged(@NotNull ToolInstance toolInstance) {
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            this.toolInstance = toolInstance;
        }

        @NotNull
        public final ToolInstance getToolInstance() {
            return this.toolInstance;
        }

        @NotNull
        public String toString() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "()";
        }

        @NotNull
        public final ToolInstance component1() {
            return this.toolInstance;
        }

        @NotNull
        public final ToolInstanceChanged copy(@NotNull ToolInstance toolInstance) {
            Intrinsics.checkNotNullParameter((Object)toolInstance, (String)"toolInstance");
            return new ToolInstanceChanged(toolInstance);
        }

        public static /* synthetic */ ToolInstanceChanged copy$default(ToolInstanceChanged toolInstanceChanged, ToolInstance toolInstance, int n, Object object) {
            if ((n & 1) != 0) {
                toolInstance = toolInstanceChanged.toolInstance;
            }
            return toolInstanceChanged.copy(toolInstance);
        }

        public int hashCode() {
            return this.toolInstance.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ToolInstanceChanged)) {
                return false;
            }
            ToolInstanceChanged toolInstanceChanged = (ToolInstanceChanged)other;
            return Intrinsics.areEqual((Object)this.toolInstance, (Object)toolInstanceChanged.toolInstance);
        }
    }

    public static final class UninstallFailed
    implements ChannelEvent {
        @NotNull
        private final UninstallResult reason;

        public UninstallFailed(@NotNull UninstallResult reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.reason = reason;
        }

        @NotNull
        public final UninstallResult getReason() {
            return this.reason;
        }

        @NotNull
        public final UninstallResult component1() {
            return this.reason;
        }

        @NotNull
        public final UninstallFailed copy(@NotNull UninstallResult reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new UninstallFailed(reason);
        }

        public static /* synthetic */ UninstallFailed copy$default(UninstallFailed uninstallFailed, UninstallResult uninstallResult, int n, Object object) {
            if ((n & 1) != 0) {
                uninstallResult = uninstallFailed.reason;
            }
            return uninstallFailed.copy(uninstallResult);
        }

        @NotNull
        public String toString() {
            return "UninstallFailed(reason=" + this.reason + ")";
        }

        public int hashCode() {
            return this.reason.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UninstallFailed)) {
                return false;
            }
            UninstallFailed uninstallFailed = (UninstallFailed)other;
            return Intrinsics.areEqual((Object)this.reason, (Object)uninstallFailed.reason);
        }
    }

    public static final class Uninstalled
    implements ChannelEvent {
        @NotNull
        public static final Uninstalled INSTANCE = new Uninstalled();

        private Uninstalled() {
        }

        @NotNull
        public String toString() {
            return "Uninstalled";
        }

        public int hashCode() {
            return -378834878;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Uninstalled)) {
                return false;
            }
            Uninstalled cfr_ignored_0 = (Uninstalled)other;
            return true;
        }
    }

    public static final class Unpacked
    implements ChannelEvent {
        @NotNull
        private final Path directory;

        public Unpacked(@NotNull Path directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            this.directory = directory;
        }

        @NotNull
        public final Path getDirectory() {
            return this.directory;
        }

        @NotNull
        public final Path component1() {
            return this.directory;
        }

        @NotNull
        public final Unpacked copy(@NotNull Path directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return new Unpacked(directory);
        }

        public static /* synthetic */ Unpacked copy$default(Unpacked unpacked, Path path2, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = unpacked.directory;
            }
            return unpacked.copy(path2);
        }

        @NotNull
        public String toString() {
            return "Unpacked(directory=" + this.directory + ")";
        }

        public int hashCode() {
            return this.directory.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Unpacked)) {
                return false;
            }
            Unpacked unpacked = (Unpacked)other;
            return Intrinsics.areEqual((Object)this.directory, (Object)unpacked.directory);
        }
    }

    public static final class UpdatePostponed
    implements ChannelEvent {
        @NotNull
        private final FailedUpdate failedUpdate;

        public UpdatePostponed(@NotNull FailedUpdate failedUpdate) {
            Intrinsics.checkNotNullParameter((Object)failedUpdate, (String)"failedUpdate");
            this.failedUpdate = failedUpdate;
        }

        @NotNull
        public final FailedUpdate getFailedUpdate() {
            return this.failedUpdate;
        }

        @NotNull
        public final FailedUpdate component1() {
            return this.failedUpdate;
        }

        @NotNull
        public final UpdatePostponed copy(@NotNull FailedUpdate failedUpdate) {
            Intrinsics.checkNotNullParameter((Object)failedUpdate, (String)"failedUpdate");
            return new UpdatePostponed(failedUpdate);
        }

        public static /* synthetic */ UpdatePostponed copy$default(UpdatePostponed updatePostponed, FailedUpdate failedUpdate, int n, Object object) {
            if ((n & 1) != 0) {
                failedUpdate = updatePostponed.failedUpdate;
            }
            return updatePostponed.copy(failedUpdate);
        }

        @NotNull
        public String toString() {
            return "UpdatePostponed(failedUpdate=" + this.failedUpdate + ")";
        }

        public int hashCode() {
            return this.failedUpdate.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UpdatePostponed)) {
                return false;
            }
            UpdatePostponed updatePostponed = (UpdatePostponed)other;
            return Intrinsics.areEqual((Object)this.failedUpdate, (Object)updatePostponed.failedUpdate);
        }
    }

    public static final class VerificationFailed
    implements ChannelEvent {
        @NotNull
        public static final VerificationFailed INSTANCE = new VerificationFailed();

        private VerificationFailed() {
        }

        @NotNull
        public String toString() {
            return "VerificationFailed";
        }

        public int hashCode() {
            return -1292685353;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VerificationFailed)) {
                return false;
            }
            VerificationFailed cfr_ignored_0 = (VerificationFailed)other;
            return true;
        }
    }

    public static final class VerificationSuccessful
    implements ChannelEvent {
        @NotNull
        public static final VerificationSuccessful INSTANCE = new VerificationSuccessful();

        private VerificationSuccessful() {
        }

        @NotNull
        public String toString() {
            return "VerificationSuccessful";
        }

        public int hashCode() {
            return 1448536372;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VerificationSuccessful)) {
                return false;
            }
            VerificationSuccessful cfr_ignored_0 = (VerificationSuccessful)other;
            return true;
        }
    }

    public static final class WaitForUserAction
    implements ChannelEvent {
        @NotNull
        public static final WaitForUserAction INSTANCE = new WaitForUserAction();

        private WaitForUserAction() {
        }

        @NotNull
        public String toString() {
            return "WaitForUserAction";
        }

        public int hashCode() {
            return 112324246;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WaitForUserAction)) {
                return false;
            }
            WaitForUserAction cfr_ignored_0 = (WaitForUserAction)other;
            return true;
        }
    }
}

