/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools.launcher;

import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.tools.launcher.ProcessParameters;
import com.jetbrains.toolbox.tools.launcher.ToolParameters;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProcessLauncher {
    @NotNull
    public abstract ProcessRunner getProcesses();

    @Nullable
    public final ProcessHandle attach(long pid) {
        Optional<ProcessHandle> optional = ProcessHandle.of(pid);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return (ProcessHandle)OptionalsKt.getOrNull(optional);
    }

    @Nullable
    public abstract ProcessHandle launch(@NotNull ToolParameters var1, @NotNull ProcessParameters var2);

    public static /* synthetic */ ProcessHandle launch$default(ProcessLauncher processLauncher, ToolParameters toolParameters, ProcessParameters processParameters, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: launch");
        }
        if ((n & 2) != 0) {
            processParameters = new ProcessParameters(null, false, false, null, null, null, null, 127, null);
        }
        return processLauncher.launch(toolParameters, processParameters);
    }

    @Nullable
    public final ProcessHandle executeProcess(@NotNull Path file, @NotNull ProcessParameters processParameters) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        return ProcessLauncher.executeProcess$default(this, file.toFile(), processParameters, null, 4, null);
    }

    @Nullable
    public final ProcessHandle executeProcess(@NotNull File file, @NotNull ProcessParameters processParameters, @Nullable File workingDir) {
        ProcessHandle processHandle;
        File realWorkingDir;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)processParameters, (String)"processParameters");
        ProcessParameters $this$executeProcess_u24lambda_u240 = processParameters;
        boolean bl = false;
        File file2 = workingDir;
        if (file2 == null) {
            file2 = realWorkingDir = new File(file.getParent());
        }
        if ($this$executeProcess_u24lambda_u240.getWait()) {
            ProcessRunner processRunner = this.getProcesses();
            List<String> list2 = $this$executeProcess_u24lambda_u240.getArguments();
            Map<String, String> map2 = $this$executeProcess_u24lambda_u240.getAdditionalEnvironment();
            ProcessOutputHandler processOutputHandler = $this$executeProcess_u24lambda_u240.getHandleOut();
            ProcessOutputHandler processOutputHandler2 = $this$executeProcess_u24lambda_u240.getHandleErr();
            long l = DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.MINUTES);
            processRunner.executeProcessAndWait-B8UsjHI(file, list2, realWorkingDir, processOutputHandler, processOutputHandler2, map2, l);
            processHandle = null;
        } else {
            processHandle = this.getProcesses().forkProcessNoWait(file, $this$executeProcess_u24lambda_u240.getArguments(), realWorkingDir, $this$executeProcess_u24lambda_u240.getAdditionalEnvironment(), $this$executeProcess_u24lambda_u240.getAsAdmin(), $this$executeProcess_u24lambda_u240.getHandleOut(), $this$executeProcess_u24lambda_u240.getHandleErr());
        }
        return processHandle;
    }

    public static /* synthetic */ ProcessHandle executeProcess$default(ProcessLauncher processLauncher, File file, ProcessParameters processParameters, File file2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeProcess");
        }
        if ((n & 4) != 0) {
            file2 = null;
        }
        return processLauncher.executeProcess(file, processParameters, file2);
    }
}

