/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.common.ActionProgress;
import com.jetbrains.toolbox.enterprise.EnterpriseToolExtension;
import com.jetbrains.toolbox.enterprise.rest.ToolNotification;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.tools.UninstallResultKt;
import com.jetbrains.toolbox.tools.model.AvailableToolBuild;
import com.jetbrains.toolbox.tools.model.ChangeOptions;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.ToolDescription;
import com.jetbrains.toolbox.tools.model.ToolUpdate;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;

public final class LocalToolStateManagerKt {
    @NotNull
    public static final ToolDescription.ChangeOptionsDescription toChangeOptionsDescription(@NotNull ChangeOptions $this$toChangeOptionsDescription) {
        Intrinsics.checkNotNullParameter((Object)$this$toChangeOptionsDescription, (String)"<this>");
        ToolUpdate toolUpdate = $this$toChangeOptionsDescription.getUpdate();
        ToolUpdate toolUpdate2 = $this$toChangeOptionsDescription.getSkippedUpdate();
        ToolUpdate.Full full = $this$toChangeOptionsDescription.getDowngrade();
        ToolUpdate toolUpdate3 = $this$toChangeOptionsDescription.getUpdate();
        return new ToolDescription.ChangeOptionsDescription(toolUpdate != null ? LocalToolStateManagerKt.toAvailableToolBuild(toolUpdate) : null, toolUpdate2 != null ? LocalToolStateManagerKt.toAvailableToolBuild(toolUpdate2) : null, full != null ? LocalToolStateManagerKt.toAvailableToolBuild(full) : null, $this$toChangeOptionsDescription.getStatus(), toolUpdate3 != null ? toolUpdate3.getPreviousFailedUpdate() : null);
    }

    @NotNull
    public static final AvailableToolBuild toAvailableToolBuild(@NotNull ToolUpdate $this$toAvailableToolBuild) {
        Intrinsics.checkNotNullParameter((Object)$this$toAvailableToolBuild, (String)"<this>");
        return AvailableToolBuild.Companion.of($this$toAvailableToolBuild.getBuild());
    }

    @NotNull
    public static final ToolDescription.Enterprise toEnterprise(@NotNull EnterpriseToolExtension $this$toEnterprise, @NotNull Clock clock) {
        ToolDescription.Enterprise.Notification notification2;
        Intrinsics.checkNotNullParameter((Object)$this$toEnterprise, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        ToolNotification toolNotification = $this$toEnterprise.getNotification();
        if (toolNotification != null) {
            ToolNotification notification3 = toolNotification;
            boolean bl = false;
            notification2 = new ToolDescription.Enterprise.Notification(notification3.getDeadline().compareTo(clock.now()) <= 0, notification3.getDeadline(), notification3.getDescription());
        } else {
            notification2 = null;
        }
        ToolDescription.Enterprise.Notification notification4 = notification2;
        return new ToolDescription.Enterprise(notification4);
    }

    @NotNull
    public static final ToolDescription.State toDescriptionState(@NotNull ChannelState $this$toDescriptionState) {
        ToolDescription.State state2;
        Intrinsics.checkNotNullParameter((Object)$this$toDescriptionState, (String)"<this>");
        ChannelState channelState2 = $this$toDescriptionState;
        if (channelState2 instanceof ChannelState.Terminal) {
            ChannelState.InstallationUnsuccessful installationUnsuccessful = $this$toDescriptionState instanceof ChannelState.InstallationUnsuccessful ? (ChannelState.InstallationUnsuccessful)$this$toDescriptionState : null;
            state2 = new ToolDescription.State.Terminal(LocalToolStateManagerKt.localizableName($this$toDescriptionState), false, false, (LocalizableString)(installationUnsuccessful != null ? installationUnsuccessful.getReason() : null));
        } else if (channelState2 instanceof ChannelState.Uninstalling) {
            state2 = new ToolDescription.State.Uninstalling(LocalToolStateManagerKt.localizableName($this$toDescriptionState), true, false);
        } else if (channelState2 instanceof ChannelState.UpdatePending || channelState2 instanceof ChannelState.RefreshingPendingToolUpdate || channelState2 instanceof ChannelState.PendingInstantUpdate) {
            LocalizableString localizableString;
            LocalizableString localizableString2 = LocalToolStateManagerKt.localizableName($this$toDescriptionState);
            ChannelState.HasTargetBuild hasTargetBuild = (ChannelState.HasTargetBuild)$this$toDescriptionState;
            if (hasTargetBuild instanceof ChannelState.UpdatePending) {
                localizableString = UninstallResultKt.toLocalizableString(((ChannelState.UpdatePending)$this$toDescriptionState).getReason(), ((ChannelState.UpdatePending)$this$toDescriptionState).getTool().getToolName());
            } else if (hasTargetBuild instanceof ChannelState.RefreshingPendingToolUpdate) {
                localizableString = UninstallResultKt.toLocalizableString(((ChannelState.RefreshingPendingToolUpdate)$this$toDescriptionState).getReason(), ((ChannelState.RefreshingPendingToolUpdate)$this$toDescriptionState).getTool().getToolName());
            } else if (hasTargetBuild instanceof ChannelState.PendingInstantUpdate) {
                localizableString = UninstallResultKt.toLocalizableString(((ChannelState.PendingInstantUpdate)$this$toDescriptionState).getReason(), ((ChannelState.PendingInstantUpdate)$this$toDescriptionState).getTool().getToolName());
            } else {
                throw new IllegalStateException("Unreachable".toString());
            }
            state2 = new ToolDescription.State.UpdatePending(localizableString2, true, false, localizableString);
        } else if (channelState2 instanceof ChannelState.Idle || channelState2 instanceof ChannelState.SelfUpdatePending || channelState2 instanceof ChannelState.RefreshingPendingSelfUpdate) {
            state2 = new ToolDescription.State.Idle(LocalToolStateManagerKt.localizableName($this$toDescriptionState), true, false);
        } else if (channelState2 instanceof ChannelState.Refreshing) {
            state2 = new ToolDescription.State.Refreshing(LocalToolStateManagerKt.localizableName($this$toDescriptionState), true, false);
        } else if (channelState2 instanceof ChannelState.ConfigurationPending) {
            state2 = new ToolDescription.State.ConfigurationPending(LocalToolStateManagerKt.localizableName($this$toDescriptionState), true, true);
        } else {
            LocalizableString localizableString = LocalToolStateManagerKt.localizableName($this$toDescriptionState);
            boolean bl = $this$toDescriptionState.getTool() instanceof InstalledTool;
            boolean bl2 = $this$toDescriptionState.getTool() instanceof InstalledTool && !($this$toDescriptionState instanceof ChannelState.Installing) && !($this$toDescriptionState instanceof ChannelState.Recovering);
            boolean bl3 = $this$toDescriptionState instanceof ChannelState.Cancelable;
            Object object = $this$toDescriptionState instanceof ChannelState.ApplyingConfigurator ? (ChannelState.ApplyingConfigurator)$this$toDescriptionState : null;
            StateFlow<LocalizableString> stateFlow = object != null && (object = ((ChannelState.ApplyingConfigurator)object).getConfigurator()) != null ? object.getDisplayName() : null;
            ChannelState.Measurable measurable = $this$toDescriptionState instanceof ChannelState.Measurable ? (ChannelState.Measurable)((Object)$this$toDescriptionState) : null;
            ActionProgress actionProgress = measurable != null ? measurable.getProgress() : null;
            state2 = new ToolDescription.State.Updating(localizableString, bl, bl3, bl2, stateFlow, actionProgress);
        }
        return state2;
    }

    @NotNull
    public static final LocalizableString localizableName(@NotNull ChannelState $this$localizableName) {
        LocalizableString localizableString;
        Intrinsics.checkNotNullParameter((Object)$this$localizableName, (String)"<this>");
        ChannelState channelState2 = $this$localizableName;
        if (channelState2 instanceof ChannelState.Initial) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (channelState2 instanceof ChannelState.Downloading || channelState2 instanceof ChannelState.PatchDownloading || channelState2 instanceof ChannelState.CheckingForUpdates) {
            localizableString = LocalizableStringExKt.trl("Downloading\u2026");
        } else if (channelState2 instanceof ChannelState.Idle) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (channelState2 instanceof ChannelState.Refreshing) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (channelState2 instanceof ChannelState.InstallationUnsuccessful) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (channelState2 instanceof ChannelState.Installing || channelState2 instanceof ChannelState.PerformingInstantUpdate) {
            localizableString = LocalizableStringExKt.trl("Installing\u2026");
        } else if (channelState2 instanceof ChannelState.SelfUpdate) {
            localizableString = LocalizableStringExKt.trl("Restarting\u2026");
        } else if (channelState2 instanceof ChannelState.Configuring || channelState2 instanceof ChannelState.ConfiguringForInstantUpdate || channelState2 instanceof ChannelState.PreparingForInstantUpdate) {
            localizableString = LocalizableStringExKt.trl("Configuring\u2026");
        } else if (channelState2 instanceof ChannelState.PatchVerifying) {
            localizableString = LocalizableStringExKt.trl("Verifying\u2026");
        } else if (channelState2 instanceof ChannelState.Patching) {
            localizableString = LocalizableStringExKt.trl("Applying patches\u2026");
        } else if (channelState2 instanceof ChannelState.Uninstalled) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (channelState2 instanceof ChannelState.Uninstalling) {
            localizableString = LocalizableStringExKt.trl("Uninstalling\u2026");
        } else if (channelState2 instanceof ChannelState.Unpacking) {
            localizableString = LocalizableStringExKt.trl("Unpacking\u2026");
        } else if (channelState2 instanceof ChannelState.UpdatePending || channelState2 instanceof ChannelState.SelfUpdatePending || channelState2 instanceof ChannelState.PendingInstantUpdate) {
            localizableString = LocalizableStringExKt.trl("Update ready");
        } else if (channelState2 instanceof ChannelState.CancellingPendingUpdate || channelState2 instanceof ChannelState.CancelingInstantUpdate) {
            localizableString = LocalizableStringExKt.trl("Cancelling\u2026");
        } else if (channelState2 instanceof ChannelState.RefreshingPendingUpdate) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (channelState2 instanceof ChannelState.Verifying) {
            localizableString = LocalizableStringExKt.trl("Verifying\u2026");
        } else if (channelState2 instanceof ChannelState.BackupVerifying) {
            localizableString = LocalizableStringExKt.trl("Verifying\u2026");
        } else if (channelState2 instanceof ChannelState.ApplyingConfigurator) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (channelState2 instanceof ChannelState.ResettingSettings) {
            localizableString = LocalizableStringExKt.trl("Resetting\u2026");
        } else if (channelState2 instanceof ChannelState.ConfigurationPending) {
            localizableString = LocalizableStringExKt.trl("Restart to apply new settings\u2026");
        } else if (channelState2 instanceof ChannelState.UpdateFailed) {
            localizableString = LocalizableStringExKt.trl("Update failed\u2026");
        } else if (channelState2 instanceof ChannelState.Preinstalling) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (channelState2 instanceof ChannelState.Recovering) {
            localizableString = LocalizableStringExKt.trl("Recovering\u2026");
        } else if (channelState2 instanceof ChannelState.CheckingInstantUpdateEligibility) {
            localizableString = LocalizableStringExKt.trl("");
        } else if (channelState2 instanceof ChannelState.Abandoned) {
            localizableString = LocalizableStringExKt.trl("");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return localizableString;
    }
}

