/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.tools;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.tools.model.IDEDirectories;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntelliJOptions {
    @Nullable
    private final Path defaultSettingsLocation;
    @NotNull
    private final IDEDirectories ideDirectories;
    private final boolean useDefaultVmOptions;
    @Nullable
    private final String xmx;
    @Nullable
    private final String defaultXmx;
    @Nullable
    private final LocalizableString reasonForNoCustomVmOptions;

    public IntelliJOptions(@Nullable Path defaultSettingsLocation, @NotNull IDEDirectories ideDirectories, boolean useDefaultVmOptions, @Nullable String xmx, @Nullable String defaultXmx, @Nullable LocalizableString reasonForNoCustomVmOptions) {
        Intrinsics.checkNotNullParameter((Object)ideDirectories, (String)"ideDirectories");
        this.defaultSettingsLocation = defaultSettingsLocation;
        this.ideDirectories = ideDirectories;
        this.useDefaultVmOptions = useDefaultVmOptions;
        this.xmx = xmx;
        this.defaultXmx = defaultXmx;
        this.reasonForNoCustomVmOptions = reasonForNoCustomVmOptions;
    }

    @Nullable
    public final Path getDefaultSettingsLocation() {
        return this.defaultSettingsLocation;
    }

    @NotNull
    public final IDEDirectories getIdeDirectories() {
        return this.ideDirectories;
    }

    public final boolean getUseDefaultVmOptions() {
        return this.useDefaultVmOptions;
    }

    @Nullable
    public final String getXmx() {
        return this.xmx;
    }

    @Nullable
    public final String getDefaultXmx() {
        return this.defaultXmx;
    }

    @Nullable
    public final LocalizableString getReasonForNoCustomVmOptions() {
        return this.reasonForNoCustomVmOptions;
    }

    @NotNull
    public String toString() {
        return "IntelliJOptions(defaultSettingsLocation=" + this.defaultSettingsLocation + ", ideDirectories=" + this.ideDirectories + ", useDefaultVmOptions=" + this.useDefaultVmOptions + ", xmx=" + this.xmx + ", defaultXmx=" + this.defaultXmx + ", reasonForNoCustomVmOptions=" + this.reasonForNoCustomVmOptions + ")";
    }

    public int hashCode() {
        int result2 = this.defaultSettingsLocation == null ? 0 : this.defaultSettingsLocation.hashCode();
        result2 = result2 * 31 + this.ideDirectories.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.useDefaultVmOptions);
        result2 = result2 * 31 + (this.xmx == null ? 0 : this.xmx.hashCode());
        result2 = result2 * 31 + (this.defaultXmx == null ? 0 : this.defaultXmx.hashCode());
        result2 = result2 * 31 + (this.reasonForNoCustomVmOptions == null ? 0 : this.reasonForNoCustomVmOptions.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntelliJOptions)) {
            return false;
        }
        IntelliJOptions intelliJOptions = (IntelliJOptions)other;
        if (!Intrinsics.areEqual((Object)this.defaultSettingsLocation, (Object)intelliJOptions.defaultSettingsLocation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.ideDirectories, (Object)intelliJOptions.ideDirectories)) {
            return false;
        }
        if (this.useDefaultVmOptions != intelliJOptions.useDefaultVmOptions) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.xmx, (Object)intelliJOptions.xmx)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultXmx, (Object)intelliJOptions.defaultXmx)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.reasonForNoCustomVmOptions, (Object)intelliJOptions.reasonForNoCustomVmOptions);
    }
}

