/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shortcutsWindows;

import com.jetbrains.toolbox.shortcutsWindows.UtilKt;
import com.jetbrains.toolbox.shortcutsWindows.Win32Shortcuts;
import com.jetbrains.toolbox.shortcutsWindows.WindowsShortcutChannelExtension;
import com.jetbrains.toolbox.tools.UninstallResult;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolUninstallHandler;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShortcutsUninstallHandler
implements ToolUninstallHandler {
    @NotNull
    private final Win32Shortcuts win32Shortcuts;

    public ShortcutsUninstallHandler(@NotNull Win32Shortcuts win32Shortcuts) {
        Intrinsics.checkNotNullParameter((Object)win32Shortcuts, (String)"win32Shortcuts");
        this.win32Shortcuts = win32Shortcuts;
    }

    @Override
    @Nullable
    public Object onUninstall(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super UninstallResult> $completion) {
        WindowsShortcutChannelExtension windowsShortcutChannelExtension = UtilKt.getWindowsShortcutExtension(toolInstance.getChannel());
        if (windowsShortcutChannelExtension == null || (windowsShortcutChannelExtension = windowsShortcutChannelExtension.getLastShortcutPath()) == null) {
            return UninstallResult.NotSupported.INSTANCE;
        }
        WindowsShortcutChannelExtension shortcutPath = windowsShortcutChannelExtension;
        UtilKt.removeApplicationShortcut(this.win32Shortcuts, (Path)shortcutPath);
        return UninstallResult.Success.INSTANCE;
    }
}

