/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.shell.resolver;

import com.jetbrains.toolbox.shell.model.ToolInfo;
import com.jetbrains.toolbox.shell.resolver.ExecutablePathResolver;
import com.jetbrains.toolbox.shell.resolver.ExecutableResolver;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nExecutableResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutableResolverImpl.kt\ncom/jetbrains/toolbox/shell/resolver/ExecutableResolverImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,16:1\n1#2:17\n*E\n"})
public final class ExecutableResolverImpl
implements ExecutableResolver {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final ExecutablePathResolver pathResolver;

    public ExecutableResolverImpl(@NotNull FileSystem fileSystem, @NotNull ExecutablePathResolver pathResolver) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)pathResolver, (String)"pathResolver");
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
    }

    @Override
    @NotNull
    public Path resolveExecutablePath(@NotNull ToolInfo tool) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Path path3 = path2 = this.pathResolver.resolveExecutablePath(tool);
        boolean bl = false;
        if (!this.fileSystem.exists(path3)) {
            boolean bl2 = false;
            String string = "No executable found at '" + path3 + "'";
            throw new IllegalStateException(string.toString());
        }
        return path2;
    }
}

