/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.settings;

import com.jetbrains.toolbox.common.JsonKt;
import com.jetbrains.toolbox.common.io.FileSystemWatcher;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.interop.Win32Integration;
import com.jetbrains.toolbox.log.BootstrapLogger;
import com.jetbrains.toolbox.settings.AdvancedSettings;
import com.jetbrains.toolbox.settings.InternalSettings;
import com.jetbrains.toolbox.settings.JetBrainsAccountSettings;
import com.jetbrains.toolbox.settings.NetworkSettings;
import com.jetbrains.toolbox.settings.OrderingSettings;
import com.jetbrains.toolbox.settings.ProjectSettings;
import com.jetbrains.toolbox.settings.ProxyAuthSettings;
import com.jetbrains.toolbox.settings.ProxySettings;
import com.jetbrains.toolbox.settings.ProxyType;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsStorage$watchSettingsFileForChanges$;
import com.jetbrains.toolbox.settings.ShellScriptsSettings;
import com.jetbrains.toolbox.settings.StatisticsSettings;
import com.jetbrains.toolbox.settings.ToolsSettings;
import com.jetbrains.toolbox.settings.UISettings;
import com.jetbrains.toolbox.settings.UpdateSettings;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.okio.OkioStreamsKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSettingsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsStorage.kt\ncom/jetbrains/toolbox/settings/SettingsStorage\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 OkioStreams.kt\nkotlinx/serialization/json/okio/OkioStreamsKt\n+ 5 BootstrapLogger.kt\ncom/jetbrains/toolbox/log/BootstrapLogger\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Transform.kt\nkotlinx/coroutines/flow/FlowKt__TransformKt\n+ 8 Emitters.kt\nkotlinx/coroutines/flow/FlowKt__EmittersKt\n+ 9 SafeCollector.common.kt\nkotlinx/coroutines/flow/internal/SafeCollector_commonKt\n+ 10 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,176:1\n155#1:378\n156#1,4:393\n160#1,2:407\n155#1,5:412\n160#1,2:427\n155#1,5:429\n160#1,2:444\n155#1,5:446\n160#1,2:461\n155#1,5:463\n160#1,2:478\n155#1,5:480\n160#1,2:495\n155#1,5:497\n160#1,2:512\n155#1,5:514\n160#1,2:529\n66#2:177\n52#2,4:179\n60#2,10:185\n56#2,3:195\n71#2,3:198\n66#2:215\n52#2,4:217\n60#2,10:222\n56#2,3:232\n71#2,3:235\n52#2,4:241\n60#2,10:247\n56#2,18:257\n52#2,4:286\n60#2,10:291\n56#2,18:301\n52#2,4:336\n60#2,10:341\n56#2,18:351\n67#3:178\n68#3:183\n67#3:216\n68#3:221\n80#3:238\n165#3:239\n81#3:240\n82#3:245\n80#3:283\n165#3:284\n81#3:285\n82#3:290\n80#3:333\n165#3:334\n81#3:335\n82#3:340\n78#4:184\n46#4:246\n127#5,10:201\n137#5,3:212\n79#5,7:275\n112#5,10:319\n122#5,3:330\n112#5,10:379\n122#5,3:390\n88#5,2:397\n91#5,7:400\n122#5,3:409\n88#5,2:417\n91#5,7:420\n88#5,2:434\n91#5,7:437\n88#5,2:451\n91#5,7:454\n88#5,2:468\n91#5,7:471\n88#5,2:485\n91#5,7:488\n88#5,2:502\n91#5,7:505\n88#5,2:519\n91#5,7:522\n88#5,2:531\n91#5,7:534\n88#5,2:541\n91#5,7:544\n1#6:211\n1#6:282\n1#6:329\n1#6:389\n1#6:399\n1#6:419\n1#6:436\n1#6:453\n1#6:470\n1#6:487\n1#6:504\n1#6:521\n1#6:533\n1#6:543\n17#7:369\n19#7:373\n46#8:370\n51#8:372\n105#9:371\n126#10:374\n153#10,3:375\n*S KotlinDebug\n*F\n+ 1 SettingsStorage.kt\ncom/jetbrains/toolbox/settings/SettingsStorage\n*L\n103#1:378\n103#1:393,4\n103#1:407,2\n118#1:412,5\n118#1:427,2\n119#1:429,5\n119#1:444,2\n120#1:446,5\n120#1:461,2\n121#1:463,5\n121#1:478,2\n126#1:480,5\n126#1:495,2\n127#1:497,5\n127#1:512,2\n128#1:514,5\n128#1:529,2\n55#1:177\n55#1:179,4\n55#1:185,10\n55#1:195,3\n55#1:198,3\n61#1:215\n61#1:217,4\n61#1:222,10\n61#1:232,3\n61#1:235,3\n73#1:241,4\n73#1:247,10\n73#1:257,18\n80#1:286,4\n80#1:291,10\n80#1:301,18\n83#1:336,4\n83#1:341,10\n83#1:351,18\n55#1:178\n55#1:183\n61#1:216\n61#1:221\n73#1:238\n73#1:239\n73#1:240\n73#1:245\n80#1:283\n80#1:284\n80#1:285\n80#1:290\n83#1:333\n83#1:334\n83#1:335\n83#1:340\n55#1:184\n73#1:246\n57#1:201,10\n57#1:212,3\n78#1:275,7\n82#1:319,10\n82#1:330,3\n111#1:379,10\n111#1:390,3\n103#1:397,2\n103#1:400,7\n111#1:409,3\n118#1:417,2\n118#1:420,7\n119#1:434,2\n119#1:437,7\n120#1:451,2\n120#1:454,7\n121#1:468,2\n121#1:471,7\n126#1:485,2\n126#1:488,7\n127#1:502,2\n127#1:505,7\n128#1:519,2\n128#1:522,7\n149#1:531,2\n149#1:534,7\n159#1:541,2\n159#1:544,7\n57#1:211\n82#1:329\n111#1:389\n103#1:399\n118#1:419\n119#1:436\n120#1:453\n121#1:470\n126#1:487\n127#1:504\n128#1:521\n149#1:533\n159#1:543\n91#1:369\n91#1:373\n91#1:370\n91#1:372\n91#1:371\n100#1:374\n100#1:375,3\n*E\n"})
public final class SettingsStorage {
    @NotNull
    private final Path settingsFile;
    @NotNull
    private final FileSystem fileSystem;
    @Nullable
    private final BootstrapLogger bootstrapLogger;
    @NotNull
    private final Json json;

    public SettingsStorage(@NotNull Path settingsFile, @NotNull FileSystem fileSystem, @Nullable BootstrapLogger bootstrapLogger) {
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.settingsFile = settingsFile;
        this.fileSystem = fileSystem;
        this.bootstrapLogger = bootstrapLogger;
        this.json = kotlinx.serialization.json.JsonKt.Json$default(null, SettingsStorage::json$lambda$0, (int)1, null);
    }

    public /* synthetic */ SettingsStorage(Path path2, FileSystem fileSystem, BootstrapLogger bootstrapLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bootstrapLogger = null;
        }
        this(path2, fileSystem, bootstrapLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final SelfSettings readSettings(boolean createFileIfMissingOrEmpty) {
        if (createFileIfMissingOrEmpty) {
            this.createFileIfMissingOrEmpty();
        } else if (!this.fileSystem.exists(this.settingsFile)) {
            return new SelfSettings(null, null, false, false, null, 0, null, null, null, null, null, null, null, null, null, null, null, 131071, null);
        }
        try {
            SelfSettings $i$a$-use-FileSystem$read$1$iv23332;
            Throwable thrown$iv$iv;
            block43: {
                void this_$iv;
                FileSystem fileSystem = this.fileSystem;
                Path file$iv2 = this.settingsFile;
                boolean bl = false;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv2));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    void $this$decodeFromBufferedSource$iv;
                    BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                    boolean $i$a$-use-FileSystem$read$1$iv23332 = false;
                    BufferedSource $this$readSettings_u24lambda_u240 = it$iv;
                    boolean bl2 = false;
                    Json json2 = this.json;
                    BufferedSource source$iv = $this$readSettings_u24lambda_u240;
                    boolean $i$f$decodeFromBufferedSource = false;
                    $this$decodeFromBufferedSource$iv.getSerializersModule();
                    $i$a$-use-FileSystem$read$1$iv23332 = (SelfSettings)OkioStreamsKt.decodeFromBufferedSource((Json)$this$decodeFromBufferedSource$iv, (DeserializationStrategy)((DeserializationStrategy)SelfSettings.Companion.serializer()), (BufferedSource)source$iv);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        $i$a$-use-FileSystem$read$1$iv23332 = null;
                        break block43;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block44: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block44;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            SelfSettings result$iv$iv = $i$a$-use-FileSystem$read$1$iv23332;
            Throwable throwable = thrown$iv$iv;
            if (throwable == null) return result$iv$iv;
            throw throwable;
        }
        catch (Throwable t2) {
            JsonElement jsonElement;
            BufferedSource it$iv;
            block45: {
                block48: {
                    Object object;
                    void this_$iv;
                    String message$iv;
                    block51: {
                        block50: {
                            void exception$iv;
                            block49: {
                                BootstrapLogger bootstrapLogger = this.bootstrapLogger;
                                if (bootstrapLogger == null) break block48;
                                BootstrapLogger $this$use$iv$iv = bootstrapLogger;
                                Throwable $i$f$use = t2;
                                message$iv = "Failed to deserialize settings";
                                boolean $i$f$error = false;
                                if (!this_$iv.isTinylogEnabled()) break block49;
                                if (exception$iv == null) {
                                    Logger.INSTANCE.error(message$iv);
                                    break block45;
                                } else {
                                    Logger.INSTANCE.error((Throwable)exception$iv, message$iv);
                                }
                                break block45;
                            }
                            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.ERROR, message$iv, (Throwable)exception$iv));
                            object = exception$iv;
                            if (object == null) break block50;
                            it$iv = object;
                            boolean bl = false;
                            String string = "\n" + ExceptionsKt.stackTraceToString((Throwable)it$iv);
                            object = string;
                            if (string != null) break block51;
                        }
                        object = "";
                    }
                    String exceptionInfo$iv = object;
                    this_$iv.writeln(Level.ERROR, message$iv + exceptionInfo$iv);
                    break block45;
                }
                Logger.INSTANCE.error(t2, "Failed to deserialize settings");
            }
            this.fileSystem.copy(this.settingsFile, Path.Companion.get$default((Path.Companion)Path.Companion, (String)(this.settingsFile + "~"), (boolean)false, (int)1, null));
            try {
                String string;
                Throwable thrown$iv$iv;
                Json json3;
                block46: {
                    void file$iv;
                    void this_$iv;
                    FileSystem file$iv2 = this.fileSystem;
                    Path bl = this.settingsFile;
                    json3 = this.json;
                    boolean $i$f$-read2 = false;
                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source((Path)file$iv));
                    boolean $i$f$use = false;
                    thrown$iv$iv = null;
                    try {
                        it$iv = (BufferedSource)$this$use$iv$iv;
                        boolean bl3 = false;
                        BufferedSource $this$readSettings_u24lambda_u241 = it$iv;
                        boolean bl4 = false;
                        string = $this$readSettings_u24lambda_u241.readUtf8();
                    }
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv = t$iv$iv;
                            string = null;
                            break block46;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            block47: {
                                try {
                                    Closeable closeable = $this$use$iv$iv;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv$iv3) {
                                    if (thrown$iv$iv == null) {
                                        thrown$iv$iv = t$iv$iv3;
                                        break block47;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                }
                String result$iv$iv = string;
                Throwable throwable = thrown$iv$iv;
                if (throwable != null) {
                    throw throwable;
                }
                jsonElement = json3.parseToJsonElement(result$iv$iv);
            }
            catch (Throwable throwable) {
                jsonElement = (JsonElement)new JsonObject(MapsKt.emptyMap());
            }
            JsonElement rawSettings = jsonElement;
            return this.loadSettingsSafe(rawSettings);
        }
    }

    public static /* synthetic */ SelfSettings readSettings$default(SettingsStorage settingsStorage, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return settingsStorage.readSettings(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveSettings(@NotNull SelfSettings settings2) {
        Unit unit;
        Throwable thrown$iv$iv;
        block15: {
            void $this$iv;
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            if (OS.INSTANCE.isWindows() && this.fileSystem.exists(this.settingsFile)) {
                Win32Integration.INSTANCE.setFileAttributesNormal(this.settingsFile.toFile());
            }
            FileSystem fileSystem = this.fileSystem;
            Path file$iv = this.settingsFile;
            boolean mustCreate$iv = false;
            boolean bl = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                void value$iv;
                void $this$encodeToBufferedSink$iv;
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl2 = false;
                BufferedSink $this$saveSettings_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                Json json2 = this.json;
                SelfSettings selfSettings = settings2;
                BufferedSink sink$iv = $this$saveSettings_u24lambda_u240;
                boolean $i$f$encodeToBufferedSink = false;
                $this$encodeToBufferedSink$iv.getSerializersModule();
                OkioStreamsKt.encodeToBufferedSink((Json)$this$encodeToBufferedSink$iv, (SerializationStrategy)((SerializationStrategy)SelfSettings.Companion.serializer()), (Object)value$iv, (BufferedSink)sink$iv);
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    unit = null;
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block16: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block16;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        Unit result$iv$iv = unit;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return;
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void createFileIfMissingOrEmpty() {
        BufferedSink bufferedSink;
        Throwable thrown$iv$iv;
        block44: {
            boolean bl;
            if (!this.fileSystem.exists(this.settingsFile)) {
                BufferedSink $i$a$-use-FileSystem$write$1$iv23332;
                Throwable thrown$iv$iv2;
                block41: {
                    void $this$iv;
                    BootstrapLogger bootstrapLogger = this.bootstrapLogger;
                    if (bootstrapLogger != null) {
                        void this_$iv;
                        BootstrapLogger bootstrapLogger2 = bootstrapLogger;
                        String message$iv = this.settingsFile + " doesn't exist -> creating a new one";
                        boolean $i$f$info = false;
                        if (this_$iv.isTinylogEnabled()) {
                            Logger.INSTANCE.info(message$iv);
                        } else {
                            this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.INFO, message$iv, null, 4, null));
                            this_$iv.writeln(Level.INFO, message$iv);
                        }
                    } else {
                        Logger.INSTANCE.info(this.settingsFile + " doesn't exist -> creating a new one");
                    }
                    Path path2 = this.settingsFile.parent();
                    if (path2 != null) {
                        Path it = path2;
                        boolean bl2 = false;
                        this.fileSystem.createDirectories(it);
                    }
                    FileSystem fileSystem = this.fileSystem;
                    Path file$iv = this.settingsFile;
                    boolean mustCreate$iv = false;
                    boolean bl3 = false;
                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                    boolean $i$f$use = false;
                    thrown$iv$iv2 = null;
                    try {
                        BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                        boolean $i$a$-use-FileSystem$write$1$iv23332 = false;
                        BufferedSink $this$createFileIfMissingOrEmpty_u24lambda_u241 = it$iv;
                        boolean bl4 = false;
                        $i$a$-use-FileSystem$write$1$iv23332 = $this$createFileIfMissingOrEmpty_u24lambda_u241.writeUtf8("{}");
                    }
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv2 = t$iv$iv;
                            $i$a$-use-FileSystem$write$1$iv23332 = null;
                            break block41;
                        }
                        catch (Throwable t$iv$iv2) {
                            throw t$iv$iv2;
                        }
                        finally {
                            block42: {
                                try {
                                    Closeable closeable = $this$use$iv$iv;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv$iv2) {
                                    if (thrown$iv$iv2 == null) {
                                        thrown$iv$iv2 = t$iv$iv2;
                                        break block42;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv2, (Throwable)t$iv$iv2);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv2 = t$iv$iv;
                    }
                }
                BufferedSink result$iv$iv = $i$a$-use-FileSystem$write$1$iv23332;
                Throwable throwable = thrown$iv$iv2;
                if (throwable == null) return;
                throw throwable;
            }
            FileMetadata fileMetadata2 = this.fileSystem.metadataOrNull(this.settingsFile);
            if (fileMetadata2 != null) {
                Long l = fileMetadata2.getSize();
                long file$iv = 0L;
                bl = l != null && l == file$iv;
            } else {
                bl = false;
            }
            if (!bl) return;
            BootstrapLogger bootstrapLogger = this.bootstrapLogger;
            if (bootstrapLogger != null) {
                void this_$iv;
                BootstrapLogger mustCreate$iv = bootstrapLogger;
                Object bl3 = null;
                String message$iv = this.settingsFile + " is empty";
                boolean $i$f$warn = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.warn(message$iv);
                } else {
                    void exception$iv;
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, message$iv, (Throwable)exception$iv));
                    String exceptionInfo$iv = "";
                    this_$iv.writeln(Level.WARN, message$iv + exceptionInfo$iv);
                }
            } else {
                Logger.INSTANCE.warn(this.settingsFile + " is empty");
            }
            FileSystem $this$iv = this.fileSystem;
            Path file$iv2 = this.settingsFile;
            boolean mustCreate$iv = false;
            boolean bl5 = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv2, mustCreate$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                boolean bl6 = false;
                BufferedSink $this$createFileIfMissingOrEmpty_u24lambda_u242 = it$iv;
                boolean bl7 = false;
                bufferedSink = $this$createFileIfMissingOrEmpty_u24lambda_u242.writeUtf8("{}");
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    bufferedSink = null;
                    break block44;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block45: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv3) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv3;
                                break block45;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv3);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        BufferedSink result$iv$iv = bufferedSink;
        Throwable throwable = thrown$iv$iv;
        if (throwable == null) return;
        throw throwable;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object watchSettingsFileForChanges$settings(@NotNull FileSystemWatcher fileSystemWatcher, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> onFileChanged, @NotNull Continuation<? super Unit> $completion) {
        void $this$filter$iv;
        Flow flow2 = new Flow[]{this.settingsFile};
        fileSystemWatcher.watch((Path[])flow2);
        flow2 = (Flow)fileSystemWatcher.getEvents();
        boolean $i$f$filter = false;
        void $this$unsafeTransform$iv$iv = $this$filter$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        Object object = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)new Flow<FileSystemWatcher.Event>((Flow)$this$unsafeTransform$iv$iv, this){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ SettingsStorage this$0;
            {
                this.$this_unsafeTransform$inlined = flow2;
                this.this$0 = settingsStorage;
            }

            public Object collect(FlowCollector collector, Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240, this.this$0){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    final /* synthetic */ SettingsStorage this$0;
                    {
                        this.$this_unsafeFlow = $receiver;
                        this.this$0 = settingsStorage;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object emit(Object value, Continuation $completion) {
                        if (!($completion instanceof watchSettingsFileForChanges$$inlined$filter$1$2$1)) ** GOTO lbl-1000
                        var3_3 = $completion;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, $completion){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                Object L$1;
                                final /* synthetic */ watchSettingsFileForChanges$$inlined$filter$1$2 this$0;
                                Object L$2;
                                Object L$3;
                                int I$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = $continuation;
                                var7_8 = value;
                                $this$filter_u24lambda_u240 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = 0;
                                var10_14 = (Continuation)$continuation;
                                it = (FileSystemWatcher.Event)value;
                                $i$a$-filter-SettingsStorage$watchSettingsFileForChanges$2 = false;
                                if (!Intrinsics.areEqual((Object)it.getFile(), (Object)SettingsStorage.access$getSettingsFile$p(this.this$0))) break;
                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$completion);
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)value);
                                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$filter_u24lambda_u240);
                                $continuation.I$0 = $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1;
                                $continuation.label = 1;
                                v0 = $this$filter_u24lambda_u240.emit((Object)value, (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                break;
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = $continuation.I$0;
                                $this$filter_u24lambda_u240 = (FlowCollector)$continuation.L$3;
                                value = $continuation.L$2;
                                $completion = $continuation.L$1;
                                value = $continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
                                break;
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }), (long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<FileSystemWatcher.Event, Continuation<? super Unit>, Object>(onFileChanged, null){
            int label;
            final /* synthetic */ Function1<Continuation<? super Unit>, Object> $onFileChanged;
            {
                this.$onFileChanged = $onFileChanged;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$onFileChanged.invoke((Object)((Object)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(FileSystemWatcher.Event p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final SelfSettings loadSettingsSafe(JsonElement rawSettings) {
        int n;
        String string;
        String string2;
        OrderingSettings orderingSettings;
        Map map2;
        Object object;
        int n2;
        String string3;
        boolean bl;
        boolean bl2;
        InternalSettings internalSettings;
        AdvancedSettings advancedSettings;
        block167: {
            int n3;
            JsonPrimitive $this$loadSettingsSafe_u24lambda_u248;
            JsonElement jsonElement;
            Object exceptionInfo$iv$iv;
            Throwable exception$iv$iv;
            BootstrapLogger this_$iv$iv;
            JsonElement currentNode$iv;
            BootstrapLogger bootstrapLogger;
            Object this_$iv;
            Object[] path$iv;
            block166: {
                String string4;
                JsonObject $this$safePrimitiveAt$iv;
                boolean $i$f$safePrimitiveAt;
                block160: {
                    String string5;
                    JsonPrimitive $this$loadSettingsSafe_u24lambda_u247;
                    JsonElement jsonElement2;
                    block159: {
                        String string6;
                        block153: {
                            String string7;
                            JsonPrimitive $this$loadSettingsSafe_u24lambda_u246;
                            JsonElement jsonElement3;
                            block152: {
                                int n4;
                                Object proxyType;
                                Map projects;
                                block146: {
                                    int n5;
                                    JsonPrimitive $this$loadSettingsSafe_u24lambda_u245;
                                    JsonElement jsonElement4;
                                    block145: {
                                        String string8;
                                        block139: {
                                            String string9;
                                            JsonPrimitive $this$loadSettingsSafe_u24lambda_u244;
                                            JsonElement jsonElement5;
                                            block138: {
                                                boolean bl3;
                                                block132: {
                                                    boolean bl4;
                                                    JsonPrimitive $this$loadSettingsSafe_u24lambda_u243;
                                                    JsonElement jsonElement6;
                                                    block131: {
                                                        boolean bl5;
                                                        block125: {
                                                            boolean bl6;
                                                            boolean bl7;
                                                            JsonPrimitive $this$loadSettingsSafe_u24lambda_u242;
                                                            JsonElement jsonElement7;
                                                            Object exception$iv;
                                                            Object message$iv;
                                                            block124: {
                                                                Object object2;
                                                                block108: {
                                                                    Object object3;
                                                                    Object exceptionInfo$iv;
                                                                    boolean bl8;
                                                                    Throwable it$iv;
                                                                    BootstrapLogger this_$iv2;
                                                                    boolean $i$f$warn;
                                                                    BootstrapLogger bootstrapLogger2;
                                                                    boolean bl9;
                                                                    JsonPrimitive $this$loadSettingsSafe_u24lambda_u241;
                                                                    JsonElement jsonElement8;
                                                                    Object it;
                                                                    block102: {
                                                                        JsonObject $this$mapTo$iv$iv;
                                                                        if (!(rawSettings instanceof JsonObject)) {
                                                                            return new SelfSettings(null, null, false, false, null, 0, null, null, null, null, null, null, null, null, null, null, null, 131071, null);
                                                                        }
                                                                        String[] stringArray = new String[]{"projects"};
                                                                        Map $this$map$iv = (Map)this.loadSafe((JsonObject)rawSettings, BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)JsonObject.Companion.serializer()), stringArray);
                                                                        boolean $i$f$map22 = false;
                                                                        Map map3 = $this$map$iv;
                                                                        Object[] destination$iv$iv = (Object[])new ArrayList($this$map$iv.size());
                                                                        boolean $i$f$mapTo = false;
                                                                        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                                                                        while (iterator2.hasNext()) {
                                                                            Map.Entry item$iv$iv;
                                                                            Map.Entry entry = item$iv$iv = iterator2.next();
                                                                            Object[] objectArray = destination$iv$iv;
                                                                            boolean bl10 = false;
                                                                            Pair pair = TuplesKt.to(it.getKey(), (Object)this.loadSafe((JsonObject)it.getValue(), ProjectSettings.Companion.serializer(), new String[0]));
                                                                            objectArray.add(pair);
                                                                        }
                                                                        projects = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
                                                                        SettingsStorage $i$f$map22 = this;
                                                                        $this$mapTo$iv$iv = (JsonObject)rawSettings;
                                                                        destination$iv$iv = new String[]{"proxy", "type"};
                                                                        path$iv = destination$iv$iv;
                                                                        $i$f$safePrimitiveAt = false;
                                                                        jsonElement8 = super.getNodeSafe($this$safePrimitiveAt$iv, (String[])path$iv);
                                                                        if (jsonElement8 != null) break block102;
                                                                        $this$loadSettingsSafe_u24lambda_u241 = (JsonPrimitive)JsonNull.INSTANCE;
                                                                        bl9 = false;
                                                                        try {
                                                                            it = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u241);
                                                                            it = it == null || it.length() == 0 ? ProxyType.System : (ProxyType)((Object)JsonKt.getJsonx().decodeFromString((DeserializationStrategy)ProxyType.Companion.serializer(), $this$loadSettingsSafe_u24lambda_u241.getContent()));
                                                                        }
                                                                        catch (Throwable t2) {
                                                                            block105: {
                                                                                block103: {
                                                                                    Object object4;
                                                                                    block107: {
                                                                                        block106: {
                                                                                            block104: {
                                                                                                BootstrapLogger bootstrapLogger3 = bootstrapLogger2 = this.bootstrapLogger;
                                                                                                if (bootstrapLogger3 == null) break block103;
                                                                                                bootstrapLogger = bootstrapLogger3;
                                                                                                Throwable throwable = t2;
                                                                                                message$iv = "Unknown Proxy type";
                                                                                                $i$f$warn = false;
                                                                                                if (!this_$iv2.isTinylogEnabled()) break block104;
                                                                                                if (exception$iv == null) {
                                                                                                    Logger.INSTANCE.warn((String)message$iv);
                                                                                                } else {
                                                                                                    Logger.INSTANCE.warn((Throwable)exception$iv, (String)message$iv);
                                                                                                }
                                                                                                break block105;
                                                                                            }
                                                                                            this_$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, (String)message$iv, (Throwable)exception$iv));
                                                                                            object4 = exception$iv;
                                                                                            if (object4 == null) break block106;
                                                                                            it$iv = object4;
                                                                                            bl8 = false;
                                                                                            String string10 = "\n" + it$iv;
                                                                                            object4 = string10;
                                                                                            if (string10 != null) break block107;
                                                                                        }
                                                                                        object4 = "";
                                                                                    }
                                                                                    exceptionInfo$iv = object4;
                                                                                    this_$iv2.writeln(Level.WARN, (String)message$iv + (String)exceptionInfo$iv);
                                                                                    break block105;
                                                                                }
                                                                                Logger.INSTANCE.error(t2, "Unknown Proxy type");
                                                                            }
                                                                            it = ProxyType.Disabled;
                                                                        }
                                                                        object2 = it;
                                                                        break block108;
                                                                    }
                                                                    JsonElement currentNode$iv2 = jsonElement8;
                                                                    try {
                                                                        $this$loadSettingsSafe_u24lambda_u241 = JsonElementKt.getJsonPrimitive((JsonElement)currentNode$iv2);
                                                                        bl9 = false;
                                                                        try {
                                                                            it = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u241);
                                                                            it = it == null || it.length() == 0 ? ProxyType.System : (ProxyType)((Object)JsonKt.getJsonx().decodeFromString((DeserializationStrategy)ProxyType.Companion.serializer(), $this$loadSettingsSafe_u24lambda_u241.getContent()));
                                                                        }
                                                                        catch (Throwable t3) {
                                                                            block111: {
                                                                                block109: {
                                                                                    Object object5;
                                                                                    block113: {
                                                                                        block112: {
                                                                                            block110: {
                                                                                                BootstrapLogger bootstrapLogger4 = bootstrapLogger2 = this.bootstrapLogger;
                                                                                                if (bootstrapLogger4 == null) break block109;
                                                                                                this_$iv2 = bootstrapLogger4;
                                                                                                exception$iv = t3;
                                                                                                message$iv = "Unknown Proxy type";
                                                                                                $i$f$warn = false;
                                                                                                if (!this_$iv2.isTinylogEnabled()) break block110;
                                                                                                if (exception$iv == null) {
                                                                                                    Logger.INSTANCE.warn((String)message$iv);
                                                                                                } else {
                                                                                                    Logger.INSTANCE.warn((Throwable)exception$iv, (String)message$iv);
                                                                                                }
                                                                                                break block111;
                                                                                            }
                                                                                            this_$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, (String)message$iv, (Throwable)exception$iv));
                                                                                            object5 = exception$iv;
                                                                                            if (object5 == null) break block112;
                                                                                            it$iv = object5;
                                                                                            bl8 = false;
                                                                                            String string11 = "\n" + it$iv;
                                                                                            object5 = string11;
                                                                                            if (string11 != null) break block113;
                                                                                        }
                                                                                        object5 = "";
                                                                                    }
                                                                                    exceptionInfo$iv = object5;
                                                                                    this_$iv2.writeln(Level.WARN, (String)message$iv + (String)exceptionInfo$iv);
                                                                                    break block111;
                                                                                }
                                                                                Logger.INSTANCE.error(t3, "Unknown Proxy type");
                                                                            }
                                                                            it = ProxyType.Disabled;
                                                                        }
                                                                        object3 = it;
                                                                    }
                                                                    catch (Throwable t$iv) {
                                                                        block116: {
                                                                            block114: {
                                                                                Object object6;
                                                                                void this_$iv$iv2;
                                                                                String message$iv$iv;
                                                                                block118: {
                                                                                    block117: {
                                                                                        void exception$iv$iv2;
                                                                                        block115: {
                                                                                            BootstrapLogger bootstrapLogger5;
                                                                                            BootstrapLogger bootstrapLogger6 = bootstrapLogger5 = ((SettingsStorage)this_$iv).bootstrapLogger;
                                                                                            if (bootstrapLogger6 == null) break block114;
                                                                                            BootstrapLogger bootstrapLogger7 = bootstrapLogger6;
                                                                                            Throwable throwable = t$iv;
                                                                                            message$iv$iv = "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                                                                                            boolean $i$f$debug = false;
                                                                                            if (!this_$iv$iv2.isTinylogEnabled()) break block115;
                                                                                            void v9 = exception$iv$iv2;
                                                                                            if (v9 != null) {
                                                                                                void it$iv$iv = v9;
                                                                                                boolean bl11 = false;
                                                                                                Logger.INSTANCE.debug((Throwable)it$iv$iv, message$iv$iv);
                                                                                            } else {
                                                                                                Logger.INSTANCE.debug(message$iv$iv);
                                                                                            }
                                                                                            break block116;
                                                                                        }
                                                                                        this_$iv$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.DEBUG, message$iv$iv, (Throwable)exception$iv$iv2));
                                                                                        object6 = exception$iv$iv2;
                                                                                        if (object6 == null) break block117;
                                                                                        void it$iv$iv = object6;
                                                                                        boolean bl12 = false;
                                                                                        String string12 = "\n" + (Throwable)it$iv$iv;
                                                                                        object6 = string12;
                                                                                        if (string12 != null) break block118;
                                                                                    }
                                                                                    object6 = "";
                                                                                }
                                                                                String exceptionInfo$iv$iv2 = object6;
                                                                                this_$iv$iv2.writeln(Level.DEBUG, message$iv$iv + exceptionInfo$iv$iv2);
                                                                                break block116;
                                                                            }
                                                                            Logger.INSTANCE.debug(t$iv, "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
                                                                        }
                                                                        $this$loadSettingsSafe_u24lambda_u241 = (JsonPrimitive)JsonNull.INSTANCE;
                                                                        bl9 = false;
                                                                        try {
                                                                            it = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u241);
                                                                            it = it == null || it.length() == 0 ? ProxyType.System : (ProxyType)((Object)JsonKt.getJsonx().decodeFromString((DeserializationStrategy)ProxyType.Companion.serializer(), $this$loadSettingsSafe_u24lambda_u241.getContent()));
                                                                        }
                                                                        catch (Throwable t4) {
                                                                            block121: {
                                                                                block119: {
                                                                                    Object object7;
                                                                                    block123: {
                                                                                        block122: {
                                                                                            block120: {
                                                                                                BootstrapLogger bootstrapLogger8 = bootstrapLogger2 = this.bootstrapLogger;
                                                                                                if (bootstrapLogger8 == null) break block119;
                                                                                                this_$iv2 = bootstrapLogger8;
                                                                                                exception$iv = t4;
                                                                                                message$iv = "Unknown Proxy type";
                                                                                                $i$f$warn = false;
                                                                                                if (!this_$iv2.isTinylogEnabled()) break block120;
                                                                                                if (exception$iv == null) {
                                                                                                    Logger.INSTANCE.warn((String)message$iv);
                                                                                                } else {
                                                                                                    Logger.INSTANCE.warn((Throwable)exception$iv, (String)message$iv);
                                                                                                }
                                                                                                break block121;
                                                                                            }
                                                                                            this_$iv2.getMessages().add(new BootstrapLogger.LogEntry(Level.WARN, (String)message$iv, (Throwable)exception$iv));
                                                                                            object7 = exception$iv;
                                                                                            if (object7 == null) break block122;
                                                                                            it$iv = object7;
                                                                                            bl8 = false;
                                                                                            String string13 = "\n" + it$iv;
                                                                                            object7 = string13;
                                                                                            if (string13 != null) break block123;
                                                                                        }
                                                                                        object7 = "";
                                                                                    }
                                                                                    exceptionInfo$iv = object7;
                                                                                    this_$iv2.writeln(Level.WARN, (String)message$iv + (String)exceptionInfo$iv);
                                                                                    break block121;
                                                                                }
                                                                                Logger.INSTANCE.error(t4, "Unknown Proxy type");
                                                                            }
                                                                            it = ProxyType.Disabled;
                                                                        }
                                                                        object3 = it;
                                                                    }
                                                                    object2 = object3;
                                                                }
                                                                proxyType = object2;
                                                                this_$iv = new String[]{"internal"};
                                                                this_$iv = this;
                                                                $this$safePrimitiveAt$iv = (JsonObject)rawSettings;
                                                                path$iv = new String[]{"autostart"};
                                                                advancedSettings = null;
                                                                internalSettings = this.loadSafe((JsonObject)rawSettings, InternalSettings.Companion.serializer(), (String[])this_$iv);
                                                                $i$f$safePrimitiveAt = false;
                                                                jsonElement7 = super.getNodeSafe($this$safePrimitiveAt$iv, (String[])path$iv);
                                                                if (jsonElement7 != null) break block124;
                                                                $this$loadSettingsSafe_u24lambda_u242 = (JsonPrimitive)JsonNull.INSTANCE;
                                                                bl7 = false;
                                                                Boolean bl13 = JsonElementKt.getBooleanOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u242);
                                                                bl5 = bl13 != null ? bl13 : true;
                                                                break block125;
                                                            }
                                                            currentNode$iv = jsonElement7;
                                                            try {
                                                                $this$loadSettingsSafe_u24lambda_u242 = JsonElementKt.getJsonPrimitive((JsonElement)currentNode$iv);
                                                                bl7 = false;
                                                                Boolean bl14 = JsonElementKt.getBooleanOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u242);
                                                                bl6 = bl14 != null ? bl14 : true;
                                                            }
                                                            catch (Throwable t$iv) {
                                                                block128: {
                                                                    block126: {
                                                                        Object object8;
                                                                        String message$iv$iv;
                                                                        block130: {
                                                                            block129: {
                                                                                block127: {
                                                                                    BootstrapLogger bootstrapLogger9 = bootstrapLogger = ((SettingsStorage)this_$iv).bootstrapLogger;
                                                                                    if (bootstrapLogger9 == null) break block126;
                                                                                    exception$iv = bootstrapLogger9;
                                                                                    message$iv = t$iv;
                                                                                    message$iv$iv = "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                                                                                    boolean $i$f$debug = false;
                                                                                    if (!this_$iv$iv.isTinylogEnabled()) break block127;
                                                                                    void v20 = exception$iv$iv;
                                                                                    if (v20 != null) {
                                                                                        void it$iv$iv = v20;
                                                                                        boolean bl15 = false;
                                                                                        Logger.INSTANCE.debug((Throwable)it$iv$iv, message$iv$iv);
                                                                                    } else {
                                                                                        Logger.INSTANCE.debug(message$iv$iv);
                                                                                    }
                                                                                    break block128;
                                                                                }
                                                                                this_$iv$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.DEBUG, message$iv$iv, exception$iv$iv));
                                                                                object8 = exception$iv$iv;
                                                                                if (object8 == null) break block129;
                                                                                void it$iv$iv = object8;
                                                                                boolean bl16 = false;
                                                                                String string14 = "\n" + (Throwable)it$iv$iv;
                                                                                object8 = string14;
                                                                                if (string14 != null) break block130;
                                                                            }
                                                                            object8 = "";
                                                                        }
                                                                        exceptionInfo$iv$iv = object8;
                                                                        this_$iv$iv.writeln(Level.DEBUG, message$iv$iv + (String)exceptionInfo$iv$iv);
                                                                        break block128;
                                                                    }
                                                                    Logger.INSTANCE.debug(t$iv, "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
                                                                }
                                                                JsonPrimitive $this$loadSettingsSafe_u24lambda_u2422 = (JsonPrimitive)JsonNull.INSTANCE;
                                                                boolean bl17 = false;
                                                                Boolean bl18 = JsonElementKt.getBooleanOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u2422);
                                                                bl6 = bl18 != null ? bl18 : true;
                                                            }
                                                            bl5 = bl6;
                                                        }
                                                        bl2 = bl5;
                                                        this_$iv = this;
                                                        $this$safePrimitiveAt$iv = (JsonObject)rawSettings;
                                                        path$iv = new String[]{"start_menu_shortcut"};
                                                        $i$f$safePrimitiveAt = false;
                                                        jsonElement6 = super.getNodeSafe($this$safePrimitiveAt$iv, (String[])path$iv);
                                                        if (jsonElement6 != null) break block131;
                                                        $this$loadSettingsSafe_u24lambda_u243 = (JsonPrimitive)JsonNull.INSTANCE;
                                                        boolean bl19 = false;
                                                        Boolean bl20 = JsonElementKt.getBooleanOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u243);
                                                        bl3 = bl20 != null ? bl20 : true;
                                                        break block132;
                                                    }
                                                    currentNode$iv = jsonElement6;
                                                    try {
                                                        $this$loadSettingsSafe_u24lambda_u243 = JsonElementKt.getJsonPrimitive((JsonElement)currentNode$iv);
                                                        boolean bl21 = false;
                                                        Boolean bl22 = JsonElementKt.getBooleanOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u243);
                                                        bl4 = bl22 != null ? bl22 : true;
                                                    }
                                                    catch (Throwable t$iv) {
                                                        block135: {
                                                            block133: {
                                                                Object object9;
                                                                String message$iv$iv;
                                                                block137: {
                                                                    block136: {
                                                                        block134: {
                                                                            BootstrapLogger bootstrapLogger10 = bootstrapLogger = ((SettingsStorage)this_$iv).bootstrapLogger;
                                                                            if (bootstrapLogger10 == null) break block133;
                                                                            this_$iv$iv = bootstrapLogger10;
                                                                            exception$iv$iv = t$iv;
                                                                            message$iv$iv = "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                                                                            boolean $i$f$debug = false;
                                                                            if (!this_$iv$iv.isTinylogEnabled()) break block134;
                                                                            Throwable throwable = exception$iv$iv;
                                                                            if (throwable != null) {
                                                                                Throwable it$iv$iv = throwable;
                                                                                boolean bl23 = false;
                                                                                Logger.INSTANCE.debug(it$iv$iv, message$iv$iv);
                                                                            } else {
                                                                                Logger.INSTANCE.debug(message$iv$iv);
                                                                            }
                                                                            break block135;
                                                                        }
                                                                        this_$iv$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.DEBUG, message$iv$iv, exception$iv$iv));
                                                                        object9 = exception$iv$iv;
                                                                        if (object9 == null) break block136;
                                                                        Throwable it$iv$iv = object9;
                                                                        boolean bl24 = false;
                                                                        String string15 = "\n" + it$iv$iv;
                                                                        object9 = string15;
                                                                        if (string15 != null) break block137;
                                                                    }
                                                                    object9 = "";
                                                                }
                                                                exceptionInfo$iv$iv = object9;
                                                                this_$iv$iv.writeln(Level.DEBUG, message$iv$iv + (String)exceptionInfo$iv$iv);
                                                                break block135;
                                                            }
                                                            Logger.INSTANCE.debug(t$iv, "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
                                                        }
                                                        JsonPrimitive $this$loadSettingsSafe_u24lambda_u2432 = (JsonPrimitive)JsonNull.INSTANCE;
                                                        boolean bl25 = false;
                                                        Boolean bl26 = JsonElementKt.getBooleanOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u2432);
                                                        bl4 = bl26 != null ? bl26 : true;
                                                    }
                                                    bl3 = bl4;
                                                }
                                                bl = bl3;
                                                this_$iv = this;
                                                $this$safePrimitiveAt$iv = (JsonObject)rawSettings;
                                                path$iv = new String[]{"install_location"};
                                                $i$f$safePrimitiveAt = false;
                                                jsonElement5 = super.getNodeSafe($this$safePrimitiveAt$iv, (String[])path$iv);
                                                if (jsonElement5 != null) break block138;
                                                $this$loadSettingsSafe_u24lambda_u244 = (JsonPrimitive)JsonNull.INSTANCE;
                                                boolean bl27 = false;
                                                string8 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u244);
                                                break block139;
                                            }
                                            currentNode$iv = jsonElement5;
                                            try {
                                                $this$loadSettingsSafe_u24lambda_u244 = JsonElementKt.getJsonPrimitive((JsonElement)currentNode$iv);
                                                boolean bl28 = false;
                                                string9 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u244);
                                            }
                                            catch (Throwable t$iv) {
                                                block142: {
                                                    block140: {
                                                        Object object10;
                                                        String message$iv$iv;
                                                        block144: {
                                                            block143: {
                                                                block141: {
                                                                    BootstrapLogger bootstrapLogger11 = bootstrapLogger = ((SettingsStorage)this_$iv).bootstrapLogger;
                                                                    if (bootstrapLogger11 == null) break block140;
                                                                    this_$iv$iv = bootstrapLogger11;
                                                                    exception$iv$iv = t$iv;
                                                                    message$iv$iv = "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                                                                    boolean $i$f$debug = false;
                                                                    if (!this_$iv$iv.isTinylogEnabled()) break block141;
                                                                    Throwable throwable = exception$iv$iv;
                                                                    if (throwable != null) {
                                                                        Throwable it$iv$iv = throwable;
                                                                        boolean bl29 = false;
                                                                        Logger.INSTANCE.debug(it$iv$iv, message$iv$iv);
                                                                    } else {
                                                                        Logger.INSTANCE.debug(message$iv$iv);
                                                                    }
                                                                    break block142;
                                                                }
                                                                this_$iv$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.DEBUG, message$iv$iv, exception$iv$iv));
                                                                object10 = exception$iv$iv;
                                                                if (object10 == null) break block143;
                                                                Throwable it$iv$iv = object10;
                                                                boolean bl30 = false;
                                                                String string16 = "\n" + it$iv$iv;
                                                                object10 = string16;
                                                                if (string16 != null) break block144;
                                                            }
                                                            object10 = "";
                                                        }
                                                        exceptionInfo$iv$iv = object10;
                                                        this_$iv$iv.writeln(Level.DEBUG, message$iv$iv + (String)exceptionInfo$iv$iv);
                                                        break block142;
                                                    }
                                                    Logger.INSTANCE.debug(t$iv, "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
                                                }
                                                JsonPrimitive $this$loadSettingsSafe_u24lambda_u2442 = (JsonPrimitive)JsonNull.INSTANCE;
                                                boolean bl31 = false;
                                                string9 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u2442);
                                            }
                                            string8 = string9;
                                        }
                                        string3 = string8;
                                        this_$iv = this;
                                        $this$safePrimitiveAt$iv = (JsonObject)rawSettings;
                                        path$iv = new String[]{"channel_rollback_max_history"};
                                        $i$f$safePrimitiveAt = false;
                                        jsonElement4 = super.getNodeSafe($this$safePrimitiveAt$iv, (String[])path$iv);
                                        if (jsonElement4 != null) break block145;
                                        $this$loadSettingsSafe_u24lambda_u245 = (JsonPrimitive)JsonNull.INSTANCE;
                                        boolean bl32 = false;
                                        Integer n6 = JsonElementKt.getIntOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u245);
                                        n4 = n6 != null ? n6 : 2;
                                        break block146;
                                    }
                                    currentNode$iv = jsonElement4;
                                    try {
                                        $this$loadSettingsSafe_u24lambda_u245 = JsonElementKt.getJsonPrimitive((JsonElement)currentNode$iv);
                                        boolean bl33 = false;
                                        Integer n7 = JsonElementKt.getIntOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u245);
                                        n5 = n7 != null ? n7 : 2;
                                    }
                                    catch (Throwable t$iv) {
                                        block149: {
                                            block147: {
                                                Object object11;
                                                String message$iv$iv;
                                                block151: {
                                                    block150: {
                                                        block148: {
                                                            BootstrapLogger bootstrapLogger12 = bootstrapLogger = ((SettingsStorage)this_$iv).bootstrapLogger;
                                                            if (bootstrapLogger12 == null) break block147;
                                                            this_$iv$iv = bootstrapLogger12;
                                                            exception$iv$iv = t$iv;
                                                            message$iv$iv = "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                                                            boolean $i$f$debug = false;
                                                            if (!this_$iv$iv.isTinylogEnabled()) break block148;
                                                            Throwable throwable = exception$iv$iv;
                                                            if (throwable != null) {
                                                                Throwable it$iv$iv = throwable;
                                                                boolean bl34 = false;
                                                                Logger.INSTANCE.debug(it$iv$iv, message$iv$iv);
                                                            } else {
                                                                Logger.INSTANCE.debug(message$iv$iv);
                                                            }
                                                            break block149;
                                                        }
                                                        this_$iv$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.DEBUG, message$iv$iv, exception$iv$iv));
                                                        object11 = exception$iv$iv;
                                                        if (object11 == null) break block150;
                                                        Throwable it$iv$iv = object11;
                                                        boolean bl35 = false;
                                                        String string17 = "\n" + it$iv$iv;
                                                        object11 = string17;
                                                        if (string17 != null) break block151;
                                                    }
                                                    object11 = "";
                                                }
                                                exceptionInfo$iv$iv = object11;
                                                this_$iv$iv.writeln(Level.DEBUG, message$iv$iv + (String)exceptionInfo$iv$iv);
                                                break block149;
                                            }
                                            Logger.INSTANCE.debug(t$iv, "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
                                        }
                                        JsonPrimitive $this$loadSettingsSafe_u24lambda_u2452 = (JsonPrimitive)JsonNull.INSTANCE;
                                        boolean bl36 = false;
                                        Integer n8 = JsonElementKt.getIntOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u2452);
                                        n5 = n8 != null ? n8 : 2;
                                    }
                                    n4 = n5;
                                }
                                n2 = n4;
                                this_$iv = new String[]{"ordering"};
                                this_$iv = this;
                                $this$safePrimitiveAt$iv = (JsonObject)rawSettings;
                                path$iv = new String[]{"proxy", "config_url"};
                                object = proxyType;
                                map2 = projects;
                                orderingSettings = this.loadSafe((JsonObject)rawSettings, OrderingSettings.Companion.serializer(), (String[])this_$iv);
                                $i$f$safePrimitiveAt = false;
                                jsonElement3 = super.getNodeSafe($this$safePrimitiveAt$iv, (String[])path$iv);
                                if (jsonElement3 != null) break block152;
                                $this$loadSettingsSafe_u24lambda_u246 = (JsonPrimitive)JsonNull.INSTANCE;
                                boolean bl37 = false;
                                string6 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u246);
                                if (string6 == null) {
                                    string6 = "";
                                }
                                break block153;
                            }
                            currentNode$iv = jsonElement3;
                            try {
                                $this$loadSettingsSafe_u24lambda_u246 = JsonElementKt.getJsonPrimitive((JsonElement)currentNode$iv);
                                boolean bl38 = false;
                                String string18 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u246);
                                if (string18 == null) {
                                    string18 = "";
                                }
                                string7 = string18;
                            }
                            catch (Throwable t$iv) {
                                block156: {
                                    block154: {
                                        Object object12;
                                        String message$iv$iv;
                                        block158: {
                                            block157: {
                                                block155: {
                                                    BootstrapLogger bootstrapLogger13 = bootstrapLogger = ((SettingsStorage)this_$iv).bootstrapLogger;
                                                    if (bootstrapLogger13 == null) break block154;
                                                    this_$iv$iv = bootstrapLogger13;
                                                    exception$iv$iv = t$iv;
                                                    message$iv$iv = "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                                                    boolean $i$f$debug = false;
                                                    if (!this_$iv$iv.isTinylogEnabled()) break block155;
                                                    Throwable throwable = exception$iv$iv;
                                                    if (throwable != null) {
                                                        Throwable it$iv$iv = throwable;
                                                        boolean bl39 = false;
                                                        Logger.INSTANCE.debug(it$iv$iv, message$iv$iv);
                                                    } else {
                                                        Logger.INSTANCE.debug(message$iv$iv);
                                                    }
                                                    break block156;
                                                }
                                                this_$iv$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.DEBUG, message$iv$iv, exception$iv$iv));
                                                object12 = exception$iv$iv;
                                                if (object12 == null) break block157;
                                                Throwable it$iv$iv = object12;
                                                boolean bl40 = false;
                                                String string19 = "\n" + it$iv$iv;
                                                object12 = string19;
                                                if (string19 != null) break block158;
                                            }
                                            object12 = "";
                                        }
                                        exceptionInfo$iv$iv = object12;
                                        this_$iv$iv.writeln(Level.DEBUG, message$iv$iv + (String)exceptionInfo$iv$iv);
                                        break block156;
                                    }
                                    Logger.INSTANCE.debug(t$iv, "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
                                }
                                JsonPrimitive $this$loadSettingsSafe_u24lambda_u2462 = (JsonPrimitive)JsonNull.INSTANCE;
                                boolean bl41 = false;
                                String string20 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u2462);
                                if (string20 == null) {
                                    string20 = "";
                                }
                                string7 = string20;
                            }
                            string6 = string7;
                        }
                        string2 = string6;
                        this_$iv = this;
                        $this$safePrimitiveAt$iv = (JsonObject)rawSettings;
                        path$iv = new String[]{"proxy", "host"};
                        $i$f$safePrimitiveAt = false;
                        jsonElement2 = super.getNodeSafe($this$safePrimitiveAt$iv, (String[])path$iv);
                        if (jsonElement2 != null) break block159;
                        $this$loadSettingsSafe_u24lambda_u247 = (JsonPrimitive)JsonNull.INSTANCE;
                        boolean bl42 = false;
                        string4 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u247);
                        if (string4 == null) {
                            string4 = "";
                        }
                        break block160;
                    }
                    currentNode$iv = jsonElement2;
                    try {
                        $this$loadSettingsSafe_u24lambda_u247 = JsonElementKt.getJsonPrimitive((JsonElement)currentNode$iv);
                        boolean bl43 = false;
                        String string21 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u247);
                        if (string21 == null) {
                            string21 = "";
                        }
                        string5 = string21;
                    }
                    catch (Throwable t$iv) {
                        block163: {
                            block161: {
                                Object object13;
                                String message$iv$iv;
                                block165: {
                                    block164: {
                                        block162: {
                                            BootstrapLogger bootstrapLogger14 = bootstrapLogger = ((SettingsStorage)this_$iv).bootstrapLogger;
                                            if (bootstrapLogger14 == null) break block161;
                                            this_$iv$iv = bootstrapLogger14;
                                            exception$iv$iv = t$iv;
                                            message$iv$iv = "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                                            boolean $i$f$debug = false;
                                            if (!this_$iv$iv.isTinylogEnabled()) break block162;
                                            Throwable throwable = exception$iv$iv;
                                            if (throwable != null) {
                                                Throwable it$iv$iv = throwable;
                                                boolean bl44 = false;
                                                Logger.INSTANCE.debug(it$iv$iv, message$iv$iv);
                                            } else {
                                                Logger.INSTANCE.debug(message$iv$iv);
                                            }
                                            break block163;
                                        }
                                        this_$iv$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.DEBUG, message$iv$iv, exception$iv$iv));
                                        object13 = exception$iv$iv;
                                        if (object13 == null) break block164;
                                        Throwable it$iv$iv = object13;
                                        boolean bl45 = false;
                                        String string22 = "\n" + it$iv$iv;
                                        object13 = string22;
                                        if (string22 != null) break block165;
                                    }
                                    object13 = "";
                                }
                                exceptionInfo$iv$iv = object13;
                                this_$iv$iv.writeln(Level.DEBUG, message$iv$iv + (String)exceptionInfo$iv$iv);
                                break block163;
                            }
                            Logger.INSTANCE.debug(t$iv, "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
                        }
                        JsonPrimitive $this$loadSettingsSafe_u24lambda_u2472 = (JsonPrimitive)JsonNull.INSTANCE;
                        boolean bl46 = false;
                        String string23 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u2472);
                        if (string23 == null) {
                            string23 = "";
                        }
                        string5 = string23;
                    }
                    string4 = string5;
                }
                string = string4;
                this_$iv = this;
                $this$safePrimitiveAt$iv = (JsonObject)rawSettings;
                path$iv = new String[]{"proxy", "port"};
                $i$f$safePrimitiveAt = false;
                jsonElement = super.getNodeSafe($this$safePrimitiveAt$iv, (String[])path$iv);
                if (jsonElement != null) break block166;
                $this$loadSettingsSafe_u24lambda_u248 = (JsonPrimitive)JsonNull.INSTANCE;
                boolean bl47 = false;
                Integer n9 = JsonElementKt.getIntOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u248);
                if (n9 != null) {
                    n = n9;
                } else {
                    String string24 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u248);
                    Integer n10 = string24 != null ? StringsKt.toIntOrNull((String)string24) : null;
                    n = n10 != null ? n10 : 0;
                }
                break block167;
            }
            currentNode$iv = jsonElement;
            try {
                int n11;
                $this$loadSettingsSafe_u24lambda_u248 = JsonElementKt.getJsonPrimitive((JsonElement)currentNode$iv);
                boolean bl48 = false;
                Integer n12 = JsonElementKt.getIntOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u248);
                if (n12 != null) {
                    n11 = n12;
                } else {
                    String string25 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u248);
                    Integer n13 = string25 != null ? StringsKt.toIntOrNull((String)string25) : null;
                    n11 = n13 != null ? n13 : 0;
                }
                n3 = n11;
            }
            catch (Throwable t$iv) {
                int n14;
                block170: {
                    block168: {
                        Object object14;
                        String message$iv$iv;
                        block172: {
                            block171: {
                                block169: {
                                    BootstrapLogger bootstrapLogger15 = bootstrapLogger = ((SettingsStorage)this_$iv).bootstrapLogger;
                                    if (bootstrapLogger15 == null) break block168;
                                    this_$iv$iv = bootstrapLogger15;
                                    exception$iv$iv = t$iv;
                                    message$iv$iv = "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                                    boolean $i$f$debug = false;
                                    if (!this_$iv$iv.isTinylogEnabled()) break block169;
                                    Throwable throwable = exception$iv$iv;
                                    if (throwable != null) {
                                        Throwable it$iv$iv = throwable;
                                        boolean bl49 = false;
                                        Logger.INSTANCE.debug(it$iv$iv, message$iv$iv);
                                    } else {
                                        Logger.INSTANCE.debug(message$iv$iv);
                                    }
                                    break block170;
                                }
                                this_$iv$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.DEBUG, message$iv$iv, exception$iv$iv));
                                object14 = exception$iv$iv;
                                if (object14 == null) break block171;
                                Throwable it$iv$iv = object14;
                                boolean bl50 = false;
                                String string26 = "\n" + it$iv$iv;
                                object14 = string26;
                                if (string26 != null) break block172;
                            }
                            object14 = "";
                        }
                        exceptionInfo$iv$iv = object14;
                        this_$iv$iv.writeln(Level.DEBUG, message$iv$iv + (String)exceptionInfo$iv$iv);
                        break block170;
                    }
                    Logger.INSTANCE.debug(t$iv, "Failed to parse settings node " + ArraysKt.joinToString$default((Object[])path$iv, (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
                }
                JsonPrimitive $this$loadSettingsSafe_u24lambda_u2482 = (JsonPrimitive)JsonNull.INSTANCE;
                boolean bl51 = false;
                Integer n15 = JsonElementKt.getIntOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u2482);
                if (n15 != null) {
                    n14 = n15;
                } else {
                    String string27 = JsonElementKt.getContentOrNull((JsonPrimitive)$this$loadSettingsSafe_u24lambda_u2482);
                    Integer n16 = string27 != null ? StringsKt.toIntOrNull((String)string27) : null;
                    n14 = n16 != null ? n16 : 0;
                }
                n3 = n14;
            }
            n = n3;
        }
        int n17 = n;
        String[] stringArray = new String[]{"proxy", "auth"};
        ProxyAuthSettings proxyAuthSettings = this.loadSafe((JsonObject)rawSettings, ProxyAuthSettings.Companion.serializer(), stringArray);
        int n18 = n17;
        String string28 = string;
        String string29 = string2;
        Object object15 = object;
        stringArray = new String[]{"shell_scripts"};
        stringArray = new String[]{"statistics"};
        stringArray = new String[]{"network"};
        stringArray = new String[]{"ui"};
        stringArray = new String[]{"tools"};
        stringArray = new String[]{"update"};
        stringArray = new String[]{"jetbrains_account"};
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n19 = 65538;
        Set set2 = null;
        JetBrainsAccountSettings jetBrainsAccountSettings = this.loadSafe((JsonObject)rawSettings, JetBrainsAccountSettings.Companion.serializer(), stringArray);
        UpdateSettings updateSettings = this.loadSafe((JsonObject)rawSettings, UpdateSettings.Companion.serializer(), stringArray);
        ToolsSettings toolsSettings = this.loadSafe((JsonObject)rawSettings, ToolsSettings.Companion.serializer(), stringArray);
        UISettings uISettings = this.loadSafe((JsonObject)rawSettings, UISettings.Companion.serializer(), stringArray);
        NetworkSettings networkSettings = this.loadSafe((JsonObject)rawSettings, NetworkSettings.Companion.serializer(), stringArray);
        StatisticsSettings statisticsSettings = this.loadSafe((JsonObject)rawSettings, StatisticsSettings.Companion.serializer(), stringArray);
        ShellScriptsSettings shellScriptsSettings = this.loadSafe((JsonObject)rawSettings, ShellScriptsSettings.Companion.serializer(), stringArray);
        ProxySettings proxySettings2 = new ProxySettings((ProxyType)((Object)object15), string29, string28, n18, proxyAuthSettings);
        Map map4 = map2;
        OrderingSettings orderingSettings2 = orderingSettings;
        int n20 = n2;
        String string30 = string3;
        boolean bl52 = bl;
        boolean bl53 = bl2;
        AdvancedSettings advancedSettings2 = advancedSettings;
        InternalSettings internalSettings2 = internalSettings;
        return new SelfSettings(internalSettings2, advancedSettings2, bl53, bl52, string30, n20, orderingSettings2, map4, proxySettings2, shellScriptsSettings, statisticsSettings, networkSettings, uISettings, toolsSettings, updateSettings, jetBrainsAccountSettings, set2, n19, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T loadSafe(JsonObject $this$loadSafe, KSerializer<T> serializer2, String ... path2) {
        Object object;
        try {
            JsonElement jsonObject = this.getNodeSafe($this$loadSafe, path2);
            object = jsonObject instanceof JsonObject ? this.json.decodeFromJsonElement((DeserializationStrategy)serializer2, jsonObject) : this.json.decodeFromJsonElement((DeserializationStrategy)serializer2, (JsonElement)new JsonObject(MapsKt.emptyMap()));
        }
        catch (Throwable throwable) {
            BootstrapLogger bootstrapLogger = this.bootstrapLogger;
            if (bootstrapLogger != null) {
                void this_$iv;
                BootstrapLogger bootstrapLogger2 = bootstrapLogger;
                Object var7_7 = null;
                String message$iv = "Failed to parse settings object at " + path2;
                boolean $i$f$debug = false;
                if (this_$iv.isTinylogEnabled()) {
                    Logger.INSTANCE.debug(message$iv);
                } else {
                    void exception$iv;
                    this_$iv.getMessages().add(new BootstrapLogger.LogEntry(Level.DEBUG, message$iv, (Throwable)exception$iv));
                    String exceptionInfo$iv = "";
                    this_$iv.writeln(Level.DEBUG, message$iv + exceptionInfo$iv);
                }
            } else {
                Logger.INSTANCE.debug("Failed to parse settings object at " + path2);
            }
            object = this.json.decodeFromJsonElement((DeserializationStrategy)serializer2, (JsonElement)new JsonObject(MapsKt.emptyMap()));
        }
        return (T)object;
    }

    private final JsonElement getNodeSafe(JsonObject $this$getNodeSafe, String[] nodes) {
        JsonElement currentNode = (JsonElement)$this$getNodeSafe;
        for (String node2 : nodes) {
            if (!(currentNode instanceof JsonObject)) {
                return currentNode;
            }
            currentNode = (JsonElement)((JsonObject)currentNode).get((Object)node2);
        }
        return currentNode;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setEncodeDefaults(false);
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setAllowTrailingComma(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Path access$getSettingsFile$p(SettingsStorage $this) {
        return $this.settingsFile;
    }
}

