/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.settings;

import com.jetbrains.toolbox.Keychain;
import com.jetbrains.toolbox.KeychainKt;
import com.jetbrains.toolbox.common.io.FileSystemWatcher;
import com.jetbrains.toolbox.i18n.UILanguage;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import com.jetbrains.toolbox.settings.SettingsStorage;
import com.jetbrains.toolbox.settings.Storage;
import com.jetbrains.toolbox.settings.StorageManager;
import com.jetbrains.toolbox.settings.UISettings;
import java.util.Locale;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SuspendFunction;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSettingsManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsManagerImpl.kt\ncom/jetbrains/toolbox/settings/SettingsManagerImpl\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n230#2,5:73\n295#3,2:78\n*S KotlinDebug\n*F\n+ 1 SettingsManagerImpl.kt\ncom/jetbrains/toolbox/settings/SettingsManagerImpl\n*L\n43#1:73,5\n48#1:78,2\n*E\n"})
public final class SettingsManagerImpl
implements SettingsManager {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final SettingsStorage settingsStorage;
    @NotNull
    private final StorageManager storage;
    @NotNull
    private final Keychain keychain;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<SelfSettings> _settings;
    @NotNull
    private final StateFlow<SelfSettings> settings;
    @NotNull
    private final ReadWriteProperty proxyPassword$delegate;
    @NotNull
    private final ReadWriteProperty apiKeyHeaderValue$delegate;

    public SettingsManagerImpl(@NotNull SettingsStorage settingsStorage, @NotNull StorageManager storage, @NotNull Keychain keychain, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)settingsStorage, (String)"settingsStorage");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)keychain, (String)"keychain");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.settingsStorage = settingsStorage;
        this.storage = storage;
        this.keychain = keychain;
        this.coroutineScope = coroutineScope;
        this._settings = StateFlowKt.MutableStateFlow((Object)this.loadSettingsOnStart());
        this.settings = FlowKt.asStateFlow(this._settings);
        if (((Storage)this.storage.getStorage().getValue()).getFirstRunDate() != null) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ SettingsManagerImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = FlowKt.collectLatest((Flow)((Flow)this.this$0.getSettings()), (Function2)((Function2)new SuspendFunction(this.this$0.settingsStorage){

                                public final Object invoke(SelfSettings p0, Continuation<? super Unit> $completion) {
                                    return 1.invokeSuspend$saveSettings((SettingsStorage)this.receiver, p0, $completion);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final /* synthetic */ Object invokeSuspend$saveSettings(SettingsStorage $this$invokeSuspend_u24saveSettings, SelfSettings p0, Continuation $completion) {
                    $this$invokeSuspend_u24saveSettings.saveSettings(p0);
                    return Unit.INSTANCE;
                }
            }), (int)3, null);
        }
        this.proxyPassword$delegate = KeychainKt.prop$default(this.keychain, "system-proxy", null, 2, null);
        this.apiKeyHeaderValue$delegate = KeychainKt.prop$default(this.keychain, "api-key-header-value", null, 2, null);
    }

    @Override
    @NotNull
    public StateFlow<SelfSettings> getSettings() {
        return this.settings;
    }

    public final void watchSettingsFileForChanges(@NotNull FileSystemWatcher fileSystemWatcher) {
        Intrinsics.checkNotNullParameter((Object)fileSystemWatcher, (String)"fileSystemWatcher");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, fileSystemWatcher, null){
            int label;
            final /* synthetic */ SettingsManagerImpl this$0;
            final /* synthetic */ FileSystemWatcher $fileSystemWatcher;
            {
                this.this$0 = $receiver;
                this.$fileSystemWatcher = $fileSystemWatcher;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = SettingsManagerImpl.access$getSettingsStorage$p(this.this$0).watchSettingsFileForChanges$settings(this.$fileSystemWatcher, (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ SettingsManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(1, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        SettingsManagerImpl.access$get_settings$p(this.this$0).setValue((Object)SettingsStorage.readSettings$default(SettingsManagerImpl.access$getSettingsStorage$p(this.this$0), false, 1, null));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Continuation<? super Unit> p1) {
                                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void updateSettings(@NotNull Function1<? super SelfSettings, SelfSettings> transform2) {
        Object nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        MutableStateFlow<SelfSettings> $this$update$iv = this._settings;
        boolean $i$f$update = false;
        while (!$this$update$iv.compareAndSet(prevValue$iv = $this$update$iv.getValue(), nextValue$iv = transform2.invoke(prevValue$iv))) {
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SelfSettings loadSettingsOnStart() {
        SelfSettings selfSettings;
        UILanguage systemLanguage;
        UILanguage uILanguage;
        Object v0;
        block6: {
            void $this$firstOrNull$iv;
            Locale systemLocale = Locale.getDefault();
            Iterable iterable = (Iterable)UILanguage.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UILanguage language = (UILanguage)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)language.getLocale().getLanguage(), (Object)systemLocale.getLanguage())) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        if ((uILanguage = (UILanguage)v0) == null) {
            uILanguage = systemLanguage = UILanguage.EN;
        }
        if (((Storage)this.storage.getStorage().getValue()).getFirstRunDate() == null) {
            selfSettings = new SelfSettings(null, null, false, false, null, 0, null, null, null, null, null, null, new UISettings(null, null, systemLanguage, null, 0.0f, 27, null), null, null, null, null, 126975, null);
        } else {
            SelfSettings selfSettings2;
            try {
                selfSettings2 = this.settingsStorage.readSettings(true);
            }
            catch (Throwable t2) {
                Logger.INSTANCE.error(t2, "Failed to load settings");
                selfSettings2 = new SelfSettings(null, null, false, false, null, 0, null, null, null, null, null, null, new UISettings(null, null, systemLanguage, null, 0.0f, 27, null), null, null, null, null, 126975, null);
            }
            selfSettings = selfSettings2;
        }
        return selfSettings;
    }

    @Override
    @NotNull
    public String getProxyPassword() {
        return (String)this.proxyPassword$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setProxyPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.proxyPassword$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @Override
    @NotNull
    public String getApiKeyHeaderValue() {
        return (String)this.apiKeyHeaderValue$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Override
    public void setApiKeyHeaderValue(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.apiKeyHeaderValue$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
    }

    public static final /* synthetic */ MutableStateFlow access$get_settings$p(SettingsManagerImpl $this) {
        return $this._settings;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SettingsManagerImpl.class, "proxyPassword", "getProxyPassword()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SettingsManagerImpl.class, "apiKeyHeaderValue", "getApiKeyHeaderValue()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

