/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.rpc.model;

import com.jetbrains.toolbox.agentNetworkApiUtils.AgentNetworkApiInfoProvider;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface HandshakeResult {
    @Nullable
    default public String retrieveErrorMessage() {
        Object object;
        HandshakeResult handshakeResult = this;
        if (handshakeResult instanceof Error) {
            object = "Handshake failed with error: " + ((Error)this).getErrorMessage();
        } else if (handshakeResult instanceof ClientFailure) {
            object = "Handshake failed because Toolbox Agent doesn't meet requirements. Remote side version: " + ((ClientFailure)this).getRemoteVersion().toUserFriendlyString() + ". Local side version: " + ((ClientFailure)this).getLocalVersion().toUserFriendlyString() + " " + (((ClientFailure)this).getRedeploy() ? "Requested server quit" : null);
        } else if (handshakeResult instanceof ServerFailure) {
            object = "Handshake failed because Toolbox App doesn't meet requirements of remote side. Minimal required version: " + ((ServerFailure)this).getMinimalVersion().toUserFriendlyString();
        } else if (Intrinsics.areEqual((Object)handshakeResult, (Object)ServerWillUpdate.INSTANCE)) {
            object = "Handshake needs to be restarted because remote side promised to update";
        } else if (handshakeResult instanceof UpdateNeeded) {
            object = "Remote side asked for update to version greater or equal to " + ((UpdateNeeded)this).getMinimalVersion().toUserFriendlyString();
        } else if (Intrinsics.areEqual((Object)handshakeResult, (Object)UserCancelled.INSTANCE)) {
            object = "User decided to cancel the connection";
        } else if (Intrinsics.areEqual((Object)handshakeResult, (Object)Success.INSTANCE)) {
            object = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    public static final class ClientFailure
    implements HandshakeResult,
    Failed {
        @NotNull
        private final AgentNetworkApiInfoProvider.VersionNumber localVersion;
        @NotNull
        private final AgentNetworkApiInfoProvider.VersionNumber remoteVersion;
        private final boolean redeploy;

        public ClientFailure(@NotNull AgentNetworkApiInfoProvider.VersionNumber localVersion, @NotNull AgentNetworkApiInfoProvider.VersionNumber remoteVersion, boolean redeploy) {
            Intrinsics.checkNotNullParameter((Object)localVersion, (String)"localVersion");
            Intrinsics.checkNotNullParameter((Object)remoteVersion, (String)"remoteVersion");
            this.localVersion = localVersion;
            this.remoteVersion = remoteVersion;
            this.redeploy = redeploy;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber getLocalVersion() {
            return this.localVersion;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber getRemoteVersion() {
            return this.remoteVersion;
        }

        public final boolean getRedeploy() {
            return this.redeploy;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber component1() {
            return this.localVersion;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber component2() {
            return this.remoteVersion;
        }

        public final boolean component3() {
            return this.redeploy;
        }

        @NotNull
        public final ClientFailure copy(@NotNull AgentNetworkApiInfoProvider.VersionNumber localVersion, @NotNull AgentNetworkApiInfoProvider.VersionNumber remoteVersion, boolean redeploy) {
            Intrinsics.checkNotNullParameter((Object)localVersion, (String)"localVersion");
            Intrinsics.checkNotNullParameter((Object)remoteVersion, (String)"remoteVersion");
            return new ClientFailure(localVersion, remoteVersion, redeploy);
        }

        public static /* synthetic */ ClientFailure copy$default(ClientFailure clientFailure, AgentNetworkApiInfoProvider.VersionNumber versionNumber, AgentNetworkApiInfoProvider.VersionNumber versionNumber2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                versionNumber = clientFailure.localVersion;
            }
            if ((n & 2) != 0) {
                versionNumber2 = clientFailure.remoteVersion;
            }
            if ((n & 4) != 0) {
                bl = clientFailure.redeploy;
            }
            return clientFailure.copy(versionNumber, versionNumber2, bl);
        }

        @NotNull
        public String toString() {
            return "ClientFailure(localVersion=" + this.localVersion + ", remoteVersion=" + this.remoteVersion + ", redeploy=" + this.redeploy + ")";
        }

        public int hashCode() {
            int result2 = this.localVersion.hashCode();
            result2 = result2 * 31 + this.remoteVersion.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.redeploy);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClientFailure)) {
                return false;
            }
            ClientFailure clientFailure = (ClientFailure)other;
            if (!Intrinsics.areEqual((Object)this.localVersion, (Object)clientFailure.localVersion)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.remoteVersion, (Object)clientFailure.remoteVersion)) {
                return false;
            }
            return this.redeploy == clientFailure.redeploy;
        }
    }

    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static String retrieveErrorMessage(@NotNull HandshakeResult $this) {
            return $this.retrieveErrorMessage();
        }
    }

    public static final class Error
    implements HandshakeResult,
    Failed {
        @NotNull
        private final String errorMessage;

        public Error(@NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            this.errorMessage = errorMessage;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @NotNull
        public final String component1() {
            return this.errorMessage;
        }

        @NotNull
        public final Error copy(@NotNull String errorMessage) {
            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
            return new Error(errorMessage);
        }

        public static /* synthetic */ Error copy$default(Error error2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = error2.errorMessage;
            }
            return error2.copy(string);
        }

        @NotNull
        public String toString() {
            return "Error(errorMessage=" + this.errorMessage + ")";
        }

        public int hashCode() {
            return this.errorMessage.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Error)) {
                return false;
            }
            Error error2 = (Error)other;
            return Intrinsics.areEqual((Object)this.errorMessage, (Object)error2.errorMessage);
        }
    }

    public static sealed interface Failed
    extends HandshakeResult
    permits ClientFailure, Error, ServerFailure, ServerWillUpdate, UpdateNeeded {

        public static final class DefaultImpls {
            @Deprecated
            @Nullable
            public static String retrieveErrorMessage(@NotNull Failed $this) {
                return $this.retrieveErrorMessage();
            }
        }
    }

    public static final class ServerFailure
    implements HandshakeResult,
    Failed {
        @NotNull
        private final AgentNetworkApiInfoProvider.VersionNumber localVersion;
        @NotNull
        private final AgentNetworkApiInfoProvider.VersionNumber minimalVersion;

        public ServerFailure(@NotNull AgentNetworkApiInfoProvider.VersionNumber localVersion, @NotNull AgentNetworkApiInfoProvider.VersionNumber minimalVersion) {
            Intrinsics.checkNotNullParameter((Object)localVersion, (String)"localVersion");
            Intrinsics.checkNotNullParameter((Object)minimalVersion, (String)"minimalVersion");
            this.localVersion = localVersion;
            this.minimalVersion = minimalVersion;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber getLocalVersion() {
            return this.localVersion;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber getMinimalVersion() {
            return this.minimalVersion;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber component1() {
            return this.localVersion;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber component2() {
            return this.minimalVersion;
        }

        @NotNull
        public final ServerFailure copy(@NotNull AgentNetworkApiInfoProvider.VersionNumber localVersion, @NotNull AgentNetworkApiInfoProvider.VersionNumber minimalVersion) {
            Intrinsics.checkNotNullParameter((Object)localVersion, (String)"localVersion");
            Intrinsics.checkNotNullParameter((Object)minimalVersion, (String)"minimalVersion");
            return new ServerFailure(localVersion, minimalVersion);
        }

        public static /* synthetic */ ServerFailure copy$default(ServerFailure serverFailure, AgentNetworkApiInfoProvider.VersionNumber versionNumber, AgentNetworkApiInfoProvider.VersionNumber versionNumber2, int n, Object object) {
            if ((n & 1) != 0) {
                versionNumber = serverFailure.localVersion;
            }
            if ((n & 2) != 0) {
                versionNumber2 = serverFailure.minimalVersion;
            }
            return serverFailure.copy(versionNumber, versionNumber2);
        }

        @NotNull
        public String toString() {
            return "ServerFailure(localVersion=" + this.localVersion + ", minimalVersion=" + this.minimalVersion + ")";
        }

        public int hashCode() {
            int result2 = this.localVersion.hashCode();
            result2 = result2 * 31 + this.minimalVersion.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServerFailure)) {
                return false;
            }
            ServerFailure serverFailure = (ServerFailure)other;
            if (!Intrinsics.areEqual((Object)this.localVersion, (Object)serverFailure.localVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.minimalVersion, (Object)serverFailure.minimalVersion);
        }
    }

    public static final class ServerWillUpdate
    implements HandshakeResult,
    Failed {
        @NotNull
        public static final ServerWillUpdate INSTANCE = new ServerWillUpdate();

        private ServerWillUpdate() {
        }

        @NotNull
        public String toString() {
            return "ServerWillUpdate";
        }

        public int hashCode() {
            return 1920544486;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServerWillUpdate)) {
                return false;
            }
            ServerWillUpdate cfr_ignored_0 = (ServerWillUpdate)other;
            return true;
        }
    }

    public static final class Success
    implements HandshakeResult {
        @NotNull
        public static final Success INSTANCE = new Success();

        private Success() {
        }

        @NotNull
        public String toString() {
            return "Success";
        }

        public int hashCode() {
            return -433902853;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success cfr_ignored_0 = (Success)other;
            return true;
        }
    }

    public static final class UpdateNeeded
    implements HandshakeResult,
    Failed {
        @NotNull
        private final AgentNetworkApiInfoProvider.VersionNumber minimalVersion;

        public UpdateNeeded(@NotNull AgentNetworkApiInfoProvider.VersionNumber minimalVersion) {
            Intrinsics.checkNotNullParameter((Object)minimalVersion, (String)"minimalVersion");
            this.minimalVersion = minimalVersion;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber getMinimalVersion() {
            return this.minimalVersion;
        }

        @NotNull
        public final AgentNetworkApiInfoProvider.VersionNumber component1() {
            return this.minimalVersion;
        }

        @NotNull
        public final UpdateNeeded copy(@NotNull AgentNetworkApiInfoProvider.VersionNumber minimalVersion) {
            Intrinsics.checkNotNullParameter((Object)minimalVersion, (String)"minimalVersion");
            return new UpdateNeeded(minimalVersion);
        }

        public static /* synthetic */ UpdateNeeded copy$default(UpdateNeeded updateNeeded, AgentNetworkApiInfoProvider.VersionNumber versionNumber, int n, Object object) {
            if ((n & 1) != 0) {
                versionNumber = updateNeeded.minimalVersion;
            }
            return updateNeeded.copy(versionNumber);
        }

        @NotNull
        public String toString() {
            return "UpdateNeeded(minimalVersion=" + this.minimalVersion + ")";
        }

        public int hashCode() {
            return this.minimalVersion.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UpdateNeeded)) {
                return false;
            }
            UpdateNeeded updateNeeded = (UpdateNeeded)other;
            return Intrinsics.areEqual((Object)this.minimalVersion, (Object)updateNeeded.minimalVersion);
        }
    }

    public static final class UserCancelled
    implements HandshakeResult {
        @NotNull
        public static final UserCancelled INSTANCE = new UserCancelled();

        private UserCancelled() {
        }

        @NotNull
        public String toString() {
            return "UserCancelled";
        }

        public int hashCode() {
            return 307774142;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserCancelled)) {
                return false;
            }
            UserCancelled cfr_ignored_0 = (UserCancelled)other;
            return true;
        }
    }
}

