/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.resharper.model;

import java.util.List;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstalledDotNetTool {
    @NotNull
    private final Tool tool;
    @NotNull
    private final Path directory;
    @NotNull
    private final String hive;
    private final int wave;

    public InstalledDotNetTool(@NotNull Tool tool, @NotNull Path directory, @NotNull String hive, int wave) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)hive, (String)"hive");
        this.tool = tool;
        this.directory = directory;
        this.hive = hive;
        this.wave = wave;
    }

    @NotNull
    public final Tool getTool() {
        return this.tool;
    }

    @NotNull
    public final String getHive() {
        return this.hive;
    }

    public final int getWave() {
        return this.wave;
    }

    @NotNull
    public String toString() {
        return "InstalledDotNetTool(tool=" + this.tool + ", directory=" + this.directory + ", hive=" + this.hive + ", wave=" + this.wave + ")";
    }

    public int hashCode() {
        int result2 = this.tool.hashCode();
        result2 = result2 * 31 + this.directory.hashCode();
        result2 = result2 * 31 + this.hive.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.wave);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstalledDotNetTool)) {
            return false;
        }
        InstalledDotNetTool installedDotNetTool = (InstalledDotNetTool)other;
        if (!Intrinsics.areEqual((Object)this.tool, (Object)installedDotNetTool.tool)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.directory, (Object)installedDotNetTool.directory)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hive, (Object)installedDotNetTool.hive)) {
            return false;
        }
        return this.wave == installedDotNetTool.wave;
    }

    public static sealed interface Tool {

        public static final class Known
        implements Tool {
            @NotNull
            private final Type type;
            @NotNull
            private final Path executable;
            @NotNull
            private final List<String> arguments;
            @NotNull
            private final String shortName;

            public Known(@NotNull Type type2, @NotNull Path executable, @NotNull List<String> arguments) {
                Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
                Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
                Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
                this.type = type2;
                this.executable = executable;
                this.arguments = arguments;
                this.shortName = this.type.getShortName();
            }

            @NotNull
            public final Path getExecutable() {
                return this.executable;
            }

            @NotNull
            public final List<String> getArguments() {
                return this.arguments;
            }

            @NotNull
            public String getShortName() {
                return this.shortName;
            }

            @NotNull
            public String toString() {
                return "Known(type=" + this.type + ", executable=" + this.executable + ", arguments=" + this.arguments + ")";
            }

            public int hashCode() {
                int result2 = this.type.hashCode();
                result2 = result2 * 31 + this.executable.hashCode();
                result2 = result2 * 31 + ((Object)this.arguments).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Known)) {
                    return false;
                }
                Known known = (Known)other;
                if (this.type != known.type) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.executable, (Object)known.executable)) {
                    return false;
                }
                return Intrinsics.areEqual(this.arguments, known.arguments);
            }
        }

        public static final class ReSharperPlatform
        implements Tool {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final String vsVersion;

            public ReSharperPlatform(@NotNull String vsVersion) {
                Intrinsics.checkNotNullParameter((Object)vsVersion, (String)"vsVersion");
                this.vsVersion = vsVersion;
            }

            @NotNull
            public String toString() {
                return "ReSharperPlatform(vsVersion=" + this.vsVersion + ")";
            }

            public int hashCode() {
                return this.vsVersion.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReSharperPlatform)) {
                    return false;
                }
                ReSharperPlatform reSharperPlatform = (ReSharperPlatform)other;
                return Intrinsics.areEqual((Object)this.vsVersion, (Object)reSharperPlatform.vsVersion);
            }

            public static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        public static final class Unknown
        implements Tool {
            @NotNull
            private final String shortName;

            public Unknown(@NotNull String shortName) {
                Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
                this.shortName = shortName;
            }

            @NotNull
            public String toString() {
                return "Unknown(shortName=" + this.shortName + ")";
            }

            public int hashCode() {
                return this.shortName.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unknown)) {
                    return false;
                }
                Unknown unknown = (Unknown)other;
                return Intrinsics.areEqual((Object)this.shortName, (Object)unknown.shortName);
            }
        }
    }

    public static final class Type
    extends Enum<Type> {
        @NotNull
        private final String shortName;
        public static final /* enum */ Type DotPeek = new Type("dotPeek");
        public static final /* enum */ Type DotMemory = new Type("dotMemory");
        public static final /* enum */ Type DotTrace = new Type("dotTrace");
        public static final /* enum */ Type DotCover = new Type("dotCover");
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Type(String shortName) {
            this.shortName = shortName;
        }

        @NotNull
        public final String getShortName() {
            return this.shortName;
        }

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.DotPeek, Type.DotMemory, Type.DotTrace, Type.DotCover};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

