/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.protocolhandler;

import com.jetbrains.toolbox.JetBrainsAnalytics;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.protocolhandler.JetBrainsProtocolHandler;
import com.jetbrains.toolbox.protocolhandler.ProtocolHandler;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nJetBrainsProtocolHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JetBrainsProtocolHandler.kt\ncom/jetbrains/toolbox/protocolhandler/JetBrainsProtocolHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n295#2,2:63\n*S KotlinDebug\n*F\n+ 1 JetBrainsProtocolHandler.kt\ncom/jetbrains/toolbox/protocolhandler/JetBrainsProtocolHandler\n*L\n31#1:63,2\n*E\n"})
public final class JetBrainsProtocolHandler {
    @NotNull
    private final JetBrainsAnalytics fus;
    @NotNull
    private final CoroutineScope applicationScope;
    @NotNull
    private final List<ProtocolHandler> protocolHandlers;

    public JetBrainsProtocolHandler(@NotNull JetBrainsAnalytics fus, @NotNull CoroutineScope applicationScope2, @NotNull List<? extends ProtocolHandler> protocolHandlers) {
        Intrinsics.checkNotNullParameter((Object)fus, (String)"fus");
        Intrinsics.checkNotNullParameter((Object)applicationScope2, (String)"applicationScope");
        Intrinsics.checkNotNullParameter(protocolHandlers, (String)"protocolHandlers");
        this.fus = fus;
        this.applicationScope = applicationScope2;
        this.protocolHandlers = protocolHandlers;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object handle(@NotNull String protocolUrl, @NotNull Continuation<? super ProtocolHandlingResult> $completion) {
        block18: {
            if (!($completion instanceof handle.1)) ** GOTO lbl-1000
            var12_3 = $completion;
            if ((var12_3.label & -2147483648) != 0) {
                var12_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ JetBrainsProtocolHandler this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.handle(null, (Continuation<? super ProtocolHandlingResult>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    try {
                        var4_6 = new URI(protocolUrl);
                    }
                    catch (Throwable t) {
                        Logger.INSTANCE.warn(t, "Incorrect activation URL");
                        return new ProtocolHandlingResult(false, false);
                    }
                    uri = var4_6;
                    if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"jetbrains")) {
                        Logger.INSTANCE.info("Unknown protocol scheme: " + uri.getScheme() + " for URL: " + protocolUrl);
                        return new ProtocolHandlingResult(false, false);
                    }
                    $this$firstOrNull$iv = this.protocolHandlers;
                    $i$f$firstOrNull = 0;
                    var7_13 = $this$firstOrNull$iv.iterator();
lbl26:
                    // 2 sources

                    while (var7_13.hasNext()) {
                        element$iv = var7_13.next();
                        it = (ProtocolHandler)element$iv;
                        $i$a$-firstOrNull-JetBrainsProtocolHandler$handle$handler$1 = 0;
                        $continuation.L$0 = protocolUrl;
                        $continuation.L$1 = uri;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)$this$firstOrNull$iv);
                        $continuation.L$3 = var7_13;
                        $continuation.L$4 = element$iv;
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = $i$f$firstOrNull;
                        $continuation.I$1 = $i$a$-firstOrNull-JetBrainsProtocolHandler$handle$handler$1;
                        $continuation.label = 1;
                        v0 = it.canHandle(uri, (Continuation<? super Boolean>)$continuation);
                        if (v0 == var13_5) {
                            return var13_5;
                        }
                        ** GOTO lbl55
                    }
                    break;
                }
                case 1: {
                    $i$a$-firstOrNull-JetBrainsProtocolHandler$handle$handler$1 = $continuation.I$1;
                    $i$f$firstOrNull = $continuation.I$0;
                    it = (ProtocolHandler)$continuation.L$5;
                    element$iv = $continuation.L$4;
                    var7_13 = (Iterator<T>)$continuation.L$3;
                    $this$firstOrNull$iv = (Iterable)$continuation.L$2;
                    uri = (URI)$continuation.L$1;
                    protocolUrl = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl55:
                    // 2 sources

                    if (!((Boolean)v0).booleanValue()) ** GOTO lbl26
                    v1 = element$iv;
                    break block18;
                }
            }
            v1 = null;
        }
        handler = (ProtocolHandler)v1;
        if (handler == null) {
            Logger.INSTANCE.warn("Cannot handle URL: " + protocolUrl);
            BuildersKt.launch$default((CoroutineScope)this.applicationScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uri, null){
                int label;
                final /* synthetic */ JetBrainsProtocolHandler this$0;
                final /* synthetic */ URI $uri;
                {
                    this.this$0 = $receiver;
                    this.$uri = $uri;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            JetBrainsProtocolHandler.access$getFus$p(this.this$0).getLogger().log(Fus.Counters.UrlHandling.INSTANCE.getUrlFailed(), this.$uri.getHost());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return new ProtocolHandlingResult(false, false);
        }
        $continuation.L$0 = protocolUrl;
        $continuation.L$1 = uri;
        $continuation.L$2 = handler;
        $continuation.L$3 = null;
        $continuation.L$4 = null;
        $continuation.L$5 = null;
        $continuation.label = 2;
        v2 = handler.handle(uri, (Continuation<? super Unit>)$continuation);
        ** if (v2 != var13_5) goto lbl78
lbl77:
        // 1 sources

        return var13_5;
lbl78:
        // 1 sources

        ** GOTO lbl87
        {
            case 2: {
                handler = (ProtocolHandler)$continuation.L$2;
                uri = (URI)$continuation.L$1;
                protocolUrl = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl87:
                    // 2 sources

                    Logger.INSTANCE.info("Handled URL: " + StringsKt.take((String)protocolUrl, (int)20) + "...");
                    BuildersKt.launch$default((CoroutineScope)this.applicationScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, handler, null){
                        int label;
                        final /* synthetic */ JetBrainsProtocolHandler this$0;
                        final /* synthetic */ ProtocolHandler $handler;
                        {
                            this.this$0 = $receiver;
                            this.$handler = $handler;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    JetBrainsProtocolHandler.access$getFus$p(this.this$0).getLogger().log(Fus.Counters.UrlHandling.INSTANCE.getUrlHandled(), this.$handler.getClass().getName());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    return new ProtocolHandlingResult(true, handler.getImpliesUiMode());
                }
                catch (CancellationException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    Logger.INSTANCE.error(ex, "Failed to handle URL " + protocolUrl);
                    BuildersKt.launch$default((CoroutineScope)this.applicationScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uri, null){
                        int label;
                        final /* synthetic */ JetBrainsProtocolHandler this$0;
                        final /* synthetic */ URI $uri;
                        {
                            this.this$0 = $receiver;
                            this.$uri = $uri;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    JetBrainsProtocolHandler.access$getFus$p(this.this$0).getLogger().log(Fus.Counters.UrlHandling.INSTANCE.getUrlFailed(), this.$uri.getHost());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    return new ProtocolHandlingResult(true, false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ JetBrainsAnalytics access$getFus$p(JetBrainsProtocolHandler $this) {
        return $this.fus;
    }

    public static final class ProtocolHandlingResult {
        private final boolean handlerFound;
        private final boolean shouldAllowUi;

        public ProtocolHandlingResult(boolean handlerFound, boolean shouldAllowUi) {
            this.handlerFound = handlerFound;
            this.shouldAllowUi = shouldAllowUi;
        }

        public final boolean getShouldAllowUi() {
            return this.shouldAllowUi;
        }

        @NotNull
        public String toString() {
            return "ProtocolHandlingResult(handlerFound=" + this.handlerFound + ", shouldAllowUi=" + this.shouldAllowUi + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.handlerFound);
            result2 = result2 * 31 + Boolean.hashCode(this.shouldAllowUi);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProtocolHandlingResult)) {
                return false;
            }
            ProtocolHandlingResult protocolHandlingResult = (ProtocolHandlingResult)other;
            if (this.handlerFound != protocolHandlingResult.handlerFound) {
                return false;
            }
            return this.shouldAllowUi == protocolHandlingResult.shouldAllowUi;
        }
    }
}

