/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.project.devcontainers;

import com.jetbrains.toolbox.project.devcontainers.DevcontainerProject;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DevcontainersManager {
    @NotNull
    public StateFlow<State> getState();

    public static sealed interface State {

        public static final class Collected
        implements State {
            @NotNull
            private final List<DevcontainerProject> devcontainers;

            public Collected(@NotNull List<? extends DevcontainerProject> devcontainers) {
                Intrinsics.checkNotNullParameter(devcontainers, (String)"devcontainers");
                this.devcontainers = devcontainers;
            }

            @NotNull
            public final List<DevcontainerProject> getDevcontainers() {
                return this.devcontainers;
            }

            @NotNull
            public final List<DevcontainerProject> component1() {
                return this.devcontainers;
            }

            @NotNull
            public final Collected copy(@NotNull List<? extends DevcontainerProject> devcontainers) {
                Intrinsics.checkNotNullParameter(devcontainers, (String)"devcontainers");
                return new Collected(devcontainers);
            }

            public static /* synthetic */ Collected copy$default(Collected collected, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    list2 = collected.devcontainers;
                }
                return collected.copy(list2);
            }

            @NotNull
            public String toString() {
                return "Collected(devcontainers=" + this.devcontainers + ")";
            }

            public int hashCode() {
                return ((Object)this.devcontainers).hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Collected)) {
                    return false;
                }
                Collected collected = (Collected)other;
                return Intrinsics.areEqual(this.devcontainers, collected.devcontainers);
            }
        }

        public static final class Failure
        implements State {
            @NotNull
            private final String errorMessage;

            public Failure(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                this.errorMessage = errorMessage;
            }

            @NotNull
            public final String getErrorMessage() {
                return this.errorMessage;
            }

            @NotNull
            public final String component1() {
                return this.errorMessage;
            }

            @NotNull
            public final Failure copy(@NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                return new Failure(errorMessage);
            }

            public static /* synthetic */ Failure copy$default(Failure failure, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = failure.errorMessage;
                }
                return failure.copy(string);
            }

            @NotNull
            public String toString() {
                return "Failure(errorMessage=" + this.errorMessage + ")";
            }

            public int hashCode() {
                return this.errorMessage.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure failure = (Failure)other;
                return Intrinsics.areEqual((Object)this.errorMessage, (Object)failure.errorMessage);
            }
        }

        public static final class Initial
        implements State {
            @NotNull
            public static final Initial INSTANCE = new Initial();

            private Initial() {
            }

            @NotNull
            public String toString() {
                return "Initial";
            }

            public int hashCode() {
                return -995710981;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Initial)) {
                    return false;
                }
                Initial cfr_ignored_0 = (Initial)other;
                return true;
            }
        }

        public static final class IntegrationUnavailable
        implements State {
            @NotNull
            public static final IntegrationUnavailable INSTANCE = new IntegrationUnavailable();

            private IntegrationUnavailable() {
            }

            @NotNull
            public String toString() {
                return "IntegrationUnavailable";
            }

            public int hashCode() {
                return 1148921925;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof IntegrationUnavailable)) {
                    return false;
                }
                IntegrationUnavailable cfr_ignored_0 = (IntegrationUnavailable)other;
                return true;
            }
        }
    }
}

