/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.project;

import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import java.net.URI;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

public final class PartialUriSerializer
implements KSerializer<URI> {
    @NotNull
    public static final PartialUriSerializer INSTANCE = new PartialUriSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.buildClassSerialDescriptor$default((String)"java.net.URI", (SerialDescriptor[])new SerialDescriptor[0], null, (int)4, null);

    private PartialUriSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public URI deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        String s = decoder.decodeString();
        URI uRI = StringExtensionsKt.toUriOrNull(s);
        if (uRI == null) {
            URI uRI2 = StringExtensionsKt.toUriOrNull("ssh://" + s);
            uRI = uRI2;
            Intrinsics.checkNotNull((Object)uRI2);
        }
        return uRI;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull URI value2) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String string = value2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        encoder.encodeString(string);
    }
}

