/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.keychain;

import com.jetbrains.rhizomedb.Attributes;
import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntityAttributeKt;
import com.jetbrains.rhizomedb.EntityBuilder;
import com.jetbrains.rhizomedb.Indexing;
import com.jetbrains.toolbox.platform.keychain.KeychainSecret;
import com.jetbrains.toolbox.platform.keychain.KeychainSecretEntityType;
import com.jetbrains.toolbox.platform.keychain.KeychainSecretException;
import fleet.kernel.ReteExtKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.uuid.Uuid;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringSecret
extends KeychainSecret<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Attributes.Required<Uuid> idAttr = Attributes.requiredValue$default(Companion, "uuid", BuiltinSerializersKt.serializer((Uuid.Companion)Uuid.Companion), Indexing.UNIQUE, null, 8, null);

    public StringSecret(int eid2) {
        super(eid2, Companion);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class Companion
    extends KeychainSecretEntityType<StringSecret, String> {
        private Companion() {
            super(Reflection.getOrCreateKotlinClass(StringSecret.class), (Function1)1.INSTANCE, BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE));
        }

        @Nullable
        public final StringSecret keychainSecret(@NotNull Uuid secretId) {
            Intrinsics.checkNotNullParameter((Object)secretId, (String)"secretId");
            return (StringSecret)EntityAttributeKt.entity(idAttr, secretId);
        }

        @Nullable
        public final Object keychainSecretString(@NotNull Uuid secretId, @NotNull Continuation<? super String> $completion) {
            StringSecret stringSecret = this.keychainSecret(secretId);
            if (stringSecret == null) {
                throw new KeychainSecretException("Secret with ID '" + secretId + "' not found", null);
            }
            StringSecret secret = stringSecret;
            return ReteExtKt.waitForNotNull(() -> Companion.keychainSecretString$lambda$0(secret), $completion);
        }

        @NotNull
        public final StringSecret new(@NotNull ChangeScope changeScope, @NotNull Uuid secretId, @NotNull String secretValue) {
            Intrinsics.checkNotNullParameter((Object)changeScope, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)secretId, (String)"secretId");
            Intrinsics.checkNotNullParameter((Object)secretValue, (String)"secretValue");
            return (StringSecret)this.new(changeScope, arg_0 -> Companion.new$lambda$0(secretId, secretValue, arg_0));
        }

        private static final String keychainSecretString$lambda$0(StringSecret $secret) {
            return (String)$secret.getSecret();
        }

        private static final void new$lambda$0(Uuid $secretId, String $secretValue, EntityBuilder.Target it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Companion.init(it, "", $secretId.toString(), $secretValue);
            it.set(idAttr, $secretId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

