/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.packageextractor;

import com.jetbrains.toolbox.common.FileExtension;
import com.jetbrains.toolbox.common.io.FileHandleExtKt;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.packageextractor.NonStrippingExtractor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.InterruptibleKt;
import okio.BufferedSink;
import okio.FileHandle;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.tinylog.kotlin.Logger;

@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nZipExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipExtractor.kt\ncom/jetbrains/toolbox/packageextractor/ZipExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n+ 4 FileSystem.kt\nokio/FileSystem\n*L\n1#1,123:1\n1#2:124\n66#3:125\n52#3,4:127\n60#3,10:132\n56#3,3:142\n71#3,3:145\n81#4:126\n82#4:131\n*S KotlinDebug\n*F\n+ 1 ZipExtractor.kt\ncom/jetbrains/toolbox/packageextractor/ZipExtractor\n*L\n94#1:125\n94#1:127,4\n94#1:132,10\n94#1:142,3\n94#1:145,3\n94#1:126\n94#1:131\n*E\n"})
public final class ZipExtractor
implements NonStrippingExtractor {
    @NotNull
    private final FileSystem fileSystem;

    public ZipExtractor(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @NotNull
    public Set<FileExtension> getSupportedArchiveExtensions() {
        return SetsKt.setOf((Object)FileExtension.box-impl(FileExtension.constructor-impl("zip")));
    }

    private final Path ensureRelativePathInside(Path destinationDir, String childName) {
        Path file = destinationDir.resolve(childName);
        if (!PathExtensionsKt.contains(destinationDir, file)) {
            throw new IOException("Entry '" + childName + "' is outside of the target dir '" + destinationDir + "'");
        }
        return file;
    }

    private final void ensureDirectories(FileSystem $this$ensureDirectories, Path path2) {
        if ($this$ensureDirectories.exists(path2)) {
            if ($this$ensureDirectories.metadata(path2).isDirectory()) {
                return;
            }
            throw new IOException("Failed to create directory '" + path2 + "': a file already exists");
        }
        $this$ensureDirectories.createDirectories(path2);
    }

    private final void addPermissions(Set<PosixFilePermission> $this$addPermissions, String prefix, int mode) {
        if ((mode & 1) == 1) {
            $this$addPermissions.add(PosixFilePermission.valueOf(prefix + "_EXECUTE"));
        }
        if ((mode & 2) == 2) {
            $this$addPermissions.add(PosixFilePermission.valueOf(prefix + "_WRITE"));
        }
        if ((mode & 4) == 4) {
            $this$addPermissions.add(PosixFilePermission.valueOf(prefix + "_READ"));
        }
    }

    private final Set<PosixFilePermission> permissionsFromMode(int mode) {
        Set set2;
        Set $this$permissionsFromMode_u24lambda_u240 = set2 = SetsKt.createSetBuilder();
        boolean bl = false;
        this.addPermissions($this$permissionsFromMode_u24lambda_u240, "OTHERS", mode);
        this.addPermissions($this$permissionsFromMode_u24lambda_u240, "GROUP", mode >>> 3);
        this.addPermissions($this$permissionsFromMode_u24lambda_u240, "OWNER", mode >>> 6);
        return SetsKt.build((Set)set2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void unpackZip(FileSystem $this$unpackZip, Path archive, Path destinationDirectory) {
        Closeable closeable = (Closeable)$this$unpackZip.openReadOnly(archive);
        Throwable throwable = null;
        try {
            FileHandle file = (FileHandle)closeable;
            boolean bl = false;
            Closeable closeable2 = FileHandleExtKt.toSeekableByteChannel(file);
            Throwable throwable2 = null;
            try {
                SeekableByteChannel channel = (SeekableByteChannel)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new ZipFile(channel);
                Throwable throwable3 = null;
                try {
                    ZipFile zip = (ZipFile)closeable3;
                    boolean bl3 = false;
                    Enumeration<ZipArchiveEntry> enumeration = zip.getEntries();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getEntries(...)");
                    Iterator iterator2 = CollectionsKt.iterator(enumeration);
                    while (iterator2.hasNext()) {
                        Object object;
                        ZipArchiveEntry zipEntry = (ZipArchiveEntry)iterator2.next();
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        String string = zipEntry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        LinkOption[] newFile = this.ensureRelativePathInside(destinationDirectory, string);
                        if (zipEntry.isDirectory()) {
                            this.ensureDirectories($this$unpackZip, (Path)newFile);
                            v2 = Unit.INSTANCE;
                        } else {
                            Path path2 = newFile.parent();
                            Intrinsics.checkNotNull((Object)path2);
                            this.ensureDirectories($this$unpackZip, path2);
                            if (zipEntry.isUnixSymlink() && FileSystemExtKt.isSystem($this$unpackZip) && OS.INSTANCE.isUnix()) {
                                Object it;
                                object3 = zip.getInputStream(zipEntry);
                                java.nio.file.Path path3 = newFile.toNioPath();
                                object = null;
                                try {
                                    it = (InputStream)object3;
                                    boolean bl4 = false;
                                    Intrinsics.checkNotNull((Object)it);
                                    it = ByteStreamsKt.readBytes((InputStream)it);
                                }
                                catch (Throwable bl4) {
                                    object = bl4;
                                    throw bl4;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object3, (Throwable)object);
                                }
                                object3 = it;
                                v2 = Files.createSymbolicLink(path3, java.nio.file.Path.of(new String((byte[])object3, Charsets.UTF_8), new String[0]), new FileAttribute[0]);
                            } else {
                                Long l;
                                Throwable thrown$iv$iv;
                                block57: {
                                    void file$iv;
                                    void this_$iv;
                                    if (zipEntry.isUnixSymlink()) {
                                        Logger.INSTANCE.warn("Creating the symlink '" + (Path)newFile + "' as a simple file because the OS (" + OS.INSTANCE.getType() + ") is not UNIX (then admin rights are needed) or/and the target FS (" + $this$unpackZip + ") is not SYSTEM");
                                    }
                                    object3 = $this$unpackZip;
                                    object = newFile;
                                    boolean mustCreate$iv = true;
                                    boolean bl5 = false;
                                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)this_$iv.sink((Path)file$iv, mustCreate$iv));
                                    boolean $i$f$use = false;
                                    thrown$iv$iv = null;
                                    try {
                                        long l2;
                                        BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                                        boolean bl6 = false;
                                        BufferedSink $this$unpackZip_u24lambda_u240_u240_u240_u241 = it$iv;
                                        boolean bl7 = false;
                                        Closeable closeable4 = $this$unpackZip_u24lambda_u240_u240_u240_u241.outputStream();
                                        Throwable throwable4 = null;
                                        try {
                                            long l3;
                                            OutputStream outputStream = (OutputStream)closeable4;
                                            boolean bl8 = false;
                                            Closeable closeable5 = zip.getInputStream(zipEntry);
                                            Throwable throwable5 = null;
                                            try {
                                                InputStream it = (InputStream)closeable5;
                                                boolean bl9 = false;
                                                Intrinsics.checkNotNull((Object)it);
                                                l3 = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)outputStream, (int)0, (int)2, null);
                                            }
                                            catch (Throwable throwable6) {
                                                throwable5 = throwable6;
                                                throw throwable6;
                                            }
                                            finally {
                                                CloseableKt.closeFinally((Closeable)closeable5, (Throwable)throwable5);
                                            }
                                            l2 = l3;
                                        }
                                        catch (Throwable throwable7) {
                                            throwable4 = throwable7;
                                            throw throwable7;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                                        }
                                        l = l2;
                                    }
                                    catch (Throwable t$iv$iv) {
                                        try {
                                            thrown$iv$iv = t$iv$iv;
                                            l = null;
                                            break block57;
                                        }
                                        catch (Throwable throwable8) {
                                            throw throwable8;
                                        }
                                        finally {
                                            block58: {
                                                try {
                                                    Closeable closeable4 = $this$use$iv$iv;
                                                    if (closeable4 != null) {
                                                        closeable4.close();
                                                    }
                                                }
                                                catch (Throwable t$iv$iv2) {
                                                    if (thrown$iv$iv == null) {
                                                        thrown$iv$iv = t$iv$iv2;
                                                        break block58;
                                                    }
                                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                                                }
                                            }
                                        }
                                    }
                                    try {
                                        Closeable closeable5 = $this$use$iv$iv;
                                        if (closeable5 != null) {
                                            closeable5.close();
                                        }
                                    }
                                    catch (Throwable t$iv$iv) {
                                        thrown$iv$iv = t$iv$iv;
                                    }
                                }
                                Long result$iv$iv = l;
                                Throwable throwable4 = thrown$iv$iv;
                                if (throwable4 != null) {
                                    throw throwable4;
                                }
                                v2 = result$iv$iv;
                            }
                        }
                        if (FileSystemExtKt.isSystem($this$unpackZip)) {
                            if (!Files.isSymbolicLink(newFile.toNioPath())) {
                                BasicFileAttributeView attributes;
                                object = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                                Intrinsics.checkNotNull((Object)Files.getFileAttributeView(newFile.toNioPath(), BasicFileAttributeView.class, object));
                                attributes.setTimes(zipEntry.getLastModifiedTime(), zipEntry.getLastAccessTime(), zipEntry.getCreationTime());
                            }
                            if (!OS.INSTANCE.isUnix() || zipEntry.getPlatform() != 3 || zipEntry.isUnixSymlink()) continue;
                            Set<PosixFilePermission> permissions = this.permissionsFromMode(zipEntry.getUnixMode());
                            Files.setPosixFilePermissions(newFile.toNioPath(), permissions);
                            continue;
                        }
                        Logger.INSTANCE.warn("Skipping setting metadata for '" + (Path)newFile + "' because the FS (" + $this$unpackZip + ") is not SYSTEM");
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable10) {
                    throwable3 = throwable10;
                    throw throwable10;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable11) {
                throwable2 = throwable11;
                throw throwable11;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
        catch (Throwable throwable12) {
            throwable = throwable12;
            throw throwable12;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @Nullable
    public Object extract(@NotNull Path archive, @NotNull Path destinationDirectory, @NotNull Continuation<? super Unit> $completion) {
        return InterruptibleKt.runInterruptible$default(null, () -> ZipExtractor.extract$lambda$0(this, archive, destinationDirectory), $completion, (int)1, null);
    }

    private static final Unit extract$lambda$0(ZipExtractor this$0, Path $archive, Path $destinationDirectory) {
        this$0.unpackZip(this$0.fileSystem, $archive, $destinationDirectory);
        return Unit.INSTANCE;
    }
}

