/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.opensshAskpass;

import com.jetbrains.toolbox.common.WellKnownPaths;
import com.jetbrains.toolbox.opensshAskpass.AskpassHandler;
import com.jetbrains.toolbox.opensshAskpass.AskpassScriptDeployer;
import com.jetbrains.toolbox.opensshAskpass.AskpassService;
import com.jetbrains.toolbox.opensshAskpass.AskpassServiceStarter;
import com.jetbrains.toolbox.opensshAskpass.AskpassSocketImpl;
import com.jetbrains.toolbox.opensshAskpass.ToolboxAskpassEnvironmentProvider;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import okio.Path;
import org.jetbrains.annotations.NotNull;

public final class AskpassServiceStarterImpl
implements AskpassServiceStarter {
    @NotNull
    private final AskpassScriptDeployer scriptDeployer;
    @NotNull
    private final WellKnownPaths wellKnownPaths;

    public AskpassServiceStarterImpl(@NotNull AskpassScriptDeployer scriptDeployer, @NotNull WellKnownPaths wellKnownPaths) {
        Intrinsics.checkNotNullParameter((Object)scriptDeployer, (String)"scriptDeployer");
        Intrinsics.checkNotNullParameter((Object)wellKnownPaths, (String)"wellKnownPaths");
        this.scriptDeployer = scriptDeployer;
        this.wellKnownPaths = wellKnownPaths;
    }

    @Override
    @NotNull
    public AskpassService start(@NotNull AskpassHandler askpassHandler, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)askpassHandler, (String)"askpassHandler");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Path executablePath = this.scriptDeployer.getAskpassExecutableLocation();
        AskpassSocketImpl socket = new AskpassSocketImpl(askpassHandler, this.wellKnownPaths);
        Job job2 = socket.runInScope(scope2);
        return new AskpassService(executablePath, socket, job2){
            private final String askpassExecutablePath;
            private final Map<String, String> environment;
            final /* synthetic */ Job $job;
            {
                this.$job = $job;
                this.askpassExecutablePath = $executablePath.toString();
                this.environment = ToolboxAskpassEnvironmentProvider.INSTANCE.getEnvironment($socket);
            }

            public String getAskpassExecutablePath() {
                return this.askpassExecutablePath;
            }

            public Map<String, String> getEnvironment() {
                return this.environment;
            }
        };
    }
}

