/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import com.jetbrains.toolbox.openssh.SshError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface SshEvent
permits SshError, AskpassRequested, AuthenticationFailed, AuthenticationFinished, AuthenticationMethodStarted, AuthenticationStarted {

    public static final class AskpassRequested
    implements SshEvent {
        @NotNull
        public static final AskpassRequested INSTANCE = new AskpassRequested();

        private AskpassRequested() {
        }

        @NotNull
        public String toString() {
            return "AskpassRequested";
        }

        public int hashCode() {
            return 2750800;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AskpassRequested)) {
                return false;
            }
            AskpassRequested cfr_ignored_0 = (AskpassRequested)other;
            return true;
        }
    }

    public static final class AuthenticationFailed
    implements SshEvent {
        @NotNull
        public static final AuthenticationFailed INSTANCE = new AuthenticationFailed();

        private AuthenticationFailed() {
        }

        @NotNull
        public String toString() {
            return "AuthenticationFailed";
        }

        public int hashCode() {
            return 2114319265;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticationFailed)) {
                return false;
            }
            AuthenticationFailed cfr_ignored_0 = (AuthenticationFailed)other;
            return true;
        }
    }

    public static final class AuthenticationFinished
    implements SshEvent {
        @NotNull
        public static final AuthenticationFinished INSTANCE = new AuthenticationFinished();

        private AuthenticationFinished() {
        }

        @NotNull
        public String toString() {
            return "AuthenticationFinished";
        }

        public int hashCode() {
            return -1007823146;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticationFinished)) {
                return false;
            }
            AuthenticationFinished cfr_ignored_0 = (AuthenticationFinished)other;
            return true;
        }
    }

    public static final class AuthenticationMethodStarted
    implements SshEvent {
        @NotNull
        private final String method;

        public AuthenticationMethodStarted(@NotNull String method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            this.method = method;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public String toString() {
            return "AuthenticationMethodStarted(method=" + this.method + ")";
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticationMethodStarted)) {
                return false;
            }
            AuthenticationMethodStarted authenticationMethodStarted = (AuthenticationMethodStarted)other;
            return Intrinsics.areEqual((Object)this.method, (Object)authenticationMethodStarted.method);
        }
    }

    public static final class AuthenticationStarted
    implements SshEvent {
        @NotNull
        private final String host;
        @NotNull
        private final String user;

        public AuthenticationStarted(@NotNull String host, @NotNull String user) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            this.host = host;
            this.user = user;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @NotNull
        public final String getUser() {
            return this.user;
        }

        @NotNull
        public String toString() {
            return "AuthenticationStarted(host=" + this.host + ", user=" + this.user + ")";
        }

        public int hashCode() {
            int result2 = this.host.hashCode();
            result2 = result2 * 31 + this.user.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticationStarted)) {
                return false;
            }
            AuthenticationStarted authenticationStarted = (AuthenticationStarted)other;
            if (!Intrinsics.areEqual((Object)this.host, (Object)authenticationStarted.host)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.user, (Object)authenticationStarted.user);
        }
    }
}

