/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import com.jetbrains.toolbox.openssh.SshEvent;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface SshError
extends SshEvent {

    public static final class AuthenticationError
    implements SshError {
        @NotNull
        public static final AuthenticationError INSTANCE = new AuthenticationError();

        private AuthenticationError() {
        }

        @NotNull
        public String toString() {
            return "AuthenticationError";
        }

        public int hashCode() {
            return 63722130;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticationError)) {
                return false;
            }
            AuthenticationError cfr_ignored_0 = (AuthenticationError)other;
            return true;
        }
    }

    public static final class ConnectionRefused
    implements SshError {
        @NotNull
        public static final ConnectionRefused INSTANCE = new ConnectionRefused();

        private ConnectionRefused() {
        }

        @NotNull
        public String toString() {
            return "ConnectionRefused";
        }

        public int hashCode() {
            return 1564118708;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionRefused)) {
                return false;
            }
            ConnectionRefused cfr_ignored_0 = (ConnectionRefused)other;
            return true;
        }
    }

    public static final class ConnectionTimeout
    implements SshError {
        @NotNull
        public static final ConnectionTimeout INSTANCE = new ConnectionTimeout();

        private ConnectionTimeout() {
        }

        @NotNull
        public String toString() {
            return "ConnectionTimeout";
        }

        public int hashCode() {
            return -835339963;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionTimeout)) {
                return false;
            }
            ConnectionTimeout cfr_ignored_0 = (ConnectionTimeout)other;
            return true;
        }
    }

    public static final class ForwardingProhibited
    implements SshError {
        @NotNull
        public static final ForwardingProhibited INSTANCE = new ForwardingProhibited();

        private ForwardingProhibited() {
        }

        @NotNull
        public String toString() {
            return "ForwardingProhibited";
        }

        public int hashCode() {
            return -885483079;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ForwardingProhibited)) {
                return false;
            }
            ForwardingProhibited cfr_ignored_0 = (ForwardingProhibited)other;
            return true;
        }
    }

    public static final class HostKeyVerificationFailed
    implements SshError {
        @NotNull
        private final String host;

        public HostKeyVerificationFailed(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.host = host;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @NotNull
        public String toString() {
            return "HostKeyVerificationFailed(host=" + this.host + ")";
        }

        public int hashCode() {
            return this.host.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HostKeyVerificationFailed)) {
                return false;
            }
            HostKeyVerificationFailed hostKeyVerificationFailed = (HostKeyVerificationFailed)other;
            return Intrinsics.areEqual((Object)this.host, (Object)hostKeyVerificationFailed.host);
        }
    }

    public static final class HostUnreachable
    implements SshError {
        @NotNull
        public static final HostUnreachable INSTANCE = new HostUnreachable();

        private HostUnreachable() {
        }

        @NotNull
        public String toString() {
            return "HostUnreachable";
        }

        public int hashCode() {
            return -615068370;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HostUnreachable)) {
                return false;
            }
            HostUnreachable cfr_ignored_0 = (HostUnreachable)other;
            return true;
        }
    }

    public static final class InaccessibleFile
    implements SshError {
        @NotNull
        private final String type;
        @NotNull
        private final String path;
        @NotNull
        private final String reason;

        public InaccessibleFile(@NotNull String type2, @NotNull String path2, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.type = type2;
            this.path = path2;
            this.reason = reason;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public String toString() {
            return "InaccessibleFile(type=" + this.type + ", path=" + this.path + ", reason=" + this.reason + ")";
        }

        public int hashCode() {
            int result2 = this.type.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            result2 = result2 * 31 + this.reason.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InaccessibleFile)) {
                return false;
            }
            InaccessibleFile inaccessibleFile = (InaccessibleFile)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)inaccessibleFile.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)inaccessibleFile.path)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)inaccessibleFile.reason);
        }
    }

    public static final class SshAgentConflict
    implements SshError {
        @NotNull
        private final String identityAgentPath;
        @Nullable
        private final String sshAuthSock;

        public SshAgentConflict(@NotNull String identityAgentPath, @Nullable String sshAuthSock) {
            Intrinsics.checkNotNullParameter((Object)identityAgentPath, (String)"identityAgentPath");
            this.identityAgentPath = identityAgentPath;
            this.sshAuthSock = sshAuthSock;
        }

        @NotNull
        public final String getIdentityAgentPath() {
            return this.identityAgentPath;
        }

        @Nullable
        public final String getSshAuthSock() {
            return this.sshAuthSock;
        }

        @NotNull
        public String toString() {
            return "SshAgentConflict(identityAgentPath=" + this.identityAgentPath + ", sshAuthSock=" + this.sshAuthSock + ")";
        }

        public int hashCode() {
            int result2 = this.identityAgentPath.hashCode();
            result2 = result2 * 31 + (this.sshAuthSock == null ? 0 : this.sshAuthSock.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SshAgentConflict)) {
                return false;
            }
            SshAgentConflict sshAgentConflict = (SshAgentConflict)other;
            if (!Intrinsics.areEqual((Object)this.identityAgentPath, (Object)sshAgentConflict.identityAgentPath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.sshAuthSock, (Object)sshAgentConflict.sshAuthSock);
        }
    }

    public static final class TooWidePermissions
    implements SshError {
        @NotNull
        private final String keyPath;

        public TooWidePermissions(@NotNull String keyPath) {
            Intrinsics.checkNotNullParameter((Object)keyPath, (String)"keyPath");
            this.keyPath = keyPath;
        }

        @NotNull
        public final String getKeyPath() {
            return this.keyPath;
        }

        @NotNull
        public String toString() {
            return "TooWidePermissions(keyPath=" + this.keyPath + ")";
        }

        public int hashCode() {
            return this.keyPath.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TooWidePermissions)) {
                return false;
            }
            TooWidePermissions tooWidePermissions = (TooWidePermissions)other;
            return Intrinsics.areEqual((Object)this.keyPath, (Object)tooWidePermissions.keyPath);
        }
    }

    public static final class UnknownError
    implements SshError {
        private final int exitCode;
        @NotNull
        private final String stdout;
        @NotNull
        private final String stderr;

        public final int getExitCode() {
            return this.exitCode;
        }

        @NotNull
        public final String getStdout() {
            return this.stdout;
        }

        @NotNull
        public final String getStderr() {
            return this.stderr;
        }

        @NotNull
        public String toString() {
            return "UnknownError(exitCode=" + this.exitCode + ", stdout=" + this.stdout + ", stderr=" + this.stderr + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.exitCode);
            result2 = result2 * 31 + this.stdout.hashCode();
            result2 = result2 * 31 + this.stderr.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnknownError)) {
                return false;
            }
            UnknownError unknownError = (UnknownError)other;
            if (this.exitCode != unknownError.exitCode) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stdout, (Object)unknownError.stdout)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stderr, (Object)unknownError.stderr);
        }
    }

    public static final class UnresolvedHostname
    implements SshError {
        @NotNull
        private final String hostname;
        @NotNull
        private final String reason;

        public UnresolvedHostname(@NotNull String hostname, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.hostname = hostname;
            this.reason = reason;
        }

        @NotNull
        public final String getHostname() {
            return this.hostname;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public String toString() {
            return "UnresolvedHostname(hostname=" + this.hostname + ", reason=" + this.reason + ")";
        }

        public int hashCode() {
            int result2 = this.hostname.hashCode();
            result2 = result2 * 31 + this.reason.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnresolvedHostname)) {
                return false;
            }
            UnresolvedHostname unresolvedHostname = (UnresolvedHostname)other;
            if (!Intrinsics.areEqual((Object)this.hostname, (Object)unresolvedHostname.hostname)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)unresolvedHostname.reason);
        }
    }
}

