/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import com.jetbrains.toolbox.common.AvailablePortFinder;
import com.jetbrains.toolbox.openssh.AbstractOpenSshProcess;
import com.jetbrains.toolbox.openssh.AfterSshAddListener;
import com.jetbrains.toolbox.openssh.AfterSshListener;
import com.jetbrains.toolbox.openssh.BeforeSshAddListener;
import com.jetbrains.toolbox.openssh.BeforeSshListener;
import com.jetbrains.toolbox.openssh.ConnectionInfo;
import com.jetbrains.toolbox.openssh.OnAskpassRequestSshAddListener;
import com.jetbrains.toolbox.openssh.OpenSsh;
import com.jetbrains.toolbox.openssh.OpenSshAskpassRunner;
import com.jetbrains.toolbox.openssh.OpenSshCommand;
import com.jetbrains.toolbox.openssh.OpenSshDumpConfigProcessImpl;
import com.jetbrains.toolbox.openssh.OpenSshExecProcessImpl;
import com.jetbrains.toolbox.openssh.OpenSshLocalForwardingProcessImpl;
import com.jetbrains.toolbox.openssh.OpenSshProcess;
import com.jetbrains.toolbox.openssh.SshAddService;
import com.jetbrains.toolbox.openssh.SshAgentInterface;
import com.jetbrains.toolbox.openssh.SshAgentInterfaceFactory;
import com.jetbrains.toolbox.openssh.SshConfigParser;
import com.jetbrains.toolbox.openssh.SshContext;
import com.jetbrains.toolbox.openssh.SshError;
import com.jetbrains.toolbox.openssh.SshExecutableError;
import com.jetbrains.toolbox.openssh.SshExecutableValidator;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import kotlin.uuid.Uuid;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nOpenSshAskpassRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshAskpassRunner.kt\ncom/jetbrains/toolbox/openssh/OpenSshAskpassRunner\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n216#2,2:267\n37#3,2:269\n37#3,2:271\n37#3,2:279\n1374#4:273\n1460#4,5:274\n*S KotlinDebug\n*F\n+ 1 OpenSshAskpassRunner.kt\ncom/jetbrains/toolbox/openssh/OpenSshAskpassRunner\n*L\n174#1:267,2\n223#1:269,2\n237#1:271,2\n249#1:279,2\n249#1:273\n249#1:274,5\n*E\n"})
public final class OpenSshAskpassRunner
implements OpenSsh {
    @NotNull
    private final ConnectionInfo connectionInfo;
    @NotNull
    private final String sshExecutable;
    @NotNull
    private final SshExecutableValidator validator;
    @NotNull
    private final List<BeforeSshListener> beforeSshListeners;
    @NotNull
    private final List<AfterSshListener> afterSshListeners;
    @NotNull
    private final List<BeforeSshAddListener> beforeSshAddListeners;
    @NotNull
    private final List<AfterSshAddListener> afterSshAddListeners;
    @NotNull
    private final List<OnAskpassRequestSshAddListener> onAskpassRequestSshAddListeners;
    @NotNull
    private final SshAgentInterfaceFactory sshAgentInterfaceFactory;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Lazy additionalConfig$delegate;
    @NotNull
    private final String[] identityKeysPreconfiguration;
    @NotNull
    private final Deferred<String[]> identityKeysConfig;
    @NotNull
    private final Deferred<SshError.SshAgentConflict> sshAgentConflict;
    @NotNull
    private final Map<String, String> envVars;
    @NotNull
    private final Deferred<SshConfigParser> sshConfigParser;

    public OpenSshAskpassRunner(@NotNull ConnectionInfo connectionInfo, @NotNull String sshExecutable, @NotNull SshExecutableValidator validator, @NotNull List<? extends BeforeSshListener> beforeSshListeners, @NotNull List<? extends AfterSshListener> afterSshListeners, @NotNull List<? extends BeforeSshAddListener> beforeSshAddListeners, @NotNull List<? extends AfterSshAddListener> afterSshAddListeners, @NotNull List<? extends OnAskpassRequestSshAddListener> onAskpassRequestSshAddListeners, @NotNull SshAgentInterfaceFactory sshAgentInterfaceFactory, @NotNull FileSystem fileSystem, @NotNull CoroutineScope scope2) {
        String configPath;
        Intrinsics.checkNotNullParameter((Object)connectionInfo, (String)"connectionInfo");
        Intrinsics.checkNotNullParameter((Object)sshExecutable, (String)"sshExecutable");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        Intrinsics.checkNotNullParameter(beforeSshListeners, (String)"beforeSshListeners");
        Intrinsics.checkNotNullParameter(afterSshListeners, (String)"afterSshListeners");
        Intrinsics.checkNotNullParameter(beforeSshAddListeners, (String)"beforeSshAddListeners");
        Intrinsics.checkNotNullParameter(afterSshAddListeners, (String)"afterSshAddListeners");
        Intrinsics.checkNotNullParameter(onAskpassRequestSshAddListeners, (String)"onAskpassRequestSshAddListeners");
        Intrinsics.checkNotNullParameter((Object)sshAgentInterfaceFactory, (String)"sshAgentInterfaceFactory");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.connectionInfo = connectionInfo;
        this.sshExecutable = sshExecutable;
        this.validator = validator;
        this.beforeSshListeners = beforeSshListeners;
        this.afterSshListeners = afterSshListeners;
        this.beforeSshAddListeners = beforeSshAddListeners;
        this.afterSshAddListeners = afterSshAddListeners;
        this.onAskpassRequestSshAddListeners = onAskpassRequestSshAddListeners;
        this.sshAgentInterfaceFactory = sshAgentInterfaceFactory;
        this.fileSystem = fileSystem;
        this.scope = scope2;
        this.additionalConfig$delegate = LazyKt.lazy(() -> OpenSshAskpassRunner.additionalConfig_delegate$lambda$0(this));
        List list2 = this.connectionInfo.getPrivateKeyPaths();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        this.identityKeysPreconfiguration = this.generateIdentityKeys(list2);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"SSH_ASKPASS", (Object)this.connectionInfo.getAskpassExecutablePath()), TuplesKt.to((Object)"SSH_ASKPASS_REQUIRE", (Object)"force"), TuplesKt.to((Object)"DISPLAY", (Object)"1")};
        this.envVars = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), this.connectionInfo.getEnvironment());
        this.sshConfigParser = BuildersKt.async$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SshConfigParser>, Object>(this, null){
            int label;
            final /* synthetic */ OpenSshAskpassRunner this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = OpenSshAskpassRunner.access$dumpSshConfig(this.this$0, (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = (List)v0;
                        return new SshConfigParser(var2_3);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SshConfigParser> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.sshAgentConflict = BuildersKt.async$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SshError.SshAgentConflict>, Object>(this, null){
            int label;
            final /* synthetic */ OpenSshAskpassRunner this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block5: {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (!OpenSshAskpassRunner.access$getConnectionInfo$p(this.this$0).getShouldUseSystemSshAgent()) break;
                            this.label = 1;
                            v0 = OpenSshAskpassRunner.access$checkSshConfigProblems(this.this$0, (Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            v1 = (SshError.SshAgentConflict)v0;
                            break block5;
                        }
                    }
                    v1 = null;
                }
                return v1;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SshError.SshAgentConflict> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Deferred keyPaths2 = BuildersKt.async$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(this, null){
            int label;
            final /* synthetic */ OpenSshAskpassRunner this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = OpenSshAskpassRunner.access$getSshConfigParser$p(this.this$0).await((Continuation)this);
                        if (v0 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = CollectionsKt.distinct((Iterable)((SshConfigParser)v0).getIdentityFiles());
                        var3_4 = this.this$0;
                        $i$f$filter = false;
                        var5_6 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            path = (String)element$iv$iv;
                            $i$a$-filter-OpenSshAskpassRunner$keyPaths$1$1 = false;
                            if (!OpenSshAskpassRunner.access$getFileSystem$p(var3_4).exists(Path.Companion.get$default((Path.Companion)Path.Companion, (String)path, (boolean)false, (int)1, null))) {
                                Logger.INSTANCE.warn("Key at path '" + path + "' doesn't exist and will be ignored");
                                v1 = false;
                            } else {
                                v1 = true;
                            }
                            if (!v1) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        String string = configPath = this.connectionInfo.getSshConfigPath();
        if (string != null) {
            String configPath2 = string;
            boolean bl = false;
            if (!this.fileSystem.exists(Path.Companion.get$default((Path.Companion)Path.Companion, (String)configPath2, (boolean)false, (int)1, null))) {
                Logger.INSTANCE.warn("Config at path " + configPath2 + " doesn't exist");
            }
        }
        this.identityKeysConfig = BuildersKt.async$default((CoroutineScope)this.scope, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String[]>, Object>(this, (Deferred<? extends List<String>>)keyPaths2, null){
            int I$0;
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            final /* synthetic */ OpenSshAskpassRunner this$0;
            final /* synthetic */ Deferred<List<String>> $keyPaths;
            {
                this.this$0 = $receiver;
                this.$keyPaths = $keyPaths;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (System.getenv("SSH_AUTH_SOCK") != null) ** GOTO lbl-1000
                        this.label = 1;
                        v0 = OpenSshAskpassRunner.access$getSshAgentConflict$p(this.this$0).await((Continuation)this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        v1 = (SshError.SshAgentConflict)v0;
                        if ((v1 != null ? v1.getIdentityAgentPath() : null) != null || OpenSshAskpassRunner.access$getConnectionInfo$p(this.this$0).getEnvironment().get("SSH_AUTH_SOCK") != null) lbl-1000:
                        // 2 sources

                        {
                            v2 = 1;
                        } else {
                            v2 = envIsAvailable = 0;
                        }
                        if (!OpenSshAskpassRunner.access$getConnectionInfo$p(this.this$0).getShouldUseSystemSshAgent() || envIsAvailable == 0) break;
                        this.I$0 = envIsAvailable;
                        this.label = 2;
                        v3 = OpenSshAskpassRunner.access$getSshAgentConflict$p(this.this$0).await((Continuation)this);
                        if (v3 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl30
                    }
                    case 2: {
                        envIsAvailable = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl30:
                        // 2 sources

                        if ((v4 = (SshError.SshAgentConflict)v3) != null && (v4 = v4.getIdentityAgentPath()) != null) {
                            it = v4;
                            $i$a$-let-OpenSshAskpassRunner$3$sshAuthSockOverride$1 = false;
                            v5 = TuplesKt.to((Object)"SSH_AUTH_SOCK", (Object)it);
                        } else {
                            v5 = null;
                        }
                        sshAuthSockOverride = v5;
                        sshAddEnvVars = MapsKt.plus((Map)OpenSshAskpassRunner.access$getEnvVars$p(this.this$0), (Map)MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull(sshAuthSockOverride)));
                        sshAgentInterface = OpenSshAskpassRunner.access$getSshAgentInterfaceFactory$p(this.this$0).create(sshAddEnvVars, OpenSshAskpassRunner.access$getOnAskpassRequestSshAddListeners$p(this.this$0), OpenSshAskpassRunner.access$getScope$p(this.this$0));
                        var9_16 = sshAddService = new SshAddService(sshAgentInterface, OpenSshAskpassRunner.access$getBeforeSshAddListeners$p(this.this$0), OpenSshAskpassRunner.access$getAfterSshAddListeners$p(this.this$0));
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)sshAuthSockOverride);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)sshAddEnvVars);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)sshAgentInterface);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)sshAddService);
                        this.L$4 = var9_16;
                        this.I$0 = envIsAvailable;
                        this.label = 3;
                        v6 = this.$keyPaths.await((Continuation)this);
                        if (v6 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl60
                    }
                    case 3: {
                        envIsAvailable = this.I$0;
                        var9_16 = (SshAddService)this.L$4;
                        sshAddService = (SshAddService)this.L$3;
                        sshAgentInterface = (SshAgentInterface)this.L$2;
                        sshAddEnvVars = (Map)this.L$1;
                        sshAuthSockOverride = (Pair)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl60:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)sshAuthSockOverride);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)sshAddEnvVars);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)sshAgentInterface);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)sshAddService);
                        this.L$4 = null;
                        this.I$0 = envIsAvailable;
                        this.label = 4;
                        v7 = var9_16.addKeysToAgent((List)v6, (Continuation<? super List<String>>)((Continuation)this));
                        if (v7 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl79
                    }
                    case 4: {
                        envIsAvailable = this.I$0;
                        sshAddService = (SshAddService)this.L$3;
                        sshAgentInterface = (SshAgentInterface)this.L$2;
                        sshAddEnvVars = (Map)this.L$1;
                        sshAuthSockOverride = (Pair)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl79:
                        // 2 sources

                        leftover = (List)v7;
                        v8 = OpenSshAskpassRunner.access$generateIdentityKeys(this.this$0, leftover);
                        ** GOTO lbl97
                    }
                }
                Logger.INSTANCE.info("The connection is set not to use ssh-agent.");
                var9_17 = this.this$0;
                this.L$0 = var9_17;
                this.I$0 = envIsAvailable;
                this.label = 5;
                v9 = this.$keyPaths.await((Continuation)this);
                if (v9 == var10_2) {
                    return var10_2;
                }
                ** GOTO lbl96
                {
                    case 5: {
                        envIsAvailable = this.I$0;
                        var9_17 = (OpenSshAskpassRunner)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl96:
                        // 2 sources

                        v8 = OpenSshAskpassRunner.access$generateIdentityKeys(var9_17, (List)v9);
lbl97:
                        // 2 sources

                        return v8;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.logEnvVars();
    }

    private final String[] getAdditionalConfig() {
        Lazy lazy = this.additionalConfig$delegate;
        return (String[])lazy.getValue();
    }

    /*
     * Unable to fully structure code
     */
    private final Object checkSshConfigProblems(Continuation<? super SshError.SshAgentConflict> $completion) {
        if (!($completion instanceof checkSshConfigProblems.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ OpenSshAskpassRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSshAskpassRunner.access$checkSshConfigProblems(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.sshConfigParser.await((Continuation)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                identityAgentOverride = ((SshConfigParser)v0).getIdentityAgent();
                sshAuthSock = System.getenv("SSH_AUTH_SOCK");
                if (sshAuthSock != null && identityAgentOverride != null && !Intrinsics.areEqual((Object)identityAgentOverride, (Object)sshAuthSock)) {
                    Logger.INSTANCE.warn(StringsKt.trimMargin$default((String)("\n        |Detected a conflict in ssh-agent configuration for '" + this.toUsernameHostString(this.connectionInfo) + "'\n        |SSH uses IdentityAgent at path: '" + identityAgentOverride + "'\n        |SSH_AUTH_SOCK is set to: '" + sshAuthSock + "'\n        |Will set SSH_AUTH_SOCK to IdentityAgent path\n        "), null, (int)1, null));
                    v1 = new SshError.SshAgentConflict(identityAgentOverride, sshAuthSock);
                } else {
                    v1 = null;
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object dumpSshConfig(Continuation<? super List<String>> $completion) {
        block15: {
            if (!($completion instanceof dumpSshConfig.1)) ** GOTO lbl-1000
            var9_2 = $completion;
            if ((var9_2.label & -2147483648) != 0) {
                var9_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ OpenSshAskpassRunner this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return OpenSshAskpassRunner.access$dumpSshConfig(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = this.createProcess(OpenSshCommand.DumpConfig.INSTANCE, (Continuation<? super OpenSshProcess>)$continuation);
                    if (v0 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    dumpConfigProcess = (OpenSshProcess)v0;
                    $continuation.L$0 = dumpConfigProcess;
                    $continuation.label = 2;
                    v1 = dumpConfigProcess.start((Continuation<? super Unit>)$continuation);
                    if (v1 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl31
                }
                case 2: {
                    dumpConfigProcess = (OpenSshProcess)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl31:
                    // 2 sources

                    output = BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(dumpConfigProcess, null){
                        int label;
                        final /* synthetic */ OpenSshProcess $dumpConfigProcess;
                        {
                            this.$dumpConfigProcess = $dumpConfigProcess;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    v0 = this.$dumpConfigProcess.getOutput((Continuation<? super Flow<String>>)((Continuation)this));
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    this.label = 2;
                                    v1 = FlowKt.toList$default((Flow)((Flow)v0), null, (Continuation)((Continuation)this), (int)1, null);
                                    if (v1 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl21
                                }
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl21:
                                    // 2 sources

                                    return v1;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    error = BuildersKt.async$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends String>>, Object>(dumpConfigProcess, null){
                        int label;
                        final /* synthetic */ OpenSshProcess $dumpConfigProcess;
                        {
                            this.$dumpConfigProcess = $dumpConfigProcess;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    v0 = this.$dumpConfigProcess.getErrorOutput((Continuation<? super Flow<String>>)((Continuation)this));
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    this.label = 2;
                                    v1 = FlowKt.toList$default((Flow)((Flow)v0), null, (Continuation)((Continuation)this), (int)1, null);
                                    if (v1 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl21
                                }
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl21:
                                    // 2 sources

                                    return v1;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super List<String>> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)dumpConfigProcess);
                    $continuation.L$1 = output;
                    $continuation.L$2 = error;
                    $continuation.label = 3;
                    v2 = dumpConfigProcess.awaitFinished((Continuation<? super Integer>)$continuation);
                    if (v2 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl47
                }
                case 3: {
                    error = (Deferred)$continuation.L$2;
                    output = (Deferred)$continuation.L$1;
                    dumpConfigProcess = (OpenSshProcess)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl47:
                    // 2 sources

                    exitCode = ((Number)v2).intValue();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)dumpConfigProcess);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)output);
                    $continuation.L$2 = error;
                    $continuation.I$0 = exitCode;
                    $continuation.label = 4;
                    v3 = output.await((Continuation)$continuation);
                    if (v3 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl64
                }
                case 4: {
                    exitCode = $continuation.I$0;
                    error = (Deferred)$continuation.L$2;
                    output = (Deferred)$continuation.L$1;
                    dumpConfigProcess = (OpenSshProcess)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl64:
                    // 2 sources

                    outputLines = (List)v3;
                    if (exitCode == 0) break;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)dumpConfigProcess);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)output);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)error);
                    $continuation.L$3 = outputLines;
                    $continuation.I$0 = exitCode;
                    $continuation.label = 5;
                    v4 = error.await((Continuation)$continuation);
                    if (v4 == var10_4) {
                        return var10_4;
                    }
                    ** GOTO lbl84
                }
                case 5: {
                    exitCode = $continuation.I$0;
                    outputLines = (List)$continuation.L$3;
                    error = (Deferred)$continuation.L$2;
                    output = (Deferred)$continuation.L$1;
                    dumpConfigProcess = (OpenSshProcess)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl84:
                    // 2 sources

                    errorLines = (List)v4;
                    Logger.INSTANCE.warn(StringsKt.trimMargin$default((String)("\n        |SSH configuration dump for '" + this.toUsernameHostString(this.connectionInfo) + "' finished with non-zero exit code: " + exitCode + "\n        |Error output:\n        |" + CollectionsKt.joinToString$default((Iterable)errorLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n        |Output:" + CollectionsKt.joinToString$default((Iterable)outputLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n        "), null, (int)1, null));
                    v5 = CollectionsKt.emptyList();
                    break block15;
                }
            }
            v5 = outputLines;
        }
        return v5;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String getSshExecutable() {
        String sshPath;
        String string = this.connectionInfo.getSshExecutablePath();
        if (string == null) {
            string = this.sshExecutable;
        }
        if (this.validator.validate(sshPath = string) instanceof SshExecutableValidator.Result.Failure) {
            throw new SshExecutableError(sshPath);
        }
        return sshPath;
    }

    /*
     * Unable to fully structure code
     */
    private final Object constructSshConfigDumpCommand(Continuation<? super String[]> $completion) {
        if (!($completion instanceof constructSshConfigDumpCommand.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ OpenSshAskpassRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSshAskpassRunner.access$constructSshConfigDumpCommand(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                sshPath = this.getSshExecutable();
                var3_7 = new String[]{sshPath};
                v0 = var3_7;
                var3_7 = new String[]{"-G"};
                var4_8 = ArraysKt.plus((Object[])v0, (Object[])var3_7);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)sshPath);
                $continuation.L$1 = var4_8;
                $continuation.label = 1;
                v1 = this.generateConnectionArgs(true, (Continuation<? super String[]>)$continuation);
                if (v1 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl29
            }
            case 1: {
                var4_8 = (Object[])$continuation.L$1;
                sshPath = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                return ArraysKt.plus((Object[])var4_8, (Object[])((Object[])v1));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object constructExecuteCommand(OpenSshCommand.Execute command, Integer dynamicPortForwardingPort, Continuation<? super String[]> $completion) {
        if (!($completion instanceof constructExecuteCommand.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ OpenSshAskpassRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSshAskpassRunner.access$constructExecuteCommand(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                sshPath = this.getSshExecutable();
                $continuation.L$0 = command;
                $continuation.L$1 = dynamicPortForwardingPort;
                $continuation.L$2 = sshPath;
                $continuation.label = 1;
                v0 = this.generateSshArgs(command.getAllocatePty(), (Continuation<? super String[]>)$continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                sshPath = (String)$continuation.L$2;
                dynamicPortForwardingPort = (Integer)$continuation.L$1;
                command = (OpenSshCommand.Execute)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                args = (String[])v0;
                if (dynamicPortForwardingPort != null) {
                    var7_9 = new String[]{"-D", String.valueOf(dynamicPortForwardingPort)};
                    v1 = var7_9;
                } else {
                    v1 = new String[]{};
                }
                dynamicForwardingArgs = v1;
                var7_9 = new String[]{sshPath};
                return ArraysKt.plus((Object[])ArraysKt.plus((Object[])ArraysKt.plus((Object[])var7_9, (Object[])dynamicForwardingArgs), (Object[])args), (Object)CollectionsKt.joinToString$default((Iterable)command.getCommand(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object constructPortForwardingCommand(OpenSshCommand.ForwardLocalPort command, Continuation<? super String[]> $completion) {
        if (!($completion instanceof constructPortForwardingCommand.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ OpenSshAskpassRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSshAskpassRunner.access$constructPortForwardingCommand(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = new String[]{"-L", command.getLocalAddress().getHostAddress() + ":" + command.getLocalPort() + ":" + command.getRemoteLocalAddress().getHostAddress() + ":" + command.getRemotePort(), "-N"};
                args = var4_6;
                sshPath = this.getSshExecutable();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)command);
                $continuation.L$1 = args;
                $continuation.L$2 = sshPath;
                $continuation.label = 1;
                v0 = this.generateSshArgs(true, (Continuation<? super String[]>)$continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                sshPath = (String)$continuation.L$2;
                args = (String[])$continuation.L$1;
                command = (OpenSshCommand.ForwardLocalPort)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                sshArgs = (String[])v0;
                var6_9 = new String[]{sshPath};
                return ArraysKt.plus((Object[])ArraysKt.plus((Object[])var6_9, (Object[])args), (Object[])sshArgs);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void setEnv(ProcessBuilder $this$setEnv, Map<String, String> environment) {
        Map<String, String> map2 = $this$setEnv.environment();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"environment(...)");
        Map<String, String> map3 = map2;
        map3.putAll(this.envVars);
        Map<String, String> map4 = $this$setEnv.environment();
        Intrinsics.checkNotNullExpressionValue(map4, (String)"environment(...)");
        map4.putAll(environment);
    }

    private final void logEnvVars() {
        if (this.envVars.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder("Printing environment variables:");
        Map<String, String> $this$forEach$iv = this.envVars;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator2.next();
            boolean bl = false;
            builder.append(it.getKey() + ": " + it.getValue()).append('\n');
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Logger.INSTANCE.info(string);
    }

    @Override
    @Nullable
    public Object createProcess(@NotNull OpenSshCommand command2, @NotNull Continuation<? super OpenSshProcess> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AbstractOpenSshProcess>, Object>(command2, this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ OpenSshCommand $command;
            final /* synthetic */ OpenSshAskpassRunner this$0;
            {
                this.$command = $command;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block17: {
                    block18: {
                        block16: {
                            block15: {
                                var26_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        if (!(this.$command instanceof OpenSshCommand.Execute) || !((OpenSshCommand.Execute)this.$command).getWithDynamicProxy()) break;
                                        v0 = InetAddress.getLoopbackAddress();
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getLoopbackAddress(...)");
                                        this.label = 1;
                                        v1 = AvailablePortFinder.INSTANCE.getNextAvailable(v0, 8000, 65535, (Continuation<? super AvailablePortFinder.Port>)((Continuation)this));
                                        if (v1 == var26_2) {
                                            return var26_2;
                                        }
                                        ** GOTO lbl16
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl16:
                                        // 2 sources

                                        v2 = (AvailablePortFinder.Port)v1;
                                        break block15;
                                    }
                                }
                                v2 = null;
                            }
                            v3 = dynamicForwardingPort = v2;
                            this.L$0 = dynamicForwardingPort;
                            this.label = 2;
                            v4 = OpenSshAskpassRunner.access$constructCommand(this.this$0, this.$command, v3 != null ? Boxing.boxInt((int)v3.getPort()) : null, (Continuation)this);
                            if (v4 == var26_2) {
                                return var26_2;
                            }
                            ** GOTO lbl31
                            {
                                case 2: {
                                    dynamicForwardingPort = (AvailablePortFinder.Port)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v4 = $result;
lbl31:
                                    // 2 sources

                                    cmd = (String[])v4;
                                    Logger.INSTANCE.info("Executing command " + ArraysKt.joinToString$default((Object[])cmd, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                                    context = new SshContext(){
                                        private final String id;
                                        private final Map<String, String> environment;
                                        {
                                            this.id = Uuid.Companion.random().toString();
                                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"TB_ASKPASS_SESSION_ID", (Object)this.getId())};
                                            this.environment = MapsKt.mutableMapOf((Pair[])pairArray);
                                        }

                                        public String getId() {
                                            return this.id;
                                        }

                                        public Map<String, String> getEnvironment() {
                                            return this.environment;
                                        }
                                    };
                                    $this$forEach$iv = OpenSshAskpassRunner.access$getBeforeSshListeners$p(this.this$0);
                                    $i$f$forEach = 0;
                                    var7_9 = $this$forEach$iv.iterator();
lbl37:
                                    // 3 sources

                                    while (var7_9.hasNext()) {
                                        element$iv = var7_9.next();
                                        it = (BeforeSshListener)element$iv;
                                        $i$a$-forEach-OpenSshAskpassRunner$createProcess$2$1 = 0;
                                        this.L$0 = dynamicForwardingPort;
                                        this.L$1 = cmd;
                                        this.L$2 = context;
                                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                                        this.L$4 = var7_9;
                                        this.L$5 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                                        this.L$6 = SpillingKt.nullOutSpilledVariable((Object)it);
                                        this.I$0 = $i$f$forEach;
                                        this.I$1 = $i$a$-forEach-OpenSshAskpassRunner$createProcess$2$1;
                                        this.label = 3;
                                        v5 = it.beforeSsh(context, (Continuation<? super Unit>)this);
                                        if (v5 != var26_2) continue;
                                        return var26_2;
                                    }
                                    break;
                                }
                                case 3: {
                                    $i$a$-forEach-OpenSshAskpassRunner$createProcess$2$1 = this.I$1;
                                    $i$f$forEach = this.I$0;
                                    it = (BeforeSshListener)this.L$6;
                                    element$iv = this.L$5;
                                    var7_9 = (Iterator<T>)this.L$4;
                                    $this$forEach$iv = (Iterable)this.L$3;
                                    context = this.L$2;
                                    cmd = (String[])this.L$1;
                                    dynamicForwardingPort = (AvailablePortFinder.Port)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v5 = $result;
                                    ** GOTO lbl37
                                }
                            }
                            builder = new ProcessBuilder(new String[0]).redirectErrorStream(this.$command.getRedirectStderr()).command((String[])Arrays.copyOf(cmd, cmd.length));
                            Intrinsics.checkNotNull((Object)builder);
                            OpenSshAskpassRunner.access$setEnv(this.this$0, builder, context.getEnvironment());
                            var7_9 = this.$command;
                            if (!(var7_9 instanceof OpenSshCommand.Execute)) break block16;
                            var13_13 = builder;
                            var12_14 = cmd;
                            var11_15 = context.getId();
                            this.L$0 = dynamicForwardingPort;
                            this.L$1 = SpillingKt.nullOutSpilledVariable((Object)cmd);
                            this.L$2 = context;
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)builder);
                            this.L$4 = var11_15;
                            this.L$5 = var12_14;
                            this.L$6 = var13_13;
                            this.label = 4;
                            v6 = OpenSshAskpassRunner.access$getSshAgentConflict$p(this.this$0).await((Continuation)this);
                            if (v6 == var26_2) {
                                return var26_2;
                            }
                            ** GOTO lbl98
                            {
                                case 4: {
                                    var13_13 = (ProcessBuilder)this.L$6;
                                    var12_14 = (String[])this.L$5;
                                    var11_15 = (String)this.L$4;
                                    builder = (ProcessBuilder)this.L$3;
                                    context = this.L$2;
                                    cmd = (String[])this.L$1;
                                    dynamicForwardingPort = (AvailablePortFinder.Port)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v6 = $result;
lbl98:
                                    // 2 sources

                                    var14_16 = v6;
                                    v7 = dynamicForwardingPort;
                                    var15_17 = OpenSshAskpassRunner.access$getScope$p(this.this$0);
                                    var16_18 = v7 != null ? Boxing.boxInt((int)v7.getPort()) : null;
                                    var17_19 = (SshError.SshAgentConflict)var14_16;
                                    var18_20 = var13_13;
                                    var19_21 = var12_14;
                                    var20_22 = var11_15;
                                    v8 = new OpenSshExecProcessImpl(var20_22, var19_21, var18_20, var17_19, var16_18, var15_17);
                                    break block17;
                                }
                            }
                        }
                        if (!(var7_9 instanceof OpenSshCommand.ForwardLocalPort)) break block18;
                        var13_13 = builder;
                        var12_14 = cmd;
                        var11_15 = context.getId();
                        this.L$0 = dynamicForwardingPort;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)cmd);
                        this.L$2 = context;
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)builder);
                        this.L$4 = var11_15;
                        this.L$5 = var12_14;
                        this.L$6 = var13_13;
                        this.label = 5;
                        v9 = OpenSshAskpassRunner.access$getSshAgentConflict$p(this.this$0).await((Continuation)this);
                        if (v9 == var26_2) {
                            return var26_2;
                        }
                        ** GOTO lbl135
                        {
                            case 5: {
                                var13_13 = (ProcessBuilder)this.L$6;
                                var12_14 = (String[])this.L$5;
                                var11_15 = (String)this.L$4;
                                builder = (ProcessBuilder)this.L$3;
                                context = this.L$2;
                                cmd = (String[])this.L$1;
                                dynamicForwardingPort = (AvailablePortFinder.Port)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v9 = $result;
lbl135:
                                // 2 sources

                                var14_16 = v9;
                                var21_23 = OpenSshAskpassRunner.access$getScope$p(this.this$0);
                                var22_24 = (SshError.SshAgentConflict)var14_16;
                                var23_25 = var13_13;
                                var24_26 = var12_14;
                                var25_27 = var11_15;
                                v8 = new OpenSshLocalForwardingProcessImpl(var25_27, var24_26, var23_25, var22_24, var21_23);
                                break block17;
                            }
                        }
                    }
                    if (var7_9 instanceof OpenSshCommand.DumpConfig) {
                        v8 = new OpenSshDumpConfigProcessImpl(context.getId(), (String[])cmd, builder, OpenSshAskpassRunner.access$getScope$p(this.this$0));
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                process = v8;
                BuildersKt.launch$default((CoroutineScope)OpenSshAskpassRunner.access$getScope$p(this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process, dynamicForwardingPort, this.this$0, context, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    int I$0;
                    int I$1;
                    int label;
                    final /* synthetic */ AbstractOpenSshProcess $process;
                    final /* synthetic */ AvailablePortFinder.Port $dynamicForwardingPort;
                    final /* synthetic */ OpenSshAskpassRunner this$0;
                    final /* synthetic */ createProcess.context.1 $context;
                    {
                        this.$process = $process;
                        this.$dynamicForwardingPort = $dynamicForwardingPort;
                        this.this$0 = $receiver;
                        this.$context = $context;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        block17: {
                            block16: {
                                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = this.$process.awaitFinished((Continuation<? super Integer>)((Continuation)this));
                                        ** if (v0 != var10_2) goto lbl11
lbl10:
                                        // 1 sources

                                        return var10_2;
lbl11:
                                        // 1 sources

                                        ** GOTO lbl17
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl17:
                                        // 2 sources

                                        ((Number)v0).intValue();
                                        v1 = this.$dynamicForwardingPort;
                                        if (v1 == null) break;
                                        this.label = 2;
                                        v2 = v1.release((Continuation<? super Unit>)((Continuation)this));
                                        if (v2 == var10_2) {
                                            return var10_2;
                                        }
                                        break;
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
                                        break;
                                    }
                                }
                                var2_3 = OpenSshAskpassRunner.access$getAfterSshListeners$p(this.this$0);
                                var3_6 = this.$context;
                                $i$f$forEach = 0;
                                var5_10 = $this$forEach$iv.iterator();
lbl34:
                                // 3 sources

                                while (var5_10.hasNext()) {
                                    element$iv = var5_10.next();
                                    it = (AfterSshListener)element$iv;
                                    $i$a$-forEach-OpenSshAskpassRunner$createProcess$2$2$1 = 0;
                                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                                    this.L$1 = var3_6;
                                    this.L$2 = var5_10;
                                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                                    this.L$4 = SpillingKt.nullOutSpilledVariable((Object)it);
                                    this.I$0 = $i$f$forEach;
                                    this.I$1 = $i$a$-forEach-OpenSshAskpassRunner$createProcess$2$2$1;
                                    this.label = 3;
                                    v3 = it.afterSsh(var3_6, (Continuation<? super Unit>)this);
                                    if (v3 != var10_2) continue;
                                    return var10_2;
                                }
                                {
                                    break block17;
                                    case 3: {
                                        $i$a$-forEach-OpenSshAskpassRunner$createProcess$2$2$1 = this.I$1;
                                        $i$f$forEach = this.I$0;
                                        it = (AfterSshListener)this.L$4;
                                        element$iv = this.L$3;
                                        var5_10 = (Iterator<T>)this.L$2;
                                        var3_6 = this.L$1;
                                        $this$forEach$iv = (Iterable)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v3 = $result;
                                        ** GOTO lbl34
                                    }
                                }
                                catch (Throwable var2_4) {
                                    v4 = this.$dynamicForwardingPort;
                                    if (v4 == null) break block16;
                                    this.L$0 = var2_4;
                                    this.label = 4;
                                    v5 = v4.release((Continuation<? super Unit>)((Continuation)this));
                                    if (v5 == var10_2) {
                                        return var10_2;
                                    }
                                    break block16;
                                }
                                {
                                    case 4: {
                                        var2_5 = (Throwable)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v5 = $result;
                                        break;
                                    }
                                }
                            }
                            var3_7 = OpenSshAskpassRunner.access$getAfterSshListeners$p(this.this$0);
                            var4_9 = this.$context;
                            $i$f$forEach = 0;
                            var6_13 = $this$forEach$iv.iterator();
lbl80:
                            // 3 sources

                            while (var6_13.hasNext()) {
                                element$iv = var6_13.next();
                                it = (AfterSshListener)element$iv;
                                $i$a$-forEach-OpenSshAskpassRunner$createProcess$2$2$1 = 0;
                                this.L$0 = var2_5;
                                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                                this.L$2 = var4_9;
                                this.L$3 = var6_13;
                                this.L$4 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                                this.L$5 = SpillingKt.nullOutSpilledVariable((Object)it);
                                this.I$0 = $i$f$forEach;
                                this.I$1 = $i$a$-forEach-OpenSshAskpassRunner$createProcess$2$2$1;
                                this.label = 5;
                                v6 = it.afterSsh(var4_9, (Continuation<? super Unit>)this);
                                if (v6 != var10_2) continue;
                                return var10_2;
                            }
                            {
                                break;
                                case 5: {
                                    $i$a$-forEach-OpenSshAskpassRunner$createProcess$2$2$1 = this.I$1;
                                    $i$f$forEach = this.I$0;
                                    it = (AfterSshListener)this.L$5;
                                    element$iv = this.L$4;
                                    var6_13 = (Iterator<T>)this.L$3;
                                    var4_9 = this.L$2;
                                    $this$forEach$iv = (Iterable)this.L$1;
                                    var2_5 = (Throwable)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v6 = $result;
                                    ** GOTO lbl80
                                }
                            }
                            throw var2_5;
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return process;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super AbstractOpenSshProcess> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Object constructCommand(OpenSshCommand command2, Integer dynamicPortForwardingPort, Continuation<? super String[]> $completion) {
        OpenSshCommand openSshCommand = command2;
        if (openSshCommand instanceof OpenSshCommand.Execute) {
            return this.constructExecuteCommand((OpenSshCommand.Execute)command2, dynamicPortForwardingPort, $completion);
        }
        if (openSshCommand instanceof OpenSshCommand.ForwardLocalPort) {
            return this.constructPortForwardingCommand((OpenSshCommand.ForwardLocalPort)command2, $completion);
        }
        if (openSshCommand instanceof OpenSshCommand.DumpConfig) {
            return this.constructSshConfigDumpCommand($completion);
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * Unable to fully structure code
     */
    private final Object generateConnectionArgs(boolean preconfiguration, Continuation<? super String[]> $completion) {
        if (!($completion instanceof generateConnectionArgs.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ OpenSshAskpassRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSshAskpassRunner.access$generateConnectionArgs(this.this$0, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.toPortOption(this.connectionInfo, "-p");
                if (v0 == null) {
                    v0 = new String[]{};
                }
                var3_6 = new SpreadBuilder(3);
                var3_6.addSpread((Object)this.getAdditionalConfig());
                v1 = var3_6;
                if (!preconfiguration) ** GOTO lbl21
                v2 = this.identityKeysPreconfiguration;
                ** GOTO lbl43
lbl21:
                // 1 sources

                var7_7 = v1;
                var6_8 = v0;
                $continuation.L$0 = var3_6;
                $continuation.L$1 = var6_8;
                $continuation.L$2 = var7_7;
                $continuation.Z$0 = preconfiguration;
                $continuation.label = 1;
                v3 = this.identityKeysConfig.await((Continuation)$continuation);
                if (v3 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl39
            }
            case 1: {
                preconfiguration = $continuation.Z$0;
                var7_7 = (SpreadBuilder)$continuation.L$2;
                var6_8 = (String[])$continuation.L$1;
                var3_6 = (SpreadBuilder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl39:
                // 2 sources

                var8_9 = v3;
                v0 = var6_8;
                v1 = var7_7;
                v2 = (String[])var8_9;
lbl43:
                // 2 sources

                v1.addSpread((Object)v2);
                var3_6.add((Object)this.toUsernameHostString(this.connectionInfo));
                $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])var3_6.toArray((Object[])new String[var3_6.size()]));
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                return ArraysKt.plus((Object[])v0, (Object[])thisCollection$iv.toArray(new String[0]));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object generateConnectionArgs$default(OpenSshAskpassRunner openSshAskpassRunner, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return openSshAskpassRunner.generateConnectionArgs(bl, (Continuation<? super String[]>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object generateSshArgs(boolean allocatePty, Continuation<? super String[]> $completion) {
        if (!($completion instanceof generateSshArgs.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ OpenSshAskpassRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return OpenSshAskpassRunner.access$generateSshArgs(this.this$0, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = new String[]{allocatePty != false ? "-tt" : "-T", "-vv", "-o", "EscapeChar=none", "-C"};
                $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object[])var3_6);
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                $continuation.L$0 = var6_9 = thisCollection$iv.toArray(new String[0]);
                $continuation.Z$0 = allocatePty;
                $continuation.label = 1;
                v0 = OpenSshAskpassRunner.generateConnectionArgs$default(this, false, (Continuation)$continuation, 1, null);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                allocatePty = $continuation.Z$0;
                var6_9 = (Object[])$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                return ArraysKt.plus((Object[])var6_9, (Object[])((Object[])v0));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String[] generateAdditionalConfigArg() {
        String[] stringArray;
        if (this.connectionInfo.getSshConfigPath() != null) {
            String[] stringArray2 = new String[]{"-F", String.valueOf(this.connectionInfo.getSshConfigPath())};
            stringArray = stringArray2;
        } else if (!this.connectionInfo.getShouldUseSystemConfiguration()) {
            String[] stringArray3 = new String[]{"-F", "none"};
            stringArray = stringArray3;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private final String[] generateIdentityKeys(List<String> paths) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = paths;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{"-i", it};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private final String toUsernameHostString(ConnectionInfo $this$toUsernameHostString) {
        return $this$toUsernameHostString.getUserName() != null ? $this$toUsernameHostString.getUserName() + "@" + $this$toUsernameHostString.getHost() : $this$toUsernameHostString.getHost();
    }

    private final String[] toPortOption(ConnectionInfo $this$toPortOption, String optionPrefix) {
        String[] stringArray;
        if ($this$toPortOption.getPort() != null) {
            String[] stringArray2 = new String[]{optionPrefix, String.valueOf($this$toPortOption.getPort())};
            stringArray = stringArray2;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private static final String[] additionalConfig_delegate$lambda$0(OpenSshAskpassRunner this$0) {
        return this$0.generateAdditionalConfigArg();
    }

    public static final /* synthetic */ Object access$checkSshConfigProblems(OpenSshAskpassRunner $this, Continuation $completion) {
        return $this.checkSshConfigProblems((Continuation<? super SshError.SshAgentConflict>)$completion);
    }

    public static final /* synthetic */ Object access$dumpSshConfig(OpenSshAskpassRunner $this, Continuation $completion) {
        return $this.dumpSshConfig((Continuation<? super List<String>>)$completion);
    }

    public static final /* synthetic */ Object access$constructSshConfigDumpCommand(OpenSshAskpassRunner $this, Continuation $completion) {
        return $this.constructSshConfigDumpCommand((Continuation<? super String[]>)$completion);
    }

    public static final /* synthetic */ Object access$constructExecuteCommand(OpenSshAskpassRunner $this, OpenSshCommand.Execute command2, Integer dynamicPortForwardingPort, Continuation $completion) {
        return $this.constructExecuteCommand(command2, dynamicPortForwardingPort, (Continuation<? super String[]>)$completion);
    }

    public static final /* synthetic */ Object access$constructPortForwardingCommand(OpenSshAskpassRunner $this, OpenSshCommand.ForwardLocalPort command2, Continuation $completion) {
        return $this.constructPortForwardingCommand(command2, (Continuation<? super String[]>)$completion);
    }

    public static final /* synthetic */ Object access$constructCommand(OpenSshAskpassRunner $this, OpenSshCommand command2, Integer dynamicPortForwardingPort, Continuation $completion) {
        return $this.constructCommand(command2, dynamicPortForwardingPort, (Continuation<? super String[]>)$completion);
    }

    public static final /* synthetic */ List access$getBeforeSshListeners$p(OpenSshAskpassRunner $this) {
        return $this.beforeSshListeners;
    }

    public static final /* synthetic */ void access$setEnv(OpenSshAskpassRunner $this, ProcessBuilder $receiver, Map environment) {
        $this.setEnv($receiver, environment);
    }

    public static final /* synthetic */ Deferred access$getSshAgentConflict$p(OpenSshAskpassRunner $this) {
        return $this.sshAgentConflict;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(OpenSshAskpassRunner $this) {
        return $this.scope;
    }

    public static final /* synthetic */ List access$getAfterSshListeners$p(OpenSshAskpassRunner $this) {
        return $this.afterSshListeners;
    }

    public static final /* synthetic */ Object access$generateConnectionArgs(OpenSshAskpassRunner $this, boolean preconfiguration, Continuation $completion) {
        return $this.generateConnectionArgs(preconfiguration, (Continuation<? super String[]>)$completion);
    }

    public static final /* synthetic */ Object access$generateSshArgs(OpenSshAskpassRunner $this, boolean allocatePty, Continuation $completion) {
        return $this.generateSshArgs(allocatePty, (Continuation<? super String[]>)$completion);
    }

    public static final /* synthetic */ ConnectionInfo access$getConnectionInfo$p(OpenSshAskpassRunner $this) {
        return $this.connectionInfo;
    }

    public static final /* synthetic */ Deferred access$getSshConfigParser$p(OpenSshAskpassRunner $this) {
        return $this.sshConfigParser;
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(OpenSshAskpassRunner $this) {
        return $this.fileSystem;
    }

    public static final /* synthetic */ Map access$getEnvVars$p(OpenSshAskpassRunner $this) {
        return $this.envVars;
    }

    public static final /* synthetic */ SshAgentInterfaceFactory access$getSshAgentInterfaceFactory$p(OpenSshAskpassRunner $this) {
        return $this.sshAgentInterfaceFactory;
    }

    public static final /* synthetic */ List access$getOnAskpassRequestSshAddListeners$p(OpenSshAskpassRunner $this) {
        return $this.onAskpassRequestSshAddListeners;
    }

    public static final /* synthetic */ List access$getBeforeSshAddListeners$p(OpenSshAskpassRunner $this) {
        return $this.beforeSshAddListeners;
    }

    public static final /* synthetic */ List access$getAfterSshAddListeners$p(OpenSshAskpassRunner $this) {
        return $this.afterSshAddListeners;
    }

    public static final /* synthetic */ String[] access$generateIdentityKeys(OpenSshAskpassRunner $this, List paths) {
        return $this.generateIdentityKeys(paths);
    }
}

