/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.openssh;

import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.openssh.CommonOpenSshPathsProvider;
import com.jetbrains.toolbox.openssh.CommonOpenSshPathsProviderImplKt;
import com.jetbrains.toolbox.openssh.SshExecutable;
import com.jetbrains.toolbox.openssh.SshExecutableType;
import com.jetbrains.toolbox.openssh.SshExecutableValidator;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nCommonOpenSshPathsProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonOpenSshPathsProviderImpl.kt\ncom/jetbrains/toolbox/openssh/CommonOpenSshPathsProviderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n295#2,2:79\n295#2,2:81\n1563#2:83\n1634#2,3:84\n1617#2,9:87\n1869#2:96\n1870#2:98\n1626#2:99\n1#3:97\n1#3:100\n*S KotlinDebug\n*F\n+ 1 CommonOpenSshPathsProviderImpl.kt\ncom/jetbrains/toolbox/openssh/CommonOpenSshPathsProviderImpl\n*L\n48#1:79,2\n49#1:81,2\n37#1:83\n37#1:84,3\n38#1:87,9\n38#1:96\n38#1:98\n38#1:99\n38#1:97\n*E\n"})
public final class CommonOpenSshPathsProviderImpl
implements CommonOpenSshPathsProvider {
    @NotNull
    private final SshExecutableValidator validator;
    @NotNull
    private final List<Path> commonLocations;
    @NotNull
    private final String sshOnPath;
    @NotNull
    private final List<SshExecutable> availablePaths;
    @Nullable
    private final SshExecutable defaultRecommendedExecutable;

    /*
     * WARNING - void declaration
     */
    public CommonOpenSshPathsProviderImpl(@NotNull SshExecutableValidator validator) {
        Object v2;
        CommonOpenSshPathsProviderImpl commonOpenSshPathsProviderImpl;
        block12: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
            this.validator = validator;
            this.commonLocations = switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
                case 1 -> this.windowsPaths();
                case 2, 3 -> CollectionsKt.emptyList();
                default -> throw new NoWhenBranchMatchedException();
            };
            this.sshOnPath = switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
                case 1 -> "ssh.exe";
                case 2, 3 -> "ssh";
                default -> throw new NoWhenBranchMatchedException();
            };
            this.availablePaths = this.calculate();
            Iterable iterable = this.availablePaths;
            commonOpenSshPathsProviderImpl = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SshExecutable it = (SshExecutable)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLocation(), (Object)this.sshOnPath)) continue;
                v2 = element$iv;
                break block12;
            }
            v2 = null;
        }
        CommonOpenSshPathsProviderImpl commonOpenSshPathsProviderImpl2 = commonOpenSshPathsProviderImpl;
        SshExecutable sshExecutable = v2;
        if (sshExecutable == null) {
            Object v5;
            block13: {
                void $this$firstOrNull$iv;
                Iterable $i$f$firstOrNull = this.availablePaths;
                commonOpenSshPathsProviderImpl = commonOpenSshPathsProviderImpl2;
                boolean $i$f$firstOrNull2 = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SshExecutable it = (SshExecutable)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == SshExecutableType.OPENSSH_WINDOWS)) continue;
                    v5 = element$iv;
                    break block13;
                }
                v5 = null;
            }
            commonOpenSshPathsProviderImpl2 = commonOpenSshPathsProviderImpl;
            sshExecutable = v5;
            if (sshExecutable == null) {
                sshExecutable = (SshExecutable)CollectionsKt.firstOrNull(this.availablePaths);
            }
        }
        commonOpenSshPathsProviderImpl2.defaultRecommendedExecutable = sshExecutable;
    }

    private final List<SshExecutable> calculate() {
        Pair path2 = TuplesKt.to((Object)(this.sshOnPath + " (PATH)"), (Object)this.sshOnPath);
        return switch (WhenMappings.$EnumSwitchMapping$0[OS.INSTANCE.getType().ordinal()]) {
            case 1 -> {
                void $this$mapNotNullTo$iv$iv;
                Object var10_11;
                Iterable $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable var3_2 = this.commonLocations;
                Collection var18_3 = CollectionsKt.listOf((Object)path2);
                boolean $i$f$map = false;
                void var5_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    var10_11 = (Path)item$iv$iv;
                    Collection var19_14 = destination$iv$iv;
                    boolean $i$a$-map-CommonOpenSshPathsProviderImpl$calculate$locationsToCheck$1 = false;
                    var19_14.add(TuplesKt.to((Object)it.toString(), (Object)it.toString()));
                }
                List locationsToCheck = CollectionsKt.plus((Collection)var18_3, (Iterable)((List)destination$iv$iv));
                Iterable $this$mapNotNull$iv = locationsToCheck;
                boolean $i$f$mapNotNull = false;
                $this$mapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                var10_11 = $this$forEach$iv$iv$iv.iterator();
                while (var10_11.hasNext()) {
                    SshExecutable it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = var10_11.next();
                    boolean $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                    Pair it = (Pair)element$iv$iv;
                    boolean $i$a$-mapNotNull-CommonOpenSshPathsProviderImpl$calculate$1 = false;
                    if (this.validate((String)it.getFirst(), (String)it.getSecond()) == null) continue;
                    boolean $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 2, 3 -> CollectionsKt.listOfNotNull((Object)this.validate((String)path2.getFirst(), (String)path2.getSecond()));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final SshExecutable validate(String key, String location) {
        SshExecutable sshExecutable;
        SshExecutableValidator.Result res2 = this.validator.validate(location);
        if (res2 instanceof SshExecutableValidator.Result.Failure) {
            sshExecutable = null;
        } else if (res2 instanceof SshExecutableValidator.Result.Success) {
            sshExecutable = new SshExecutable(((SshExecutableValidator.Result.Success)res2).getClientType(), ((SshExecutableValidator.Result.Success)res2).getVersion(), location, key);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sshExecutable;
    }

    private final List<Path> windowsPaths() {
        Path path2;
        Path path3;
        Path path4;
        Path path5;
        Path path6;
        Path path7;
        String it;
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        Object[] objectArray3 = objectArray2 = new Path[5];
        int n2 = 0;
        Guid.GUID gUID = KnownFolders.FOLDERID_ProgramFiles;
        Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_ProgramFiles");
        String string = CommonOpenSshPathsProviderImplKt.access$tryGetKnownFolderPath(gUID, "PROGRAMFILES");
        if (string != null) {
            String string2 = string;
            n = n2;
            objectArray = objectArray3;
            boolean bl = false;
            path7 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null).resolve("Git").resolve("usr").resolve("bin").resolve("ssh.exe");
            objectArray3 = objectArray;
            n2 = n;
            path6 = path7;
        } else {
            path6 = null;
        }
        objectArray3[n2] = path6;
        Object[] objectArray4 = objectArray2;
        int n3 = 1;
        Guid.GUID gUID2 = KnownFolders.FOLDERID_ProgramFilesX86;
        Intrinsics.checkNotNullExpressionValue((Object)gUID2, (String)"FOLDERID_ProgramFilesX86");
        String string3 = CommonOpenSshPathsProviderImplKt.access$tryGetKnownFolderPath(gUID2, "PROGRAMFILES(X86)");
        if (string3 != null) {
            it = string3;
            n = n3;
            objectArray = objectArray4;
            boolean bl = false;
            path7 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null).resolve("Git").resolve("usr").resolve("bin").resolve("ssh.exe");
            objectArray4 = objectArray;
            n3 = n;
            path5 = path7;
        } else {
            path5 = null;
        }
        objectArray4[n3] = path5;
        Object[] objectArray5 = objectArray2;
        int n4 = 2;
        Guid.GUID gUID3 = KnownFolders.FOLDERID_LocalAppData;
        Intrinsics.checkNotNullExpressionValue((Object)gUID3, (String)"FOLDERID_LocalAppData");
        String string4 = CommonOpenSshPathsProviderImplKt.access$tryGetKnownFolderPath(gUID3, "LOCALAPPDATA");
        if (string4 != null) {
            it = string4;
            n = n4;
            objectArray = objectArray5;
            boolean bl = false;
            path7 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null).resolve("Programs").resolve("Git").resolve("usr").resolve("bin").resolve("ssh.exe");
            objectArray5 = objectArray;
            n4 = n;
            path4 = path7;
        } else {
            path4 = null;
        }
        objectArray5[n4] = path4;
        Object[] objectArray6 = objectArray2;
        int n5 = 3;
        Guid.GUID gUID4 = KnownFolders.FOLDERID_Windows;
        Intrinsics.checkNotNullExpressionValue((Object)gUID4, (String)"FOLDERID_Windows");
        String string5 = CommonOpenSshPathsProviderImplKt.access$tryGetKnownFolderPath(gUID4, "WINDIR");
        if (string5 != null) {
            it = string5;
            n = n5;
            objectArray = objectArray6;
            boolean bl = false;
            path7 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null).resolve("System32").resolve("OpenSSH").resolve("ssh.exe");
            objectArray6 = objectArray;
            n5 = n;
            path3 = path7;
        } else {
            path3 = null;
        }
        objectArray6[n5] = path3;
        Object[] objectArray7 = objectArray2;
        int n6 = 4;
        Guid.GUID gUID5 = KnownFolders.FOLDERID_Windows;
        Intrinsics.checkNotNullExpressionValue((Object)gUID5, (String)"FOLDERID_Windows");
        String string6 = CommonOpenSshPathsProviderImplKt.access$tryGetKnownFolderPath(gUID5, "WINDIR");
        if (string6 != null) {
            it = string6;
            n = n6;
            objectArray = objectArray7;
            boolean bl = false;
            path7 = Path.Companion.get$default((Path.Companion)Path.Companion, (String)it, (boolean)false, (int)1, null).resolve("Sysnative").resolve("OpenSSH").resolve("ssh.exe");
            objectArray7 = objectArray;
            n6 = n;
            path2 = path7;
        } else {
            path2 = null;
        }
        objectArray7[n6] = path2;
        return CollectionsKt.listOfNotNull((Object[])objectArray2);
    }

    @Override
    @NotNull
    public List<SshExecutable> getPaths() {
        return this.availablePaths;
    }

    @Override
    @Nullable
    public SshExecutable getDefaultRecommendedExecutable() {
        return this.defaultRecommendedExecutable;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.Type.values().length];
            try {
                nArray[OS.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Linux.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Type.Mac.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

