/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.nio.CharBuffer;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpUtilsKt {
    @NotNull
    public static final HttpResponse createStatusResponse(@NotNull HttpResponseStatus responseStatus, @Nullable HttpRequest request2, @Nullable String description2, boolean usePlainText) {
        Intrinsics.checkNotNullParameter((Object)responseStatus, (String)"responseStatus");
        if (request2 != null && Intrinsics.areEqual((Object)request2.method(), (Object)HttpMethod.HEAD)) {
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.EMPTY_BUFFER);
        }
        String string = responseStatus.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String message2 = string;
        StringBuilder builder = new StringBuilder();
        if (usePlainText) {
            builder.append(message2);
            if (description2 != null) {
                builder.append("\n").append(description2);
            }
        } else {
            builder.append("<!doctype html><title>").append(message2).append("</title>").append("<h1 style=\"text-align: center\">").append(message2).append("</h1>");
            if (description2 != null) {
                builder.append("<p>").append(description2).append("</p>");
            }
        }
        ByteBuf content2 = ByteBufUtil.encodeString(ByteBufAllocator.DEFAULT, CharBuffer.wrap(builder), Charsets.UTF_8);
        DefaultFullHttpResponse response2 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, content2);
        response2.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(usePlainText ? HttpHeaderValues.TEXT_PLAIN : HttpHeaderValues.TEXT_HTML));
        return response2;
    }

    public static /* synthetic */ HttpResponse createStatusResponse$default(HttpResponseStatus httpResponseStatus, HttpRequest httpRequest, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return HttpUtilsKt.createStatusResponse(httpResponseStatus, httpRequest, string, bl);
    }

    public static final void addHttpServerCodec(@NotNull ChannelPipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        pipeline.addLast("httpRequestEncoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("httpRequestDecoder", (ChannelHandler)new HttpRequestDecoder(16384, 16384, 8192));
        pipeline.addLast("httpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(0xB400000));
        if (pipeline.get(ChunkedWriteHandler.class) == null) {
            pipeline.addLast("chunkedWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
        }
        Object[] objectArray = new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.PATCH};
        CorsConfigBuilder corsConfigBuilder = CorsConfigBuilder.forAnyOrigin().shortCircuit().allowCredentials().allowNullOrigin().allowedRequestMethods((HttpMethod[])objectArray);
        objectArray = new String[]{"origin", "accept", "authorization", "content-type", "x-ijt", "x-requested-with"};
        pipeline.addLast("corsHandler", (ChannelHandler)new CorsHandler(corsConfigBuilder.allowedRequestHeaders((String[])objectArray).build()));
    }
}

