/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Collection;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nProxyAuthenticator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyAuthenticator.kt\ncom/jetbrains/toolbox/network/ProxyAuthenticator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1761#2,3:40\n*S KotlinDebug\n*F\n+ 1 ProxyAuthenticator.kt\ncom/jetbrains/toolbox/network/ProxyAuthenticator\n*L\n16#1:40,3\n*E\n"})
public final class ProxyAuthenticator
implements Authenticator {
    @NotNull
    private final SettingsManager settings;
    @NotNull
    private final Function1<String, Unit> credentialsPrompt;

    public ProxyAuthenticator(@NotNull SettingsManager settings2, @NotNull Function1<? super String, Unit> credentialsPrompt) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter(credentialsPrompt, (String)"credentialsPrompt");
        this.settings = settings2;
        this.credentialsPrompt = credentialsPrompt;
    }

    @Override
    @Nullable
    public Request authenticate(@Nullable Route route, @NotNull Response response2) {
        InetSocketAddress proxyAddress;
        boolean isPreemptive;
        block4: {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            Iterable $this$any$iv = response2.challenges();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Challenge it = (Challenge)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.scheme(), (String)"OkHttp-Preemptive", (boolean)true)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = isPreemptive = false;
            }
        }
        if (isPreemptive) {
            return this.addProxyAuthorizationHeader(response2.request());
        }
        Object object = route;
        SocketAddress $i$f$any = object != null && (object = ((Route)object).proxy()) != null ? ((Proxy)object).address() : null;
        InetSocketAddress inetSocketAddress = proxyAddress = $i$f$any instanceof InetSocketAddress ? (InetSocketAddress)$i$f$any : null;
        String host = inetSocketAddress != null ? inetSocketAddress.getHostName() : null;
        InetSocketAddress inetSocketAddress2 = proxyAddress;
        Integer port = inetSocketAddress2 != null ? Integer.valueOf(inetSocketAddress2.getPort()) : null;
        this.credentialsPrompt.invoke((Object)(host + ":" + port));
        return null;
    }

    private final Request addProxyAuthorizationHeader(Request $this$addProxyAuthorizationHeader) {
        String proxyUsername = ((SelfSettings)this.settings.getSettings().getValue()).getProxy().getAuth().getUsername();
        if (((CharSequence)proxyUsername).length() == 0) {
            return $this$addProxyAuthorizationHeader;
        }
        String credential = Credentials.basic$default(proxyUsername, this.settings.getProxyPassword(), null, 4, null);
        return $this$addProxyAuthorizationHeader.newBuilder().header("Proxy-Authorization", credential).build();
    }
}

