/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.network;

import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.datetime.InstantExtensionsKt;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.common.security.ShaKt;
import com.jetbrains.toolbox.network.CertificateManager;
import com.jetbrains.toolbox.network.CertificateManagerContext;
import com.jetbrains.toolbox.network.CertificateManagerImpl;
import com.jetbrains.toolbox.network.CertificateTrustRequest;
import com.jetbrains.toolbox.network.CustomTrustManager;
import com.jetbrains.toolbox.network.UntrustedCertificateHandler;
import com.jetbrains.toolbox.settings.KeystoreSettings;
import com.jetbrains.toolbox.settings.NetworkSettings;
import com.jetbrains.toolbox.settings.SelfSettings;
import com.jetbrains.toolbox.settings.SettingsManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.HexExtensionsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.datetime.Clock;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.internal.TlsUtil;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.nativecerts.NativeTrustedCertificates;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nCertificateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateManager.kt\ncom/jetbrains/toolbox/network/CertificateManagerImpl\n+ 2 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n116#2,10:218\n126#2:229\n116#2,11:230\n1#3:228\n*S KotlinDebug\n*F\n+ 1 CertificateManager.kt\ncom/jetbrains/toolbox/network/CertificateManagerImpl\n*L\n115#1:218,10\n115#1:229\n157#1:230,11\n*E\n"})
public final class CertificateManagerImpl
implements CertificateManager {
    @NotNull
    private final SettingsManager settingsManager;
    @NotNull
    private final Path cacerts;
    @NotNull
    private final UntrustedCertificateHandler untrustedCertificateHandler;
    @NotNull
    private final Mutex lock;
    @NotNull
    private final Map<String, X509Certificate> pendingCertificates;
    @NotNull
    private final Set<String> rejectedCertificates;
    @NotNull
    private final Set<String> customCertificates;
    @NotNull
    private final MutableSharedFlow<Unit> _certificatesChanged;
    @NotNull
    private final SharedFlow<Unit> certificatesChanged;

    public CertificateManagerImpl(@NotNull SettingsManager settingsManager, @NotNull Path cacerts, @NotNull UntrustedCertificateHandler untrustedCertificateHandler) {
        Intrinsics.checkNotNullParameter((Object)settingsManager, (String)"settingsManager");
        Intrinsics.checkNotNullParameter((Object)cacerts, (String)"cacerts");
        Intrinsics.checkNotNullParameter((Object)untrustedCertificateHandler, (String)"untrustedCertificateHandler");
        this.settingsManager = settingsManager;
        this.cacerts = cacerts;
        this.untrustedCertificateHandler = untrustedCertificateHandler;
        this.lock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.pendingCertificates = new LinkedHashMap();
        this.rejectedCertificates = new LinkedHashSet();
        this.customCertificates = new LinkedHashSet();
        this._certificatesChanged = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.certificatesChanged = FlowKt.asSharedFlow(this._certificatesChanged);
    }

    @Override
    @NotNull
    public SharedFlow<Unit> getCertificatesChanged() {
        return this.certificatesChanged;
    }

    @Override
    @Nullable
    public CertificateManagerContext currentContext() {
        return (CertificateManagerContext)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CertificateManagerContext>, Object>(this, null){
            Object L$0;
            Object L$1;
            int I$0;
            int label;
            final /* synthetic */ CertificateManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ThreadGuardKt.assertNotMainThread("java.io.File.exists()");
                        var2_3 = CertificateManagerImpl.access$getLock$p(this.this$0);
                        var4_4 = this.this$0;
                        owner$iv = null;
                        $i$f$withLock = 0;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.I$0 = $i$f$withLock;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var15_2) {
                            return var15_2;
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        $i$f$withLock = this.I$0;
                        var4_4 = (CertificateManagerImpl)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        try {
                            $i$a$-withLock$default-CertificateManagerImpl$currentContext$1$1 = false;
                            builder = new HandshakeCertificates.Builder();
                            try {
                                builder.addPlatformTrustedCertificates();
                            }
                            catch (Exception e) {
                                Logger.INSTANCE.error((Throwable)e, "Platform certificates are inaccessible");
                            }
                            for (X509Certificate trustedCertificate : NativeTrustedCertificates.getCustomOsSpecificTrustedCertificates()) {
                                Intrinsics.checkNotNull((Object)trustedCertificate);
                                builder.addTrustedCertificate(trustedCertificate);
                            }
                            try {
                                CertificateManagerImpl.access$getCustomCertificates$p(var4_4).clear();
                                settings = (SelfSettings)CertificateManagerImpl.access$getSettingsManager$p(var4_4).getSettings().getValue();
                                v1 = settings.getNetwork().getKeystore();
                                keystoreLocation = v1 != null ? v1.getLocation() : null;
                                var10_15 = keystoreLocation;
                                if (!(var10_15 == null || var10_15.length() == 0) && (keystore = new File(keystoreLocation)).exists()) {
                                    Logger.INSTANCE.warn("Adding trusted certificate from " + keystore);
                                    v2 = settings.getNetwork().getKeystore();
                                    if (v2 == null || (v2 = v2.getPassword()) == null) {
                                        v2 = "";
                                    }
                                    v3 = v2.toCharArray();
                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toCharArray(...)");
                                    trustedCertificates = KeyStore.getInstance(keystore, v3);
                                    Intrinsics.checkNotNull((Object)trustedCertificates);
                                    CertificateManagerImpl.access$addCertificatesFromKeystore(var4_4, builder, trustedCertificates, "trusted");
                                    v4 = trustedCertificates.aliases();
                                    Intrinsics.checkNotNullExpressionValue(v4, (String)"aliases(...)");
                                    var12_17 = CollectionsKt.iterator(v4);
                                    while (var12_17.hasNext()) {
                                        alias = (String)var12_17.next();
                                        v5 = CertificateManagerImpl.access$getCustomCertificates$p(var4_4);
                                        Intrinsics.checkNotNull((Object)alias);
                                        v5.add(alias);
                                    }
                                }
                            }
                            catch (Exception e) {
                                Logger.INSTANCE.error((Throwable)e, "User certificates are inaccessible");
                            }
                            try {
                                certificates = builder.build();
                                trustManager = new CustomTrustManager(certificates.trustManager(), var4_4);
                                keyManager = TlsUtil.newKeyManager(null, null, new X509Certificate[0]);
                                sslContext = SSLContext.getInstance("TLS");
                                var12_17 = new X509KeyManager[]{keyManager};
                                v6 = (KeyManager[])var12_17;
                                var12_17 = new CustomTrustManager[]{trustManager};
                                sslContext.init(v6, (TrustManager[])var12_17, new SecureRandom());
                                v7 = sslContext.getSocketFactory();
                                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getSocketFactory(...)");
                                var9_13 = new CertificateManagerContext(v7, trustManager);
                            }
                            catch (Throwable t) {
                                Logger.INSTANCE.error(t, "Failed to setup certificates");
                                var9_13 = null;
                            }
                            var14_19 = var9_13;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return var14_19;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super CertificateManagerContext> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private final void addCertificatesFromKeystore(HandshakeCertificates.Builder $this$addCertificatesFromKeystore, KeyStore trustedCertificates, String type2) {
        int added = 0;
        Enumeration<String> enumeration = trustedCertificates.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"aliases(...)");
        Iterator iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            String alias = (String)iterator2.next();
            Certificate certificate2 = trustedCertificates.getCertificate(alias);
            if (certificate2 instanceof X509Certificate) {
                Object object;
                try {
                    ((X509Certificate)certificate2).checkValidity();
                    Logger.INSTANCE.trace("Adding " + type2 + " certificate " + alias + " (" + ((X509Certificate)certificate2).getSubjectX500Principal().getName() + ")");
                    $this$addCertificatesFromKeystore.addTrustedCertificate((X509Certificate)certificate2);
                    object = added++;
                }
                catch (Throwable t2) {
                    Logger.INSTANCE.debug(t2, "Skipping invalid certificate " + alias + " (" + ((X509Certificate)certificate2).getSubjectX500Principal().getName() + ")");
                    object = Unit.INSTANCE;
                }
                continue;
            }
            Logger.INSTANCE.error("Certificate " + alias + " is not a X509 Certificate");
        }
        Logger.INSTANCE.info("Added " + added + " " + type2 + " certificates");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object acceptCertificate(@NotNull String alias, boolean accept, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof acceptCertificate.1)) ** GOTO lbl-1000
        var22_4 = $completion;
        if ((var22_4.label & -2147483648) != 0) {
            var22_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                boolean Z$0;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ CertificateManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.acceptCertificate(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.lock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = alias;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.Z$0 = accept;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var23_6) {
                    return var23_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                accept = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                alias = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 3 sources

                $i$a$-withLock$default-CertificateManagerImpl$acceptCertificate$2 = 0;
                ThreadGuardKt.assertNotMainThread("java.io.File.exists()");
                certificate = this.pendingCertificates.remove(alias);
                if (certificate != null) ** GOTO lbl43
                Logger.INSTANCE.error("Cannot find pending certificate " + alias);
                var20_15 = Unit.INSTANCE;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var20_15;
lbl43:
                // 2 sources

                if (accept) ** GOTO lbl53
                v1 = certificate.getEncoded();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getEncoded(...)");
                this.rejectedCertificates.add(HexExtensionsKt.toHexString$default((byte[])ShaKt.sha256(v1), null, (int)1, null));
                Logger.INSTANCE.info("Untrusted certificate " + alias + " rejected");
                var19_16 = Unit.INSTANCE;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var19_16;
lbl53:
                // 2 sources

                Logger.INSTANCE.info("Storing accepted certificate " + alias + ": " + certificate);
                v2 = ((SelfSettings)this.settingsManager.getSettings().getValue()).getNetwork().getKeystore();
                if (v2 == null || (v2 = v2.getLocation()) == null) {
                    v2 = "";
                }
                keystoreLocation = v2;
                f = new File((String)keystoreLocation);
                $i$a$-let-CertificateManagerImpl$acceptCertificate$2$keystoreFile$1 = false;
                if (((CharSequence)keystoreLocation).length() > 0 && f.exists()) {
                    v3 = f;
                } else {
                    this.settingsManager.updateSettings((Function1<? super SelfSettings, SelfSettings>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, acceptCertificate$lambda$0$0$0(com.jetbrains.toolbox.network.CertificateManagerImpl com.jetbrains.toolbox.settings.SelfSettings ), (Lcom/jetbrains/toolbox/settings/SelfSettings;)Lcom/jetbrains/toolbox/settings/SelfSettings;)((CertificateManagerImpl)this));
                    v3 = this.cacerts.toFile();
                }
                keystoreFile = v3;
                v4 = ((SelfSettings)this.settingsManager.getSettings().getValue()).getNetwork().getKeystore();
                if (v4 == null || (v4 = v4.getPassword()) == null) {
                    v4 = "";
                }
                v5 = v4.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"toCharArray(...)");
                password = v5;
                if (keystoreFile.exists()) {
                    v6 = KeyStore.getInstance(keystoreFile, password);
                } else {
                    $this$acceptCertificate_u24lambda_u240_u241 = var13_23 = KeyStore.getInstance("JKS");
                    $i$a$-apply-CertificateManagerImpl$acceptCertificate$2$keystore$1 = false;
                    $this$acceptCertificate_u24lambda_u240_u241.load(null, password);
                    v6 = var13_23;
                }
                keystore = v6;
                keystore.setCertificateEntry(alias, certificate);
                var13_24 = new FileOutputStream(keystoreFile);
                var14_29 = null;
                try {
                    it = (FileOutputStream)var13_24;
                    $i$a$-use-CertificateManagerImpl$acceptCertificate$2$1 = false;
                    keystore.store(it, password);
                    var15_31 = Unit.INSTANCE;
                }
                catch (Throwable var16_33) {
                    var14_29 = var16_33;
                    throw var16_33;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var13_24, (Throwable)var14_29);
                }
                $continuation.L$0 = alias;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)certificate);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)keystoreLocation);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)keystoreFile);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)password);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)keystore);
                $continuation.Z$0 = accept;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-CertificateManagerImpl$acceptCertificate$2;
                $continuation.label = 2;
                v7 = this._certificatesChanged.emit((Object)Unit.INSTANCE, (Continuation)$continuation);
                ** if (v7 != var23_6) goto lbl113
lbl112:
                // 1 sources

                return var23_6;
lbl113:
                // 1 sources

                ** GOTO lbl135
            }
            case 2: {
                $i$a$-withLock$default-CertificateManagerImpl$acceptCertificate$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                accept = $continuation.Z$0;
                keystore = (KeyStore)$continuation.L$6;
                password = (char[])$continuation.L$5;
                keystoreFile = (File)$continuation.L$4;
                keystoreLocation = (String)$continuation.L$3;
                certificate = (X509Certificate)$continuation.L$2;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                alias = (String)$continuation.L$0;
                try {
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
                    }
                    catch (Throwable t) {
                        Logger.INSTANCE.warn(t, "Unable to store accepted certificate " + alias);
                    }
lbl135:
                    // 3 sources

                    var17_35 = Unit.INSTANCE;
                }
                catch (Throwable var18_36) {
                    throw var18_36;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var17_35;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object addPendingCertificate(@NotNull X509Certificate certificate, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof addPendingCertificate.1)) ** GOTO lbl-1000
        var18_3 = $completion;
        if ((var18_3.label & -2147483648) != 0) {
            var18_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ CertificateManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.addPendingCertificate(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var19_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.lock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = certificate;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var19_5) {
                    return var19_5;
                }
                ** GOTO lbl30
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                certificate = (X509Certificate)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                try {
                    $i$a$-withLock$default-CertificateManagerImpl$addPendingCertificate$2 = false;
                    v1 = certificate.getEncoded();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getEncoded(...)");
                    fingerprint = ShaKt.sha256(v1);
                    if (this.rejectedCertificates.contains(HexExtensionsKt.toHexString$default((byte[])fingerprint, null, (int)1, null))) {
                        var16_12 = Unit.INSTANCE;
                        return var16_12;
                    }
                    v2 = certificate.getSubjectX500Principal().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                    var8_13 = v2;
                    var9_14 = new Regex("[^a-zA-Z0-9]]");
                    var10_15 = "";
                    v3 = var9_14.replace(var8_13, var10_15).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
                    alias = StringsKt.take((String)v3, (int)7) + "-" + StringsKt.take((String)HexExtensionsKt.toHexString$default((byte[])fingerprint, null, (int)1, null), (int)8);
                    if (this.pendingCertificates.containsKey(alias) || this.customCertificates.contains(alias)) {
                        var15_17 = Unit.INSTANCE;
                        return var15_17;
                    }
                    now = Clock.System.INSTANCE.now();
                    v4 = certificate.getNotAfter();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getNotAfter(...)");
                    if (InstantExtensionsKt.getAsInstant(v4).compareTo(now) < 0) ** GOTO lbl57
                    v5 = certificate.getNotBefore();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getNotBefore(...)");
                    if (InstantExtensionsKt.getAsInstant(v5).compareTo(now) <= 0) ** GOTO lbl60
lbl57:
                    // 2 sources

                    Logger.INSTANCE.info("Certificate " + certificate.getSubjectX500Principal().getName() + " is expired or not yet valid: " + certificate.getNotBefore() + " - " + certificate.getNotAfter());
                    var14_18 = Unit.INSTANCE;
                    return var14_18;
lbl60:
                    // 1 sources

                    this.pendingCertificates.put(alias, certificate);
                    Logger.INSTANCE.info("Prompt user action for untrusted certificate " + alias);
                    v6 = certificate.getSubjectX500Principal().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getName(...)");
                    v7 = certificate.getIssuerX500Principal().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getName(...)");
                    v8 = certificate.getNotBefore().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"toString(...)");
                    v9 = certificate.getNotAfter().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toString(...)");
                    this.untrustedCertificateHandler.addPrompt(new CertificateTrustRequest(alias, v6, v7, v8, v9, ShaKt.fingerprint(fingerprint)));
                    var12_19 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final SelfSettings acceptCertificate$lambda$0$0$0(CertificateManagerImpl this$0, SelfSettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getNetwork().getKeystore();
        if (object == null || (object = ((KeystoreSettings)object).getPassword()) == null || (object = StringExtensionsKt.getNullIfEmpty((String)object)) == null) {
            object = "changeit";
        }
        Object password = object;
        return SelfSettings.copy$default(it, null, null, false, false, null, 0, null, null, null, null, null, NetworkSettings.copy-NqJ4yvY$default(it.getNetwork(), 0L, 0L, new KeystoreSettings(this$0.cacerts.toString(), (String)password), 3, null), null, null, null, null, null, 129023, null);
    }

    public static final /* synthetic */ Mutex access$getLock$p(CertificateManagerImpl $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Set access$getCustomCertificates$p(CertificateManagerImpl $this) {
        return $this.customCertificates;
    }

    public static final /* synthetic */ SettingsManager access$getSettingsManager$p(CertificateManagerImpl $this) {
        return $this.settingsManager;
    }

    public static final /* synthetic */ void access$addCertificatesFromKeystore(CertificateManagerImpl $this, HandshakeCertificates.Builder $receiver, KeyStore trustedCertificates, String type2) {
        $this.addCertificatesFromKeystore($receiver, trustedCertificates, type2);
    }
}

