/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.markdown.configuration;

import com.jetbrains.toolbox.common.ai.TextGenerationSpeed;
import com.jetbrains.toolbox.common.ai.TextGenerationSpeedKt;
import com.jetbrains.toolbox.markdown.configuration.MarkdownElementAnimation;
import com.jetbrains.toolbox.markdown.renderer.animation.caret.MarkdownCaretTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownConfiguration {
    @NotNull
    private final Animation animation;
    public static final int $stable = 8;

    public MarkdownConfiguration(@NotNull Animation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        this.animation = animation;
    }

    @NotNull
    public final Animation getAnimation() {
        return this.animation;
    }

    @NotNull
    public String toString() {
        return "MarkdownConfiguration(animation=" + this.animation + ")";
    }

    public int hashCode() {
        return this.animation.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MarkdownConfiguration)) {
            return false;
        }
        MarkdownConfiguration markdownConfiguration = (MarkdownConfiguration)other;
        return Intrinsics.areEqual((Object)this.animation, (Object)markdownConfiguration.animation);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @SourceDebugExtension(value={"SMAP\nMarkdownConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownConfiguration.kt\ncom/jetbrains/toolbox/markdown/configuration/MarkdownConfiguration$Animation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1740#2,3:115\n*S KotlinDebug\n*F\n+ 1 MarkdownConfiguration.kt\ncom/jetbrains/toolbox/markdown/configuration/MarkdownConfiguration$Animation\n*L\n33#1:115,3\n*E\n"})
    public static final class Animation {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<IElementType, MarkdownElementAnimation> elements;
        @NotNull
        private final MarkdownCaretTracker tracker;
        private final long tick;
        public static final int $stable = 8;
        @NotNull
        private static final Set<IElementType> animated;

        private Animation(Map<IElementType, ? extends MarkdownElementAnimation> elements, MarkdownCaretTracker tracker, long tick2) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
                this.elements = elements;
                this.tracker = tracker;
                this.tick = tick2;
                Iterable $this$all$iv = animated;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        IElementType it = (IElementType)element$iv;
                        boolean bl2 = false;
                        if (this.elements.containsKey(it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                boolean bl3 = false;
                String string = "All the elements should be presented in the animation map";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final MarkdownCaretTracker getTracker() {
            return this.tracker;
        }

        public final long getTick-UwyO8pc() {
            return this.tick;
        }

        @NotNull
        public final MarkdownElementAnimation animationForOrFail$markdown(@NotNull IElementType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            MarkdownElementAnimation markdownElementAnimation = this.elements.get(type2);
            if (markdownElementAnimation == null) {
                throw new IllegalStateException(("Can't find animation for " + type2).toString());
            }
            return markdownElementAnimation;
        }

        @Nullable
        public final MarkdownElementAnimation animationForOrNull$markdown(@NotNull IElementType type2) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            return this.elements.get(type2);
        }

        @NotNull
        public String toString() {
            return "Animation(elements=" + this.elements + ", tracker=" + this.tracker + ", tick=" + Duration.toString-impl((long)this.tick) + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.elements).hashCode();
            result2 = result2 * 31 + this.tracker.hashCode();
            result2 = result2 * 31 + Duration.hashCode-impl((long)this.tick);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Animation)) {
                return false;
            }
            Animation animation = (Animation)other;
            if (!Intrinsics.areEqual(this.elements, animation.elements)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tracker, (Object)animation.tracker)) {
                return false;
            }
            return Duration.equals-impl0((long)this.tick, (long)animation.tick);
        }

        public /* synthetic */ Animation(Map elements, MarkdownCaretTracker tracker, long tick2, DefaultConstructorMarker $constructor_marker) {
            this(elements, tracker, tick2);
        }

        static {
            Object[] objectArray = new IElementType[]{MarkdownElementTypes.PARAGRAPH, MarkdownTokenTypes.LIST_BULLET, MarkdownTokenTypes.LIST_NUMBER, MarkdownTokenTypes.BLOCK_QUOTE, MarkdownTokenTypes.CODE_FENCE_START, MarkdownTokenTypes.CODE_FENCE_CONTENT, MarkdownTokenTypes.ATX_HEADER, MarkdownTokenTypes.ATX_CONTENT, MarkdownTokenTypes.HORIZONTAL_RULE};
            animated = SetsKt.setOf((Object[])objectArray);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @SourceDebugExtension(value={"SMAP\nMarkdownConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownConfiguration.kt\ncom/jetbrains/toolbox/markdown/configuration/MarkdownConfiguration$Animation$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n77#2:115\n97#2,2:116\n99#2,3:122\n1563#3:118\n1634#3,3:119\n*S KotlinDebug\n*F\n+ 1 MarkdownConfiguration.kt\ncom/jetbrains/toolbox/markdown/configuration/MarkdownConfiguration$Animation$Companion\n*L\n56#1:115\n56#1:116,2\n56#1:122,3\n56#1:118\n56#1:119,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            private final Animation of-SxA4cEA(Map<Set<IElementType>, ? extends MarkdownElementAnimation> elements, MarkdownCaretTracker tracker, long l) {
                void $this$flatMapTo$iv$iv;
                Map<Set<IElementType>, ? extends MarkdownElementAnimation> $this$flatMap$iv = elements;
                boolean $i$f$flatMap = false;
                Map<Set<IElementType>, ? extends MarkdownElementAnimation> map2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void $this$mapTo$iv$iv;
                    Map.Entry element$iv$iv;
                    Map.Entry entry = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    Set types = (Set)entry.getKey();
                    MarkdownElementAnimation animation = (MarkdownElementAnimation)entry.getValue();
                    Iterable $this$map$iv = types;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        IElementType iElementType = (IElementType)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(TuplesKt.to((Object)it, (Object)animation));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                DefaultConstructorMarker defaultConstructorMarker = null;
                long l2 = l;
                MarkdownCaretTracker markdownCaretTracker = tracker;
                Map map3 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                return new Animation(map3, markdownCaretTracker, l2, defaultConstructorMarker);
            }

            @NotNull
            public final Animation none() {
                return this.of-SxA4cEA(MapsKt.mapOf((Pair)TuplesKt.to((Object)animated, (Object)MarkdownElementAnimation.Snap.INSTANCE)), MarkdownCaretTracker.Snap.INSTANCE, DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS));
            }

            @NotNull
            public final Animation default-LRDsOJo(long l) {
                Pair[] pairArray = new Pair[3];
                Object[] objectArray = new IElementType[]{MarkdownElementTypes.PARAGRAPH, MarkdownTokenTypes.LIST_BULLET, MarkdownTokenTypes.LIST_NUMBER, MarkdownTokenTypes.ATX_CONTENT};
                Set set2 = SetsKt.setOf((Object[])objectArray);
                objectArray = RangesKt.rangeTo((Comparable)TextGenerationSpeedKt.getCharactersPerSecond(20), (Comparable)TextGenerationSpeedKt.getCharactersPerSecond(1000));
                ClosedRange closedRange = RangesKt.rangeTo((Comparable)Duration.box-impl((long)l), (Comparable)Duration.box-impl((long)Duration.times-UwyO8pc((long)l, (int)5)));
                ClosedRange closedRange2 = RangesKt.rangeTo((Comparable)Duration.box-impl((long)DurationKt.toDuration((double)0.5, (DurationUnit)DurationUnit.SECONDS)), (Comparable)Duration.box-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)));
                pairArray[0] = TuplesKt.to((Object)set2, (Object)new MarkdownElementAnimation.Typing.PerChunk((ClosedRange<TextGenerationSpeed>)objectArray, (ClosedRange<Duration>)closedRange2, (ClosedRange<Duration>)closedRange, 100));
                objectArray = RangesKt.rangeTo((Comparable)TextGenerationSpeedKt.getCharactersPerSecond(20), (Comparable)TextGenerationSpeedKt.getCharactersPerSecond(1000));
                closedRange = RangesKt.rangeTo((Comparable)Duration.box-impl((long)l), (Comparable)Duration.box-impl((long)Duration.times-UwyO8pc((long)l, (int)5)));
                closedRange2 = RangesKt.rangeTo((Comparable)Duration.box-impl((long)DurationKt.toDuration((double)0.5, (DurationUnit)DurationUnit.SECONDS)), (Comparable)Duration.box-impl((long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS)));
                pairArray[1] = TuplesKt.to((Object)SetsKt.setOf((Object)MarkdownTokenTypes.CODE_FENCE_CONTENT), (Object)new MarkdownElementAnimation.Typing.PerLine((ClosedRange<TextGenerationSpeed>)objectArray, (ClosedRange<Duration>)closedRange2, (ClosedRange<Duration>)closedRange, 3));
                objectArray = new IElementType[]{MarkdownTokenTypes.BLOCK_QUOTE, MarkdownTokenTypes.CODE_FENCE_START, MarkdownTokenTypes.ATX_HEADER, MarkdownTokenTypes.HORIZONTAL_RULE};
                pairArray[2] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)new MarkdownElementAnimation.Fade.Block(Duration.times-UwyO8pc((long)l, (int)2), null));
                return this.of-SxA4cEA(MapsKt.mapOf((Pair[])pairArray), MarkdownCaretTracker.Default.INSTANCE, l);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

