/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.ErrorsHelperKt;
import com.jetbrains.toolbox.FileUtils;
import com.jetbrains.toolbox.common.io.Copy_and_moveKt;
import com.jetbrains.toolbox.common.platform.OS;
import com.jetbrains.toolbox.feed.PatchAsserts;
import com.jetbrains.toolbox.feed.PatchAssertsStopwords;
import com.jetbrains.toolbox.feed.PatchFormat;
import com.jetbrains.toolbox.interop.LoggingKt;
import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.interop.Processes;
import com.jetbrains.toolbox.managers.PatchingStateWorker;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.ChannelStateKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolPatch;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.YieldKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nPatchingStateWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchingStateWorker.kt\ncom/jetbrains/toolbox/managers/PatchingStateWorker\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 3 ErrorsHelper.kt\ncom/jetbrains/toolbox/ErrorsHelperKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n375#2:187\n8#3,4:188\n8#3,4:192\n8#3,4:201\n1563#4:196\n1634#4,3:197\n1#5:200\n*S KotlinDebug\n*F\n+ 1 PatchingStateWorker.kt\ncom/jetbrains/toolbox/managers/PatchingStateWorker\n*L\n41#1:187\n56#1:188,4\n83#1:192,4\n104#1:201,4\n89#1:196\n89#1:197,3\n*E\n"})
public final class PatchingStateWorker
implements ChannelStateWorker<ChannelState.Patching> {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final ShellEnvironment shellEnvironment;

    public PatchingStateWorker(@NotNull FileSystem fileSystem, @NotNull FileUtils fileUtils, @NotNull ShellEnvironment shellEnvironment) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)fileUtils, (String)"fileUtils");
        Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
        this.fileSystem = fileSystem;
        this.fileUtils = fileUtils;
        this.shellEnvironment = shellEnvironment;
    }

    @Override
    @NotNull
    public KClass<ChannelState.Patching> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.Patching.class);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.Patching state, @NotNull Continuation<? super ChannelEvent> $completion) {
        if (!($completion instanceof handle.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ PatchingStateWorker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handle((ChannelState.Patching)null, (Continuation<? super ChannelEvent>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                tmpDir = this.fileUtils.createTempDirectory(state.getBuild().getBuild().getId-Y_E1uuk());
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)state);
                $continuation.L$1 = tmpDir;
                $continuation.label = 1;
                v0 = this.execute(ChannelStateKt.toToolInstance(state), state.getPatches(), tmpDir, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var9_5) goto lbl21
lbl20:
                // 1 sources

                return var9_5;
lbl21:
                // 1 sources

                ** GOTO lbl29
            }
            case 1: {
                tmpDir = (Path)$continuation.L$1;
                state = (ChannelState.Patching)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    var4_7 = new ChannelEvent.PatchingSuccessful(tmpDir);
                }
                catch (Exception e) {
                    $i$f$currentCoroutineContext = false;
                    JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    Logger.INSTANCE.error((Throwable)e, "Failed to apply patch: " + e.getMessage());
                    var4_7 = ChannelEvent.PatchingFailed.INSTANCE;
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object execute(@NotNull ToolInstance baseImage, @NotNull List<Pair<ToolPatch, Path>> downloadedPatches, @NotNull Path targetDirectory, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var12_5 = $completion;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                /* synthetic */ Object result;
                final /* synthetic */ PatchingStateWorker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.debug("Using " + baseImage + " as base");
                baseImagePath = baseImage.getChannel().getInstallationDirectory();
                if (Intrinsics.areEqual((Object)baseImagePath, (Object)targetDirectory)) {
                    ErrorsHelperKt.errorResult$default("Cannot patch into existing feed item!", null, 2, null);
                    throw new KotlinNothingValueException();
                }
                errorMessagePrefix$iv = "Failed to clean " + targetDirectory;
                $i$f$wrapError = false;
                try {
                    $i$a$-wrapError-PatchingStateWorker$execute$2 = false;
                    this.fileSystem.deleteRecursively(targetDirectory);
                    var9_14 = Unit.INSTANCE;
                }
                catch (Throwable t$iv) {
                    ErrorsHelperKt.errorResult(errorMessagePrefix$iv + ": " + t$iv.getMessage(), t$iv);
                    throw new KotlinNothingValueException();
                }
                Logger.INSTANCE.debug("Copying base image to " + targetDirectory);
                Copy_and_moveKt.copyRecursively$default(this.fileSystem, baseImagePath, targetDirectory, null, false, 0, 28, null);
                Logger.INSTANCE.debug("Applying patches to " + targetDirectory);
                var6_9 = downloadedPatches.iterator();
lbl35:
                // 3 sources

                while (var6_9.hasNext()) {
                    var7_11 = (Pair)var6_9.next();
                    patch = (ToolPatch)var7_11.component1();
                    path = (Path)var7_11.component2();
                    $continuation.L$0 = baseImage;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)downloadedPatches);
                    $continuation.L$2 = targetDirectory;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)baseImagePath);
                    $continuation.L$4 = var6_9;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)patch);
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)path);
                    $continuation.label = 1;
                    v0 = this.applyPatch(baseImage, targetDirectory, patch, path, (Continuation<? super Unit>)$continuation);
                    if (v0 != var13_7) continue;
                    return var13_7;
                }
                break;
            }
            case 1: {
                path = (Path)$continuation.L$6;
                patch = (ToolPatch)$continuation.L$5;
                var6_9 = (Iterator<E>)$continuation.L$4;
                baseImagePath = (Path)$continuation.L$3;
                targetDirectory = (Path)$continuation.L$2;
                downloadedPatches = (List)$continuation.L$1;
                baseImage = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                ** GOTO lbl35
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object applyPatch(ToolInstance baseImage, Path directory, ToolPatch patch, Path patchFile, Continuation<? super Unit> $completion) {
        if (!($completion instanceof applyPatch.1)) ** GOTO lbl-1000
        var23_6 = $completion;
        if ((var23_6.label & -2147483648) != 0) {
            var23_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                /* synthetic */ Object result;
                final /* synthetic */ PatchingStateWorker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PatchingStateWorker.access$applyPatch(this.this$0, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var24_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logger.INSTANCE.info("Patching " + directory + " with " + patch + " downloaded to " + patchFile);
                patchCommand = patch.getCommand();
                if (patchCommand.isEmpty()) {
                    Logger.INSTANCE.error("Failed to read patch command form JSON");
                    ErrorsHelperKt.errorResult$default("Failed to read patch command form JSON", null, 2, null);
                    throw new KotlinNothingValueException();
                }
                if (patch.getType() != PatchFormat.IntelliJ) {
                    ErrorsHelperKt.errorResult$default("Unsupported patch type: " + patch.getType(), null, 2, null);
                    throw new KotlinNothingValueException();
                }
                errorMessagePrefix$iv = "Java not found from " + baseImage;
                $i$f$wrapError = false;
                try {
                    $i$a$-wrapError-PatchingStateWorker$applyPatch$javaPath$1 = false;
                    var11_19 = this.resolveJavaPath(baseImage);
                }
                catch (Throwable t$iv) {
                    ErrorsHelperKt.errorResult(errorMessagePrefix$iv + ": " + t$iv.getMessage(), t$iv);
                    throw new KotlinNothingValueException();
                }
                javaPath = var11_19;
                nativePatchFilePath = this.fileSystem.canonicalize(patchFile).toString();
                nativeInstallDirFilePath = this.fileSystem.canonicalize(directory).toString();
                nativeJavaPath = this.fileSystem.canonicalize(javaPath).toString();
                $this$map$iv = patchCommand;
                $i$f$map = false;
                var14_29 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var19_39 = (String)item$iv$iv;
                    var21_42 = destination$iv$iv;
                    $i$a$-map-PatchingStateWorker$applyPatch$processedCommand$1 = false;
                    var21_42.add(StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"%JAVA_PATH%", (String)nativeJavaPath, (boolean)false, (int)4, null), (String)"%PATCH_FILE%", (String)nativePatchFilePath, (boolean)false, (int)4, null), (String)"%INSTALL_DIRECTORY%", (String)nativeInstallDirFilePath, (boolean)false, (int)4, null));
                }
                processedCommand = (List)destination$iv$iv;
                executableName = (String)CollectionsKt.first((List)processedCommand);
                it = destination$iv$iv = Path.Companion.get$default((Path.Companion)Path.Companion, (String)executableName, (boolean)false, (int)1, null);
                $i$a$-takeIf-PatchingStateWorker$applyPatch$executable$1 = false;
                v0 = this.fileSystem.exists((Path)it) != false ? destination$iv$iv : null;
                if (v0 == null && (v0 = this.shellEnvironment.findExecutable(executableName)) == null) {
                    ErrorsHelperKt.errorResult$default("Can't find patch command " + executableName, null, 2, null);
                    throw new KotlinNothingValueException();
                }
                executable /* !! */  = v0;
                args = CollectionsKt.drop((Iterable)processedCommand, (int)1);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)baseImage);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)directory);
                $continuation.L$2 = patch;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)patchFile);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)patchCommand);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)javaPath);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)nativePatchFilePath);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)nativeInstallDirFilePath);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)nativeJavaPath);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)processedCommand);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)executableName);
                $continuation.L$11 = executable /* !! */ ;
                $continuation.L$12 = args;
                $continuation.label = 1;
                v1 = YieldKt.yield((Continuation)$continuation);
                if (v1 == var24_8) {
                    return var24_8;
                }
                ** GOTO lbl95
            }
            case 1: {
                args = (List)$continuation.L$12;
                executable /* !! */  = (Path)$continuation.L$11;
                executableName = (String)$continuation.L$10;
                processedCommand = (List)$continuation.L$9;
                nativeJavaPath = (String)$continuation.L$8;
                nativeInstallDirFilePath = (String)$continuation.L$7;
                nativePatchFilePath = (String)$continuation.L$6;
                javaPath = (Path)$continuation.L$5;
                patchCommand = (List)$continuation.L$4;
                patchFile = (Path)$continuation.L$3;
                patch = (ToolPatch)$continuation.L$2;
                directory = (Path)$continuation.L$1;
                baseImage = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl95:
                // 2 sources

                stopWordDetected = new Ref.BooleanRef();
                errorMessagePrefix$iv = "Failed to apply " + patch;
                $i$f$wrapError = false;
                try {
                    $i$a$-wrapError-PatchingStateWorker$applyPatch$2 = false;
                    ProcessRunner.executeProcessAndWait-B8UsjHI$default((ProcessRunner)Processes.INSTANCE, executable /* !! */ , args, executable /* !! */ .parent(), (ProcessOutputHandler)LoggingKt.logOutput((ProcessOutputHandler.ReadLineByLine)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)V, applyPatch$lambda$3$0(com.jetbrains.toolbox.managers.PatchingStateWorker com.jetbrains.toolbox.tools.model.ToolPatch kotlin.jvm.internal.Ref$BooleanRef java.lang.String ), (Ljava/lang/String;)V)((PatchingStateWorker)this, (ToolPatch)patch, (Ref.BooleanRef)stopWordDetected)), (ProcessOutputHandler)LoggingKt.logOutput((ProcessOutputHandler.ReadLineByLine)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)V, applyPatch$lambda$3$1(com.jetbrains.toolbox.managers.PatchingStateWorker com.jetbrains.toolbox.tools.model.ToolPatch kotlin.jvm.internal.Ref$BooleanRef java.lang.String ), (Ljava/lang/String;)V)((PatchingStateWorker)this, (ToolPatch)patch, (Ref.BooleanRef)stopWordDetected)), null, 0L, 96, null);
                    var19_39 = Unit.INSTANCE;
                }
                catch (Throwable t$iv) {
                    ErrorsHelperKt.errorResult(errorMessagePrefix$iv + ": " + t$iv.getMessage(), t$iv);
                    throw new KotlinNothingValueException();
                }
                Logger.INSTANCE.debug("Patch " + patch + " application process finished");
                if (stopWordDetected.element) {
                    ErrorsHelperKt.errorResult$default("Patch process failed with a stop word", null, 2, null);
                    throw new KotlinNothingValueException();
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)baseImage);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)directory);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)patch);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)patchFile);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)patchCommand);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)javaPath);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)nativePatchFilePath);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)nativeInstallDirFilePath);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)nativeJavaPath);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)processedCommand);
                $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)executableName);
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)executable /* !! */ );
                $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)args);
                $continuation.L$13 = SpillingKt.nullOutSpilledVariable((Object)stopWordDetected);
                $continuation.label = 2;
                v2 = YieldKt.yield((Continuation)$continuation);
                if (v2 == var24_8) {
                    return var24_8;
                }
                ** GOTO lbl150
            }
            case 2: {
                stopWordDetected = (Ref.BooleanRef)$continuation.L$13;
                args = (List)$continuation.L$12;
                executable = (Path)$continuation.L$11;
                executableName = (String)$continuation.L$10;
                processedCommand = (List)$continuation.L$9;
                nativeJavaPath = (String)$continuation.L$8;
                nativeInstallDirFilePath = (String)$continuation.L$7;
                nativePatchFilePath = (String)$continuation.L$6;
                javaPath = (Path)$continuation.L$5;
                patchCommand = (List)$continuation.L$4;
                patchFile = (Path)$continuation.L$3;
                patch = (ToolPatch)$continuation.L$2;
                directory = (Path)$continuation.L$1;
                baseImage = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl150:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final List<String> assertStopWords(ToolPatch item2, StopWordsStream stream) {
        List list2 = switch (WhenMappings.$EnumSwitchMapping$0[stream.ordinal()]) {
            case 1 -> {
                Object v0 = item2.getAsserts();
                if (v0 != null && (v0 = ((PatchAsserts)v0).getStopwords()) != null) {
                    yield ((PatchAssertsStopwords)v0).getStderr();
                }
                yield null;
            }
            case 2 -> {
                Object v2 = item2.getAsserts();
                if (v2 != null && (v2 = ((PatchAsserts)v2).getStopwords()) != null) {
                    yield ((PatchAssertsStopwords)v2).getStdout();
                }
                yield null;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        List list3 = list2;
        if (list2 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    private final Function1<String, Unit> stopWordsFilter(ToolPatch patch, StopWordsStream stream, Function0<Unit> stopWordDetected) {
        List<String> stopWords = this.assertStopWords(patch, stream);
        if (stopWords.isEmpty()) {
            return PatchingStateWorker::stopWordsFilter$lambda$0;
        }
        Object commonRegex = "";
        for (String word : stopWords) {
            if (!(((CharSequence)commonRegex).length() == 0)) {
                commonRegex = (String)commonRegex + "|";
            }
            commonRegex = (String)commonRegex + "(" + word + ")";
        }
        Logger.INSTANCE.debug("Expression " + stream + " " + (String)commonRegex);
        Regex expression = new Regex((String)commonRegex, RegexOption.IGNORE_CASE);
        return arg_0 -> PatchingStateWorker.stopWordsFilter$lambda$1(expression, stopWordDetected, arg_0);
    }

    private final Path resolveJavaPath(ToolInstance baseImage) {
        Path resolved;
        Path javaPathRaw = baseImage.getTool().getJavaPath();
        if (javaPathRaw != null && this.fileSystem.exists(resolved = Path.resolve$default((Path)baseImage.getChannel().getInstallationDirectory(), (Path)javaPathRaw, (boolean)false, (int)2, null))) {
            return resolved;
        }
        Path javaPathActual = this.findJava(baseImage.getChannel().getInstallationDirectory());
        if (javaPathActual == null || !this.fileSystem.exists(javaPathActual)) {
            throw new IllegalStateException("Patch failed. JRE not found".toString());
        }
        return javaPathActual;
    }

    private final Path findJava(Path path2) {
        String filename = OS.INSTANCE.isWindows() ? "java.exe" : "java";
        return (Path)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)this.fileSystem.listRecursively(path2), arg_0 -> PatchingStateWorker.findJava$lambda$0(filename, this, arg_0)));
    }

    private static final void applyPatch$lambda$3$0(PatchingStateWorker this$0, ToolPatch $patch, Ref.BooleanRef $stopWordDetected, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.stopWordsFilter($patch, StopWordsStream.STDOUT, (Function0<Unit>)((Function0)() -> PatchingStateWorker.applyPatch$lambda$3$0$0($stopWordDetected)));
    }

    private static final Unit applyPatch$lambda$3$0$0(Ref.BooleanRef $stopWordDetected) {
        $stopWordDetected.element = true;
        return Unit.INSTANCE;
    }

    private static final void applyPatch$lambda$3$1(PatchingStateWorker this$0, ToolPatch $patch, Ref.BooleanRef $stopWordDetected, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.stopWordsFilter($patch, StopWordsStream.STDERR, (Function0<Unit>)((Function0)() -> PatchingStateWorker.applyPatch$lambda$3$1$0($stopWordDetected)));
    }

    private static final Unit applyPatch$lambda$3$1$0(Ref.BooleanRef $stopWordDetected) {
        $stopWordDetected.element = true;
        return Unit.INSTANCE;
    }

    private static final Unit stopWordsFilter$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit stopWordsFilter$lambda$1(Regex $expression, Function0 $stopWordDetected, String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if ($expression.containsMatchIn((CharSequence)msg)) {
            $stopWordDetected.invoke();
            Logger.INSTANCE.warn("Detected stop word in patcher process output: " + msg);
        }
        return Unit.INSTANCE;
    }

    private static final boolean findJava$lambda$0(String $filename, PatchingStateWorker this$0, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.name(), (Object)$filename) && this$0.fileSystem.metadata(it).isRegularFile();
    }

    public static final /* synthetic */ Object access$applyPatch(PatchingStateWorker $this, ToolInstance baseImage, Path directory, ToolPatch patch, Path patchFile, Continuation $completion) {
        return $this.applyPatch(baseImage, directory, patch, patchFile, (Continuation<? super Unit>)$completion);
    }

    private static final class StopWordsStream
    extends Enum<StopWordsStream> {
        public static final /* enum */ StopWordsStream STDOUT = new StopWordsStream();
        public static final /* enum */ StopWordsStream STDERR = new StopWordsStream();
        private static final /* synthetic */ StopWordsStream[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static StopWordsStream[] values() {
            return (StopWordsStream[])$VALUES.clone();
        }

        static {
            $VALUES = stopWordsStreamArray = new StopWordsStream[]{StopWordsStream.STDOUT, StopWordsStream.STDERR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StopWordsStream.values().length];
            try {
                nArray[StopWordsStream.STDERR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StopWordsStream.STDOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

