/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okio.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class CancellingPendingUpdateStateWorker
implements ChannelStateWorker<ChannelState.CancellingPendingUpdate> {
    @NotNull
    private final FileSystem fileSystem;

    public CancellingPendingUpdateStateWorker(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @NotNull
    public KClass<ChannelState.CancellingPendingUpdate> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.CancellingPendingUpdate.class);
    }

    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.CancellingPendingUpdate state2, @NotNull Continuation<? super ChannelEvent> $completion) {
        try {
            this.fileSystem.deleteRecursively(state2.getDirectory());
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Cannot remove " + state2.getDirectory());
        }
        return new ChannelEvent.Completed(state2.getChannel(), state2.getTool());
    }
}

