/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.managers;

import com.jetbrains.toolbox.common.filesystem.WorkingCopy;
import com.jetbrains.toolbox.filesystem.WorkingCopyManager;
import com.jetbrains.toolbox.tools.ChannelStateWorker;
import com.jetbrains.toolbox.tools.model.ChannelEvent;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class CancelingInstantUpdateStateWorker
implements ChannelStateWorker<ChannelState.CancelingInstantUpdate> {
    @NotNull
    private final WorkingCopyManager workingCopyManager;

    public CancelingInstantUpdateStateWorker(@NotNull WorkingCopyManager workingCopyManager) {
        Intrinsics.checkNotNullParameter((Object)workingCopyManager, (String)"workingCopyManager");
        this.workingCopyManager = workingCopyManager;
    }

    @Override
    @NotNull
    public KClass<ChannelState.CancelingInstantUpdate> getState() {
        return Reflection.getOrCreateKotlinClass(ChannelState.CancelingInstantUpdate.class);
    }

    @Override
    @Nullable
    public Object handle(@NotNull ChannelState.CancelingInstantUpdate state2, @NotNull Continuation<? super ChannelEvent> $completion) {
        Logger.INSTANCE.info("Canceling instant update for " + InstalledToolKt.displayNameWithVersion(state2.getChannel(), state2.getTool()));
        Path unpackedToolDirectory = state2.getUnpackedToolDirectory();
        for (WorkingCopy workingCopy : state2.getWorkingCopies()) {
            if (Intrinsics.areEqual((Object)workingCopy.getPath(), (Object)unpackedToolDirectory)) continue;
            Logger.INSTANCE.debug("Dropping '" + workingCopy.getPath() + "'");
            this.workingCopyManager.discardChanges(workingCopy);
        }
        return unpackedToolDirectory != null ? (ChannelEvent)new ChannelEvent.Unpacked(unpackedToolDirectory) : (ChannelEvent)new ChannelEvent.InstallFailed(state2.getReason());
    }
}

