/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.manager;

import com.jetbrains.toolbox.BuildNumber;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract sealed class ToolboxVersionUpdateDialog {
    private ToolboxVersionUpdateDialog() {
    }

    public /* synthetic */ ToolboxVersionUpdateDialog(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class RestrictedVersion
    extends ToolboxVersionUpdateDialog {
        @NotNull
        private final Instant deadline;
        @NotNull
        private final String message;

        public RestrictedVersion(@NotNull Instant deadline, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)deadline, (String)"deadline");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            super(null);
            this.deadline = deadline;
            this.message = message2;
        }

        @NotNull
        public final Instant getDeadline() {
            return this.deadline;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public String toString() {
            return "RestrictedVersion(deadline=" + this.deadline + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result2 = this.deadline.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RestrictedVersion)) {
                return false;
            }
            RestrictedVersion restrictedVersion = (RestrictedVersion)other;
            if (!Intrinsics.areEqual((Object)this.deadline, (Object)restrictedVersion.deadline)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)restrictedVersion.message);
        }
    }

    public static final class UnsupportedVersion
    extends ToolboxVersionUpdateDialog {
        @NotNull
        private final String minimumSupportedVersion;

        private UnsupportedVersion(String minimumSupportedVersion) {
            Intrinsics.checkNotNullParameter((Object)minimumSupportedVersion, (String)"minimumSupportedVersion");
            super(null);
            this.minimumSupportedVersion = minimumSupportedVersion;
        }

        @NotNull
        public String toString() {
            return "UnsupportedVersion(minimumSupportedVersion=" + BuildNumber.toString-impl(this.minimumSupportedVersion) + ")";
        }

        public int hashCode() {
            return BuildNumber.hashCode-impl(this.minimumSupportedVersion);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UnsupportedVersion)) {
                return false;
            }
            UnsupportedVersion unsupportedVersion = (UnsupportedVersion)other;
            return BuildNumber.equals-impl0(this.minimumSupportedVersion, unsupportedVersion.minimumSupportedVersion);
        }

        public /* synthetic */ UnsupportedVersion(String minimumSupportedVersion, DefaultConstructorMarker $constructor_marker) {
            this(minimumSupportedVersion);
        }
    }
}

