/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.jbclient.clientLink;

import com.jetbrains.toolbox.AppRestartInhibitor;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.common.extensions.URIExtensionsKt;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.jbclient.JBClientManager;
import com.jetbrains.toolbox.jbclient.JBClientManagerImpl;
import com.jetbrains.toolbox.jbclient.clientLink.JBClientConnectionHandle;
import com.jetbrains.toolbox.jbclient.clientLink.JBClientConnectionHandleImpl;
import com.jetbrains.toolbox.jbclient.clientLink.JBClientConnectionHandleManager;
import com.jetbrains.toolbox.jbclient.clientLink.JBClientCreationInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nJBClientConnectionHandleManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBClientConnectionHandleManagerImpl.kt\ncom/jetbrains/toolbox/jbclient/clientLink/JBClientConnectionHandleManagerImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,82:1\n216#2,2:83\n*S KotlinDebug\n*F\n+ 1 JBClientConnectionHandleManagerImpl.kt\ncom/jetbrains/toolbox/jbclient/clientLink/JBClientConnectionHandleManagerImpl\n*L\n48#1:83,2\n*E\n"})
public final class JBClientConnectionHandleManagerImpl
implements JBClientConnectionHandleManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JBClientManager clientManager;
    @NotNull
    private final TimeSource clock;
    @NotNull
    private final ProcessRunner processRunner;
    @NotNull
    private final Path logPath;
    @NotNull
    private final AppRestartInhibitor appRestartInhibitor;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<String, JBClientConnectionHandle> knownClients;
    private static final long TIMEOUT = DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS);

    public JBClientConnectionHandleManagerImpl(@NotNull JBClientManager clientManager, @NotNull TimeSource clock, @NotNull ProcessRunner processRunner, @NotNull Path logPath, @NotNull AppRestartInhibitor appRestartInhibitor, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)clientManager, (String)"clientManager");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)processRunner, (String)"processRunner");
        Intrinsics.checkNotNullParameter((Object)logPath, (String)"logPath");
        Intrinsics.checkNotNullParameter((Object)appRestartInhibitor, (String)"appRestartInhibitor");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.clientManager = clientManager;
        this.clock = clock;
        this.processRunner = processRunner;
        this.logPath = logPath;
        this.appRestartInhibitor = appRestartInhibitor;
        this.coroutineScope = coroutineScope;
        this.knownClients = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public JBClientConnectionHandle createConnectionHandle(@NotNull JBClientCreationInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!(BuildNumber.compareTo-Szkhn3Q(info.getVersion().getBuild-Y_E1uuk(), JBClientManagerImpl.Companion.getClientVersionWithProcessPerConnectionSupport-Y_E1uuk$jbclient()) >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        JBClientConnectionHandleImpl clientHandle = new JBClientConnectionHandleImpl(info.getUid(), info.getLocalAgentConnectionUri(), info.getBackendConnectionUri(), info.getVersion(), this.clientManager, this.coroutineScope, TIMEOUT, this.clock, this.processRunner, this.logPath, null);
        this.registerClientHandle(info.getUid(), clientHandle);
        return clientHandle;
    }

    @Override
    @Nullable
    public JBClientConnectionHandle findConnectionByFingerprint(@Nullable String fingerprint) {
        if (fingerprint == null) {
            return null;
        }
        Map $this$forEach$iv = this.knownClients;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)URIExtensionsKt.parseFragment(((JBClientConnectionHandle)it.getValue()).getCurrentJoinLink()).get("fp"), (Object)fingerprint)) continue;
            return (JBClientConnectionHandle)it.getValue();
        }
        return null;
    }

    private final void registerClientHandle(String uid2, JBClientConnectionHandle handle2) {
        ((Map)this.knownClients).put(uid2, handle2);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(handle2, this, uid2, null){
            Object L$0;
            int label;
            final /* synthetic */ JBClientConnectionHandle $handle;
            final /* synthetic */ JBClientConnectionHandleManagerImpl this$0;
            final /* synthetic */ String $uid;
            {
                this.$handle = $handle;
                this.this$0 = $receiver;
                this.$uid = $uid;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        AppRestartInhibitor.BlockOwner.ActiveConnection blocker = new AppRestartInhibitor.BlockOwner.ActiveConnection(this.$handle);
                        JBClientConnectionHandleManagerImpl.access$getAppRestartInhibitor$p(this.this$0).preventRestart(blocker);
                        this.L$0 = blocker;
                        this.label = 1;
                        Object object2 = this.$handle.awaitClose((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        AppRestartInhibitor.BlockOwner.ActiveConnection blocker = (AppRestartInhibitor.BlockOwner.ActiveConnection)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            JBClientConnectionHandleManagerImpl.access$getAppRestartInhibitor$p(this.this$0).enableRestart(blocker);
                            JBClientConnectionHandleManagerImpl.access$unregisterClientHandle(this.this$0, this.$uid);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void unregisterClientHandle(String uid2) {
        this.knownClients.remove(uid2);
    }

    @Override
    @Nullable
    public JBClientConnectionHandle getConnectionHandle(@Nullable String uid2) {
        if (uid2 == null) {
            return null;
        }
        return this.knownClients.get(uid2);
    }

    public static final /* synthetic */ AppRestartInhibitor access$getAppRestartInhibitor$p(JBClientConnectionHandleManagerImpl $this) {
        return $this.appRestartInhibitor;
    }

    public static final /* synthetic */ void access$unregisterClientHandle(JBClientConnectionHandleManagerImpl $this, String uid2) {
        $this.unregisterClientHandle(uid2);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

