/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop.processes;

import com.jetbrains.toolbox.interop.LoggingKt;
import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.interop.processes.ProcessOutputDecoder;
import com.jetbrains.toolbox.interop.processes.ProcessesRunnerBlockingKt;
import com.jetbrains.toolbox.interop.processes.ReadResult;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.tinylog.kotlin.Logger;

public final class ProcessesRunnerUtil {
    @NotNull
    public static final ProcessesRunnerUtil INSTANCE = new ProcessesRunnerUtil();

    private ProcessesRunnerUtil() {
    }

    @NotNull
    public final Thread thread(@NotNull String processName, @NotNull String threadName, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Semaphore readerStarted = new Semaphore(0);
        Thread thread2 = ThreadsKt.thread$default((boolean)true, (boolean)true, null, (String)(processName + "-" + threadName), (int)0, () -> ProcessesRunnerUtil.thread$lambda$0(readerStarted, processName, threadName, action), (int)20, null);
        try {
            readerStarted.acquire();
        }
        catch (InterruptedException e) {
            Logger.INSTANCE.warn((Throwable)e, "Process " + processName + " interrupted waiting for reader thread to start. " + e.getMessage());
            thread2.interrupt();
        }
        return thread2;
    }

    @NotNull
    public final Thread readThread(@NotNull Charset charset, @NotNull String processName, @NotNull String threadName, @NotNull Process process2, @NotNull Function1<? super Process, ? extends InputStream> processStream, @NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter(processStream, (String)"processStream");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.thread(processName, threadName, (Function0<Unit>)((Function0)() -> ProcessesRunnerUtil.readThread$lambda$0(charset, callback, processStream, process2)));
    }

    @NotNull
    public final Function1<String, Unit> safeHandler(@NotNull String processName, @NotNull Function1<? super String, Unit> anotherHandler) {
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter(anotherHandler, (String)"anotherHandler");
        return arg_0 -> ProcessesRunnerUtil.safeHandler$lambda$0(anotherHandler, processName, arg_0);
    }

    public final void setUpIORedirection(@NotNull ProcessBuilder builder, @NotNull ProcessOutputHandler onOutput, @NotNull ProcessOutputHandler onError) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)onOutput, (String)"onOutput");
        Intrinsics.checkNotNullParameter((Object)onError, (String)"onError");
        ProcessOutputHandler processOutputHandler = onOutput;
        if (processOutputHandler instanceof ProcessOutputHandler.Discard) {
            v0 = builder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        } else if (processOutputHandler instanceof ProcessOutputHandler.ReadLineByLine) {
            v0 = builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        } else if (processOutputHandler instanceof ProcessOutputHandler.RedirectToFile) {
            v0 = builder.redirectOutput(ProcessBuilder.Redirect.to(((ProcessOutputHandler.RedirectToFile)onOutput).getFile().toFile()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        processOutputHandler = onError;
        if (processOutputHandler instanceof ProcessOutputHandler.Discard) {
            v1 = builder.redirectError(ProcessBuilder.Redirect.DISCARD);
        } else if (processOutputHandler instanceof ProcessOutputHandler.ReadLineByLine) {
            v1 = builder.redirectError(ProcessBuilder.Redirect.PIPE);
        } else if (processOutputHandler instanceof ProcessOutputHandler.RedirectToFile) {
            v1 = builder.redirectError(ProcessBuilder.Redirect.to(((ProcessOutputHandler.RedirectToFile)onError).getFile().toFile()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        builder.redirectErrorStream(false);
    }

    private static final Unit thread$lambda$0(Semaphore $readerStarted, String $processName, String $threadName, Function0 $action) {
        block2: {
            try {
                $readerStarted.release();
                LoggingKt.withProcessLoggingContext($processName, $threadName, (Function0<Unit>)((Function0)() -> ProcessesRunnerUtil.thread$lambda$0$0($action)));
            }
            catch (Throwable t2) {
                if (t2 instanceof InterruptedException) break block2;
                Logger.INSTANCE.error(t2, "Unhandled exception in process thread " + $processName + ", " + $threadName + ". " + t2.getMessage());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit thread$lambda$0$0(Function0 $action) {
        $action.invoke();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit readThread$lambda$0(Charset $charset, Function1 $callback, Function1 $processStream, Process $process) {
        CharBuffer charBuffer = CharBuffer.allocate(16384);
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"allocate(...)");
        ProcessOutputDecoder decoder = new ProcessOutputDecoder($charset, charBuffer, (Function1<? super String, Unit>)$callback);
        ByteBuffer buff = ByteBuffer.allocate(32768);
        Closeable closeable = (Closeable)$processStream.invoke((Object)$process);
        Throwable throwable = null;
        try {
            InputStream processStream = (InputStream)closeable;
            boolean bl = false;
            int tooQuietHappen = 0;
            try {
                while ($process.isAlive() && !Thread.currentThread().isInterrupted()) {
                    Intrinsics.checkNotNull((Object)buff);
                    switch (WhenMappings.$EnumSwitchMapping$0[ProcessesRunnerBlockingKt.readAvailableByteBuffer(processStream, buff).ordinal()]) {
                        case 1: {
                            ++tooQuietHappen;
                            $process.waitFor(100L, TimeUnit.MILLISECONDS);
                            break;
                        }
                        case 2: {
                            tooQuietHappen = 0;
                            decoder.decode(buff);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    if (tooQuietHappen <= 5) continue;
                    tooQuietHappen = 0;
                    decoder.force();
                }
                while (true) {
                    Intrinsics.checkNotNull((Object)buff);
                    ReadResult result2 = ProcessesRunnerBlockingKt.readToEnd(processStream, buff);
                    if (result2 == ReadResult.NOT_AVAILABLE) break;
                    decoder.decode(buff);
                }
                decoder.end(buff);
            }
            catch (Throwable throwable2) {
                Intrinsics.checkNotNull((Object)buff);
                decoder.end(buff);
                throw throwable2;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final Unit safeHandler$lambda$0(Function1 $anotherHandler, String $processName, String lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        try {
            $anotherHandler.invoke((Object)lines);
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Process `" + $processName + "`: stdout handler failed, skipping.");
        }
        return Unit.INSTANCE;
    }

    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadResult.values().length];
            try {
                nArray[ReadResult.NOT_AVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadResult.NEW_DATA_ARRIVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

