/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop.processes;

import com.jetbrains.toolbox.ErrorsHelperKt;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.interop.ProcessOutputHandler;
import com.jetbrains.toolbox.interop.RunAsMode;
import com.jetbrains.toolbox.interop.Win32Integration;
import com.jetbrains.toolbox.interop.processes.ProcessRunnerEnvironment;
import com.jetbrains.toolbox.interop.processes.ProcessesRunnerUtil;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.KotlinNothingValueException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nProcessesRunnerFork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessesRunnerFork.kt\ncom/jetbrains/toolbox/interop/processes/ProcessesRunnerFork\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,93:1\n37#2,2:94\n*S KotlinDebug\n*F\n+ 1 ProcessesRunnerFork.kt\ncom/jetbrains/toolbox/interop/processes/ProcessesRunnerFork\n*L\n34#1:94,2\n*E\n"})
public final class ProcessesRunnerFork {
    @NotNull
    public static final ProcessesRunnerFork INSTANCE = new ProcessesRunnerFork();
    @NotNull
    private static final AtomicLong processCounter = new AtomicLong(42L);

    private ProcessesRunnerFork() {
    }

    @Nullable
    public final Process forkProcessNoWait(@NotNull File path2, @NotNull List<String> arguments, @Nullable File workingDir, @NotNull Map<String, String> additionalEnvironment, @NotNull ProcessOutputHandler onOutput, @NotNull ProcessOutputHandler onError) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(additionalEnvironment, (String)"additionalEnvironment");
        Intrinsics.checkNotNullParameter((Object)onOutput, (String)"onOutput");
        Intrinsics.checkNotNullParameter((Object)onError, (String)"onError");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        Logger.INSTANCE.info("Executing '" + path2 + "' with " + arguments);
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ProcessRunnerEnvironment.INSTANCE.prepareUserEnvironment(builder, com.jetbrains.toolbox.common.platform.OS.INSTANCE.getType(), additionalEnvironment);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)path2.getPath());
        Object $this$toTypedArray$iv = arguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        builder.command((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
        builder.directory(workingDir);
        ProcessesRunnerUtil.INSTANCE.setUpIORedirection(builder, onOutput, onError);
        try {
            $this$toTypedArray$iv = builder.start();
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to start process " + path2 + " with " + arguments + ". " + t2.getMessage());
            ErrorsHelperKt.errorResult$default("Creating process failed", null, 2, null);
            throw new KotlinNothingValueException();
        }
        Object process2 = $this$toTypedArray$iv;
        String processName = "[" + path2.getName() + "]-" + processCounter.getAndIncrement();
        Charset charset = OS.INSTANCE.getSystemCharset();
        if (onOutput instanceof ProcessOutputHandler.ReadLineByLine) {
            Intrinsics.checkNotNull((Object)process2);
            ProcessesRunnerUtil.INSTANCE.readThread(charset, processName, "stdout", (Process)process2, (Function1<? super Process, ? extends InputStream>)((Function1)ProcessesRunnerFork::forkProcessNoWait$lambda$0), ProcessesRunnerUtil.INSTANCE.safeHandler(processName, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)onOutput){

                public final void invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((ProcessOutputHandler.ReadLineByLine)this.receiver).read(p0);
                }
            })));
        }
        if (onError instanceof ProcessOutputHandler.ReadLineByLine) {
            Intrinsics.checkNotNull((Object)process2);
            ProcessesRunnerUtil.INSTANCE.readThread(charset, processName, "stderr", (Process)process2, (Function1<? super Process, ? extends InputStream>)((Function1)ProcessesRunnerFork::forkProcessNoWait$lambda$1), ProcessesRunnerUtil.INSTANCE.safeHandler(processName, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)onError){

                public final void invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((ProcessOutputHandler.ReadLineByLine)this.receiver).read(p0);
                }
            })));
        }
        ((Process)process2).getOutputStream().close();
        Logger.INSTANCE.info("Process '" + path2 + "' with " + arguments + " successfully started with PID: " + ((Process)process2).pid());
        return process2;
    }

    @Nullable
    public final ProcessHandle forkProcessNoWait(@NotNull File path2, @NotNull List<String> arguments, @Nullable File workingDir, @NotNull Map<String, String> additionalEnvironment, @NotNull RunAsMode runAs, @NotNull ProcessOutputHandler onOutput, @NotNull ProcessOutputHandler onError) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(additionalEnvironment, (String)"additionalEnvironment");
        Intrinsics.checkNotNullParameter((Object)((Object)runAs), (String)"runAs");
        Intrinsics.checkNotNullParameter((Object)onOutput, (String)"onOutput");
        Intrinsics.checkNotNullParameter((Object)onError, (String)"onError");
        ThreadGuardKt.assertNotMainThread$default(null, 1, null);
        if (runAs == RunAsMode.RunAsAdministrator) {
            if (!com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows()) {
                ErrorsHelperKt.errorResult$default("Run As Administrator is not supported on non-Windows OS", null, 2, null);
                throw new KotlinNothingValueException();
            }
            if (!(onOutput instanceof ProcessOutputHandler.Discard) || !(onError instanceof ProcessOutputHandler.Discard)) {
                ErrorsHelperKt.errorResult$default("Applying process output handlers for processes run as administrator is not supported", null, 2, null);
                throw new KotlinNothingValueException();
            }
            Logger.INSTANCE.debug("Running under elevation " + path2 + " " + arguments + " in " + workingDir);
            File file = workingDir;
            if (file == null) {
                file = path2.getParentFile();
            }
            File file2 = file;
            Intrinsics.checkNotNull((Object)file2);
            return Win32Integration.INSTANCE.runProcessElevated(path2, arguments, file2);
        }
        Process process2 = this.forkProcessNoWait(path2, arguments, workingDir, additionalEnvironment, onOutput, onError);
        if (process2 == null) {
            return null;
        }
        Process process3 = process2;
        return process3.toHandle();
    }

    private static final InputStream forkProcessNoWait$lambda$0(Process $this$readThread) {
        Intrinsics.checkNotNullParameter((Object)$this$readThread, (String)"$this$readThread");
        InputStream inputStream = $this$readThread.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return inputStream;
    }

    private static final InputStream forkProcessNoWait$lambda$1(Process $this$readThread) {
        Intrinsics.checkNotNullParameter((Object)$this$readThread, (String)"$this$readThread");
        InputStream inputStream = $this$readThread.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
        return inputStream;
    }
}

