/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.StandardPathsKt;
import com.jetbrains.toolbox.common.Win32ArgumentHelper;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.io.FileExtensionsKt;
import com.jetbrains.toolbox.interop.NativeInteropWin32;
import com.jetbrains.toolbox.interop.Pid;
import com.jetbrains.toolbox.interop.Win32Processes;
import com.jetbrains.toolbox.interop.Win32Psapi;
import com.jetbrains.toolbox.interop.Win32Registry;
import com.jetbrains.toolbox.interop.Win32Userenv;
import com.jetbrains.toolbox.platform.image.ImageType;
import com.jetbrains.toolbox.platform.image.internal.ImageData;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShellAPI;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;
import sun.awt.shell.ShellFolder;

@SourceDebugExtension(value={"SMAP\nWin32Integration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Win32Integration.kt\ncom/jetbrains/toolbox/interop/Win32Integration\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,532:1\n1#2:533\n1#2:544\n1617#3,9:534\n1869#3:543\n1870#3:545\n1626#3:546\n1669#3,8:547\n*S KotlinDebug\n*F\n+ 1 Win32Integration.kt\ncom/jetbrains/toolbox/interop/Win32Integration\n*L\n449#1:544\n449#1:534,9\n449#1:543\n449#1:545\n449#1:546\n461#1:547,8\n*E\n"})
public final class Win32Integration
implements Win32Processes {
    @NotNull
    public static final Win32Integration INSTANCE = new Win32Integration();
    @NotNull
    private static final Set<Character> argumentDelimiters;
    private static final int SW_SHOWNORMAL;
    @NotNull
    private static final List<String> preserveSystemEnvironmentVars;
    @NotNull
    private static final String startMenuLnkFileName;
    @NotNull
    public static final String UNINSTALL_REGISTRY_PATH = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall";
    @NotNull
    public static final String AUTORUN_REGISTRY_PATH = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run";
    @NotNull
    public static final String AUTORUN_REGISTRY_ENTRY_NAME = "JetBrains Toolbox";

    private Win32Integration() {
    }

    @NotNull
    public final String convertArgListToString(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, Win32Integration::convertArgListToString$lambda$0, (int)30, null);
    }

    @NotNull
    public final List<String> convertStringToArgList(@NotNull String commandLine) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        List $this$convertStringToArgList_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        boolean isInsideQuotes = false;
        Ref.IntRef backslashes = new Ref.IntRef();
        Ref.BooleanRef emptyArgumentAdded = new Ref.BooleanRef();
        StringBuilder argument = new StringBuilder();
        int n = commandLine.length();
        block4: for (int j = 0; j < n; ++j) {
            char ch = commandLine.charAt(j);
            switch (ch) {
                case '\\': {
                    int n2 = backslashes.element;
                    backslashes.element = n2 + 1;
                    continue block4;
                }
                case '\"': {
                    boolean isQuoteEscaped = backslashes.element % 2 == 1;
                    Win32Integration.convertStringToArgList$lambda$0$flushBackslashes(backslashes, argument, backslashes.element / 2);
                    if (isQuoteEscaped) {
                        argument.append('\"');
                        continue block4;
                    }
                    isInsideQuotes = !isInsideQuotes;
                    emptyArgumentAdded.element = false;
                    continue block4;
                }
                default: {
                    Win32Integration.convertStringToArgList$lambda$0$flushBackslashes$default(backslashes, argument, 0, 4, null);
                    if (argumentDelimiters.contains(Character.valueOf(ch)) && !isInsideQuotes) {
                        Win32Integration.convertStringToArgList$lambda$0$storeArgument(argument, emptyArgumentAdded, $this$convertStringToArgList_u24lambda_u240);
                        continue block4;
                    }
                    argument.append(ch);
                }
            }
        }
        Win32Integration.convertStringToArgList$lambda$0$flushBackslashes$default(backslashes, argument, 0, 4, null);
        Win32Integration.convertStringToArgList$lambda$0$storeArgument(argument, emptyArgumentAdded, $this$convertStringToArgList_u24lambda_u240);
        return CollectionsKt.build((List)list2);
    }

    @Nullable
    public final ProcessHandle runProcessElevated(@NotNull File file, @NotNull List<String> parameters, @NotNull File workingDirectory) {
        ShellAPI.SHELLEXECUTEINFO sHELLEXECUTEINFO;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Logger.INSTANCE.info("Running elevated " + this.convertArgListToString(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)file.getPath()), (Iterable)parameters)) + " in " + workingDirectory);
        ShellAPI.SHELLEXECUTEINFO $this$runProcessElevated_u24lambda_u240 = sHELLEXECUTEINFO = new ShellAPI.SHELLEXECUTEINFO();
        boolean bl = false;
        $this$runProcessElevated_u24lambda_u240.lpVerb = "runas";
        $this$runProcessElevated_u24lambda_u240.lpFile = file.getPath();
        $this$runProcessElevated_u24lambda_u240.lpDirectory = workingDirectory.getPath();
        $this$runProcessElevated_u24lambda_u240.nShow = SW_SHOWNORMAL;
        $this$runProcessElevated_u24lambda_u240.lpParameters = INSTANCE.convertArgListToString(parameters);
        $this$runProcessElevated_u24lambda_u240.fMask = 64;
        ShellAPI.SHELLEXECUTEINFO execInfo = sHELLEXECUTEINFO;
        Shell32.INSTANCE.ShellExecuteEx(execInfo);
        WinNT.HANDLE hANDLE = execInfo.hProcess;
        if (hANDLE == null) {
            return null;
        }
        WinNT.HANDLE processHandle = hANDLE;
        if (Intrinsics.areEqual((Object)processHandle, (Object)WinBase.INVALID_HANDLE_VALUE) || Intrinsics.areEqual((Object)processHandle.getPointer(), (Object)Pointer.NULL)) {
            return null;
        }
        Optional<ProcessHandle> optional = ProcessHandle.of(Kernel32.INSTANCE.GetProcessId(processHandle));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        ProcessHandle processHandle2 = (ProcessHandle)OptionalsKt.getOrNull(optional);
        if (processHandle2 == null) {
            return null;
        }
        ProcessHandle handle2 = processHandle2;
        Kernel32.INSTANCE.CloseHandle(processHandle);
        return handle2;
    }

    @NotNull
    public final List<String> getPreserveSystemEnvironmentVars() {
        return preserveSystemEnvironmentVars;
    }

    private final int wcslen(Pointer ptr) {
        long len = 0L;
        while (ptr.getShort(len * (long)2) != 0) {
            long l = len;
            len = l + 1L;
        }
        return (int)len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> getEnvironmentBlock() {
        WinNT.HANDLEByReference openedProcessToken = new WinNT.HANDLEByReference();
        if (!Advapi32.INSTANCE.OpenProcessToken(Kernel32.INSTANCE.GetCurrentProcess(), 131080, openedProcessToken)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        PointerByReference ptrRef = new PointerByReference();
        Win32Userenv win32Userenv = Win32Userenv.Companion.getINSTANCE();
        WinNT.HANDLE hANDLE = openedProcessToken.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"getValue(...)");
        if (!win32Userenv.CreateEnvironmentBlock(ptrRef, hANDLE, false)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Map result2 = new LinkedHashMap();
        try {
            Pointer current = ptrRef.getValue();
            while (current.getShort(0L) != 0) {
                Pointer pointer = current;
                Intrinsics.checkNotNull((Object)pointer);
                int lenInChars = this.wcslen(pointer);
                byte[] bb = current.getByteArray(0L, lenInChars * 2);
                Intrinsics.checkNotNull((Object)bb);
                String s = new String(bb, Charsets.UTF_16LE);
                if (!StringsKt.contains$default((CharSequence)s, (char)'=', (boolean)false, (int)2, null)) {
                    Logger.INSTANCE.error("CreateEnvironmentBlock returned a string without '=': " + s);
                } else {
                    result2.put(StringsKt.substringBefore$default((String)s, (char)'=', null, (int)2, null), StringsKt.substringAfter$default((String)s, (char)'=', null, (int)2, null));
                }
                current = current.share((long)(lenInChars * 2 + 2));
            }
        }
        finally {
            try {
                Kernel32Util.closeHandleRef((WinNT.HANDLEByReference)openedProcessToken);
            }
            catch (Exception e) {
                Logger.INSTANCE.error((Throwable)e, "Can't closeHandleRef, skipping");
            }
            try {
                Win32Userenv win32Userenv2 = Win32Userenv.Companion.getINSTANCE();
                Pointer pointer = ptrRef.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"getValue(...)");
                if (!win32Userenv2.DestroyEnvironmentBlock(pointer)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
            }
            catch (Exception e) {
                Logger.INSTANCE.error((Throwable)e, "Can't destroy environment block, skipping");
            }
        }
        return result2;
    }

    @NotNull
    public final Map<String, String> getCurrentUserEnvironment() {
        Map result2 = MapsKt.toMutableMap(this.getEnvironmentBlock());
        Map<String, String> map2 = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getenv(...)");
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            String name2 = entry.getKey();
            String value2 = entry.getValue();
            if (!preserveSystemEnvironmentVars.contains(name2)) continue;
            result2.put(name2, value2);
        }
        return result2;
    }

    @Nullable
    public final String getExternalIconPathForExecutable(@NotNull String $this$getExternalIconPathForExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$getExternalIconPathForExecutable, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$getExternalIconPathForExecutable, (String)".bat", (boolean)false, (int)2, null) ? StringsKt.replaceAfterLast$default((String)$this$getExternalIconPathForExecutable, (char)'.', (String)"ico", null, (int)4, null) : null;
    }

    private final File getShortcutsDirectory() {
        Guid.GUID gUID = KnownFolders.FOLDERID_Programs;
        Intrinsics.checkNotNullExpressionValue((Object)gUID, (String)"FOLDERID_Programs");
        String string = StandardPathsKt.getKnownFolderPathOrNull(gUID);
        if (string == null) {
            string = "C:\\ProgramData\\Microsoft\\Windows\\Start Menu\\Programs";
        }
        return new File(string);
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureShortcut(@NotNull String lnkFileName, @NotNull String description2, @NotNull String lnkTarget) {
        Intrinsics.checkNotNullParameter((Object)lnkFileName, (String)"lnkFileName");
        Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        Intrinsics.checkNotNullParameter((Object)lnkTarget, (String)"lnkTarget");
        ThreadGuardKt.assertNotMainThread("java.io.File.exists()|mkdirs()");
        try {
            WString wString;
            File shortcutsDirectory = this.getShortcutsDirectory();
            File file = new File(lnkFileName);
            File lnkFile = file.exists() ? file : FileExtensionsKt.div(shortcutsDirectory, lnkFileName);
            LnkInfo lnkInfo = this.readShortcutTarget(lnkFile);
            if (lnkInfo != null && Intrinsics.areEqual((Object)lnkInfo.getTarget(), (Object)lnkTarget) && Intrinsics.areEqual((Object)lnkInfo.getDescription(), (Object)description2)) {
                return;
            }
            lnkFile.getParentFile().mkdirs();
            String icon2 = this.getExternalIconPathForExecutable(lnkTarget);
            NativeInteropWin32 nativeInteropWin32 = NativeInteropWin32.INSTANCE;
            WString wString2 = new WString(lnkFile.getAbsolutePath());
            WString wString3 = new WString(lnkTarget);
            String string = icon2;
            if (string != null) {
                void p0;
                String string2 = string;
                WString wString4 = wString3;
                WString wString5 = wString2;
                NativeInteropWin32 nativeInteropWin322 = nativeInteropWin32;
                boolean bl = false;
                WString wString6 = new WString((String)p0);
                nativeInteropWin32 = nativeInteropWin322;
                wString2 = wString5;
                wString3 = wString4;
                wString = wString6;
            } else {
                wString = null;
            }
            nativeInteropWin32.createLnkFile(wString2, wString3, wString, new WString(description2));
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to create shortcut to " + lnkTarget);
        }
    }

    public final void removeShortcut(@NotNull String lnkFileName) {
        Intrinsics.checkNotNullParameter((Object)lnkFileName, (String)"lnkFileName");
        ThreadGuardKt.assertNotMainThread("java.io.File.delete()");
        File shortcutsDirectory = this.getShortcutsDirectory();
        FileExtensionsKt.div(shortcutsDirectory, lnkFileName).delete();
    }

    @Nullable
    public final LnkInfo readShortcutTarget(@NotNull File lnkFile) {
        LnkInfo lnkInfo;
        Intrinsics.checkNotNullParameter((Object)lnkFile, (String)"lnkFile");
        ThreadGuardKt.assertNotMainThread("java.io.File.exists()");
        if (!lnkFile.exists()) {
            return null;
        }
        try {
            com.jetbrains.toolbox.interop.LnkInfo lnk = NativeInteropWin32.INSTANCE.readLnkFile(new WString(lnkFile.getAbsolutePath()));
            WString wString = lnk.target;
            String target = wString != null ? wString.toString() : null;
            Object object = lnk.description;
            if (object == null || (object = object.toString()) == null) {
                object = "no description";
            }
            Object description2 = object;
            NativeInteropWin32.INSTANCE.freeLnkInfo(lnk);
            CharSequence charSequence = target;
            lnkInfo = !(charSequence == null || charSequence.length() == 0) ? new LnkInfo(target, (String)description2) : null;
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to read shortcut to " + lnkFile);
            lnkInfo = null;
        }
        return lnkInfo;
    }

    public final void ensureStartMenuShortcut() {
        if (!com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows()) {
            return;
        }
        Path applicationExecutable = OS.INSTANCE.getApplicationExecutable();
        this.ensureShortcut(startMenuLnkFileName, "Launches JetBrains IDEs and allows opening projects via links. (version 3.0.0.59313)", applicationExecutable.toString());
    }

    public final void removeStartMenuShortcut() {
        this.removeShortcut(startMenuLnkFileName);
    }

    public final void ensureAutoRunEntry() {
        if (!com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows()) {
            return;
        }
        Path applicationExecutable = OS.INSTANCE.getApplicationExecutable();
        String entryValue = "\"" + applicationExecutable + "\" --minimize";
        String existingValue = Win32Integration.readRegValue$default(this, Win32Registry.Hive.HKCU.INSTANCE, AUTORUN_REGISTRY_PATH, AUTORUN_REGISTRY_ENTRY_NAME, false, 8, null);
        if (!Intrinsics.areEqual((Object)existingValue, (Object)entryValue)) {
            Win32Integration.writeRegValue$default(this, (Win32Registry.Hive)Win32Registry.Hive.HKCU.INSTANCE, AUTORUN_REGISTRY_PATH, AUTORUN_REGISTRY_ENTRY_NAME, entryValue, false, 16, null);
        }
    }

    public final void removeAutoRunEntry() {
        if (!com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows()) {
            return;
        }
        String existingValue = Win32Integration.readRegValue$default(this, Win32Registry.Hive.HKCU.INSTANCE, AUTORUN_REGISTRY_PATH, AUTORUN_REGISTRY_ENTRY_NAME, false, 8, null);
        CharSequence charSequence = existingValue;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.deleteRegValue(Win32Registry.Hive.HKCU.INSTANCE, AUTORUN_REGISTRY_PATH, AUTORUN_REGISTRY_ENTRY_NAME);
        }
    }

    private final WinReg.HKEY getHkey(Win32Registry.Hive $this$hkey) {
        WinReg.HKEY hKEY;
        Win32Registry.Hive hive = $this$hkey;
        if (Intrinsics.areEqual((Object)hive, (Object)Win32Registry.Hive.HKLM.INSTANCE)) {
            hKEY = WinReg.HKEY_LOCAL_MACHINE;
        } else if (Intrinsics.areEqual((Object)hive, (Object)Win32Registry.Hive.HKCU.INSTANCE)) {
            hKEY = WinReg.HKEY_CURRENT_USER;
        } else if (hive instanceof Win32Registry.Hive.AppKey) {
            hKEY = new WinReg.HKEY(new Pointer(((Win32Registry.Hive.AppKey)$this$hkey).getHkey()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return hKEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String readRegValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName, boolean wow6432) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        try {
            WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
            int rc = Advapi32.INSTANCE.RegOpenKeyEx(this.getHkey(hkey), subKey, 0, 0x20019 | (wow6432 ? 512 : 256), phkKey);
            if (rc != 0) {
                throw new Win32Exception(rc);
            }
            try {
                Object object = Advapi32Util.registryGetValue((WinReg.HKEY)phkKey.getValue(), (String)"", (String)valueName);
                String string = object != null ? object.toString() : null;
                return string;
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)phkKey.getValue());
            }
        }
        catch (Win32Exception t2) {
            Logger.INSTANCE.warn("Unable to read registry key " + hkey + "\\" + subKey + " valueName '" + valueName + "': " + t2.getMessage());
            return null;
        }
    }

    public static /* synthetic */ String readRegValue$default(Win32Integration win32Integration, Win32Registry.Hive hive, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return win32Integration.readRegValue(hive, string, string2, bl);
    }

    public final void writeRegValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName, @NotNull String value2, boolean wow6432) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        try {
            int branch = wow6432 ? 512 : 256;
            Advapi32Util.registryCreateKey((WinReg.HKEY)this.getHkey(hkey), (String)subKey, (int)branch);
            Advapi32Util.registrySetStringValue((WinReg.HKEY)this.getHkey(hkey), (String)subKey, (String)valueName, (String)value2, (int)branch);
        }
        catch (Win32Exception t2) {
            Logger.INSTANCE.warn("Unable to write registry key " + hkey + "\\" + subKey + " valueName '" + valueName + "': " + t2.getMessage());
        }
    }

    public static /* synthetic */ void writeRegValue$default(Win32Integration win32Integration, Win32Registry.Hive hive, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        win32Integration.writeRegValue(hive, string, string2, string3, bl);
    }

    public final void writeRegValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName, int value2, boolean wow6432) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        try {
            int branch = wow6432 ? 512 : 256;
            Advapi32Util.registryCreateKey((WinReg.HKEY)this.getHkey(hkey), (String)subKey, (int)branch);
            Advapi32Util.registrySetIntValue((WinReg.HKEY)this.getHkey(hkey), (String)subKey, (String)valueName, (int)value2, (int)branch);
        }
        catch (Win32Exception t2) {
            Logger.INSTANCE.warn("Unable to write registry key " + hkey + "\\" + subKey + " valueName '" + valueName + "': " + t2.getMessage());
        }
    }

    public static /* synthetic */ void writeRegValue$default(Win32Integration win32Integration, Win32Registry.Hive hive, String string, String string2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        win32Integration.writeRegValue(hive, string, string2, n, bl);
    }

    public final void deleteRegKeyRecursively(@NotNull Win32Registry.Hive hKey, @NotNull String subKey) {
        Intrinsics.checkNotNullParameter((Object)hKey, (String)"hKey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        for (String subSubKey : Win32Integration.listRegKeys$default(this, hKey, subKey, false, 4, null)) {
            this.deleteRegKeyRecursively(hKey, subKey + "\\" + subSubKey);
        }
        for (String valueName : Win32Integration.listRegValues$default(this, hKey, subKey, false, 4, null)) {
            this.deleteRegValue(hKey, subKey, valueName);
        }
        this.deleteRegKey(hKey, subKey);
    }

    public final void deleteRegKey(@NotNull Win32Registry.Hive hkey, @NotNull String subKey) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        try {
            Advapi32Util.registryDeleteKey((WinReg.HKEY)this.getHkey(hkey), (String)subKey);
        }
        catch (Win32Exception t2) {
            Logger.INSTANCE.warn("Unable to delete registry key " + hkey + "\\" + subKey + ": " + t2.getMessage());
        }
    }

    public final void deleteRegValue(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, @NotNull String valueName) {
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)valueName, (String)"valueName");
        try {
            Advapi32Util.registryDeleteValue((WinReg.HKEY)this.getHkey(hkey), (String)subKey, (String)valueName);
        }
        catch (Win32Exception t2) {
            Logger.INSTANCE.warn("Unable to delete registry key " + this.getHkey(hkey) + "\\" + subKey + " valueName '" + valueName + "': " + t2.getMessage());
        }
    }

    @NotNull
    public final List<String> listRegKeys(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, boolean wow6432) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        try {
            String[] stringArray = Advapi32Util.registryGetKeys((WinReg.HKEY)this.getHkey(hkey), (String)subKey, (int)(wow6432 ? 512 : 256));
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"registryGetKeys(...)");
            list2 = ArraysKt.toList((Object[])stringArray);
        }
        catch (Win32Exception t2) {
            if (t2.getErrorCode() == 2) {
                Logger.INSTANCE.info("Unable to list registry keys at " + hkey + "\\" + subKey + ", the key is missing");
            } else {
                Logger.INSTANCE.warn("Unable to list registry keys at " + hkey + "\\" + subKey + ": " + t2.getMessage());
            }
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public static /* synthetic */ List listRegKeys$default(Win32Integration win32Integration, Win32Registry.Hive hive, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return win32Integration.listRegKeys(hive, string, bl);
    }

    @NotNull
    public final List<String> listRegValues(@NotNull Win32Registry.Hive hkey, @NotNull String subKey, boolean wow6432) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)hkey, (String)"hkey");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        try {
            Set set2 = Advapi32Util.registryGetValues((WinReg.HKEY)this.getHkey(hkey), (String)subKey, (int)(wow6432 ? 512 : 256)).keySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
            list2 = CollectionsKt.toList((Iterable)set2);
        }
        catch (Win32Exception t2) {
            Logger.INSTANCE.warn("Unable to list registry values at " + hkey + "\\" + subKey + ": " + t2.getMessage());
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public static /* synthetic */ List listRegValues$default(Win32Integration win32Integration, Win32Registry.Hive hive, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return win32Integration.listRegValues(hive, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<Pid, Path>> listProcesses() {
        void $this$distinctBy$iv;
        void $this$mapNotNullTo$iv$iv;
        int[] pProcessIds;
        block9: {
            block8: {
                if (!com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows()) {
                    return CollectionsKt.emptyList();
                }
                int maxProcesses = 1024;
                pProcessIds = new int[maxProcesses];
                int[] dummyList = new int[maxProcesses];
                if (Win32Psapi.Companion.getINSTANCE() == null) break block8;
                Win32Psapi win32Psapi = Win32Psapi.Companion.getINSTANCE();
                Intrinsics.checkNotNull((Object)win32Psapi);
                if (win32Psapi.EnumProcesses(pProcessIds, maxProcesses * 4, dummyList)) break block9;
            }
            return CollectionsKt.emptyList();
        }
        Kernel32 win32 = Kernel32.INSTANCE;
        Iterable $this$mapNotNull$iv = ArraysKt.toList((int[])pProcessIds);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            int pid = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            if (win32.OpenProcess(1040, false, pid) == null) {
                pair = null;
            } else {
                WinNT.HANDLE processHandle;
                char[] filename = new char[256];
                IntByReference size = new IntByReference(256);
                win32.QueryFullProcessImageName(processHandle, 0, filename, size);
                win32.CloseHandle(processHandle);
                String executable = Native.toString((char[])filename);
                Intrinsics.checkNotNull((Object)executable);
                pair = ((CharSequence)executable).length() == 0 ? null : TuplesKt.to((Object)Pid.box-impl(Pid.constructor-impl(pid)), (Object)Path.Companion.get$default((Path.Companion)Path.Companion, (String)executable, (boolean)false, (int)1, null));
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<Path> set$iv = new HashSet<Path>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Pair it = (Pair)e$iv;
            boolean bl = false;
            Path key$iv = (Path)it.getSecond();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    public final boolean processHasAtLeastOneVisibleWindow(long pid) {
        Ref.BooleanRef hasWindow = new Ref.BooleanRef();
        User32.INSTANCE.EnumWindows((arg_0, arg_1) -> Win32Integration.processHasAtLeastOneVisibleWindow$lambda$0(pid, hasWindow, arg_0, arg_1), null);
        return hasWindow.element;
    }

    @Nullable
    public final ImageData extractIcon(@NotNull File executablePath) {
        ImageData imageData2;
        Intrinsics.checkNotNullParameter((Object)executablePath, (String)"executablePath");
        try {
            ShellFolder sf = ShellFolder.getShellFolder(executablePath);
            ImageIcon icon2 = new ImageIcon(sf.getIcon(256, 256));
            BufferedImage image = new BufferedImage(icon2.getIconWidth(), icon2.getIconHeight(), 2);
            Graphics2D g = image.createGraphics();
            g.setComposite(AlphaComposite.Src);
            icon2.paintIcon(null, g, 0, 0);
            g.dispose();
            ByteArrayOutputStream imagesBytes = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", imagesBytes);
            byte[] byArray = imagesBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            imageData2 = new ImageData(byArray, ImageType.PNG, false, 4, null);
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Cannot read icon from " + executablePath);
            imageData2 = null;
        }
        return imageData2;
    }

    public final boolean registerProtocolHandler(@NotNull String urlScheme, @NotNull Path applicationPath) {
        Intrinsics.checkNotNullParameter((Object)urlScheme, (String)"urlScheme");
        Intrinsics.checkNotNullParameter((Object)applicationPath, (String)"applicationPath");
        Win32Integration.writeRegValue$default(this, (Win32Registry.Hive)Win32Registry.Hive.HKCU.INSTANCE, "Software\\Classes\\" + urlScheme, "", "\"URL: " + urlScheme + " Protocol\"", false, 16, null);
        Win32Integration.writeRegValue$default(this, (Win32Registry.Hive)Win32Registry.Hive.HKCU.INSTANCE, "Software\\Classes\\" + urlScheme, "URL Protocol", "\"\"", false, 16, null);
        Win32Integration.writeRegValue$default(this, (Win32Registry.Hive)Win32Registry.Hive.HKCU.INSTANCE, "Software\\Classes\\" + urlScheme + "\\shell\\open\\command", "", this.convertArgListToString(CollectionsKt.listOf((Object)applicationPath.toString())) + " %1", false, 16, null);
        return true;
    }

    public final boolean unregisterProtocolHandler(@NotNull String urlScheme) {
        Intrinsics.checkNotNullParameter((Object)urlScheme, (String)"urlScheme");
        this.deleteRegKey(Win32Registry.Hive.HKCU.INSTANCE, "Software\\Classes\\" + urlScheme);
        return true;
    }

    public final boolean isUnrestrictedConnection() {
        return !com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows() || NativeInteropWin32.INSTANCE.isUnrestrictedConnection();
    }

    public final boolean openExplorerAndSelect(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return com.jetbrains.toolbox.common.platform.OS.INSTANCE.isWindows() ? NativeInteropWin32.INSTANCE.openExplorerAndSelect(new WString(filename)) : false;
    }

    public final void setFileAttributesNormal(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ThreadGuardKt.assertNotMainThread("java.io.File.canonicalPath");
        boolean result2 = Kernel32.INSTANCE.SetFileAttributes(file.getCanonicalPath(), new WinDef.DWORD(128L));
        if (!result2) {
            Logger.INSTANCE.error("Failed to set attributes to NORMAL for " + file + ": " + Kernel32Util.getLastErrorMessage());
        }
    }

    private static final CharSequence convertArgListToString$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Win32ArgumentHelper.INSTANCE.quoteArgument(it);
    }

    private static final void convertStringToArgList$lambda$0$flushBackslashes(Ref.IntRef backslashes, StringBuilder argument, int number) {
        int n = 0;
        while (n < number) {
            int it = n++;
            boolean bl = false;
            argument.append('\\');
        }
        backslashes.element = 0;
    }

    static /* synthetic */ void convertStringToArgList$lambda$0$flushBackslashes$default(Ref.IntRef intRef, StringBuilder stringBuilder, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = intRef.element;
        }
        Win32Integration.convertStringToArgList$lambda$0$flushBackslashes(intRef, stringBuilder, n);
    }

    private static final void convertStringToArgList$lambda$0$storeArgument(StringBuilder argument, Ref.BooleanRef emptyArgumentAdded, List<String> $this_buildList) {
        if (((CharSequence)argument).length() > 0 || !emptyArgumentAdded.element) {
            String string = argument.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            $this_buildList.add(string);
            StringsKt.clear((StringBuilder)argument);
            emptyArgumentAdded.element = true;
        }
    }

    private static final boolean processHasAtLeastOneVisibleWindow$lambda$0(long $pid, Ref.BooleanRef $hasWindow, WinDef.HWND hWnd, Pointer pointer) {
        boolean bl;
        IntByReference hWndPid = new IntByReference();
        User32.INSTANCE.GetWindowThreadProcessId(hWnd, hWndPid);
        if ((int)$pid == hWndPid.getValue() && User32.INSTANCE.IsWindowVisible(hWnd)) {
            $hasWindow.element = true;
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r')};
        argumentDelimiters = SetsKt.setOf((Object[])objectArray);
        SW_SHOWNORMAL = 1;
        objectArray = new String[]{"ALLUSERSPROFILE", "APPDATA", "CommonProgramFiles", "CommonProgramFiles(x86)", "CommonProgramW6432", "COMPUTERNAME", "HOMEDRIVE", "HOMEPATH", "LOCALAPPDATA", "LOGONSERVER", "ProgramData", "ProgramFiles", "ProgramFiles(x86)", "ProgramW6432", "PUBLIC", "SESSIONNAME", "SystemDrive", "SystemRoot", "USERNAME", "USERDNSDOMAIN", "USERDOMAIN", "USERDOMAIN_ROAMINGPROFILE", "USERPROFILE"};
        preserveSystemEnvironmentVars = CollectionsKt.listOf((Object[])objectArray);
        startMenuLnkFileName = "JetBrains Toolbox/JetBrains Toolbox.lnk";
    }

    public static final class LnkInfo {
        @NotNull
        private final String target;
        @NotNull
        private final String description;

        public LnkInfo(@NotNull String target, @NotNull String description2) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
            this.target = target;
            this.description = description2;
        }

        @NotNull
        public final String getTarget() {
            return this.target;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.target;
        }

        @NotNull
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final LnkInfo copy(@NotNull String target, @NotNull String description2) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
            return new LnkInfo(target, description2);
        }

        public static /* synthetic */ LnkInfo copy$default(LnkInfo lnkInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = lnkInfo.target;
            }
            if ((n & 2) != 0) {
                string2 = lnkInfo.description;
            }
            return lnkInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "LnkInfo(target=" + this.target + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result2 = this.target.hashCode();
            result2 = result2 * 31 + this.description.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LnkInfo)) {
                return false;
            }
            LnkInfo lnkInfo = (LnkInfo)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)lnkInfo.target)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)lnkInfo.description);
        }
    }
}

