/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.interop;

import com.jetbrains.toolbox.interop.Foundation;
import com.jetbrains.toolbox.interop.ID;
import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public class NSString {
    private static final ID nsStringCls = Foundation.getClass("NSString");
    private static final Pointer stringSel = Foundation.createSelector("string");
    private static final Pointer allocSel = Foundation.createSelector("alloc");
    private static final Pointer autoreleaseSel = Foundation.createSelector("autorelease");
    private static final Pointer initWithBytesLengthEncodingSel = Foundation.createSelector("initWithBytes:length:encoding:");
    private static final long nsEncodingUTF16LE = Foundation.convertCFEncodingToNS(0x14000100L);

    @NotNull
    public static ID create(@NotNull String s) {
        if (s.isEmpty()) {
            return Foundation.invoke(nsStringCls, stringSel, new Object[0]);
        }
        byte[] utf16Bytes = s.getBytes(StandardCharsets.UTF_16LE);
        return Foundation.invoke(Foundation.invoke(Foundation.invoke(nsStringCls, allocSel, new Object[0]), initWithBytesLengthEncodingSel, utf16Bytes, utf16Bytes.length, nsEncodingUTF16LE), autoreleaseSel, new Object[0]);
    }
}

