/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.plugins;

import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.intellij.plugins.IntellijPluginVersionDetector;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nIntellijPluginVersionDetectorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntellijPluginVersionDetectorImpl.kt\ncom/jetbrains/toolbox/intellij/plugins/IntellijPluginVersionDetectorImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public final class IntellijPluginVersionDetectorImpl
implements IntellijPluginVersionDetector {
    @NotNull
    private final FileSystem fileSystem;

    public IntellijPluginVersionDetectorImpl(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @Override
    @Nullable
    public String detectPluginVersion-jgzBuIs(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path pluginFilesDirectory = path2.resolve("lib");
        List pluginFiles = this.fileSystem.listOrNull(pluginFilesDirectory);
        Collection collection = pluginFiles;
        if (collection == null || collection.isEmpty()) {
            Logger.INSTANCE.error("Couldn't retrieve plugin version for " + path2 + ". Plugin's directory " + pluginFilesDirectory + " doesn't contain any files");
            return null;
        }
        for (Path plugin : pluginFiles) {
            if (!StringsKt.endsWith$default((String)plugin.name(), (String)".jar", (boolean)false, (int)2, null)) continue;
            try {
                String string;
                String version;
                JarFile pluginJarFile = new JarFile(plugin.toFile(), false);
                ZipEntry zipEntry = pluginJarFile.getEntry("META-INF/plugin.xml");
                if (zipEntry == null) continue;
                ZipEntry pluginInfoXmlZipEntry = zipEntry;
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document document = docBuilder.parse(pluginJarFile.getInputStream(pluginInfoXmlZipEntry));
                Node node2 = document.getElementsByTagName("version").item(0);
                String string2 = version = node2 != null ? node2.getTextContent() : null;
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    string = BuildNumber.constructor-impl(it);
                } else {
                    string = null;
                }
                return string;
            }
            catch (Throwable t2) {
                Logger.INSTANCE.error("Couldn't parse `META-INF/plugin.xml` from " + plugin);
                Logger.INSTANCE.error(t2);
                return null;
            }
        }
        return null;
    }
}

