/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij.notifications;

import com.intellij.station.comms.common.discovery.IntellijToolInformation;
import com.jetbrains.toolbox.common.datetime.InstantExtensionsKt;
import com.jetbrains.toolbox.common.extensions.StringExtensionsKt;
import com.jetbrains.toolbox.intellij.IntelliJLocalAddressInfo;
import com.jetbrains.toolbox.intellij.IntelliJLocalAddressInfoProvider;
import com.jetbrains.toolbox.intellij.notifications.IntelliJLocalAddressInfoProviderImpl;
import com.jetbrains.toolbox.intellij.vmoptions.UtilKt;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsManager;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsProvider;
import com.jetbrains.toolbox.station.comms.services.IdeConnection;
import com.jetbrains.toolbox.tools.model.InstalledToolKt;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import java.io.Closeable;
import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.Instant;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nIntelliJLocalAddressInfoProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntelliJLocalAddressInfoProviderImpl.kt\ncom/jetbrains/toolbox/intellij/notifications/IntelliJLocalAddressInfoProviderImpl\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n66#2:101\n52#2,4:103\n60#2,10:108\n56#2,3:118\n71#2,3:121\n67#3:102\n68#3:107\n1#4:124\n*S KotlinDebug\n*F\n+ 1 IntelliJLocalAddressInfoProviderImpl.kt\ncom/jetbrains/toolbox/intellij/notifications/IntelliJLocalAddressInfoProviderImpl\n*L\n52#1:101\n52#1:103,4\n52#1:108,10\n52#1:118,3\n52#1:121,3\n52#1:102\n52#1:107\n*E\n"})
public final class IntelliJLocalAddressInfoProviderImpl
implements IntelliJLocalAddressInfoProvider {
    @NotNull
    private final VmOptionsManager vmOptionsManager;
    @NotNull
    private final FileSystem fileSystem;

    public IntelliJLocalAddressInfoProviderImpl(@NotNull VmOptionsManager vmOptionsManager, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)vmOptionsManager, (String)"vmOptionsManager");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.vmOptionsManager = vmOptionsManager;
        this.fileSystem = fileSystem;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object fromDefaultVmoptions(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super IntelliJLocalAddressInfo> $completion) {
        if (!($completion instanceof fromDefaultVmoptions.1)) ** GOTO lbl-1000
        var10_3 = $completion;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IntelliJLocalAddressInfoProviderImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fromDefaultVmoptions(null, (Continuation<? super IntelliJLocalAddressInfo>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolInstance);
                $continuation.label = 1;
                v0 = this.extractFromVmOptions(toolInstance, (Continuation<? super VmProperties>)$continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = (VmProperties)v0;
                if (v1 == null) {
                    return null;
                }
                var3_6 = v1;
                token = var3_6.component1();
                portFile = var3_6.component2();
                if (token == null || portFile == null) {
                    return null;
                }
                try {
                    v2 = this.readPortFile(portFile);
                    if (v2 == null) {
                        return null;
                    }
                    var7_9 = v2;
                }
                catch (IOException e) {
                    Logger.INSTANCE.trace("Couldn't read port file at '" + portFile + "': " + e.getMessage());
                    return null;
                }
                catch (Exception e) {
                    Logger.INSTANCE.trace((Throwable)e, "Couldn't read port file at '" + portFile + "'");
                    return null;
                }
                port = var7_9;
                return this.addressInfo(port, token, this.lastModified(portFile));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object fromIdeConnection(@NotNull IdeConnection ideConnection, @NotNull Continuation<? super IntelliJLocalAddressInfo> $completion) {
        IntelliJLocalAddressInfo intelliJLocalAddressInfo;
        IntellijToolInformation intellijToolInformation = ideConnection.getIntelliJToolInformation();
        if (intellijToolInformation != null) {
            IntellijToolInformation it = intellijToolInformation;
            boolean bl = false;
            intelliJLocalAddressInfo = IntelliJLocalAddressInfoProviderImpl.addressInfo$default(this, it.getBuiltInServerPort(), it.getToolboxNotificationToken(), null, 4, null);
        } else {
            intelliJLocalAddressInfo = null;
        }
        return intelliJLocalAddressInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Integer readPortFile(Path portFile) {
        boolean bl;
        String string;
        Throwable thrown$iv$iv;
        block16: {
            void this_$iv;
            FileSystem fileSystem = this.fileSystem;
            Path file$iv = portFile;
            boolean bl2 = false;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
            boolean $i$f$use = false;
            thrown$iv$iv = null;
            try {
                BufferedSource it$iv = (BufferedSource)$this$use$iv$iv;
                boolean bl22 = false;
                BufferedSource $this$readPortFile_u24lambda_u240 = it$iv;
                boolean bl3 = false;
                string = $this$readPortFile_u24lambda_u240.readUtf8();
            }
            catch (Throwable t$iv$iv) {
                try {
                    thrown$iv$iv = t$iv$iv;
                    string = null;
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block17: {
                        try {
                            Closeable closeable = $this$use$iv$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv$iv2) {
                            if (thrown$iv$iv == null) {
                                thrown$iv$iv = t$iv$iv2;
                                break block17;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                thrown$iv$iv = t$iv$iv;
            }
        }
        String result$iv$iv = string;
        Throwable throwable = thrown$iv$iv;
        if (throwable != null) {
            throw throwable;
        }
        String rawPort = result$iv$iv;
        Integer n = StringsKt.toIntOrNull((String)((Object)StringsKt.trim((CharSequence)rawPort)).toString());
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            bl = false;
            Integer n3 = (100 <= it ? it < 65536 : false) ? n2 : null;
            n = n3;
            if (n3 != null) return n;
        }
        IntelliJLocalAddressInfoProviderImpl $this$readPortFile_u24lambda_u242 = this;
        bl = false;
        Logger.INSTANCE.debug("Can't parse " + portFile + " contents: " + rawPort);
        return null;
    }

    private final IntelliJLocalAddressInfo addressInfo(int port, String token2, Instant lastModified) {
        String string = "http://127.0.0.1:" + port;
        Instant instant = lastModified;
        if (instant == null) {
            instant = InstantExtensionsKt.getEPOCH(Instant.Companion);
        }
        return new IntelliJLocalAddressInfo(string, token2, instant);
    }

    static /* synthetic */ IntelliJLocalAddressInfo addressInfo$default(IntelliJLocalAddressInfoProviderImpl intelliJLocalAddressInfoProviderImpl, int n, String string, Instant instant, int n2, Object object) {
        if ((n2 & 4) != 0) {
            instant = null;
        }
        return intelliJLocalAddressInfoProviderImpl.addressInfo(n, string, instant);
    }

    private final Instant lastModified(Path portFile) {
        Instant instant;
        try {
            Long l = this.fileSystem.metadata(portFile).getLastModifiedAtMillis();
            Intrinsics.checkNotNull((Object)l);
            instant = Instant.Companion.fromEpochMilliseconds(l.longValue());
        }
        catch (Exception e) {
            Logger.INSTANCE.trace((Throwable)e, "Couldn't read metadata for " + portFile);
            instant = InstantExtensionsKt.getEPOCH(Instant.Companion);
        }
        return instant;
    }

    /*
     * Unable to fully structure code
     */
    private final Object extractFromVmOptions(ToolInstance toolInstance, Continuation<? super VmProperties> $completion) {
        if (!($completion instanceof extractFromVmOptions.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ IntelliJLocalAddressInfoProviderImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IntelliJLocalAddressInfoProviderImpl.access$extractFromVmOptions(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                vmoptionsPath = UtilKt.getVmoptionsPath(toolInstance);
                displayName = InstalledToolKt.displayNameWithVersion(toolInstance.getChannel(), toolInstance.getTool());
                if (vmoptionsPath == null) {
                    Logger.INSTANCE.trace("Can't resolve VM options path for " + displayName);
                    return null;
                }
                Logger.INSTANCE.trace("Reading VM options from " + vmoptionsPath + " for " + displayName);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)toolInstance);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)vmoptionsPath);
                $continuation.L$2 = displayName;
                $continuation.label = 1;
                v0 = this.vmOptionsManager.createProvider(vmoptionsPath, (Continuation<? super VmOptionsProvider>)$continuation);
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                displayName = (String)$continuation.L$2;
                vmoptionsPath = (Path)$continuation.L$1;
                toolInstance = (ToolInstance)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                v1 = (v2 = (vmOptions = (VmOptionsProvider)v0).getSystemProperty("toolbox.notification.token")) != null && (v2 = v2.getValue()) != null ? StringExtensionsKt.getNullIfBlank((String)v2) : (token = null);
                if (token == null) {
                    Logger.INSTANCE.trace("No toolbox.notification.token property for " + displayName);
                }
                v3 = (v4 = vmOptions.getSystemProperty("toolbox.notification.portFile")) != null && (v4 = v4.getValue()) != null && (v4 = StringExtensionsKt.getNullIfBlank((String)v4)) != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)v4, (boolean)false, (int)1, null) : (portFile = null);
                if (portFile == null) {
                    Logger.INSTANCE.trace("No toolbox.notification.portFile property for " + displayName);
                }
                return new VmProperties(token, portFile);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$extractFromVmOptions(IntelliJLocalAddressInfoProviderImpl $this, ToolInstance toolInstance, Continuation $completion) {
        return $this.extractFromVmOptions(toolInstance, (Continuation<? super VmProperties>)$completion);
    }

    private static final class VmProperties {
        @Nullable
        private final String token;
        @Nullable
        private final Path portFile;

        public VmProperties(@Nullable String token2, @Nullable Path portFile) {
            this.token = token2;
            this.portFile = portFile;
        }

        @Nullable
        public final String component1() {
            return this.token;
        }

        @Nullable
        public final Path component2() {
            return this.portFile;
        }

        @NotNull
        public String toString() {
            return "VmProperties(token=" + this.token + ", portFile=" + this.portFile + ")";
        }

        public int hashCode() {
            int result2 = this.token == null ? 0 : this.token.hashCode();
            result2 = result2 * 31 + (this.portFile == null ? 0 : this.portFile.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VmProperties)) {
                return false;
            }
            VmProperties vmProperties = (VmProperties)other;
            if (!Intrinsics.areEqual((Object)this.token, (Object)vmProperties.token)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.portFile, (Object)vmProperties.portFile);
        }
    }
}

