/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij;

import com.intellij.station.comms.common.api.ServiceMetaInfo;
import com.intellij.station.comms.common.notifications.IdeNotificationRequest;
import com.intellij.station.comms.common.notifications.IdeNotificationsMetaInfo;
import com.intellij.station.comms.common.notifications.NotificationType;
import com.intellij.station.comms.common.toolinstall.ToolInstallMetaInfo;
import com.intellij.station.comms.common.toolinstall.ToolInstallRequest;
import com.intellij.station.comms.common.toolinstall.ToolInstallResponse;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.feed.ApplicationType;
import com.jetbrains.toolbox.feed.IntelliJProductCode;
import com.jetbrains.toolbox.feed.IntelliJToolProperties;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.i18n.gettext.I18n;
import com.jetbrains.toolbox.intellij.ToolInstallHandler;
import com.jetbrains.toolbox.intellij.ToolInstallHandler$ToolInstallationEvent$ErrorEvent;
import com.jetbrains.toolbox.intellij.ToolInstallHandlerKt;
import com.jetbrains.toolbox.interop.RunAsMode;
import com.jetbrains.toolbox.manager.tool.ToolManager;
import com.jetbrains.toolbox.station.comms.services.DiscoveryService;
import com.jetbrains.toolbox.station.comms.services.IdeConnection;
import com.jetbrains.toolbox.station.comms.services.StationRestServiceHandler;
import com.jetbrains.toolbox.station.comms.services.StationServicesClientToIde;
import com.jetbrains.toolbox.station.comms.services.ToolboxStationServicesClientProvider;
import com.jetbrains.toolbox.tools.ToolLaunchManager;
import com.jetbrains.toolbox.tools.model.AvailableTool;
import com.jetbrains.toolbox.tools.model.ChannelId;
import com.jetbrains.toolbox.tools.model.ChannelState;
import com.jetbrains.toolbox.tools.model.EphemeralTool;
import com.jetbrains.toolbox.tools.model.InstalledTool;
import com.jetbrains.toolbox.tools.model.InstallingTool;
import com.jetbrains.toolbox.tools.model.State;
import com.jetbrains.toolbox.tools.model.ToolBuild;
import com.jetbrains.toolbox.tools.model.ToolWithVersions;
import com.jetbrains.toolbox.tools.provider.AvailableToolProvider;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nToolInstallHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolInstallHandler.kt\ncom/jetbrains/toolbox/intellij/ToolInstallHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,244:1\n1#2:245\n*E\n"})
public final class ToolInstallHandler
extends StationRestServiceHandler<ToolInstallRequest, ToolInstallResponse> {
    @NotNull
    private final ToolManager toolManager;
    @NotNull
    private final AvailableToolProvider availableToolProvider;
    @NotNull
    private final ToolLaunchManager toolLaunchManager;
    @NotNull
    private final I18n i18n;
    @NotNull
    private final ToolboxStationServicesClientProvider clientProvider;
    @NotNull
    private final CoroutineScope coroutineScope;
    private final ConcurrentHashMap.KeySetView<String, Boolean> processingRequests;

    public ToolInstallHandler(@NotNull ToolManager toolManager, @NotNull AvailableToolProvider availableToolProvider, @NotNull ToolLaunchManager toolLaunchManager, @NotNull I18n i18n, @NotNull DiscoveryService discovery, @NotNull ToolboxStationServicesClientProvider clientProvider, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)toolManager, (String)"toolManager");
        Intrinsics.checkNotNullParameter((Object)availableToolProvider, (String)"availableToolProvider");
        Intrinsics.checkNotNullParameter((Object)toolLaunchManager, (String)"toolLaunchManager");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)discovery, (String)"discovery");
        Intrinsics.checkNotNullParameter((Object)clientProvider, (String)"clientProvider");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(discovery);
        this.toolManager = toolManager;
        this.availableToolProvider = availableToolProvider;
        this.toolLaunchManager = toolLaunchManager;
        this.i18n = i18n;
        this.clientProvider = clientProvider;
        this.coroutineScope = coroutineScope;
        this.processingRequests = ConcurrentHashMap.newKeySet();
    }

    @Override
    @NotNull
    public ServiceMetaInfo<ToolInstallRequest, ToolInstallResponse> getMetaInfo() {
        return ToolInstallMetaInfo.INSTANCE;
    }

    @Override
    @Nullable
    public Object handle(@NotNull ToolInstallRequest request2, @NotNull IdeConnection fromIde, @NotNull Continuation<? super ToolInstallResponse> $completion) {
        if (this.processingRequests.contains(request2.getProductCode())) {
            return new ToolInstallResponse(false);
        }
        StationServicesClientToIde client = this.clientProvider.clientFor(fromIde);
        this.launchOpenFileProcess(this.coroutineScope, client, request2);
        return new ToolInstallResponse(true);
    }

    private final Job launchOpenFileProcess(CoroutineScope $this$launchOpenFileProcess, StationServicesClientToIde client, ToolInstallRequest request2) {
        return BuildersKt.launch$default((CoroutineScope)$this$launchOpenFileProcess, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request2, client, null){
            Object L$0;
            int label;
            final /* synthetic */ ToolInstallHandler this$0;
            final /* synthetic */ ToolInstallRequest $request;
            final /* synthetic */ StationServicesClientToIde $client;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                this.$client = $client;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.station.comms.common.toolinstall.ToolInstallRequest ), ()Ljava/lang/String;)((ToolInstallRequest)this.$request));
                        ToolInstallHandler.access$getProcessingRequests$p(this.this$0).add(this.$request.getProductCode());
                        this.label = 1;
                        v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)ToolInstallHandlerKt.access$getToolLaunchingTimeout$p(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, this.$request, this.$client, null){
                            int label;
                            final /* synthetic */ ToolInstallHandler this$0;
                            final /* synthetic */ ToolInstallRequest $request;
                            final /* synthetic */ StationServicesClientToIde $client;
                            {
                                this.this$0 = $receiver;
                                this.$request = $request;
                                this.$client = $client;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = ToolInstallHandler.access$processFileOpeningFlow(this.this$0, this.$request).collect(new FlowCollector(this.$client, this.this$0){
                                            final /* synthetic */ StationServicesClientToIde $client;
                                            final /* synthetic */ ToolInstallHandler this$0;
                                            {
                                                this.$client = $client;
                                                this.this$0 = $receiver;
                                            }

                                            public final Object emit(ToolInstallationEvent it, Continuation<? super Unit> $completion) {
                                                Object object = this.$client.request(IdeNotificationsMetaInfo.INSTANCE, ToolInstallHandler.access$toNotification(this.this$0, it), $completion);
                                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                                    return object;
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (object2 != object) return Boxing.boxBoolean((boolean)true);
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Boxing.boxBoolean((boolean)true);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v0 != var4_2) goto lbl14
lbl13:
                        // 1 sources

                        return var4_2;
lbl14:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        if (Intrinsics.areEqual((Object)(success = (Boolean)v0), (Object)Boxing.boxBoolean((boolean)true))) ** GOTO lbl42
                        Logger.INSTANCE.error((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(), ()Ljava/lang/String;)());
                        var3_6 = new Pair[]{TuplesKt.to((Object)"code", (Object)this.$request.getProductCode())};
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)success);
                        this.label = 2;
                        v1 = this.$client.request(IdeNotificationsMetaInfo.INSTANCE, new IdeNotificationRequest(ToolInstallHandler.access$getI18n$p(this.this$0).tr("Cannot launch IDE"), ToolInstallHandler.access$getI18n$p(this.this$0).tr("Tool '{{code}} installation took too long.", var3_6), NotificationType.Error, null, 8, null), (Continuation)this);
                        ** if (v1 != var4_2) goto lbl28
lbl27:
                        // 1 sources

                        return var4_2;
lbl28:
                        // 1 sources

                        ** GOTO lbl42
                    }
                    case 2: {
                        success = (Boolean)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                        }
                        catch (Throwable var2_5) {
                            throw var2_5;
                        }
                        finally {
                            ToolInstallHandler.access$getProcessingRequests$p(this.this$0).remove(this.$request.getProductCode());
                        }
lbl42:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(ToolInstallRequest $request) {
                return "Request from IDE to open file '" + $request.getPathToOpen() + "' with tool '" + $request.getProductCode() + "' ";
            }

            private static final String invokeSuspend$lambda$1() {
                return "Tool launching process timed out";
            }
        }), (int)3, null);
    }

    private final Flow<ToolInstallationEvent> processFileOpeningFlow(ToolInstallRequest request2) {
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super ToolInstallationEvent>, Continuation<? super Unit>, Object>(this, request2, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ToolInstallHandler this$0;
            final /* synthetic */ ToolInstallRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block24: {
                    block22: {
                        block23: {
                            block21: {
                                var2_2 = (FlowCollector)this.L$0;
                                var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.station.comms.common.toolinstall.ToolInstallRequest ), ()Ljava/lang/String;)((ToolInstallRequest)this.$request));
                                        toolInfo = ToolInstallHandler.access$findTool-cDcmc_U(this.this$0, IntelliJProductCode.constructor-impl(this.$request.getProductCode()));
                                        if (toolInfo != null) break;
                                        Logger.INSTANCE.warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(com.intellij.station.comms.common.toolinstall.ToolInstallRequest ), ()Ljava/lang/String;)((ToolInstallRequest)this.$request));
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$flow);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)toolInfo);
                                        this.label = 1;
                                        v0 = $this$flow.emit((Object)new ToolInstallationEvent.FindError(this.$request.getProductCode()), (Continuation)this);
                                        if (v0 == var10_3) {
                                            return var10_3;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 1: {
                                        toolInfo = (ToolInfo)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl21:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                var5_8 = toolInfo;
                                if (!(var5_8 instanceof ToolInfo.Available)) break block21;
                                Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$2(com.intellij.station.comms.common.toolinstall.ToolInstallRequest ), ()Ljava/lang/String;)((ToolInstallRequest)this.$request));
                                this.L$0 = $this$flow;
                                this.L$1 = toolInfo;
                                this.label = 2;
                                v1 = $this$flow.emit((Object)new ToolInstallationEvent.StartInstallation(((ToolInfo.Available)toolInfo).getToolBuild().getTool()), (Continuation)this);
                                if (v1 == var10_3) {
                                    return var10_3;
                                }
                                ** GOTO lbl36
                                {
                                    case 2: {
                                        toolInfo = (ToolInfo)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl36:
                                        // 2 sources

                                        channelId = ToolManager.install-x49nL0w$default(ToolInstallHandler.access$getToolManager$p(this.this$0), ((ToolInfo.Available)toolInfo).getToolBuild(), null, null, null, false, 30, null);
                                        this.L$0 = $this$flow;
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)toolInfo);
                                        this.L$2 = channelId;
                                        this.label = 3;
                                        v2 = ToolInstallHandler.access$waitToolIsInstalled-R5oYZt4(this.this$0, channelId, (Continuation)this);
                                        if (v2 == var10_3) {
                                            return var10_3;
                                        }
                                        ** GOTO lbl50
                                    }
                                    case 3: {
                                        channelId = (String)this.L$2;
                                        toolInfo = (ToolInfo)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl50:
                                        // 2 sources

                                        it = (InstallationResult)v2;
                                        $i$a$-let-ToolInstallHandler$processFileOpeningFlow$1$4 = false;
                                        v3 = TuplesKt.to((Object)ChannelId.box-impl(channelId), (Object)it);
                                        break block22;
                                    }
                                }
                            }
                            if (!(var5_8 instanceof ToolInfo.Installing)) break block23;
                            Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$4(com.intellij.station.comms.common.toolinstall.ToolInstallRequest ), ()Ljava/lang/String;)((ToolInstallRequest)this.$request));
                            this.L$0 = $this$flow;
                            this.L$1 = toolInfo;
                            this.label = 4;
                            v4 = $this$flow.emit((Object)new ToolInstallationEvent.Installing(((ToolInfo.Installing)toolInfo).getTool()), (Continuation)this);
                            if (v4 == var10_3) {
                                return var10_3;
                            }
                            ** GOTO lbl69
                            {
                                case 4: {
                                    toolInfo = (ToolInfo)this.L$1;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v4 = $result;
lbl69:
                                    // 2 sources

                                    this.L$0 = $this$flow;
                                    this.L$1 = toolInfo;
                                    this.label = 5;
                                    v5 = ToolInstallHandler.access$waitToolIsInstalled-R5oYZt4(this.this$0, ((ToolInfo.Installing)toolInfo).getChannelId-5CZByfs(), (Continuation)this);
                                    if (v5 == var10_3) {
                                        return var10_3;
                                    }
                                    ** GOTO lbl80
                                }
                                case 5: {
                                    toolInfo = (ToolInfo)this.L$1;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v5 = $result;
lbl80:
                                    // 2 sources

                                    it = (InstallationResult)v5;
                                    $i$a$-let-ToolInstallHandler$processFileOpeningFlow$1$6 = false;
                                    v3 = TuplesKt.to((Object)ChannelId.box-impl(((ToolInfo.Installing)toolInfo).getChannelId-5CZByfs()), (Object)it);
                                    break block22;
                                }
                            }
                        }
                        if (var5_8 instanceof ToolInfo.Installed) {
                            v3 = TuplesKt.to((Object)ChannelId.box-impl(((ToolInfo.Installed)toolInfo).getChannelId-5CZByfs()), (Object)new InstallationResult.Success(((ToolInfo.Installed)toolInfo).getTool()));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    var4_19 = v3;
                    channelId = ((ChannelId)var4_19.component1()).unbox-impl();
                    installationResult = (InstallationResult)var4_19.component2();
                    if (!(installationResult instanceof InstallationResult.Error)) break block24;
                    Logger.INSTANCE.warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$6(com.intellij.station.comms.common.toolinstall.ToolInstallRequest com.jetbrains.toolbox.intellij.ToolInstallHandler$InstallationResult com.jetbrains.toolbox.intellij.ToolInstallHandler ), ()Ljava/lang/String;)((ToolInstallRequest)this.$request, (InstallationResult)installationResult, (ToolInstallHandler)this.this$0));
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$flow);
                    this.L$1 = SpillingKt.nullOutSpilledVariable((Object)toolInfo);
                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)channelId);
                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)installationResult);
                    this.label = 6;
                    v6 = $this$flow.emit((Object)new ToolInstallationEvent.InstallingError(((InstallationResult.Error)installationResult).getTool(), ((InstallationResult.Error)installationResult).getReason()), (Continuation)this);
                    if (v6 == var10_3) {
                        return var10_3;
                    }
                    ** GOTO lbl110
                    {
                        case 6: {
                            installationResult = (InstallationResult)this.L$3;
                            channelId = (String)this.L$2;
                            toolInfo = (ToolInfo)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v6 = $result;
lbl110:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                }
                Intrinsics.checkNotNull((Object)installationResult, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.intellij.ToolInstallHandler.InstallationResult.Success");
                installedTool = ((InstallationResult.Success)installationResult).getTool();
                Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$7(com.intellij.station.comms.common.toolinstall.ToolInstallRequest ), ()Ljava/lang/String;)((ToolInstallRequest)this.$request));
                this.L$0 = $this$flow;
                this.L$1 = SpillingKt.nullOutSpilledVariable((Object)toolInfo);
                this.L$2 = SpillingKt.nullOutSpilledVariable((Object)channelId);
                this.L$3 = SpillingKt.nullOutSpilledVariable((Object)installationResult);
                this.L$4 = installedTool;
                this.label = 7;
                v7 = ToolInstallHandler.access$openTool--IZY_0c(this.this$0, channelId, installedTool, this.$request.getPathToOpen(), (Continuation)this);
                if (v7 == var10_3) {
                    return var10_3;
                }
                ** GOTO lbl132
                {
                    case 7: {
                        installedTool = (InstalledTool)this.L$4;
                        installationResult = (InstallationResult)this.L$3;
                        channelId = (String)this.L$2;
                        toolInfo = (ToolInfo)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl132:
                        // 2 sources

                        Logger.INSTANCE.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$8(com.intellij.station.comms.common.toolinstall.ToolInstallRequest ), ()Ljava/lang/String;)((ToolInstallRequest)this.$request));
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$flow);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)toolInfo);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)channelId);
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)installationResult);
                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)installedTool);
                        this.label = 8;
                        v8 = $this$flow.emit((Object)new ToolInstallationEvent.Launched(installedTool), (Continuation)this);
                        if (v8 == var10_3) {
                            return var10_3;
                        }
                        ** GOTO lbl150
                    }
                    case 8: {
                        installedTool = (InstalledTool)this.L$4;
                        installationResult = (InstallationResult)this.L$3;
                        channelId = (String)this.L$2;
                        toolInfo = (ToolInfo)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v8 = $result;
lbl150:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super ToolInstallationEvent> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(ToolInstallRequest $request) {
                return "Checking tool availability for `" + $request.getProductCode() + "` code";
            }

            private static final String invokeSuspend$lambda$1(ToolInstallRequest $request) {
                return "Cannot find any tool with product code '" + $request.getProductCode() + "'";
            }

            private static final String invokeSuspend$lambda$2(ToolInstallRequest $request) {
                return "Installing tool with code `" + $request.getProductCode() + "`";
            }

            private static final String invokeSuspend$lambda$4(ToolInstallRequest $request) {
                return "Waiting tool `" + $request.getProductCode() + "` installation finished";
            }

            private static final String invokeSuspend$lambda$6(ToolInstallRequest $request, InstallationResult $installationResult, ToolInstallHandler this$0) {
                return "Installation of tool '" + $request.getProductCode() + "' failed: " + LocalizableStringExKt.localize(((InstallationResult.Error)$installationResult).getReason(), ToolInstallHandler.access$getI18n$p(this$0));
            }

            private static final String invokeSuspend$lambda$7(ToolInstallRequest $request) {
                Object object;
                String string;
                block3: {
                    block2: {
                        string = $request.getProductCode();
                        object = $request.getPathToOpen();
                        if (object == null) break block2;
                        String it = object;
                        String string2 = string;
                        boolean bl = false;
                        String string3 = "with file path " + it;
                        string = string2;
                        object = string3;
                        if (string3 != null) break block3;
                    }
                    object = "";
                }
                return "Launching tool '" + string + "' " + (String)object;
            }

            private static final String invokeSuspend$lambda$8(ToolInstallRequest $request) {
                Object object;
                String string;
                block3: {
                    block2: {
                        string = $request.getProductCode();
                        object = $request.getPathToOpen();
                        if (object == null) break block2;
                        String it = object;
                        String string2 = string;
                        boolean bl = false;
                        String string3 = " with file path " + it;
                        string = string2;
                        object = string3;
                        if (string3 != null) break block3;
                    }
                    object = "";
                }
                return "Tool '" + string + "' is launched" + (String)object;
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private final Object waitToolIsInstalled-R5oYZt4(String $v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0, Continuation<? super InstallationResult> $completion) {
        if (!($completion instanceof waitToolIsInstalled.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ToolInstallHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ToolInstallHandler.access$waitToolIsInstalled-R5oYZt4(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.toolManager.getState().get(ChannelId.box-impl($v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0));
                Intrinsics.checkNotNull(v0);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0);
                $continuation.label = 1;
                v1 = FlowKt.first((Flow)((Flow)v0), (Function2)((Function2)new Function2<State, Continuation<? super Boolean>, Object>(this, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ ToolInstallHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        State state2 = (State)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                return Boxing.boxBoolean((boolean)ToolInstallHandler.access$isInstallationFinished(this.this$0, (State)it));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(State p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                $v$c$com-jetbrains-toolbox-tools-model-ChannelId$-channelId$0 = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl24:
                // 2 sources

                it = (State)v1;
                $i$a$-let-ToolInstallHandler$waitToolIsInstalled$3 = false;
                if (it instanceof ChannelState.Idle) {
                    v2 = new InstallationResult.Success(((ChannelState.Idle)it).getTool());
                } else {
                    var5_8 = it;
                    reason = var5_8 instanceof ChannelState.InstallationUnsuccessful != false ? ((ChannelState.InstallationUnsuccessful)it).getReason() : (var5_8 instanceof State.PrepareInstallationFailed != false ? ((State.PrepareInstallationFailed)it).getReason() : (LocalizableString)LocalizableStringExKt.trl("Unknown error"));
                    Logger.INSTANCE.error((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, waitToolIsInstalled_R5oYZt4$lambda$0$0(com.jetbrains.toolbox.api.localization.LocalizableString com.jetbrains.toolbox.intellij.ToolInstallHandler com.jetbrains.toolbox.tools.model.State ), ()Ljava/lang/String;)((LocalizableString)reason, (ToolInstallHandler)this, (State)it));
                    v2 = new InstallationResult.Error(it.getTool(), reason);
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object openTool--IZY_0c(String string, InstalledTool tool, String filePath, Continuation<? super Unit> $completion) {
        Object object = ToolLaunchManager.launchTool-ZTOvLac$default(this.toolLaunchManager, string, tool.getToolId-UtVBrGo(), filePath, null, false, RunAsMode.RunAsUser, null, 88, null).await($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final boolean isInstallationFinished(State $this$isInstallationFinished) {
        return $this$isInstallationFinished instanceof ChannelState.Idle || $this$isInstallationFinished instanceof ChannelState.Terminal;
    }

    private final ToolInfo findTool-cDcmc_U(String string) {
        ToolInfo toolInfo;
        Object v4;
        ToolWithVersions toolWithVersions;
        Object it;
        Object object;
        block8: {
            Object object2;
            Object object3;
            block7: {
                object = ((Map)this.availableToolProvider.getFacade().getTools().observeAvailableToolsWithVersions().getValue()).entrySet();
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    object3 = iterator2.next();
                    it = (Map.Entry)object3;
                    boolean bl = false;
                    IntelliJToolProperties intelliJToolProperties = ((ToolWithVersions)it.getValue()).getTool().getIntelliJProperties();
                    String string2 = intelliJToolProperties != null ? intelliJToolProperties.getProductCode-fnix534() : null;
                    if (!(string2 == null ? false : IntelliJProductCode.equals-impl0(string2, string))) continue;
                    object2 = object3;
                    break block7;
                }
                object2 = null;
            }
            Map.Entry entry = (Map.Entry)object2;
            if (entry == null) {
                return null;
            }
            Map.Entry entry2 = entry;
            String appType = ((ApplicationType)entry2.getKey()).unbox-impl();
            toolWithVersions = (ToolWithVersions)entry2.getValue();
            object3 = this.toolManager.getState().entrySet();
            it = object3.iterator();
            while (it.hasNext()) {
                Object bl = it.next();
                Map.Entry it2 = (Map.Entry)bl;
                boolean bl2 = false;
                if (!ApplicationType.equals-impl0(((State)((StateFlow)it2.getValue()).getValue()).getTool().getToolId-UtVBrGo(), appType)) continue;
                v4 = bl;
                break block8;
            }
            v4 = null;
        }
        object = v4;
        if (object != null) {
            it = object;
            boolean bl = false;
            if (((State)((StateFlow)it.getValue()).getValue()).getTool() instanceof InstalledTool) {
                String string3 = ((ChannelId)it.getKey()).unbox-impl();
                EphemeralTool ephemeralTool = ((State)((StateFlow)it.getValue()).getValue()).getTool();
                Intrinsics.checkNotNull((Object)ephemeralTool, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.tools.model.InstalledTool");
                toolInfo = new ToolInfo.Installed(string3, (InstalledTool)ephemeralTool, null);
            } else {
                String string4 = ((ChannelId)it.getKey()).unbox-impl();
                EphemeralTool ephemeralTool = ((State)((StateFlow)it.getValue()).getValue()).getTool();
                Intrinsics.checkNotNull((Object)ephemeralTool, (String)"null cannot be cast to non-null type com.jetbrains.toolbox.tools.model.InstallingTool");
                toolInfo = new ToolInfo.Installing(string4, (InstallingTool)ephemeralTool, null);
            }
        } else {
            toolInfo = new ToolInfo.Available(toolWithVersions.getStableToolBuild());
        }
        return toolInfo;
    }

    private final IdeNotificationRequest toNotification(ToolInstallationEvent $this$toNotification) {
        IdeNotificationRequest ideNotificationRequest;
        ToolInstallationEvent toolInstallationEvent = $this$toNotification;
        if (toolInstallationEvent instanceof ToolInstallationEvent.StartInstallation) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"IDE", (Object)((ToolInstallationEvent.StartInstallation)$this$toNotification).getTool().getName())};
            String string = this.i18n.tr("Launching {{IDE}}", pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)"IDE", (Object)((ToolInstallationEvent.StartInstallation)$this$toNotification).getTool().getName())};
            IdeNotificationRequest ideNotificationRequest2 = new IdeNotificationRequest(string, this.i18n.tr("{{IDE}} is being installed. You will get notification when it is ready.", pairArray), NotificationType.Info, "toolbox-tool-installation");
            ideNotificationRequest = ideNotificationRequest2;
        } else if (toolInstallationEvent instanceof ToolInstallationEvent.Installing) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"IDE", (Object)((ToolInstallationEvent.Installing)$this$toNotification).getTool().getToolName())};
            String string = this.i18n.tr("Launching {{IDE}}", pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)"IDE", (Object)((ToolInstallationEvent.Installing)$this$toNotification).getTool().getToolName())};
            IdeNotificationRequest ideNotificationRequest3 = new IdeNotificationRequest(string, this.i18n.tr("{{IDE}} is being installed. You will get notification when it is ready.", pairArray), NotificationType.Info, "toolbox-tool-installation");
            ideNotificationRequest = ideNotificationRequest3;
        } else if (toolInstallationEvent instanceof ToolInstallationEvent.Launched) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"IDE", (Object)((ToolInstallationEvent.Launched)$this$toNotification).getTool().getToolName())};
            String string = this.i18n.tr("Launching {{IDE}}", pairArray);
            pairArray = new Pair[]{TuplesKt.to((Object)"IDE", (Object)((ToolInstallationEvent.Launched)$this$toNotification).getTool().getToolName())};
            IdeNotificationRequest ideNotificationRequest4 = new IdeNotificationRequest(string, this.i18n.tr("{{IDE}} is successfully launched", pairArray), NotificationType.Info, "toolbox-tool-installation");
            ideNotificationRequest = ideNotificationRequest4;
        } else if (toolInstallationEvent instanceof ToolInstallationEvent.FindError) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"code", (Object)((ToolInstallationEvent.FindError)$this$toNotification).getProductCode())};
            IdeNotificationRequest ideNotificationRequest5 = new IdeNotificationRequest(this.i18n.tr("IDE not found"), this.i18n.tr("Cannot find an IDE with code '{{code}}'", pairArray), NotificationType.Error, "toolbox-tool-installation");
            ideNotificationRequest = ideNotificationRequest5;
        } else if (toolInstallationEvent instanceof ToolInstallationEvent.InstallingError) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"IDE", (Object)((ToolInstallationEvent.InstallingError)$this$toNotification).getTool().getToolName())};
            IdeNotificationRequest ideNotificationRequest6 = new IdeNotificationRequest(this.i18n.tr("Cannot install {{IDE}}", pairArray), LocalizableStringExKt.localize(((ToolInstallationEvent.InstallingError)$this$toNotification).getReason(), this.i18n), NotificationType.Error, "toolbox-tool-installation");
            ideNotificationRequest = ideNotificationRequest6;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ideNotificationRequest;
    }

    private static final String waitToolIsInstalled_R5oYZt4$lambda$0$0(LocalizableString $reason, ToolInstallHandler this$0, State $it) {
        return "Installation failed: " + LocalizableStringExKt.localize($reason, this$0.i18n) + ". Channel state: " + $it.getClass().getSimpleName();
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView access$getProcessingRequests$p(ToolInstallHandler $this) {
        return $this.processingRequests;
    }

    public static final /* synthetic */ Flow access$processFileOpeningFlow(ToolInstallHandler $this, ToolInstallRequest request2) {
        return $this.processFileOpeningFlow(request2);
    }

    public static final /* synthetic */ IdeNotificationRequest access$toNotification(ToolInstallHandler $this, ToolInstallationEvent $receiver) {
        return $this.toNotification($receiver);
    }

    public static final /* synthetic */ I18n access$getI18n$p(ToolInstallHandler $this) {
        return $this.i18n;
    }

    public static final /* synthetic */ ToolInfo access$findTool-cDcmc_U(ToolInstallHandler $this, String string) {
        return $this.findTool-cDcmc_U(string);
    }

    public static final /* synthetic */ ToolManager access$getToolManager$p(ToolInstallHandler $this) {
        return $this.toolManager;
    }

    public static final /* synthetic */ Object access$waitToolIsInstalled-R5oYZt4(ToolInstallHandler $this, String string, Continuation $completion) {
        return $this.waitToolIsInstalled-R5oYZt4(string, (Continuation<? super InstallationResult>)$completion);
    }

    public static final /* synthetic */ Object access$openTool--IZY_0c(ToolInstallHandler $this, String string, InstalledTool tool, String filePath, Continuation $completion) {
        return $this.openTool--IZY_0c(string, tool, filePath, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$isInstallationFinished(ToolInstallHandler $this, State $receiver) {
        return $this.isInstallationFinished($receiver);
    }

    private static abstract sealed class InstallationResult {
        private InstallationResult() {
        }

        public /* synthetic */ InstallationResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class Error
        extends InstallationResult {
            @NotNull
            private final EphemeralTool tool;
            @NotNull
            private final LocalizableString reason;

            public Error(@NotNull EphemeralTool tool, @NotNull LocalizableString reason) {
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                super(null);
                this.tool = tool;
                this.reason = reason;
            }

            @NotNull
            public final EphemeralTool getTool() {
                return this.tool;
            }

            @NotNull
            public final LocalizableString getReason() {
                return this.reason;
            }

            @NotNull
            public String toString() {
                return "Error(tool=" + this.tool + ", reason=" + this.reason + ")";
            }

            public int hashCode() {
                int result2 = this.tool.hashCode();
                result2 = result2 * 31 + this.reason.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error2 = (Error)other;
                if (!Intrinsics.areEqual((Object)this.tool, (Object)error2.tool)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.reason, (Object)error2.reason);
            }
        }

        public static final class Success
        extends InstallationResult {
            @NotNull
            private final InstalledTool tool;

            public Success(@NotNull InstalledTool tool) {
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                super(null);
                this.tool = tool;
            }

            @NotNull
            public final InstalledTool getTool() {
                return this.tool;
            }

            @NotNull
            public String toString() {
                return "Success(tool=" + this.tool + ")";
            }

            public int hashCode() {
                return this.tool.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success2 = (Success)other;
                return Intrinsics.areEqual((Object)this.tool, (Object)success2.tool);
            }
        }
    }

    private static sealed interface ToolInfo {

        public static final class Available
        implements ToolInfo {
            @NotNull
            private final ToolBuild toolBuild;

            public Available(@NotNull ToolBuild toolBuild2) {
                Intrinsics.checkNotNullParameter((Object)toolBuild2, (String)"toolBuild");
                this.toolBuild = toolBuild2;
            }

            @NotNull
            public final ToolBuild getToolBuild() {
                return this.toolBuild;
            }

            @NotNull
            public String toString() {
                return "Available(toolBuild=" + this.toolBuild + ")";
            }

            public int hashCode() {
                return this.toolBuild.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Available)) {
                    return false;
                }
                Available available2 = (Available)other;
                return Intrinsics.areEqual((Object)this.toolBuild, (Object)available2.toolBuild);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static final class Installed
        implements ToolInfo {
            @NotNull
            private final String channelId;
            @NotNull
            private final InstalledTool tool;

            private Installed(String channelId, InstalledTool tool) {
                Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                this.channelId = channelId;
                this.tool = tool;
            }

            @NotNull
            public final String getChannelId-5CZByfs() {
                return this.channelId;
            }

            @NotNull
            public final InstalledTool getTool() {
                return this.tool;
            }

            @NotNull
            public String toString() {
                return "Installed(channelId=" + ChannelId.toString-impl(this.channelId) + ", tool=" + this.tool + ")";
            }

            public int hashCode() {
                int result2 = ChannelId.hashCode-impl(this.channelId);
                result2 = result2 * 31 + this.tool.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Installed)) {
                    return false;
                }
                Installed installed2 = (Installed)other;
                if (!ChannelId.equals-impl0(this.channelId, installed2.channelId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tool, (Object)installed2.tool);
            }

            public /* synthetic */ Installed(String channelId, InstalledTool tool, DefaultConstructorMarker $constructor_marker) {
                this(channelId, tool);
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public static final class Installing
        implements ToolInfo {
            @NotNull
            private final String channelId;
            @NotNull
            private final InstallingTool tool;

            private Installing(String channelId, InstallingTool tool) {
                Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                this.channelId = channelId;
                this.tool = tool;
            }

            @NotNull
            public final String getChannelId-5CZByfs() {
                return this.channelId;
            }

            @NotNull
            public final InstallingTool getTool() {
                return this.tool;
            }

            @NotNull
            public String toString() {
                return "Installing(channelId=" + ChannelId.toString-impl(this.channelId) + ", tool=" + this.tool + ")";
            }

            public int hashCode() {
                int result2 = ChannelId.hashCode-impl(this.channelId);
                result2 = result2 * 31 + this.tool.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Installing)) {
                    return false;
                }
                Installing installing = (Installing)other;
                if (!ChannelId.equals-impl0(this.channelId, installing.channelId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.tool, (Object)installing.tool);
            }

            public /* synthetic */ Installing(String channelId, InstallingTool tool, DefaultConstructorMarker $constructor_marker) {
                this(channelId, tool);
            }
        }
    }

    private static sealed interface ToolInstallationEvent {

        public static final class FindError
        implements ToolInstallHandler$ToolInstallationEvent$ErrorEvent {
            @NotNull
            private final String productCode;

            public FindError(@NotNull String productCode) {
                Intrinsics.checkNotNullParameter((Object)productCode, (String)"productCode");
                this.productCode = productCode;
            }

            @NotNull
            public final String getProductCode() {
                return this.productCode;
            }

            @NotNull
            public String toString() {
                return "FindError(productCode=" + this.productCode + ")";
            }

            public int hashCode() {
                return this.productCode.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof FindError)) {
                    return false;
                }
                FindError findError = (FindError)other;
                return Intrinsics.areEqual((Object)this.productCode, (Object)findError.productCode);
            }
        }

        public static final class Installing
        implements ToolInstallationEvent {
            @NotNull
            private final InstallingTool tool;

            public Installing(@NotNull InstallingTool tool) {
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                this.tool = tool;
            }

            @NotNull
            public final InstallingTool getTool() {
                return this.tool;
            }

            @NotNull
            public String toString() {
                return "Installing(tool=" + this.tool + ")";
            }

            public int hashCode() {
                return this.tool.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Installing)) {
                    return false;
                }
                Installing installing = (Installing)other;
                return Intrinsics.areEqual((Object)this.tool, (Object)installing.tool);
            }
        }

        public static final class InstallingError
        implements ToolInstallHandler$ToolInstallationEvent$ErrorEvent {
            @NotNull
            private final EphemeralTool tool;
            @NotNull
            private final LocalizableString reason;

            public InstallingError(@NotNull EphemeralTool tool, @NotNull LocalizableString reason) {
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                this.tool = tool;
                this.reason = reason;
            }

            @NotNull
            public final EphemeralTool getTool() {
                return this.tool;
            }

            @NotNull
            public final LocalizableString getReason() {
                return this.reason;
            }

            @NotNull
            public String toString() {
                return "InstallingError(tool=" + this.tool + ", reason=" + this.reason + ")";
            }

            public int hashCode() {
                int result2 = this.tool.hashCode();
                result2 = result2 * 31 + this.reason.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InstallingError)) {
                    return false;
                }
                InstallingError installingError = (InstallingError)other;
                if (!Intrinsics.areEqual((Object)this.tool, (Object)installingError.tool)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.reason, (Object)installingError.reason);
            }
        }

        public static final class Launched
        implements ToolInstallationEvent {
            @NotNull
            private final InstalledTool tool;

            public Launched(@NotNull InstalledTool tool) {
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                this.tool = tool;
            }

            @NotNull
            public final InstalledTool getTool() {
                return this.tool;
            }

            @NotNull
            public String toString() {
                return "Launched(tool=" + this.tool + ")";
            }

            public int hashCode() {
                return this.tool.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Launched)) {
                    return false;
                }
                Launched launched = (Launched)other;
                return Intrinsics.areEqual((Object)this.tool, (Object)launched.tool);
            }
        }

        public static final class StartInstallation
        implements ToolInstallationEvent {
            @NotNull
            private final AvailableTool tool;

            public StartInstallation(@NotNull AvailableTool tool) {
                Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
                this.tool = tool;
            }

            @NotNull
            public final AvailableTool getTool() {
                return this.tool;
            }

            @NotNull
            public String toString() {
                return "StartInstallation(tool=" + this.tool + ")";
            }

            public int hashCode() {
                return this.tool.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StartInstallation)) {
                    return false;
                }
                StartInstallation startInstallation = (StartInstallation)other;
                return Intrinsics.areEqual((Object)this.tool, (Object)startInstallation.tool);
            }
        }
    }
}

