/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.intellij;

import com.jetbrains.toolbox.intellij.IntelliJChannelExtension;
import com.jetbrains.toolbox.intellij.UtilKt;
import com.jetbrains.toolbox.intellij.vmoptions.VmOptionsFileLocationSideEffect;
import com.jetbrains.toolbox.tools.model.ApplicationDirectorySideEffect;
import com.jetbrains.toolbox.tools.model.SideEffect;
import com.jetbrains.toolbox.tools.model.ToolInstance;
import com.jetbrains.toolbox.tools.model.ToolRefreshHandler;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

public final class CustomVmOptionsRenamer
implements ToolRefreshHandler {
    @NotNull
    private final FileSystem fileSystem;

    public CustomVmOptionsRenamer(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
    }

    @NotNull
    public List<SideEffect> getSideEffects() {
        return CollectionsKt.listOf((Object)VmOptionsFileLocationSideEffect.INSTANCE);
    }

    @NotNull
    public List<SideEffect> getRunAfter() {
        return CollectionsKt.listOf((Object)ApplicationDirectorySideEffect.INSTANCE);
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull ToolInstance initial, @NotNull Continuation<? super ToolInstance> $completion) {
        if (!Intrinsics.areEqual((Object)initial.getChannel().getInstallationDirectory(), (Object)toolInstance.getChannel().getInstallationDirectory())) {
            IntelliJChannelExtension intelliJChannelExtension = UtilKt.getIntellij(toolInstance.getChannel());
            boolean bl = intelliJChannelExtension != null ? !intelliJChannelExtension.getDefaultVmOptionsLocation() : false;
            if (bl) {
                this.moveVmOptionsToNewDirectory(toolInstance, initial);
            }
        }
        return toolInstance;
    }

    private final void moveVmOptionsToNewDirectory(ToolInstance next2, ToolInstance prev) {
        Path path2 = com.jetbrains.toolbox.intellij.vmoptions.UtilKt.getVmoptionsPath(prev);
        if (path2 == null) {
            return;
        }
        Path currentVmOptionsPath = path2;
        if (this.fileSystem.exists(currentVmOptionsPath)) {
            Path path3 = com.jetbrains.toolbox.intellij.vmoptions.UtilKt.getVmoptionsPath(next2);
            if (path3 == null) {
                return;
            }
            Path newVmOptionsPath = path3;
            Logger.INSTANCE.info("Moving custom .vmoptions from " + currentVmOptionsPath + " to " + newVmOptionsPath);
            this.fileSystem.atomicMove(currentVmOptionsPath, newVmOptionsPath);
        }
    }

    @Override
    @Nullable
    public Object onRefresh(@NotNull ToolInstance toolInstance, @NotNull Continuation<? super ToolInstance> $completion) {
        throw new IllegalStateException("Should not be called".toString());
    }
}

