/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.integration;

import com.jetbrains.toolbox.ApplicationStartType;
import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.BuildNumber;
import com.jetbrains.toolbox.CommandLine;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.io.Copy_and_moveKt;
import com.jetbrains.toolbox.common.io.FileSize;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.integration.InstallationTypeTracker;
import com.jetbrains.toolbox.integration.OSIntegrationManagerImpl;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.interop.Processes;
import com.jetbrains.toolbox.interop.RunAsMode;
import com.jetbrains.toolbox.interop.Win32Integration;
import com.jetbrains.toolbox.interop.Win32Registry;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.datetime.Clock;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nOSIntegrationManagerWindows.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSIntegrationManagerWindows.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerWindows\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n1#2:233\n774#3:234\n865#3,2:235\n1869#3,2:237\n*S KotlinDebug\n*F\n+ 1 OSIntegrationManagerWindows.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerWindows\n*L\n150#1:234\n150#1:235,2\n151#1:237,2\n*E\n"})
public final class OSIntegrationManagerWindows
extends OSIntegrationManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final CommandLine commandLine;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Path logFile;
    @NotNull
    private final ShellEnvironment shellEnvironment;
    @NotNull
    private final InstallationTypeTracker installationTypeTracker;

    public OSIntegrationManagerWindows(@NotNull FileSystem fileSystem, @NotNull CommandLine commandLine, @NotNull CoroutineScope coroutineScope, @NotNull Path logFile, @NotNull ShellEnvironment shellEnvironment, @NotNull InstallationTypeTracker installationTypeTracker) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
        Intrinsics.checkNotNullParameter((Object)installationTypeTracker, (String)"installationTypeTracker");
        this.fileSystem = fileSystem;
        this.commandLine = commandLine;
        this.coroutineScope = coroutineScope;
        this.logFile = logFile;
        this.shellEnvironment = shellEnvironment;
        this.installationTypeTracker = installationTypeTracker;
    }

    @Override
    @NotNull
    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    @NotNull
    protected CommandLine getCommandLine() {
        return this.commandLine;
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope$core() {
        return this.coroutineScope;
    }

    @Override
    @NotNull
    public Path getLogFile() {
        return this.logFile;
    }

    @Override
    @NotNull
    protected ShellEnvironment getShellEnvironment() {
        return this.shellEnvironment;
    }

    @Override
    @NotNull
    protected OSIntegrationManagerImpl.InstallationResult install(@Nullable Path installTarget) {
        OSIntegrationManagerImpl.InstallationResult installResult;
        Path bin = StandardPaths.INSTANCE.getToolboxDataLocation().resolve("bin");
        if (installTarget != null) {
            Logger.INSTANCE.error("Install target '" + installTarget + "' is ignored. Installing into default path: '" + bin + "'");
        }
        try {
            installResult = this.safeInstall(bin);
            if (installResult instanceof OSIntegrationManagerImpl.InstallationResult.Success) {
                ApplicationStartType applicationStartType = this.getCommandLine().getInstallType();
                if (applicationStartType == null) {
                    applicationStartType = ApplicationStartType.APP;
                }
                this.installationTypeTracker.writeInstallationType(applicationStartType);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to mark installation type for further launches");
            installResult = OSIntegrationManagerImpl.InstallationResult.Companion.otherError(e);
        }
        OSIntegrationManagerImpl.InstallationResult result2 = installResult;
        OSIntegrationManagerImpl.LaunchResult launchResult = this.safeLaunch(bin, result2 instanceof OSIntegrationManagerImpl.InstallationResult.Success);
        OSIntegrationManagerImpl.InstallationResult.Failed failed = result2 instanceof OSIntegrationManagerImpl.InstallationResult.Failed ? (OSIntegrationManagerImpl.InstallationResult.Failed)result2 : null;
        return failed != null ? (OSIntegrationManagerImpl.InstallationResult)failed : launchResult.toInstallationResult(this);
    }

    @Override
    protected void uninstall() {
        Win32Integration.INSTANCE.removeStartMenuShortcut();
        Win32Integration.INSTANCE.removeAutoRunEntry();
        Win32Integration.INSTANCE.unregisterProtocolHandler("jetbrains");
        Win32Integration.INSTANCE.deleteRegKey(Win32Registry.Hive.HKCU.INSTANCE, "Software\\JavaSoft\\Prefs\\JetBrains\\jetprofile");
        Win32Integration.INSTANCE.deleteRegKey(Win32Registry.Hive.HKCU.INSTANCE, "Software\\JavaSoft\\Prefs\\JetBrains\\privacy_policy");
    }

    @Override
    protected void ensureOSIntegration(boolean runOnStartup, boolean startMenuShortcut) {
        if (this.getCommandLine().isUpdateFailed()) {
            return;
        }
        Win32Integration.INSTANCE.registerProtocolHandler("jetbrains", OS.INSTANCE.getApplicationExecutable());
        if (this.isAllowedToModifyAutostartOrStartMenu()) {
            this.ensureStartMenuShortcut(startMenuShortcut);
            this.ensureAutorun(runOnStartup);
        }
    }

    @Override
    protected void ensureAutorun(boolean enabled) {
        if (!this.isAllowedToModifyAutostartOrStartMenu()) {
            return;
        }
        if (enabled) {
            Win32Integration.INSTANCE.ensureAutoRunEntry();
        } else {
            Win32Integration.INSTANCE.removeAutoRunEntry();
        }
    }

    @Override
    protected void ensureStartMenuShortcut(boolean enabled) {
        if (!this.isAllowedToModifyAutostartOrStartMenu()) {
            return;
        }
        if (enabled) {
            Win32Integration.INSTANCE.ensureStartMenuShortcut();
        } else {
            Win32Integration.INSTANCE.removeStartMenuShortcut();
        }
    }

    @Override
    protected void unsafeOpenPath(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Win32Integration.INSTANCE.openExplorerAndSelect(path2.toString());
    }

    @Override
    @Nullable
    public Object unsafeOpenUrl$core(@NotNull String url, @NotNull Continuation<? super Unit> $completion) {
        String[] stringArray = new String[]{"/c", "start \"\" \"" + url + "\""};
        if (OSIntegrationManagerImpl.tryRunSystemExecutable$default(this, "cmd", stringArray, null, 4, null)) {
            return Unit.INSTANCE;
        }
        Logger.INSTANCE.info("Failed to use 'cmd /c start' to open " + url + ", trying to find browser executable");
        Object object = super.unsafeOpenUrl$core(url, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public String getFileManagerName() {
        return "Explorer";
    }

    @Override
    public void openSystemProxySettings() {
        this.launch((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ OSIntegrationManagerWindows this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (BuildNumber.compareTo-Szkhn3Q(OS.INSTANCE.getKernelVersion-Y_E1uuk(), BuildNumber.constructor-impl("10")) >= 0) {
                            String[] stringArray = new String[]{"/c", "start", "ms-settings:network-proxy"};
                            v0 = Boxing.boxBoolean((boolean)OSIntegrationManagerImpl.tryRunSystemExecutable$default(this.this$0, "cmd", stringArray, null, 4, null));
                        } else {
                            Path controlPanel = this.this$0.getShellEnvironment().findExecutable("control");
                            if (controlPanel == null) {
                                Logger.INSTANCE.warn("Can not find Control Panel executable");
                                return Unit.INSTANCE;
                            }
                            v0 = ProcessRunner.forkProcessNoWait$default((ProcessRunner)Processes.INSTANCE, controlPanel, CollectionsKt.listOf((Object)"inetcpl.cpl,,4"), null, null, RunAsMode.RunAsUser, null, null, 104, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final OSIntegrationManagerImpl.InstallationResult safeInstall(Path bin) {
        try {
            Path source = StandardPaths.INSTANCE.getApplicationDir();
            Logger.INSTANCE.info("Update: installing application from " + source + " to " + bin);
            Path binNew = Path.Companion.get$default((Path.Companion)Path.Companion, (String)(bin + ".new" + Clock.System.INSTANCE.now().getEpochSeconds()), (boolean)false, (int)1, null);
            Path binOld = Path.Companion.get$default((Path.Companion)Path.Companion, (String)(bin + ".old" + Clock.System.INSTANCE.now().getEpochSeconds()), (boolean)false, (int)1, null);
            try {
                Path path2 = bin.parent();
                if (path2 != null) {
                    Path path3 = path2;
                    Object object = this.getFileSystem();
                    Path p0 = path3;
                    boolean bl2 = false;
                    List list2 = object.list(p0);
                    if (list2 != null) {
                        void $this$forEach$iv;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        object = list2;
                        boolean $i$f$filter = false;
                        void bl2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Path it = (Path)element$iv$iv;
                            boolean bl3 = false;
                            if (!(StringsKt.startsWith$default((String)it.name(), (String)"bin.new", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it.name(), (String)"bin.old", (boolean)false, (int)2, null))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        FileSystem fileSystem = this.getFileSystem();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Path p02 = (Path)element$iv;
                            boolean bl4 = false;
                            fileSystem.deleteRecursively(p02);
                        }
                    }
                }
            }
            catch (Throwable t2) {
                Logger.INSTANCE.warn(t2, "Update: unable to remove old directories");
            }
            try {
                Copy_and_moveKt.copyRecursively$default(this.getFileSystem(), source, binNew, null, false, 0, 28, null);
            }
            catch (Throwable t3) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles(source, binNew, t3, true);
            }
            if (this.getFileSystem().exists(bin) && !OSIntegrationManagerWindows.rename-Wn2Vu4Y$default(this, bin, binOld, 0, 0L, 12, null)) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles$default(OSIntegrationManagerImpl.InstallationResult.Companion, bin, binOld, null, false, 12, null);
            }
            if (!OSIntegrationManagerWindows.rename-Wn2Vu4Y$default(this, binNew, bin, 0, 0L, 12, null)) {
                OSIntegrationManagerWindows.rename-Wn2Vu4Y$default(this, binOld, bin, 0, 0L, 12, null);
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles$default(OSIntegrationManagerImpl.InstallationResult.Companion, binNew, bin, null, false, 12, null);
            }
            try {
                Win32Integration.writeRegValue$default(Win32Integration.INSTANCE, (Win32Registry.Hive)Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Toolbox", "DisplayVersion", Build.INSTANCE.getBuildNumber-Y_E1uuk(), false, 16, null);
                long size = FileSize.getKibibytes-impl(FileSystemExtKt.calculateSizeRecursively(this.getFileSystem(), bin));
                if (size > 0L) {
                    Win32Integration.writeRegValue$default(Win32Integration.INSTANCE, (Win32Registry.Hive)Win32Registry.Hive.HKCU.INSTANCE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Toolbox", "EstimatedSize", String.valueOf(size), false, 16, null);
                }
            }
            catch (Throwable t4) {
                Logger.INSTANCE.info(t4);
            }
            try {
                this.getFileSystem().deleteRecursively(binOld);
            }
            catch (Exception e) {
                Logger.INSTANCE.warn((Throwable)e, "Unable to delete old build: '" + binOld + "'");
            }
            Logger.INSTANCE.info("Update: successfully updated " + bin + ", restarting from it");
            return OSIntegrationManagerImpl.InstallationResult.Success.INSTANCE;
        }
        catch (Throwable t5) {
            return OSIntegrationManagerImpl.InstallationResult.Companion.otherError(t5);
        }
    }

    private final boolean rename-Wn2Vu4Y(Path from, Path to, int attempts, long l) {
        int i2 = 1;
        if (i2 <= attempts) {
            while (true) {
                try {
                    this.getFileSystem().atomicMove(from, to);
                    Thread.sleep(Duration.getInWholeMilliseconds-impl((long)l));
                    return true;
                }
                catch (Throwable t2) {
                    Logger.INSTANCE.warn(t2, "Failed to move " + from + " -> " + to + " atomically (attempt #" + i2 + ")");
                    if (i2 == attempts) break;
                    ++i2;
                    continue;
                }
                break;
            }
        }
        Thread.sleep(Duration.getInWholeMilliseconds-impl((long)l));
        return false;
    }

    static /* synthetic */ boolean rename-Wn2Vu4Y$default(OSIntegrationManagerWindows oSIntegrationManagerWindows, Path path2, Path path3, int n, long l, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 5;
        }
        if ((n2 & 8) != 0) {
            l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
        }
        return oSIntegrationManagerWindows.rename-Wn2Vu4Y(path2, path3, n, l);
    }

    @Override
    public boolean addLocationToPath(@NotNull Path location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        String locationToAdd = location.toString();
        String string = Win32Integration.readRegValue$default(Win32Integration.INSTANCE, Win32Registry.Hive.HKCU.INSTANCE, "Environment", "Path", false, 8, null);
        if (string == null) {
            string = "";
        }
        String userPath = string;
        String string2 = Companion.appendToPath$core(userPath, locationToAdd);
        if (string2 == null) {
            OSIntegrationManagerWindows $this$addLocationToPath_u24lambda_u240 = this;
            boolean bl = false;
            Logger.INSTANCE.debug("The `" + location + "` location is already in the user PATH (`" + userPath + "`)");
            return true;
        }
        String newUserPath = string2;
        Win32Integration.writeRegValue$default(Win32Integration.INSTANCE, (Win32Registry.Hive)Win32Registry.Hive.HKCU.INSTANCE, "Environment", "Path", newUserPath, false, 16, null);
        Logger.INSTANCE.debug("The `" + location + "` location is added to the user PATH (`" + userPath + "`)");
        return true;
    }

    @SourceDebugExtension(value={"SMAP\nOSIntegrationManagerWindows.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSIntegrationManagerWindows.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerWindows$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n1761#2,3:233\n774#2:236\n865#2,2:237\n*S KotlinDebug\n*F\n+ 1 OSIntegrationManagerWindows.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerWindows$Companion\n*L\n38#1:233,3\n44#1:236\n44#1:237,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String appendToPath$core(@NotNull String oldPath, @NotNull String newEntry) {
            void $this$filterTo$iv$iv;
            boolean alreadyAdded;
            List pathElements;
            block5: {
                Intrinsics.checkNotNullParameter((Object)oldPath, (String)"oldPath");
                Intrinsics.checkNotNullParameter((Object)newEntry, (String)"newEntry");
                String[] stringArray = new String[]{StandardPaths.INSTANCE.getPathSeparator()};
                pathElements = StringsKt.split$default((CharSequence)oldPath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                Iterable $this$any$iv = pathElements;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!StringsKt.equals((String)it, (String)newEntry, (boolean)true)) continue;
                        v0 = true;
                        break block5;
                    }
                    v0 = alreadyAdded = false;
                }
            }
            if (alreadyAdded) {
                return null;
            }
            Iterable $this$filter$iv = CollectionsKt.plus((Collection)pathElements, (Object)newEntry);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String p0 = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)p0).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, Companion::appendToPath$lambda$1, (int)30, null);
        }

        private static final CharSequence appendToPath$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it + StandardPaths.INSTANCE.getPathSeparator();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

