/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.integration;

import com.jetbrains.toolbox.ApplicationStartType;
import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.CommandLine;
import com.jetbrains.toolbox.ErrorsHelperKt;
import com.jetbrains.toolbox.OS;
import com.jetbrains.toolbox.StandardPaths;
import com.jetbrains.toolbox.common.concurrent.ThreadGuardKt;
import com.jetbrains.toolbox.common.io.Copy_and_moveKt;
import com.jetbrains.toolbox.common.io.FileSystemExtKt;
import com.jetbrains.toolbox.common.io.PathExtensionsKt;
import com.jetbrains.toolbox.common.io.Temp_directoryKt;
import com.jetbrains.toolbox.dotDesktopFiles.DotDesktopAccessor;
import com.jetbrains.toolbox.integration.InstallationTypeTracker;
import com.jetbrains.toolbox.integration.OSIntegrationManagerImpl;
import com.jetbrains.toolbox.interop.ProcessRunner;
import com.jetbrains.toolbox.interop.Processes;
import com.jetbrains.toolbox.interop.RunAsMode;
import com.jetbrains.toolbox.shell.ShellEnvironment;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import okio.BufferedSink;
import okio.FileMetadata;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nOSIntegrationManagerLinux.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OSIntegrationManagerLinux.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerLinux\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,489:1\n1#2:490\n80#3:491\n165#3:492\n81#3:493\n82#3:498\n52#4,4:494\n60#4,10:499\n56#4,18:509\n*S KotlinDebug\n*F\n+ 1 OSIntegrationManagerLinux.kt\ncom/jetbrains/toolbox/integration/OSIntegrationManagerLinux\n*L\n382#1:491\n382#1:492\n382#1:493\n382#1:498\n382#1:494,4\n382#1:499,10\n382#1:509,18\n*E\n"})
public final class OSIntegrationManagerLinux
extends OSIntegrationManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final CommandLine commandLine;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Path logFile;
    @NotNull
    private final ShellEnvironment shellEnvironment;
    @NotNull
    private final DotDesktopAccessor dotDesktopAccessor;
    @NotNull
    private final Function0<Unit> updateIconCache;
    @NotNull
    private final Function1<Path, Unit> updateMimeTypesDb;
    @NotNull
    private final InstallationTypeTracker installationTypeTracker;
    @Nullable
    private final Path providedExecutable;
    @Nullable
    private final Path appDir;
    @NotNull
    private final String executableName;
    private final boolean isAppImage;
    @NotNull
    private final Lazy applicationExecutable$delegate;
    @NotNull
    private final Lazy installationPath$delegate;
    @NotNull
    private final Path executable;
    @NotNull
    private static final Path DefaultInstallationPath = StandardPaths.INSTANCE.getToolboxDataLocation().resolve("bin");
    @NotNull
    private static final byte[] ElfHeader;
    @NotNull
    private static final byte[] AppImageMagic;

    public OSIntegrationManagerLinux(@NotNull FileSystem fileSystem, @NotNull CommandLine commandLine, @NotNull CoroutineScope coroutineScope, @NotNull Path logFile, @NotNull ShellEnvironment shellEnvironment, @NotNull DotDesktopAccessor dotDesktopAccessor, @NotNull Function0<Unit> updateIconCache, @NotNull Function1<? super Path, Unit> updateMimeTypesDb, @NotNull InstallationTypeTracker installationTypeTracker, @Nullable Path providedExecutable, @Nullable Path appDir) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)logFile, (String)"logFile");
        Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
        Intrinsics.checkNotNullParameter((Object)dotDesktopAccessor, (String)"dotDesktopAccessor");
        Intrinsics.checkNotNullParameter(updateIconCache, (String)"updateIconCache");
        Intrinsics.checkNotNullParameter(updateMimeTypesDb, (String)"updateMimeTypesDb");
        Intrinsics.checkNotNullParameter((Object)installationTypeTracker, (String)"installationTypeTracker");
        this.fileSystem = fileSystem;
        this.commandLine = commandLine;
        this.coroutineScope = coroutineScope;
        this.logFile = logFile;
        this.shellEnvironment = shellEnvironment;
        this.dotDesktopAccessor = dotDesktopAccessor;
        this.updateIconCache = updateIconCache;
        this.updateMimeTypesDb = updateMimeTypesDb;
        this.installationTypeTracker = installationTypeTracker;
        this.providedExecutable = providedExecutable;
        this.appDir = appDir;
        this.executableName = "jetbrains-toolbox";
        this.isAppImage = this.appDir != null;
        this.applicationExecutable$delegate = LazyKt.lazy(OSIntegrationManagerLinux::applicationExecutable_delegate$lambda$0);
        this.installationPath$delegate = LazyKt.lazy(() -> OSIntegrationManagerLinux.installationPath_delegate$lambda$0(this));
        Path path2 = this.providedExecutable;
        if (path2 == null) {
            path2 = this.getApplicationExecutable();
        }
        this.executable = path2;
    }

    public /* synthetic */ OSIntegrationManagerLinux(FileSystem fileSystem, CommandLine commandLine, CoroutineScope coroutineScope, Path path2, ShellEnvironment shellEnvironment, DotDesktopAccessor dotDesktopAccessor, Function0 function0, Function1 function1, InstallationTypeTracker installationTypeTracker, Path path3, Path path4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            String string = shellEnvironment.get("APPIMAGE");
            Path path5 = path3 = string != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null) : null;
        }
        if ((n & 0x400) != 0) {
            String string = shellEnvironment.get("APPDIR");
            path4 = string != null ? Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null) : null;
        }
        this(fileSystem, commandLine, coroutineScope, path2, shellEnvironment, dotDesktopAccessor, (Function0<Unit>)function0, (Function1<? super Path, Unit>)function1, installationTypeTracker, path3, path4);
    }

    @Override
    @NotNull
    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    @NotNull
    protected CommandLine getCommandLine() {
        return this.commandLine;
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope$core() {
        return this.coroutineScope;
    }

    @Override
    @NotNull
    public Path getLogFile() {
        return this.logFile;
    }

    @Override
    @NotNull
    protected ShellEnvironment getShellEnvironment() {
        return this.shellEnvironment;
    }

    @Override
    @NotNull
    public Path getApplicationExecutable() {
        Lazy lazy = this.applicationExecutable$delegate;
        return (Path)lazy.getValue();
    }

    @Override
    @NotNull
    public Path getInstallationPath() {
        Lazy lazy = this.installationPath$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final Path getLinuxToolboxIcon() {
        return this.getInstallationPath().resolve("toolbox.svg");
    }

    @Override
    public boolean runToolboxApp() {
        boolean bl;
        Path path2 = this.executable.parent();
        if (path2 != null) {
            Path it = path2;
            boolean bl2 = false;
            bl = this.runProduct(it, true);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    protected OSIntegrationManagerImpl.InstallationResult install(@Nullable Path installTarget) {
        return this.isAppImage ? this.installAppImage(installTarget) : this.installTarball(installTarget);
    }

    private final OSIntegrationManagerImpl.InstallationResult installTarball(Path installTarget) {
        OSIntegrationManagerImpl.InstallationResult installResult;
        Path installSource = this.resolveTarballInstallSource();
        Path binDir = this.getBinDir(installTarget);
        try {
            installResult = this.safeInstallTarball(binDir, installSource);
            if (installResult instanceof OSIntegrationManagerImpl.InstallationResult.Success) {
                ApplicationStartType applicationStartType = this.getCommandLine().getInstallType();
                if (applicationStartType == null) {
                    applicationStartType = ApplicationStartType.APP;
                }
                this.installationTypeTracker.writeInstallationType(applicationStartType);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.error((Throwable)e, "Failed to mark installation type for further launches");
            installResult = OSIntegrationManagerImpl.InstallationResult.Companion.otherError(e);
        }
        OSIntegrationManagerImpl.InstallationResult result2 = installResult;
        OSIntegrationManagerImpl.LaunchResult launchResult = this.safeLaunch(binDir, result2 instanceof OSIntegrationManagerImpl.InstallationResult.Success);
        OSIntegrationManagerImpl.InstallationResult.Failed failed = result2 instanceof OSIntegrationManagerImpl.InstallationResult.Failed ? (OSIntegrationManagerImpl.InstallationResult.Failed)result2 : null;
        return failed != null ? (OSIntegrationManagerImpl.InstallationResult)failed : launchResult.toInstallationResult(this);
    }

    private final Path resolveTarballInstallSource() {
        Path path2;
        block4: {
            block3: {
                path2 = this.getCommandLine().getInstallSource();
                if (path2 == null) break block3;
                Path fromCommandLine = path2;
                boolean bl = false;
                Path path3 = this.getFileSystem().exists(fromCommandLine.resolve("bin")) ? fromCommandLine.resolve("bin") : fromCommandLine;
                path2 = path3;
                if (path3 != null) break block4;
            }
            OSIntegrationManagerLinux $this$resolveTarballInstallSource_u24lambda_u241 = this;
            boolean bl = false;
            path2 = $this$resolveTarballInstallSource_u24lambda_u241.getInstallationPath();
        }
        return path2;
    }

    private final OSIntegrationManagerImpl.InstallationResult safeInstallTarball(Path destinationPath, Path installSource) {
        try {
            Path t22;
            Path path2;
            Logger.INSTANCE.info("Installing to " + destinationPath);
            Path launcher = destinationPath.resolve(this.executableName);
            Path path3 = destinationPath.parent();
            if (path3 == null) {
                ErrorsHelperKt.errorResult$default(destinationPath + " has no parent directory", null, 2, null);
                throw new KotlinNothingValueException();
            }
            Path toolboxDataDir = path3;
            try {
                path2 = Temp_directoryKt.createTempDirectory(this.getFileSystem(), toolboxDataDir, "bin.next");
            }
            catch (Throwable t22) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.failedToCreateTempDirectory(this, t22, toolboxDataDir, "Failed to create temporary installation directory under " + toolboxDataDir);
            }
            Path nextBinDir = path2;
            try {
                Copy_and_moveKt.copyRecursively$default(this.getFileSystem(), installSource, nextBinDir, null, false, 0, 28, null);
            }
            catch (Throwable t3) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles(installSource, nextBinDir, t3, true);
            }
            try {
                t22 = Temp_directoryKt.createTempDirectory(this.getFileSystem(), toolboxDataDir, "bin.prev");
            }
            catch (Throwable t4) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.failedToCreateTempDirectory(this, t4, toolboxDataDir, "Failed to create temporary installation directory under " + toolboxDataDir);
            }
            Path previousBinDir = t22;
            try {
                Copy_and_moveKt.unsafeRename(destinationPath, previousBinDir);
            }
            catch (Throwable t23) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles$default(OSIntegrationManagerImpl.InstallationResult.Companion, destinationPath, previousBinDir, t23, false, 8, null);
            }
            try {
                Copy_and_moveKt.unsafeRename(nextBinDir, destinationPath);
            }
            catch (Throwable t3) {
                try {
                    this.getFileSystem().deleteRecursively(destinationPath);
                    Copy_and_moveKt.unsafeRename(previousBinDir, destinationPath);
                }
                catch (Throwable t5) {
                    Logger.INSTANCE.error(t5, "Failed to restore previous installation: " + destinationPath);
                }
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles$default(OSIntegrationManagerImpl.InstallationResult.Companion, nextBinDir, destinationPath, t3, false, 8, null);
            }
            try {
                this.getFileSystem().deleteRecursively(previousBinDir);
            }
            catch (Throwable t4) {
                Logger.INSTANCE.warn(t4, "Unable to delete old build: '" + previousBinDir + "'");
            }
            FileSystemExtKt.setExecutable$default(this.getFileSystem(), launcher, true, false, 4, null);
            return OSIntegrationManagerImpl.InstallationResult.Success.INSTANCE;
        }
        catch (Throwable t6) {
            return OSIntegrationManagerImpl.InstallationResult.Companion.otherError(t6);
        }
    }

    private final OSIntegrationManagerImpl.InstallationResult installAppImage(Path installTarget) {
        OSIntegrationManagerImpl.InstallationResult result2;
        if (!(this.getCommandLine().getType() == ApplicationStartType.APP)) {
            boolean $i$a$-require-OSIntegrationManagerLinux$installAppImage$22 = false;
            String $i$a$-require-OSIntegrationManagerLinux$installAppImage$22 = "appimage predates daemon, so it's not possible to install a daemon from it";
            throw new IllegalArgumentException($i$a$-require-OSIntegrationManagerLinux$installAppImage$22.toString());
        }
        Path binDir = OSIntegrationManagerLinux.getBinDir$default(this, null, 1, null);
        this.getFileSystem().createDirectories(binDir);
        Path destinationPath = binDir.resolve(this.executableName);
        if (installTarget != null) {
            Logger.INSTANCE.error("Install target '" + installTarget + "' is ignored. Installing into default path: '" + destinationPath + "'");
        }
        if ((result2 = this.safeInstall(destinationPath)) instanceof OSIntegrationManagerImpl.InstallationResult.Failed) {
            this.safeLaunch(binDir, false);
            return result2;
        }
        OSIntegrationManagerImpl.InstallationResult buildTxtResult = this.addBuildTxt(binDir);
        OSIntegrationManagerImpl.LaunchResult launchResult = this.safeLaunch(binDir, buildTxtResult instanceof OSIntegrationManagerImpl.InstallationResult.Success);
        OSIntegrationManagerImpl.InstallationResult.Failed failed = buildTxtResult instanceof OSIntegrationManagerImpl.InstallationResult.Failed ? (OSIntegrationManagerImpl.InstallationResult.Failed)buildTxtResult : null;
        return failed != null ? (OSIntegrationManagerImpl.InstallationResult)failed : launchResult.toInstallationResult(this);
    }

    private final OSIntegrationManagerImpl.InstallationResult safeInstall(Path destinationPath) {
        try {
            Logger.INSTANCE.info("Installing to " + destinationPath);
            Path temporaryDestination = Path.Companion.get$default((Path.Companion)Path.Companion, (String)(destinationPath + ".1"), (boolean)false, (int)1, null);
            try {
                Copy_and_moveKt.copyRecursively$default(this.getFileSystem(), this.executable, temporaryDestination, null, false, 0, 28, null);
            }
            catch (Throwable t2) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles(this.executable, temporaryDestination, t2, true);
            }
            if (this.getFileSystem().exists(destinationPath)) {
                try {
                    this.getFileSystem().delete(destinationPath);
                }
                catch (Throwable t3) {
                    return OSIntegrationManagerImpl.InstallationResult.Companion.failedToRemove(this, t3, destinationPath);
                }
            }
            try {
                Copy_and_moveKt.safeAtomicMove$default(this.getFileSystem(), temporaryDestination, destinationPath, false, 0, 12, null);
            }
            catch (Throwable t4) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles$default(OSIntegrationManagerImpl.InstallationResult.Companion, temporaryDestination, destinationPath, t4, false, 8, null);
            }
            FileSystemExtKt.setExecutable$default(this.getFileSystem(), destinationPath, true, false, 4, null);
            return OSIntegrationManagerImpl.InstallationResult.Success.INSTANCE;
        }
        catch (Throwable t5) {
            return OSIntegrationManagerImpl.InstallationResult.Companion.otherError(t5);
        }
    }

    private final OSIntegrationManagerImpl.InstallationResult addBuildTxt(Path binDir) {
        if (this.appDir != null) {
            Path source = this.appDir.resolve("build.txt");
            Path target = binDir.resolve("build.txt");
            try {
                this.getFileSystem().copy(source, target);
            }
            catch (Throwable t2) {
                return OSIntegrationManagerImpl.InstallationResult.Companion.cannotMoveFiles(source, target, t2, true);
            }
        }
        return OSIntegrationManagerImpl.InstallationResult.Success.INSTANCE;
    }

    @Override
    protected void uninstall() {
        Path dotDesktop = StandardPaths.INSTANCE.getApplicationsLocationFile().resolve("jetbrains-toolbox.desktop");
        this.getFileSystem().delete(dotDesktop);
        this.getFileSystem().delete(this.getLinuxToolboxIcon());
        this.ensureAutorun(false);
        this.updateIconCache.invoke();
        this.updateMimeTypesDb.invoke((Object)StandardPaths.INSTANCE.getApplicationsLocationFile());
    }

    @Override
    protected void ensureOSIntegration(boolean runOnStartup, boolean startMenuShortcut) {
        if (this.getCommandLine().isUpdateFailed()) {
            return;
        }
        if (!PathExtensionsKt.contains(OSIntegrationManagerLinux.getBinDir$default(this, null, 1, null), this.executable) && this.isAppImage && !Build.INSTANCE.isSNAPSHOT()) {
            Logger.INSTANCE.info("Application not installed, installing now");
            this.install(this.getCommandLine().getInstallTarget());
            throw new OSIntegrationManagerImpl.ExitAfterStartupTaskPerformedException("Toolbox app is installed to .local");
        }
        if (this.getCommandLine().getType() == ApplicationStartType.APP) {
            this.installDesktopFile(this.dotDesktopAccessor);
            Companion.setProtocolHandlerToDesktopFile(this.getShellEnvironment());
        }
        if (this.isAllowedToModifyAutostartOrStartMenu()) {
            this.ensureAutorun(runOnStartup);
        }
    }

    private final Path getBinDir(Path installTarget) {
        Path path2;
        block3: {
            block2: {
                path2 = installTarget;
                if (path2 == null) break block2;
                Path it = path2;
                boolean bl = false;
                Path path3 = OSIntegrationManagerLinux.getBinDir$resolved(this, it);
                path2 = path3;
                if (path3 != null) break block3;
            }
            OSIntegrationManagerLinux $this$getBinDir_u24lambda_u241 = this;
            boolean bl = false;
            Logger.INSTANCE.debug("Installation target is not provided, falling back to standard path");
            path2 = OSIntegrationManagerLinux.getBinDir$resolved(this, DefaultInstallationPath);
        }
        return path2;
    }

    static /* synthetic */ Path getBinDir$default(OSIntegrationManagerLinux oSIntegrationManagerLinux, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            path2 = null;
        }
        return oSIntegrationManagerLinux.getBinDir(path2);
    }

    @Override
    protected void ensureAutorun(boolean enabled) {
        if (!this.isAllowedToModifyAutostartOrStartMenu()) {
            return;
        }
        if (enabled) {
            Path autoStartDir = StandardPaths.INSTANCE.getConfigLocationFile().resolve("autostart");
            if (!this.getFileSystem().exists(autoStartDir)) {
                this.getFileSystem().createDirectories(autoStartDir);
            }
            this.installDesktopFileTo(this.dotDesktopAccessor, autoStartDir, true);
            Companion.setProtocolHandlerToDesktopFile(this.getShellEnvironment());
        } else {
            this.getFileSystem().delete(StandardPaths.INSTANCE.getConfigLocationFile().resolve("autostart").resolve("jetbrains-toolbox.desktop"));
        }
    }

    @Override
    protected void ensureStartMenuShortcut(boolean enabled) {
    }

    @Override
    protected void unsafeOpenPath(@NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Path fileManager = this.getShellEnvironment().findExecutable("nautilus");
        if (fileManager != null) {
            Object[] objectArray = new String[]{"--select", path2.toString()};
            v0 = ProcessRunner.forkProcessNoWait$default((ProcessRunner)Processes.INSTANCE, fileManager, CollectionsKt.listOf((Object[])objectArray), null, null, RunAsMode.RunAsUser, null, null, 108, null);
        } else {
            Path path3 = this.getShellEnvironment().findExecutable("xdg-open");
            if (path3 != null) {
                Path it = path3;
                boolean bl = false;
                Path path4 = path2.parent();
                if (path4 == null) {
                    return;
                }
                Path parent = path4;
                v0 = ProcessRunner.forkProcessNoWait$default((ProcessRunner)Processes.INSTANCE, it, CollectionsKt.listOf((Object)parent.toString()), parent, null, RunAsMode.RunAsUser, null, null, 104, null);
            } else {
                v0 = null;
            }
        }
    }

    private final boolean tryRunSystemExecutableFromFSRoot(String executable, String ... args) {
        return this.tryRunSystemExecutable(executable, Arrays.copyOf(args, args.length), Path.Companion.get$default((Path.Companion)Path.Companion, (String)"/", (boolean)false, (int)1, null));
    }

    @Override
    @Nullable
    public Object unsafeOpenUrl$core(@NotNull String url, @NotNull Continuation<? super Unit> $completion) {
        String[] stringArray = new String[]{url};
        if (this.tryRunSystemExecutableFromFSRoot("xdg-open", stringArray)) {
            return Unit.INSTANCE;
        }
        if (StringsKt.contains((CharSequence)OS.INSTANCE.getXdgCurrentDesktop(), (CharSequence)"GNOME", (boolean)true)) {
            stringArray = new String[]{url};
            if (this.tryRunSystemExecutableFromFSRoot("gnome-open", stringArray)) {
                return Unit.INSTANCE;
            }
        }
        Logger.INSTANCE.info("Failed to use desktop services to open " + url + ", trying to find browser executable");
        Object object = super.unsafeOpenUrl$core(url, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String getFileManagerName() {
        ThreadGuardKt.assertNotMainThread("java.io.File.exists()|.isFile");
        Path nautilus = this.getShellEnvironment().findExecutable("nautilus");
        if (nautilus == null) return "File Manager";
        FileMetadata fileMetadata2 = this.getFileSystem().metadataOrNull(nautilus);
        if (fileMetadata2 == null) return "File Manager";
        if (!fileMetadata2.isRegularFile()) return "File Manager";
        return "Nautilus";
    }

    @Override
    public void openSystemProxySettings() {
        this.launch((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ OSIntegrationManagerLinux this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.this$0.getShellEnvironment().get("XDG_CURRENT_DESKTOP");
                        if (v0 == null) {
                            v0 = "";
                        }
                        desktop = v0;
                        if (!StringsKt.startsWith$default((String)desktop, (String)"Unity", (boolean)false, (int)2, null)) ** GOTO lbl14
                        OSIntegrationManagerLinux.Companion.runSystemExecutable(this.this$0.getShellEnvironment(), CollectionsKt.listOf((Object)"unity-control-center"), CollectionsKt.listOf((Object)"network"));
                        ** GOTO lbl37
lbl14:
                        // 1 sources

                        if (!StringsKt.contains((CharSequence)desktop, (CharSequence)"GNOME", (boolean)true)) ** GOTO lbl18
                        var3_3 = new String[]{"gnome-control-center", "gnome-network-properties"};
                        OSIntegrationManagerLinux.Companion.runSystemExecutable(this.this$0.getShellEnvironment(), CollectionsKt.listOf((Object[])var3_3), CollectionsKt.listOf((Object)"network"));
                        ** GOTO lbl37
lbl18:
                        // 1 sources

                        var3_4 = desktop;
                        switch (var3_4.hashCode()) {
                            case -1382785370: {
                                if (!var3_4.equals("X-Cinnamon")) {
                                    ** break;
                                }
                                ** GOTO lbl34
                            }
                            case 2359045: {
                                if (var3_4.equals("MATE")) break;
                                ** break;
                            }
                            case 74252: {
                                if (!var3_4.equals("KDE")) ** break;
                                var4_5 = new String[]{"kcmshell5", "kcmshell4"};
                                OSIntegrationManagerLinux.Companion.runSystemExecutable(this.this$0.getShellEnvironment(), CollectionsKt.listOf((Object[])var4_5), CollectionsKt.listOf((Object)"proxy"));
                                ** GOTO lbl37
                            }
                        }
                        com.jetbrains.toolbox.integration.OSIntegrationManagerLinux$Companion.runSystemExecutable$default(OSIntegrationManagerLinux.Companion, this.this$0.getShellEnvironment(), CollectionsKt.listOf((Object)"mate-network-properties"), null, 4, null);
                        ** GOTO lbl37
lbl34:
                        // 1 sources

                        OSIntegrationManagerLinux.Companion.runSystemExecutable(this.this$0.getShellEnvironment(), CollectionsKt.listOf((Object)"cinnamon-settings"), CollectionsKt.listOf((Object)"network"));
                        ** GOTO lbl37
lbl36:
                        // 4 sources

                        Logger.INSTANCE.warn("Unknown desktop environment " + desktop);
lbl37:
                        // 6 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @NotNull
    protected List<Path> profileFiles() {
        String shell = this.getShellEnvironment().get("SHELL");
        if (shell != null) {
            if (StringsKt.endsWith$default((String)shell, (String)"bash", (boolean)false, (int)2, null)) {
                Object[] objectArray = new Path[2];
                objectArray[0] = StandardPaths.INSTANCE.getHome().resolve(".profile");
                Path path2 = this.ifExists(StandardPaths.INSTANCE.getHome().resolve(".bash_profile"));
                if (path2 == null) {
                    path2 = this.ifExists(StandardPaths.INSTANCE.getHome().resolve(".bash_login"));
                }
                objectArray[1] = path2;
                return CollectionsKt.listOfNotNull((Object[])objectArray);
            }
            if (StringsKt.endsWith$default((String)shell, (String)"zsh", (boolean)false, (int)2, null)) {
                Object[] objectArray = new Path[]{StandardPaths.INSTANCE.getHome().resolve(".profile"), this.ifExists(StandardPaths.INSTANCE.getHome().resolve(".zprofile"))};
                return CollectionsKt.listOfNotNull((Object[])objectArray);
            }
        }
        Logger.INSTANCE.debug("Can't find profile, unknown shell " + shell);
        return CollectionsKt.listOf((Object)StandardPaths.INSTANCE.getHome().resolve(".profile"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void installDesktopFile(DotDesktopAccessor $this$installDesktopFile) {
        FileSystem $this$installDesktopFile_u24lambda_u240 = this.getFileSystem();
        boolean bl = false;
        Path icon2 = this.getLinuxToolboxIcon();
        try {
            if ($this$installDesktopFile_u24lambda_u240.exists(icon2) && !FileSystemExtKt.isWritable($this$installDesktopFile_u24lambda_u240, icon2)) {
                FileSystemExtKt.setWritable($this$installDesktopFile_u24lambda_u240, icon2, true, true);
            }
            InputStream inputStream = $this$installDesktopFile_u24lambda_u240.getClass().getResourceAsStream("/toolbox.svg");
            Intrinsics.checkNotNull((Object)inputStream);
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                Long l;
                Throwable thrown$iv$iv;
                block30: {
                    void $this$iv;
                    InputStream src = (InputStream)closeable;
                    boolean bl2 = false;
                    FileSystem fileSystem = $this$installDesktopFile_u24lambda_u240;
                    Path file$iv = icon2;
                    boolean mustCreate$iv = false;
                    boolean bl3 = false;
                    Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, mustCreate$iv));
                    boolean $i$f$use = false;
                    thrown$iv$iv = null;
                    try {
                        long l2;
                        BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                        boolean bl4 = false;
                        BufferedSink $this$installDesktopFile_u24lambda_u240_u240_u240 = it$iv;
                        boolean bl5 = false;
                        Closeable closeable2 = $this$installDesktopFile_u24lambda_u240_u240_u240.outputStream();
                        Throwable throwable2 = null;
                        try {
                            OutputStream it = (OutputStream)closeable2;
                            boolean bl6 = false;
                            l2 = src.transferTo(it);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        l = l2;
                    }
                    catch (Throwable t$iv$iv) {
                        try {
                            thrown$iv$iv = t$iv$iv;
                            l = null;
                            break block30;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                        finally {
                            block31: {
                                try {
                                    Closeable closeable2 = $this$use$iv$iv;
                                    if (closeable2 != null) {
                                        closeable2.close();
                                    }
                                }
                                catch (Throwable t$iv$iv2) {
                                    if (thrown$iv$iv == null) {
                                        thrown$iv$iv = t$iv$iv2;
                                        break block31;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable3 = $this$use$iv$iv;
                        if (closeable3 != null) {
                            closeable3.close();
                        }
                    }
                    catch (Throwable t$iv$iv) {
                        thrown$iv$iv = t$iv$iv;
                    }
                }
                Long result$iv$iv = l;
                Throwable throwable2 = thrown$iv$iv;
                if (throwable2 != null) {
                    throw throwable2;
                }
                long l3 = ((Number)result$iv$iv).longValue();
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            FileSystemExtKt.setReadable($this$installDesktopFile_u24lambda_u240, icon2, true, false);
            FileSystemExtKt.setWritable($this$installDesktopFile_u24lambda_u240, icon2, true, true);
            FileSystemExtKt.setExecutable($this$installDesktopFile_u24lambda_u240, icon2, false, false);
            this.updateIconCache.invoke();
        }
        catch (Throwable t2) {
            Logger.INSTANCE.error(t2, "Failed to install icon for desktop file");
        }
        Path applicationDir = StandardPaths.INSTANCE.getApplicationsLocationFile();
        if (!$this$installDesktopFile_u24lambda_u240.exists(applicationDir)) {
            $this$installDesktopFile_u24lambda_u240.createDirectories(applicationDir);
        }
        this.installDesktopFileTo($this$installDesktopFile, applicationDir, false);
    }

    private final void installDesktopFileTo(DotDesktopAccessor $this$installDesktopFileTo, Path dir, boolean minimized) {
        Path path2 = dir.resolve("jetbrains-toolbox.desktop");
        String exec = this.executable + (minimized ? " --minimize" : " %u");
        String icon2 = this.getInstallationPath().resolve("toolbox.svg").toString();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Icon", (Object)icon2), TuplesKt.to((Object)"Exec", (Object)exec), TuplesKt.to((Object)"Version", (Object)"1.0"), TuplesKt.to((Object)"Type", (Object)"Application"), TuplesKt.to((Object)"Categories", (Object)"Development"), TuplesKt.to((Object)"Name", (Object)"JetBrains Toolbox"), TuplesKt.to((Object)"StartupWMClass", (Object)"jetbrains-toolbox"), TuplesKt.to((Object)"Terminal", (Object)"false"), TuplesKt.to((Object)"MimeType", (Object)"x-scheme-handler/jetbrains;"), TuplesKt.to((Object)"X-GNOME-Autostart-enabled", (Object)"true")};
        Map updatedDotDesktop = MapsKt.mutableMapOf((Pair[])pairArray);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"StartupNotify", (Object)"false"), TuplesKt.to((Object)"X-GNOME-Autostart-Delay", (Object)"10"), TuplesKt.to((Object)"X-MATE-Autostart-Delay", (Object)"10"), TuplesKt.to((Object)"X-KDE-autostart-after", (Object)"panel")};
        Map customizableFields = MapsKt.mapOf((Pair[])pairArray2);
        $this$installDesktopFileTo.ensureDotDesktopFile(path2, updatedDotDesktop, customizableFields);
        Logger.INSTANCE.info("Installed .desktop file to " + path2);
    }

    private static final Path applicationExecutable_delegate$lambda$0() {
        Logger.INSTANCE.debug("Resolving application executable path");
        java.nio.file.Path path2 = java.nio.file.Path.of("/proc/self/exe", new String[0]).toRealPath(new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toRealPath(...)");
        Path path3 = Path.Companion.get$default((Path.Companion)Path.Companion, (java.nio.file.Path)path2, (boolean)false, (int)1, null);
        Logger.INSTANCE.debug("Application executable path resolved to " + path3);
        return path3;
    }

    private static final Path installationPath_delegate$lambda$0(OSIntegrationManagerLinux this$0) {
        Path path2;
        block3: {
            block2: {
                Logger.INSTANCE.debug("Resolving installation path from " + this$0.executable);
                path2 = this$0.getApplicationExecutable().parent();
                if (path2 == null) break block2;
                Path path3 = path2;
                FileSystem fileSystem = this$0.getFileSystem();
                Path p0 = path3;
                boolean bl = false;
                Path path4 = FileSystemExtKt.canonicalizeOrNull(fileSystem, p0);
                path2 = path4;
                if (path4 != null) break block3;
            }
            path2 = StandardPaths.INSTANCE.getToolboxDataLocation();
        }
        return path2;
    }

    private static final Path getBinDir$resolved(OSIntegrationManagerLinux this$0, Path path2) {
        Path path3;
        try {
            Path resolved = this$0.getFileSystem().canonicalize(path2);
            Logger.INSTANCE.info("bin directory resolved to '" + resolved + "'");
        }
        catch (Throwable t2) {
            Logger.INSTANCE.info(t2, "bin directory cannot be resolved: " + t2.getMessage());
            path3 = path2;
        }
        return path3;
    }

    static {
        byte[] byArray = ByteBuffer.allocate(4).put((byte)127).put((byte)69).put((byte)76).put((byte)70).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        ElfHeader = byArray;
        byte[] byArray2 = ByteBuffer.allocate(4).putInt(4278530).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"array(...)");
        AppImageMagic = byArray2;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getDefaultInstallationPath() {
            return DefaultInstallationPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isAppImage(@NotNull Path $this$isAppImage) {
            Intrinsics.checkNotNullParameter((Object)$this$isAppImage, (String)"<this>");
            Closeable closeable = new FileInputStream($this$isAppImage.toFile());
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                byte[] buf = new byte[4];
                it.read(buf, 0, 4);
                if (!Arrays.equals(buf, ElfHeader)) {
                    boolean bl2 = false;
                    return bl2;
                }
                it.skip(3L);
                it.read(buf, 0, 4);
                boolean bl3 = Arrays.equals(buf, AppImageMagic);
                return bl3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public final void setProtocolHandlerToDesktopFile(@NotNull ShellEnvironment shellEnvironment) {
            Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
            Logger.INSTANCE.info("Adding jetbrains:// protocol handler to mimeapps.list");
            try {
                Path path2 = shellEnvironment.findExecutable("xdg-mime");
                if (path2 == null) {
                    ErrorsHelperKt.errorResult$default("Failed to find xdg-mime executable", null, 2, null);
                    throw new KotlinNothingValueException();
                }
                Path xdg = path2;
                Object[] objectArray = new String[]{"default", "jetbrains-toolbox.desktop", "x-scheme-handler/jetbrains"};
                ProcessRunner.executeProcessAndWait-9VgGkz4$default((ProcessRunner)Processes.INSTANCE, xdg, CollectionsKt.listOf((Object[])objectArray), null, null, 0L, 28, null);
            }
            catch (Throwable t2) {
                Logger.INSTANCE.error(t2, "Failed to set jetbrains:// protocol handler");
            }
        }

        public final void runSystemExecutable(@NotNull ShellEnvironment shellEnvironment, @NotNull List<String> executables, @NotNull List<String> arguments) {
            Intrinsics.checkNotNullParameter((Object)shellEnvironment, (String)"shellEnvironment");
            Intrinsics.checkNotNullParameter(executables, (String)"executables");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            for (String executable : executables) {
                Path path2 = shellEnvironment.findExecutable(executable);
                if (path2 == null) continue;
                ProcessRunner.forkProcessNoWait$default((ProcessRunner)Processes.INSTANCE, path2, arguments, null, null, RunAsMode.RunAsUser, null, null, 108, null);
                return;
            }
            ProcessRunner.forkProcessNoWait$default((ProcessRunner)Processes.INSTANCE, new File("/usr/bin/", (String)CollectionsKt.first(executables)), arguments, null, null, RunAsMode.RunAsUser, null, null, 104, null);
        }

        public static /* synthetic */ void runSystemExecutable$default(Companion companion, ShellEnvironment shellEnvironment, List list2, List list3, int n, Object object) {
            if ((n & 4) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            companion.runSystemExecutable(shellEnvironment, list2, list3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

