/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.wrapper;

import com.jetbrains.toolbox.Build;
import com.jetbrains.toolbox.api.remoteDev.connection.AgentConnection;
import com.jetbrains.toolbox.api.remoteDev.connection.AgentConnectionHandle;
import com.jetbrains.toolbox.api.remoteDev.connection.HostTunnelConnector;
import com.jetbrains.toolbox.api.remoteDev.deploy.DeploymentSettings;
import com.jetbrains.toolbox.api.remoteDev.deploy.DeploymentTarget;
import com.jetbrains.toolbox.api.remoteDev.environments.AgentConnectionBasedEnvironmentContentsView;
import com.jetbrains.toolbox.api.remoteDev.environments.EnvironmentContentsView;
import com.jetbrains.toolbox.api.remoteDev.environments.ManualEnvironmentContentsView;
import com.jetbrains.toolbox.api.remoteDev.environments.SshEnvironmentContentsView;
import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.api.remoteDev.states.EnvironmentDescription;
import com.jetbrains.toolbox.fus.Fus;
import com.jetbrains.toolbox.fus.FusEnums;
import com.jetbrains.toolbox.fus.FusFieldDescriptions;
import com.jetbrains.toolbox.gateway.DevEnvironment;
import com.jetbrains.toolbox.gateway.DevEnvironmentFeature;
import com.jetbrains.toolbox.gateway.DevEnvironmentProviderId;
import com.jetbrains.toolbox.gateway.HasRawPluginIdKt;
import com.jetbrains.toolbox.gateway.RawInterfaces;
import com.jetbrains.toolbox.gateway.RawInterfacesFactory;
import com.jetbrains.toolbox.gateway.RpcError;
import com.jetbrains.toolbox.gateway.deploy.DeployProcess;
import com.jetbrains.toolbox.gateway.error.ConnectionError;
import com.jetbrains.toolbox.gateway.error.DeployError;
import com.jetbrains.toolbox.gateway.ssh.SshConnection;
import com.jetbrains.toolbox.gateway.ssh.SshConnectionService;
import com.jetbrains.toolbox.gateway.states.AgentState;
import com.jetbrains.toolbox.gateway.wrapper.AbstractEnvironmentConnection;
import com.jetbrains.toolbox.gateway.wrapper.ConnectionResult;
import com.jetbrains.toolbox.gateway.wrapper.EnvironmentConnectionImpl;
import com.jetbrains.toolbox.gateway.wrapper.UtilKt;
import com.jetbrains.toolbox.manager.StatisticsManager;
import com.jetbrains.toolbox.rpc.RemoteToolboxClient;
import com.jetbrains.toolbox.rpc.RemoteToolboxClientFactory;
import com.jetbrains.toolbox.rpc.RemoteToolboxProcess;
import com.jetbrains.toolbox.rpc.RpcConnectionResult;
import com.jetbrains.toolbox.rpc.ToolboxKrpcClient;
import com.jetbrains.toolbox.rpc.TransportStatistics;
import com.jetbrains.toolbox.rpc.model.HandshakeResult;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nEnvironmentConnectionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentConnectionImpl.kt\ncom/jetbrains/toolbox/gateway/wrapper/EnvironmentConnectionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,239:1\n1869#2,2:240\n95#3:242\n135#3,3:243\n*S KotlinDebug\n*F\n+ 1 EnvironmentConnectionImpl.kt\ncom/jetbrains/toolbox/gateway/wrapper/EnvironmentConnectionImpl\n*L\n89#1:240,2\n109#1:242\n109#1:243,3\n*E\n"})
public final class EnvironmentConnectionImpl
extends AbstractEnvironmentConnection {
    @NotNull
    private final List<DevEnvironmentFeature> devEnvironmentFeatures;
    @NotNull
    private final EnvironmentContentsView contentsView;
    @NotNull
    private final MutableStateFlow<AgentState> agentState;
    @NotNull
    private final MutableStateFlow<EnvironmentDescription> descriptionState;
    @NotNull
    private final DeploymentTarget forcedDeployTarget;
    private final boolean redeploy;
    @NotNull
    private final CoroutineScope outerScope;
    @NotNull
    private final DeployProcess deployProcess;
    @NotNull
    private final SshConnectionService sshConnectionService;
    @NotNull
    private final RemoteToolboxClientFactory clientFactory;
    @NotNull
    private final RawInterfacesFactory rawInterfacesFactory;
    @NotNull
    private final StatisticsManager statisticsManager;
    @NotNull
    private final MutableStateFlow<TransportStatistics> transportStatsFlowSource;
    @NotNull
    private final MutableStateFlow<TransportStatistics> transportStats;

    public EnvironmentConnectionImpl(@NotNull DevEnvironment devEnvironment, @NotNull List<? extends DevEnvironmentFeature> devEnvironmentFeatures, @NotNull EnvironmentContentsView contentsView2, @NotNull MutableStateFlow<AgentState> agentState, @NotNull MutableStateFlow<EnvironmentDescription> descriptionState, @NotNull DeploymentTarget forcedDeployTarget, boolean redeploy, @NotNull CoroutineScope outerScope, @NotNull DeployProcess deployProcess, @NotNull SshConnectionService sshConnectionService, @NotNull RemoteToolboxClientFactory clientFactory, @NotNull RawInterfacesFactory rawInterfacesFactory, @NotNull StatisticsManager statisticsManager) {
        Intrinsics.checkNotNullParameter((Object)devEnvironment, (String)"devEnvironment");
        Intrinsics.checkNotNullParameter(devEnvironmentFeatures, (String)"devEnvironmentFeatures");
        Intrinsics.checkNotNullParameter((Object)contentsView2, (String)"contentsView");
        Intrinsics.checkNotNullParameter(agentState, (String)"agentState");
        Intrinsics.checkNotNullParameter(descriptionState, (String)"descriptionState");
        Intrinsics.checkNotNullParameter((Object)forcedDeployTarget, (String)"forcedDeployTarget");
        Intrinsics.checkNotNullParameter((Object)outerScope, (String)"outerScope");
        Intrinsics.checkNotNullParameter((Object)deployProcess, (String)"deployProcess");
        Intrinsics.checkNotNullParameter((Object)sshConnectionService, (String)"sshConnectionService");
        Intrinsics.checkNotNullParameter((Object)clientFactory, (String)"clientFactory");
        Intrinsics.checkNotNullParameter((Object)rawInterfacesFactory, (String)"rawInterfacesFactory");
        Intrinsics.checkNotNullParameter((Object)statisticsManager, (String)"statisticsManager");
        super(devEnvironment, agentState, descriptionState, outerScope);
        this.devEnvironmentFeatures = devEnvironmentFeatures;
        this.contentsView = contentsView2;
        this.agentState = agentState;
        this.descriptionState = descriptionState;
        this.forcedDeployTarget = forcedDeployTarget;
        this.redeploy = redeploy;
        this.outerScope = outerScope;
        this.deployProcess = deployProcess;
        this.sshConnectionService = sshConnectionService;
        this.clientFactory = clientFactory;
        this.rawInterfacesFactory = rawInterfacesFactory;
        this.statisticsManager = statisticsManager;
        this.transportStatsFlowSource = StateFlowKt.MutableStateFlow(null);
        this.transportStats = this.transportStatsFlowSource;
    }

    private final FusEnums.RemoteDevConnectionType getFusConnectionType() {
        EnvironmentContentsView environmentContentsView = this.contentsView;
        return environmentContentsView instanceof AgentConnectionBasedEnvironmentContentsView ? FusEnums.RemoteDevConnectionType.AGENT_CONNECTION : (environmentContentsView instanceof SshEnvironmentContentsView ? FusEnums.RemoteDevConnectionType.SSH : FusEnums.RemoteDevConnectionType.UNKNOWN);
    }

    private final void logConnectionFailure(Throwable ex) {
        FusEnums.RemoteDevEnvironmentConnectionError remoteDevEnvironmentConnectionError;
        Throwable throwable = ex;
        if (throwable instanceof DeployError.DeployTimeout) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.TIMEOUT;
        } else if (throwable instanceof DeployError.UntarError) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.AGENT_UNTAR_ISSUE;
        } else if (throwable instanceof DeployError.UploadError) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.AGENT_UPLOAD_ISSUE;
        } else if (throwable instanceof DeployError.DownloadError) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.AGENT_DOWNLOAD_ISSUE;
        } else if (throwable instanceof DeployError.JavaIsMissingError) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.JAVA_MISSING;
        } else if (throwable instanceof DeployError.LaunchError) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.AGENT_LAUNCH_ISSUE;
        } else if (throwable instanceof DeployError.SshDeployFailed) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.SSH_GENERIC_ISSUE;
        } else if (throwable instanceof DeployError.NoDiskSpace) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.NO_DISK_SPACE;
        } else if (throwable instanceof DeployError.SelfCheckError) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.AGENT_SELF_CHECK_FAILED;
        } else if (throwable instanceof ConnectionError.ConnectionRefused) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.CONNECTION_REFUSED;
        } else if (throwable instanceof ConnectionError.ConnectionTimeout) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.CONNECTION_TIMEOUT;
        } else if (throwable instanceof ConnectionError.AuthenticationError) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.SSH_AUTH_ISSUE;
        } else if (throwable instanceof ConnectionError.HostUnreachable) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.HOST_UNREACHABLE;
        } else if (throwable instanceof ConnectionError.UnresolvedHostname) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.UNRESOLVED_HOSTNAME;
        } else if (throwable instanceof ConnectionError.TooWidePermissions) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.SSH_TOO_WIDE_PERMISSIONS;
        } else if (throwable instanceof ConnectionError.InaccessibleFile) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.SSH_INACCESSIBLE_FILE;
        } else if (throwable instanceof ConnectionError.HostKeyVerificationFailed) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.SSH_HOST_KEY_VERIFICATION_FAILED;
        } else if (throwable instanceof ConnectionError.NonZeroExitCode) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.SSH_GENERIC_ISSUE;
        } else if (throwable instanceof ConnectionError.SshAgentConflict) {
            remoteDevEnvironmentConnectionError = FusEnums.RemoteDevEnvironmentConnectionError.SSH_AGENT_CONFLICT;
        } else {
            if (throwable instanceof ConnectionError.CompositeError) {
                Iterable $this$forEach$iv = ((ConnectionError.CompositeError)ex).getErrors();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ConnectionError it = (ConnectionError)element$iv;
                    boolean bl = false;
                    this.logConnectionFailure(it);
                }
                return;
            }
            remoteDevEnvironmentConnectionError = throwable instanceof RpcError.HandshakeFailed ? FusEnums.RemoteDevEnvironmentConnectionError.INCOMPATIBLE_AGENT : (throwable instanceof CancellationException ? FusEnums.RemoteDevEnvironmentConnectionError.CANCELLED : FusEnums.RemoteDevEnvironmentConnectionError.UNSPECIFIED);
        }
        FusEnums.RemoteDevEnvironmentConnectionError errorReportType = remoteDevEnvironmentConnectionError;
        this.statisticsManager.getLogger().logVararg(Fus.Counters.RemoteDev.INSTANCE.getEnvironmentConnectionFailed(), arg_0 -> EnvironmentConnectionImpl.logConnectionFailure$lambda$1(this, errorReportType, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object connectImpl(@NotNull Continuation<? super ConnectionResult> $completion) {
        if (!($completion instanceof connectImpl.1)) ** GOTO lbl-1000
        var14_2 = $completion;
        if ((var14_2.label & -2147483648) != 0) {
            var14_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                int I$1;
                int I$2;
                Object L$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ EnvironmentConnectionImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.connectImpl((Continuation<? super ConnectionResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$measureTimedValue = 0;
                $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
                $i$f$measureTimedValue = 0;
                mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
                $i$a$-measureTimedValue-EnvironmentConnectionImpl$connectImpl$ri$1 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$measureTimedValue$iv$iv);
                $continuation.I$0 = $i$f$measureTimedValue;
                $continuation.I$1 = $i$f$measureTimedValue;
                $continuation.J$0 = mark$iv$iv;
                $continuation.I$2 = $i$a$-measureTimedValue-EnvironmentConnectionImpl$connectImpl$ri$1;
                $continuation.label = 1;
                v0 = this.getRpcClient(this.redeploy, (Continuation<? super Pair<? extends ToolboxKrpcClient, ? extends HostTunnelConnector>>)$continuation);
                ** if (v0 != var15_4) goto lbl28
lbl27:
                // 1 sources

                return var15_4;
lbl28:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                $i$a$-measureTimedValue-EnvironmentConnectionImpl$connectImpl$ri$1 = $continuation.I$2;
                mark$iv$iv = $continuation.J$0;
                $i$f$measureTimedValue = $continuation.I$1;
                $i$f$measureTimedValue = $continuation.I$0;
                $this$measureTimedValue$iv$iv = (TimeSource.Monotonic)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl39:
                    // 2 sources

                    var9_13 = (Pair)v0;
                    $i$a$-let-EnvironmentConnectionImpl$connectImpl$ri$1$1 = false;
                    rpcClient = (ToolboxKrpcClient)var9_13.component1();
                    hostTunnelConnector = (HostTunnelConnector)var9_13.component2();
                    JobKt.getJob((CoroutineContext)rpcClient.getCoroutineContext()).invokeOnCompletion((Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, connectImpl$lambda$0$0$0(com.jetbrains.toolbox.gateway.wrapper.EnvironmentConnectionImpl java.lang.Throwable ), (Ljava/lang/Throwable;)Lkotlin/Unit;)((EnvironmentConnectionImpl)this));
                    result$iv$iv = this.rawInterfacesFactory.createRawInterfaces(this.getDevEnvironment(), rpcClient, hostTunnelConnector, this.outerScope);
                    it = $i$f$measureTimedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
                    $i$a$-also-EnvironmentConnectionImpl$connectImpl$ri$2 = false;
                    this.statisticsManager.getLogger().logVararg(Fus.Counters.RemoteDev.INSTANCE.getEnvironmentConnected(), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, connectImpl$lambda$1$0(com.jetbrains.toolbox.gateway.wrapper.EnvironmentConnectionImpl kotlin.time.TimedValue com.jetbrains.toolbox.fus.FusFieldDescriptions$RemoteDevEnvironmentConnectionSuccessEvent ), (Lcom/jetbrains/toolbox/fus/FusFieldDescriptions$RemoteDevEnvironmentConnectionSuccessEvent;)Lkotlin/Unit;)((EnvironmentConnectionImpl)this, (TimedValue)it));
                    ri = (RawInterfaces)$i$f$measureTimedValue.getValue();
                    return new ConnectionResult.Success(ri);
                }
                catch (Throwable ex) {
                    this.logConnectionFailure(ex);
                    if (this.redeploy || !(ex instanceof RpcError.HandshakeFailed)) ** GOTO lbl68
                    failedHandshake = ((RpcError.HandshakeFailed)ex).getFailedHandshake();
                    if (failedHandshake instanceof HandshakeResult.Error && this.contentsView.getSupportsRedeploy()) {
                        v1 = ConnectionResult.Redeploy.INSTANCE;
                    } else if (failedHandshake instanceof HandshakeResult.ClientFailure && ((HandshakeResult.ClientFailure)failedHandshake).getRedeploy()) {
                        v1 = ConnectionResult.Redeploy.INSTANCE;
                    } else {
                        throw ex;
lbl68:
                        // 1 sources

                        throw ex;
                    }
                    return v1;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getRpcClient(boolean redeploy, Continuation<? super Pair<? extends ToolboxKrpcClient, ? extends HostTunnelConnector>> $completion) {
        block17: {
            if (!($completion instanceof getRpcClient.1)) ** GOTO lbl-1000
            var10_3 = $completion;
            if ((var10_3.label & -2147483648) != 0) {
                var10_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    boolean Z$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ EnvironmentConnectionImpl this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return EnvironmentConnectionImpl.access$getRpcClient(this.this$0, false, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var3_6 = this.contentsView;
                    if (!(var3_6 instanceof AgentConnectionBasedEnvironmentContentsView)) break;
                    v0 = UtilKt.getConnector(this.contentsView, this.getDevEnvironmentId());
                    if (v0 == null) {
                        throw new IllegalStateException(this.getDevEnvironmentId() + " contents view doesn't provide HostTunnelConnector");
                    }
                    hostTunnelConnector = v0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)hostTunnelConnector);
                    $continuation.Z$0 = redeploy;
                    $continuation.label = 1;
                    v1 = this.handleAgentConnection(((AgentConnectionBasedEnvironmentContentsView)this.contentsView).getAgentConnectionHandle(redeploy != false), hostTunnelConnector, (Continuation<? super Pair<? extends ToolboxKrpcClient, ? extends HostTunnelConnector>>)$continuation);
                    if (v1 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    redeploy = $continuation.Z$0;
                    hostTunnelConnector = (HostTunnelConnector)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl30:
                    // 2 sources

                    return v1;
                }
            }
            if (!(var3_6 instanceof SshEnvironmentContentsView)) break block17;
            $continuation.Z$0 = redeploy;
            $continuation.label = 2;
            v2 = ((SshEnvironmentContentsView)this.contentsView).getConnectionInfo((Continuation)$continuation);
            if (v2 == var11_5) {
                return var11_5;
            }
            ** GOTO lbl42
            {
                case 2: {
                    redeploy = $continuation.Z$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl42:
                    // 2 sources

                    connectionInfo = (SshConnectionInfo)v2;
                    deploymentSettings = ((SshEnvironmentContentsView)this.contentsView).getDeploymentSettings().getDeploymentTarget() == null ? DeploymentSettings.copy$default((DeploymentSettings)((SshEnvironmentContentsView)this.contentsView).getDeploymentSettings(), null, null, (DeploymentTarget)this.forcedDeployTarget, (int)3, null) : ((SshEnvironmentContentsView)this.contentsView).getDeploymentSettings();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connectionInfo);
                    $continuation.L$1 = deploymentSettings;
                    $continuation.Z$0 = redeploy;
                    $continuation.label = 3;
                    v3 = this.sshConnectionService.connect(this.getDevEnvironmentId(), connectionInfo, (Continuation<? super SshConnection>)$continuation);
                    if (v3 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl58
                }
                case 3: {
                    redeploy = $continuation.Z$0;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    connectionInfo = (SshConnectionInfo)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl58:
                    // 2 sources

                    sshConnection = (SshConnection)v3;
                    deployInputs = new DeployProcess.DeploymentInputs(this.getDevEnvironmentId().getEnvironmentId(), sshConnection, this.agentState, this.descriptionState, deploymentSettings, redeploy != false);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connectionInfo);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deploymentSettings);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)sshConnection);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)deployInputs);
                    $continuation.Z$0 = redeploy;
                    $continuation.label = 4;
                    v4 = this.deployProcess.startDeploy(deployInputs, this.getCoroutineContext(), (Continuation<? super DeployProcess.DeploymentOutputs>)$continuation);
                    if (v4 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl78
                }
                case 4: {
                    redeploy = $continuation.Z$0;
                    deployInputs = (DeployProcess.DeploymentInputs)$continuation.L$3;
                    sshConnection = (SshConnection)$continuation.L$2;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    connectionInfo = (SshConnectionInfo)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl78:
                    // 2 sources

                    deployOutput = (DeployProcess.DeploymentOutputs)v4;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)connectionInfo);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deploymentSettings);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)sshConnection);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)deployInputs);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)deployOutput);
                    $continuation.Z$0 = redeploy;
                    $continuation.label = 5;
                    v5 = this.handleDeployOutput(deployOutput, (Continuation<? super Pair<? extends ToolboxKrpcClient, ? extends HostTunnelConnector>>)$continuation);
                    if (v5 == var11_5) {
                        return var11_5;
                    }
                    ** GOTO lbl99
                }
                case 5: {
                    redeploy = $continuation.Z$0;
                    deployOutput = (DeployProcess.DeploymentOutputs)$continuation.L$4;
                    deployInputs = (DeployProcess.DeploymentInputs)$continuation.L$3;
                    sshConnection = (SshConnection)$continuation.L$2;
                    deploymentSettings = (DeploymentSettings)$continuation.L$1;
                    connectionInfo = (SshConnectionInfo)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl99:
                    // 2 sources

                    return v5;
                }
            }
        }
        if (var3_6 instanceof ManualEnvironmentContentsView) {
            throw new IllegalStateException("Contents view should implement at least one trait other than ManualEnvironmentContentsView");
        }
        throw new IllegalStateException(this.contentsView.getClass() + " doesn't implement proper EnvironmentContentsView interfaces");
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object handleDeployOutput(DeployProcess.DeploymentOutputs deployOutput, Continuation<? super Pair<? extends ToolboxKrpcClient, ? extends HostTunnelConnector>> $completion) {
        AgentConnectionHandle agentConnectionHandle = deployOutput.getAgentConnectionHandle();
        HostTunnelConnector connector = deployOutput.getTunnelConnector();
        return this.handleAgentConnection(agentConnectionHandle, connector, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleAgentConnection(AgentConnectionHandle agentConnectionHandle, HostTunnelConnector connector, Continuation<? super Pair<? extends ToolboxKrpcClient, ? extends HostTunnelConnector>> $completion) {
        if (!($completion instanceof handleAgentConnection.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ EnvironmentConnectionImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EnvironmentConnectionImpl.access$handleAgentConnection(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("Connection cleanup " + this.getDevEnvironmentId())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, agentConnectionHandle, null){
                    int label;
                    final /* synthetic */ EnvironmentConnectionImpl this$0;
                    final /* synthetic */ AgentConnectionHandle $agentConnectionHandle;
                    {
                        this.this$0 = $receiver;
                        this.$agentConnectionHandle = $agentConnectionHandle;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = this.this$0.getConnectionJob().join((Continuation)this);
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                Logger.INSTANCE.debug("Cleaning up the connection in environment " + this.this$0.getDevEnvironmentId());
                                this.label = 2;
                                v1 = this.$agentConnectionHandle.close((Continuation)this);
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl22
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl22:
                                // 2 sources

                                Logger.INSTANCE.debug("Finished cleaning up the connection in environment " + this.this$0.getDevEnvironmentId());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                v0 = UtilKt.getConnector(this.contentsView, this.getDevEnvironmentId());
                if (v0 == null) {
                    v0 = connector;
                }
                connector = v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)agentConnectionHandle);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)connector);
                $continuation.L$2 = connector;
                $continuation.label = 1;
                v1 = this.establishRpcConnection(agentConnectionHandle, (Continuation<? super ToolboxKrpcClient>)$continuation);
                if (v1 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                connector = (HostTunnelConnector)$continuation.L$2;
                connector = (HostTunnelConnector)$continuation.L$1;
                agentConnectionHandle = (AgentConnectionHandle)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                return TuplesKt.to((Object)v1, (Object)connector);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object establishRpcConnection(AgentConnectionHandle agentConnectionHandle, Continuation<? super ToolboxKrpcClient> $completion) {
        if (!($completion instanceof establishRpcConnection.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ EnvironmentConnectionImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return EnvironmentConnectionImpl.access$establishRpcConnection(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)agentConnectionHandle);
                $continuation.label = 1;
                v0 = agentConnectionHandle.getAgentConnection((Continuation)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                agentConnectionHandle = (AgentConnectionHandle)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                remoteToolboxProcess = UtilKt.toRemoteToolboxProcess((AgentConnection)v0, this.getDevEnvironmentId().getEnvironmentId());
                BuildersKt.launch$default((CoroutineScope)this.getEnvironmentConnectionScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(remoteToolboxProcess, this, null){
                    int label;
                    final /* synthetic */ RemoteToolboxProcess $remoteToolboxProcess;
                    final /* synthetic */ EnvironmentConnectionImpl this$0;
                    {
                        this.$remoteToolboxProcess = $remoteToolboxProcess;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = FlowKt.collectLatest((Flow)((Flow)this.$remoteToolboxProcess.getTransportStats()), (Function2)((Function2)new Function2<TransportStatistics, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    /* synthetic */ Object L$0;
                                    final /* synthetic */ EnvironmentConnectionImpl this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        TransportStatistics transportStatistics = (TransportStatistics)this.L$0;
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                void it;
                                                ResultKt.throwOnFailure((Object)$result);
                                                EnvironmentConnectionImpl.access$getTransportStatsFlowSource$p(this.this$0).setValue((Object)it);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value2;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(TransportStatistics p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                client = Build.INSTANCE.isSNAPSHOT() != false ? this.clientFactory.create(remoteToolboxProcess, this.contentsView.getSupportsRedeploy(), this.getEnvironmentConnectionScope()) : this.clientFactory.create(remoteToolboxProcess, this.contentsView.getSupportsRedeploy(), this.getEnvironmentConnectionScope());
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)agentConnectionHandle);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)remoteToolboxProcess);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.label = 2;
                v1 = client.connect((Continuation<? super RpcConnectionResult>)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl40
            }
            case 2: {
                client = (RemoteToolboxClient)$continuation.L$2;
                remoteToolboxProcess = (RemoteToolboxProcess)$continuation.L$1;
                agentConnectionHandle = (AgentConnectionHandle)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl40:
                // 2 sources

                if ((connectionResult = (RpcConnectionResult)v1) instanceof RpcConnectionResult.Failure) {
                    Logger.INSTANCE.warn("Handshake failed for host " + this.getDevEnvironmentId().getEnvironmentId() + ": " + ((RpcConnectionResult.Failure)connectionResult).getHandshakeFailure().retrieveErrorMessage());
                    throw new RpcError.HandshakeFailed(this.devEnvironmentFeatures, ((RpcConnectionResult.Failure)connectionResult).getHandshakeFailure());
                }
                if (!(connectionResult instanceof RpcConnectionResult.Success)) {
                    throw new NoWhenBranchMatchedException();
                }
                return ((RpcConnectionResult.Success)connectionResult).getClient();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public MutableStateFlow<TransportStatistics> getTransportStats() {
        return this.transportStats;
    }

    private static final Unit logConnectionFailure$lambda$1(EnvironmentConnectionImpl this$0, FusEnums.RemoteDevEnvironmentConnectionError $errorReportType, FusFieldDescriptions.RemoteDevEnvironmentConnectionIssueEvent $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setPluginId(HasRawPluginIdKt.getFusId(DevEnvironmentProviderId.box-impl(this$0.getDevEnvironmentId().getProviderId-rwbms5E())));
        $this$logVararg.setEnvironmentId(this$0.getDevEnvironmentId().getEnvironmentId());
        $this$logVararg.setCause($errorReportType);
        $this$logVararg.setConnectionType(this$0.getFusConnectionType());
        return Unit.INSTANCE;
    }

    private static final Unit connectImpl$lambda$0$0$0(EnvironmentConnectionImpl this$0, Throwable it) {
        Logger.INSTANCE.info("RPC to environment: " + this$0.getDevEnvironmentId() + " finished. Cancelling the connection scope");
        Job.DefaultImpls.cancel$default((Job)((Job)this$0.getConnectionJob()), null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit connectImpl$lambda$1$0(EnvironmentConnectionImpl this$0, TimedValue $it, FusFieldDescriptions.RemoteDevEnvironmentConnectionSuccessEvent $this$logVararg) {
        Intrinsics.checkNotNullParameter((Object)$this$logVararg, (String)"$this$logVararg");
        $this$logVararg.setPluginId(HasRawPluginIdKt.getFusId(DevEnvironmentProviderId.box-impl(this$0.getDevEnvironmentId().getProviderId-rwbms5E())));
        $this$logVararg.setEnvironmentId(this$0.getDevEnvironmentId().getEnvironmentId());
        $this$logVararg.setDuration(Duration.getInWholeMilliseconds-impl((long)$it.getDuration-UwyO8pc()));
        $this$logVararg.setConnectionType(this$0.getFusConnectionType());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$getRpcClient(EnvironmentConnectionImpl $this, boolean redeploy, Continuation $completion) {
        return $this.getRpcClient(redeploy, (Continuation<? super Pair<? extends ToolboxKrpcClient, ? extends HostTunnelConnector>>)$completion);
    }

    public static final /* synthetic */ Object access$handleDeployOutput(EnvironmentConnectionImpl $this, DeployProcess.DeploymentOutputs deployOutput, Continuation $completion) {
        return $this.handleDeployOutput(deployOutput, (Continuation<? super Pair<? extends ToolboxKrpcClient, ? extends HostTunnelConnector>>)$completion);
    }

    public static final /* synthetic */ Object access$handleAgentConnection(EnvironmentConnectionImpl $this, AgentConnectionHandle agentConnectionHandle, HostTunnelConnector connector, Continuation $completion) {
        return $this.handleAgentConnection(agentConnectionHandle, connector, (Continuation<? super Pair<? extends ToolboxKrpcClient, ? extends HostTunnelConnector>>)$completion);
    }

    public static final /* synthetic */ Object access$establishRpcConnection(EnvironmentConnectionImpl $this, AgentConnectionHandle agentConnectionHandle, Continuation $completion) {
        return $this.establishRpcConnection(agentConnectionHandle, (Continuation<? super ToolboxKrpcClient>)$completion);
    }

    public static final /* synthetic */ MutableStateFlow access$getTransportStatsFlowSource$p(EnvironmentConnectionImpl $this) {
        return $this.transportStatsFlowSource;
    }
}

