/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh.autocompletion;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.gateway.ProjectStub;
import com.jetbrains.toolbox.gateway.ssh.autocompletion.AutocompletionData;
import com.jetbrains.toolbox.gateway.ssh.autocompletion.SshAutocompletionProvider;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfig;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfigs;
import com.jetbrains.toolbox.gateway.ssh.hints.IdePathsService;
import com.jetbrains.toolbox.gateway.ssh.presentation.UtilKt;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSshAutocompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshAutocompletionProvider.kt\ncom/jetbrains/toolbox/gateway/ssh/autocompletion/ImportedSshAutocompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1193#2,2:41\n1267#2,4:43\n1617#2,9:47\n1869#2:56\n1870#2:58\n1626#2:59\n1#3:57\n*S KotlinDebug\n*F\n+ 1 SshAutocompletionProvider.kt\ncom/jetbrains/toolbox/gateway/ssh/autocompletion/ImportedSshAutocompletionProvider\n*L\n24#1:41,2\n24#1:43,4\n27#1:47,9\n27#1:56\n27#1:58\n27#1:59\n27#1:57\n*E\n"})
public final class ImportedSshAutocompletionProvider
implements SshAutocompletionProvider {
    @NotNull
    private final ImportedSshConfigs configs;
    @NotNull
    private final IdePathsService idePathsService;
    @NotNull
    private final LocalizableString name;

    public ImportedSshAutocompletionProvider(@NotNull ImportedSshConfigs configs, @NotNull IdePathsService idePathsService) {
        Intrinsics.checkNotNullParameter((Object)configs, (String)"configs");
        Intrinsics.checkNotNullParameter((Object)idePathsService, (String)"idePathsService");
        this.configs = configs;
        this.idePathsService = idePathsService;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"configs", (Object)this.configs.source())};
        this.name = LocalizableStringExKt.trl("From {{configs}}", pairArray);
    }

    @Override
    @NotNull
    public LocalizableString getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, AutocompletionData> getAutocompletions() {
        void $this$associateTo$iv$iv;
        List<ImportedSshConfig> list2 = this.configs.configs();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"configs(...)");
        Iterable $this$associate$iv = list2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            ImportedSshConfig config2 = (ImportedSshConfig)element$iv$iv;
            boolean bl = false;
            SshConnectionInfo sshConnectionInfo = config2.sshConnectionInfo();
            Intrinsics.checkNotNullExpressionValue((Object)sshConnectionInfo, (String)"sshConnectionInfo(...)");
            String name2 = UtilKt.defaultPresentableName(sshConnectionInfo);
            Function1 onCreate = arg_0 -> ImportedSshAutocompletionProvider.getAutocompletions$lambda$0$0(config2, this, arg_0);
            SshConnectionInfo sshConnectionInfo2 = config2.sshConnectionInfo();
            Intrinsics.checkNotNullExpressionValue((Object)sshConnectionInfo2, (String)"sshConnectionInfo(...)");
            Pair pair = TuplesKt.to((Object)name2, (Object)new AutocompletionData(sshConnectionInfo2, (Function1<? super String, Unit>)onCreate));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public void delete(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getAutocompletions$lambda$0$0(ImportedSshConfig $config, ImportedSshAutocompletionProvider this$0, String it) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<ProjectStub> list2 = $config.recentProjects();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"recentProjects(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ProjectStub it2 = (ProjectStub)element$iv$iv;
            boolean bl2 = false;
            if (it2.getIdePath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List idePaths = (List)destination$iv$iv;
        this$0.idePathsService.registerIdePaths(it, idePaths);
        return Unit.INSTANCE;
    }
}

