/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.api.core.PluginSettingsStore;
import com.jetbrains.toolbox.api.core.ServiceLocator;
import com.jetbrains.toolbox.api.core.os.LocalDesktopManager;
import com.jetbrains.toolbox.api.core.util.LoadableState;
import com.jetbrains.toolbox.api.core.util.LoadableStateKt;
import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.api.remoteDev.AbstractRemoteProvider;
import com.jetbrains.toolbox.api.remoteDev.ProviderVisibilityState;
import com.jetbrains.toolbox.api.remoteDev.connection.ClientHelper;
import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.api.remoteDev.ssh.validation.SshConnectionValidator;
import com.jetbrains.toolbox.api.remoteDev.ssh.validation.SshValidationFailure;
import com.jetbrains.toolbox.api.remoteDev.ui.EnvironmentUiPageManager;
import com.jetbrains.toolbox.api.ui.ToolboxUi;
import com.jetbrains.toolbox.api.ui.actions.ActionDescription;
import com.jetbrains.toolbox.api.ui.actions.RunnableActionDescription;
import com.jetbrains.toolbox.api.ui.components.TextFieldKt;
import com.jetbrains.toolbox.api.ui.components.TextFieldMutable;
import com.jetbrains.toolbox.api.ui.components.TextType;
import com.jetbrains.toolbox.api.ui.components.UiField;
import com.jetbrains.toolbox.api.ui.components.UiPage;
import com.jetbrains.toolbox.api.ui.components.ValidationResult;
import com.jetbrains.toolbox.common.coroutines.flow.SingleStateFlow;
import com.jetbrains.toolbox.gateway.DialogService;
import com.jetbrains.toolbox.gateway.ProjectStub;
import com.jetbrains.toolbox.gateway.ToolPathRegisterService;
import com.jetbrains.toolbox.gateway.error.ConnectionError;
import com.jetbrains.toolbox.gateway.error.DuplicateEnvironmentError;
import com.jetbrains.toolbox.gateway.error.EnvironmentError;
import com.jetbrains.toolbox.gateway.hints.EnvironmentHint;
import com.jetbrains.toolbox.gateway.hints.EnvironmentHintService;
import com.jetbrains.toolbox.gateway.ssh.SshConfigPathProvider;
import com.jetbrains.toolbox.gateway.ssh.SshConnectionStringCache;
import com.jetbrains.toolbox.gateway.ssh.SshCustomLinkHandler;
import com.jetbrains.toolbox.gateway.ssh.SshNewEnvPage;
import com.jetbrains.toolbox.gateway.ssh.SshPluginSettingsStore;
import com.jetbrains.toolbox.gateway.ssh.SshRemoteEnvironment;
import com.jetbrains.toolbox.gateway.ssh.SshRemoteProvider;
import com.jetbrains.toolbox.gateway.ssh.UtilKt;
import com.jetbrains.toolbox.gateway.ssh.autocompletion.SshCacheAutocompletionProvider;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfig;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfigProvider;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfigs;
import com.jetbrains.toolbox.gateway.ssh.configImport.OpenSshImportedConfigsProviderFactory;
import com.jetbrains.toolbox.gateway.ssh.hints.IdePathsCache;
import com.jetbrains.toolbox.gateway.ssh.hints.IdePathsService;
import com.jetbrains.toolbox.gateway.ssh.hints.RejectedHintsCache;
import com.jetbrains.toolbox.gateway.ssh.model.Endpoint;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.platform.image.ImageResource;
import com.jetbrains.toolbox.platform.image.ImageResourceKt;
import com.jetbrains.toolbox.platform.resource.ResourceReader;
import com.jetbrains.toolbox.platform.resource.jvm.JvmResourceReaderKt;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSshRemoteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshRemoteProvider.kt\ncom/jetbrains/toolbox/gateway/ssh/SshRemoteProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,444:1\n1#2:445\n1563#3:446\n1634#3,3:447\n1669#3,8:450\n1374#3:458\n1460#3,2:459\n1563#3:461\n1634#3,3:462\n1462#3,3:465\n1374#3:468\n1460#3,2:469\n1563#3:471\n1634#3,3:472\n1462#3,3:475\n*S KotlinDebug\n*F\n+ 1 SshRemoteProvider.kt\ncom/jetbrains/toolbox/gateway/ssh/SshRemoteProvider\n*L\n140#1:446\n140#1:447,3\n146#1:450,8\n247#1:458\n247#1:459,2\n247#1:461\n247#1:462,3\n247#1:465,3\n383#1:468\n383#1:469,2\n384#1:471\n384#1:472,3\n383#1:475,3\n*E\n"})
public final class SshRemoteProvider
extends AbstractRemoteProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope pluginScope;
    @NotNull
    private final PluginSettingsStore settingsStore;
    @NotNull
    private final ServiceLocator serviceLocator;
    @NotNull
    private final Json json;
    @NotNull
    private final MutableStateFlow<LoadableState<List<SshRemoteEnvironment>>> environments;
    private long myTimeout;
    @NotNull
    private final SshConnectionValidator sshConnectionValidator;
    @NotNull
    private final SshConnectionStringCache connectionStringCache;
    @NotNull
    private final OpenSshImportedConfigsProviderFactory openSshImportedConfigsProviderFactory;
    @NotNull
    private final SshCacheAutocompletionProvider sshCacheAutocompletionProvider;
    @NotNull
    private final ToolboxUi toolboxUi;
    @NotNull
    private final EnvironmentUiPageManager environmentUiPageManager;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final RejectedHintsCache rejectedHintsCache;
    @NotNull
    private final EnvironmentHintService environmentHintService;
    @NotNull
    private final ImportedSshConfigProvider intellijImportProvider;
    @NotNull
    private final ToolPathRegisterService idePathRegisterService;
    @NotNull
    private final ClientHelper clientHelper;
    @NotNull
    private final DialogService dialogService;
    @NotNull
    private final LocalizableStringFactory i18n;
    @NotNull
    private final IdePathsCache idePathsCache;
    @NotNull
    private final IdePathsService idePathService;
    @NotNull
    private final MutableStateFlow<List<EnvironmentHint>> currentHintsAll;
    @NotNull
    private final SshConfigPathProvider sshConfigPathProvider;
    @NotNull
    private final LocalDesktopManager localDesktopManager;
    @NotNull
    private final String noEnvironmentsDescription;
    private final boolean canCreateNewEnvironments;
    private final boolean isSingleEnvironment;
    @NotNull
    private final SshNewEnvPage newEnvironmentPage;
    @NotNull
    private static final String timeoutSettingName = "timeoutSeconds";
    @NotNull
    private static final String environmentsJsonSettingName = "envsJson";
    @NotNull
    private static final ImageResource sshLogo = ImageResourceKt.image$default((ResourceReader)JvmResourceReaderKt.jvmResourceReader$default((Object)Companion, null, (int)1, null), (String)"ssh-logo.svg", (boolean)false, (int)2, null);

    public SshRemoteProvider(@NotNull CoroutineScope pluginScope, @NotNull PluginSettingsStore settingsStore, @NotNull ServiceLocator serviceLocator) {
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)settingsStore, (String)"settingsStore");
        Intrinsics.checkNotNullParameter((Object)serviceLocator, (String)"serviceLocator");
        super("SSH");
        this.pluginScope = pluginScope;
        this.settingsStore = settingsStore;
        this.serviceLocator = serviceLocator;
        this.json = JsonKt.Json$default(null, SshRemoteProvider::json$lambda$0, (int)1, null);
        this.environments = StateFlowKt.MutableStateFlow((Object)new LoadableState.Value((Object)CollectionsKt.emptyList()));
        this.myTimeout = 10000L;
        this.sshConnectionValidator = (SshConnectionValidator)this.serviceLocator.getService(SshConnectionValidator.class);
        this.connectionStringCache = new SshConnectionStringCache(this.settingsStore, this.json);
        this.openSshImportedConfigsProviderFactory = (OpenSshImportedConfigsProviderFactory)this.serviceLocator.getService(OpenSshImportedConfigsProviderFactory.class);
        this.sshCacheAutocompletionProvider = new SshCacheAutocompletionProvider(this.connectionStringCache);
        this.toolboxUi = (ToolboxUi)this.serviceLocator.getService(ToolboxUi.class);
        this.environmentUiPageManager = (EnvironmentUiPageManager)this.serviceLocator.getService(EnvironmentUiPageManager.class);
        this.fileSystem = (FileSystem)this.serviceLocator.getService(FileSystem.class);
        this.rejectedHintsCache = new RejectedHintsCache(this.settingsStore, this.json);
        this.environmentHintService = (EnvironmentHintService)this.serviceLocator.getService(EnvironmentHintService.class);
        this.intellijImportProvider = (ImportedSshConfigProvider)this.serviceLocator.getService(ImportedSshConfigProvider.class);
        this.idePathRegisterService = (ToolPathRegisterService)this.serviceLocator.getService(ToolPathRegisterService.class);
        this.clientHelper = (ClientHelper)this.serviceLocator.getService(ClientHelper.class);
        this.dialogService = (DialogService)this.serviceLocator.getService(DialogService.class);
        this.i18n = (LocalizableStringFactory)this.serviceLocator.getService(LocalizableStringFactory.class);
        this.idePathsCache = new IdePathsCache(this.settingsStore, this.json);
        this.idePathService = new IdePathsService(this.idePathsCache, this.idePathRegisterService, this.pluginScope);
        this.currentHintsAll = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.sshConfigPathProvider = new SshConfigPathProvider(this.settingsStore);
        this.localDesktopManager = (LocalDesktopManager)this.serviceLocator.getService(LocalDesktopManager.class);
        this.refreshTimeout();
        this.loadEnvironments();
        this.refreshHints();
        this.noEnvironmentsDescription = "Establish an SSH connection to your remote machine";
        this.canCreateNewEnvironments = true;
        this.newEnvironmentPage = new SshNewEnvPage(this.toolboxUi, sshLogo, this.sshCacheAutocompletionProvider, this.openSshImportedConfigsProviderFactory, this.intellijImportProvider, this.sshConfigPathProvider, this.idePathService, this.json, (Function4<? super String, ? super Endpoint, ? super Function0<Unit>, ? super Function2<? super String, ? super EnvironmentError, Unit>, ? extends Job>)((Function4)new Function4<String, Endpoint, Function0<? extends Unit>, Function2<? super String, ? super EnvironmentError, ? extends Unit>, Job>((Object)this){

            public final Job invoke(String p0, Endpoint p1, Function0<Unit> p2, Function2<? super String, ? super EnvironmentError, Unit> p3) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                Intrinsics.checkNotNullParameter(p3, (String)"p3");
                return SshRemoteProvider.createEnvironment$default((SshRemoteProvider)((Object)this.receiver), p0, p1, p2, p3, false, 16, null);
            }
        }), (Function1<? super String, ? extends Job>)((Function1)new Function1<String, Job>((Object)this){

            public final Job invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return SshRemoteProvider.access$openEnvironmentPage((SshRemoteProvider)((Object)this.receiver), p0);
            }
        }), this.fileSystem, this.pluginScope, this.i18n);
    }

    @NotNull
    public final CoroutineScope getPluginScope() {
        return this.pluginScope;
    }

    private final String asEnvSpecific(String $this$asEnvSpecific, String id) {
        return $this$asEnvSpecific + "_ENV" + id;
    }

    @NotNull
    public MutableStateFlow<LoadableState<List<SshRemoteEnvironment>>> getEnvironments() {
        return this.environments;
    }

    public final void setAutoConnect(@NotNull String devEnvironmentId, boolean autoConnect) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        ((Map)this.settingsStore).put(this.asEnvSpecific("TBX_AUTO_CONNECT", devEnvironmentId), String.valueOf(autoConnect));
    }

    public final boolean getAutoConnect(@NotNull String devEnvironmentId) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        String string = (String)this.settingsStore.get((Object)this.asEnvSpecific("TBX_AUTO_CONNECT", devEnvironmentId));
        return string != null ? Boolean.parseBoolean(string) : false;
    }

    public final long getTimeoutMillis() {
        return this.myTimeout;
    }

    private final void refreshTimeout() {
        Object object = (String)this.settingsStore.get((Object)timeoutSettingName);
        this.myTimeout = (long)(object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 10) * 1000L;
    }

    public void close() {
        this.getEnvironments().setValue((Object)new LoadableState.Value((Object)CollectionsKt.emptyList()));
    }

    public void setVisible(@NotNull ProviderVisibilityState visibilityState) {
        Intrinsics.checkNotNullParameter((Object)visibilityState, (String)"visibilityState");
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(visibilityState, this, null){
            int label;
            final /* synthetic */ ProviderVisibilityState $visibilityState;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.$visibilityState = $visibilityState;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (this.$visibilityState.getProviderVisible()) {
                            SshRemoteProvider.access$refreshHints(this.this$0);
                            SshRemoteProvider.access$getNewEnvironmentPage$p(this.this$0).recalculateItems();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Logger.INSTANCE.debug("Visibility changed " + visibilityState);
    }

    /*
     * Unable to fully structure code
     */
    private final void loadEnvironments() {
        var2_1 = (String)this.settingsStore.get((Object)"envsJson");
        if (var2_1 == null) ** GOTO lbl-1000
        it = var2_1;
        $i$a$-let-SshRemoteProvider$loadEnvironments$existingEnvironments$1 = false;
        var3_5 = (SshPluginSettingsStore)this.json.decodeFromString((DeserializationStrategy)SshPluginSettingsStore.Companion.serializer(), it);
        if (var3_5 != null && (var4_6 = var3_5.getRemotes()) != null) {
            $i$a$-let-SshRemoteProvider$loadEnvironments$existingEnvironments$1 = var4_6;
            $i$f$map = false;
            var8_9 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var13_15 = (Endpoint)item$iv$iv;
                var15_18 = destination$iv$iv;
                $i$a$-map-SshRemoteProvider$loadEnvironments$existingEnvironments$2 = false;
                var15_18.add(new SshRemoteEnvironment(this, (Endpoint)remote, this.i18n));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$distinctBy = false;
            set$iv = new HashSet<String>();
            list$iv = new ArrayList<T>();
            for (T e$iv : $this$distinctBy$iv) {
                it = (SshRemoteEnvironment)e$iv;
                $i$a$-distinctBy-SshRemoteProvider$loadEnvironments$existingEnvironments$3 = false;
                key$iv = it.getId();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            v0 = list$iv;
        } else lbl-1000:
        // 2 sources

        {
            v0 = null;
        }
        v1 = existingEnvironments = v0;
        if (v1 != null) {
            it = v1;
            $i$a$-let-SshRemoteProvider$loadEnvironments$1 = false;
            this.getEnvironments().setValue((Object)new LoadableState.Value(it));
        }
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)LoadableStateKt.filterNotLoading((Flow)((Flow)this.this$0.getEnvironments())), (Function2)((Function2)new Function2<List<? extends SshRemoteEnvironment>, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SshRemoteProvider this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                List list2 = (List)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Collection<Endpoint> collection;
                                        void $this$mapTo$iv$iv;
                                        void $this$map$iv;
                                        void state2;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Iterable iterable = (Iterable)state2;
                                        SerializationStrategy serializationStrategy = (SerializationStrategy)SshPluginSettingsStore.Companion.serializer();
                                        Json json2 = SshRemoteProvider.access$getJson$p(this.this$0);
                                        boolean $i$f$map = false;
                                        void var6_7 = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void it;
                                            SshRemoteEnvironment sshRemoteEnvironment = (SshRemoteEnvironment)((Object)item$iv$iv);
                                            collection = destination$iv$iv;
                                            boolean bl = false;
                                            collection.add(it.getEndpoint());
                                        }
                                        collection = (List)destination$iv$iv;
                                        List list3 = collection;
                                        String sshPluginSettings = json2.encodeToString(serializationStrategy, (Object)new SshPluginSettingsStore(list3));
                                        ((Map)SshRemoteProvider.access$getSettingsStore$p(this.this$0)).put("envsJson", sshPluginSettings);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(List<SshRemoteEnvironment> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collect((Flow)FlowKt.combine((Flow)LoadableStateKt.filterNotLoading((Flow)((Flow)this.this$0.getEnvironments())), (Flow)((Flow)SshRemoteProvider.access$getCurrentHintsAll$p(this.this$0)), (Function3)((Function3)new Function3<List<? extends SshRemoteEnvironment>, List<? extends EnvironmentHint>, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            /* synthetic */ Object L$1;
                            final /* synthetic */ SshRemoteProvider this$0;
                            {
                                this.this$0 = $receiver;
                                super(3, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                List list2 = (List)this.L$0;
                                List list3 = (List)this.L$1;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$filterNotTo$iv$iv;
                                        void $this$filterNot$iv;
                                        void hints2;
                                        Object object;
                                        void $this$mapTo$iv$iv;
                                        void envs;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Set<String> rejected = SshRemoteProvider.access$getRejectedHintsCache$p(this.this$0).get();
                                        Iterable $this$map$iv = (Iterable)envs;
                                        boolean $i$f$map = false;
                                        Iterable iterable = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void environment;
                                            SshRemoteEnvironment sshRemoteEnvironment = (SshRemoteEnvironment)((Object)item$iv$iv);
                                            object = destination$iv$iv;
                                            boolean bl = false;
                                            object.add(environment.getName());
                                        }
                                        List currentEnvironmentNames = (List)destination$iv$iv;
                                        $this$map$iv = (Iterable)hints2;
                                        object = SshRemoteProvider.access$getEnvironmentHintService$p(this.this$0);
                                        boolean $i$f$filterNot = false;
                                        $this$mapTo$iv$iv = $this$filterNot$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        boolean $i$f$filterNotTo = false;
                                        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                            EnvironmentHint it = (EnvironmentHint)element$iv$iv;
                                            boolean bl = false;
                                            if (rejected.contains(it.getId()) || currentEnvironmentNames.contains(it.getName())) continue;
                                            destination$iv$iv.add(element$iv$iv);
                                        }
                                        object.setEnvironmentHints((List)destination$iv$iv);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(List<SshRemoteEnvironment> p1, List<? extends EnvironmentHint> p2, Continuation<? super Unit> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p1;
                                var4_4.L$1 = p2;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        })), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public ImageResource getIconResource() {
        return sshLogo;
    }

    @NotNull
    public ImageResource getNoEnvironmentsIconResource() {
        return sshLogo;
    }

    @NotNull
    public String getNoEnvironmentsDescription() {
        return this.noEnvironmentsDescription;
    }

    public boolean getCanCreateNewEnvironments() {
        return this.canCreateNewEnvironments;
    }

    public boolean isSingleEnvironment() {
        return this.isSingleEnvironment;
    }

    private final Job createEnvironment(String singleInputValue, Endpoint endpoint, Function0<Unit> onStart, Function2<? super String, ? super EnvironmentError, Unit> onEnd, boolean withValidation) {
        return BuildersKt.launch$default((CoroutineScope)this.pluginScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onStart, this, endpoint, onEnd, singleInputValue, withValidation, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ Function0<Unit> $onStart;
            final /* synthetic */ SshRemoteProvider this$0;
            final /* synthetic */ Endpoint $endpoint;
            final /* synthetic */ Function2<String, EnvironmentError, Unit> $onEnd;
            final /* synthetic */ String $singleInputValue;
            final /* synthetic */ boolean $withValidation;
            {
                this.$onStart = $onStart;
                this.this$0 = $receiver;
                this.$endpoint = $endpoint;
                this.$onEnd = $onEnd;
                this.$singleInputValue = $singleInputValue;
                this.$withValidation = $withValidation;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.$onStart.invoke();
                        environment = new SshRemoteEnvironment(this.this$0, this.$endpoint, SshRemoteProvider.access$getI18n$p(this.this$0));
                        v0 /* !! */  = ((LoadableState)this.this$0.getEnvironments().getValue()).takeIfValue();
                        if (v0 /* !! */  == null || (v0 /* !! */  = (List)v0 /* !! */ .getValue()) == null) ** GOTO lbl20
                        var5_4 = (Iterable)v0 /* !! */ ;
                        for (T var7_6 : var5_4) {
                            it = (SshRemoteEnvironment)var7_6;
                            $i$a$-find-SshRemoteProvider$createEnvironment$1$existingEnvironment$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)environment.getId())) continue;
                            v1 = var7_6;
                            ** GOTO lbl18
                        }
                        v1 = null;
lbl18:
                        // 2 sources

                        v2 = v1;
                        ** GOTO lbl21
lbl20:
                        // 1 sources

                        v2 = existingEnvironment = null;
lbl21:
                        // 2 sources

                        if (existingEnvironment == null) ** GOTO lbl27
                        this.$onEnd.invoke((Object)existingEnvironment.getId(), (Object)new DuplicateEnvironmentError());
                        BuildersKt.launch$default((CoroutineScope)this.this$0.getPluginScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(existingEnvironment, null){
                            int label;
                            final /* synthetic */ SshRemoteEnvironment $existingEnvironment;
                            {
                                this.$existingEnvironment = $existingEnvironment;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.$existingEnvironment.connect((Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        ** GOTO lbl46
lbl27:
                        // 1 sources

                        this.L$0 = environment;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)existingEnvironment);
                        this.label = 1;
                        v3 = SshRemoteProvider.access$addEnvironment(this.this$0, environment, this.$singleInputValue, this.$endpoint, this.$withValidation, (Continuation)this);
                        if (v3 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl39
                    }
                    case 1: {
                        existingEnvironment = (SshRemoteEnvironment)this.L$1;
                        environment = (SshRemoteEnvironment)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl39:
                        // 2 sources

                        error = (EnvironmentError)v3;
                        this.$onEnd.invoke((Object)environment.getId(), (Object)error);
                        if (error == null) {
                            BuildersKt.launch$default((CoroutineScope)this.this$0.getPluginScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(environment, null){
                                int label;
                                final /* synthetic */ SshRemoteEnvironment $environment;
                                {
                                    this.$environment = $environment;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.$environment.connect((Continuation<? super Unit>)((Continuation)this));
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
                        SshRemoteProvider.access$refreshEnvironments(this.this$0);
lbl46:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    static /* synthetic */ Job createEnvironment$default(SshRemoteProvider sshRemoteProvider, String string, Endpoint endpoint, Function0 function0, Function2 function2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return sshRemoteProvider.createEnvironment(string, endpoint, (Function0<Unit>)function0, (Function2<? super String, ? super EnvironmentError, Unit>)function2, bl);
    }

    /*
     * Unable to fully structure code
     */
    private final Object addEnvironment(SshRemoteEnvironment environment, String singleInputValue, Endpoint endpoint, boolean withValidation, Continuation<? super EnvironmentError> $completion) {
        if (!($completion instanceof addEnvironment.1)) ** GOTO lbl-1000
        var26_6 = $completion;
        if ((var26_6.label & -2147483648) != 0) {
            var26_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ SshRemoteProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return SshRemoteProvider.access$addEnvironment(this.this$0, null, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var27_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!withValidation) ** GOTO lbl44
                endpointWithTimeout = Endpoint.copy$default(endpoint, null, 0, null, null, false, null, null, null, null, null, this.getTimeoutMillis(), 1023, null);
                $continuation.L$0 = environment;
                $continuation.L$1 = singleInputValue;
                $continuation.L$2 = endpoint;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)endpointWithTimeout);
                $continuation.Z$0 = withValidation;
                $continuation.label = 1;
                v0 = this.sshConnectionValidator.validate(SshRemoteEnvironment.Companion.toUsernameHostPortString(endpoint), (SshConnectionInfo)endpointWithTimeout, (Continuation)$continuation);
                ** if (v0 != var27_8) goto lbl25
lbl24:
                // 1 sources

                return var27_8;
lbl25:
                // 1 sources

                ** GOTO lbl36
            }
            case 1: {
                withValidation = $continuation.Z$0;
                endpointWithTimeout = (Endpoint)$continuation.L$3;
                endpoint = (Endpoint)$continuation.L$2;
                singleInputValue = (String)$continuation.L$1;
                environment = (SshRemoteEnvironment)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl36:
                    // 2 sources

                    var8_10 = (List)v0;
                }
                catch (ConnectionError e) {
                    return e;
                }
                validationResult = var8_10;
                if (((Collection)validationResult).isEmpty() == false) {
                    Logger.INSTANCE.warn("Failed to add SSH environment: Connection validation failed");
                    return ConnectionError.Companion.fromSshValidationFailure((List<? extends SshValidationFailure>)validationResult);
                }
lbl44:
                // 3 sources

                if (singleInputValue != null) {
                    v1 = this.openSshImportedConfigsProviderFactory.create(this.sshConfigPathProvider.getConfigPath()).getImportedSshConfigs();
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"getImportedSshConfigs(...)");
                    $this$flatMap$iv = v1;
                    $i$f$flatMap = false;
                    var8_10 = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (ImportedSshConfigs)element$iv$iv;
                        $i$a$-flatMap-SshRemoteProvider$addEnvironment$2 = false;
                        v2 = it.configs();
                        Intrinsics.checkNotNullExpressionValue(v2, (String)"configs(...)");
                        $this$map$iv = v2;
                        $i$f$map = false;
                        var17_22 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var22_27 = (ImportedSshConfig)item$iv$iv;
                            var23_28 = destination$iv$iv;
                            $i$a$-map-SshRemoteProvider$addEnvironment$2$1 = false;
                            var23_28.add(config.alias());
                        }
                        list$iv$iv = (List)destination$iv$iv;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    if (!((List)destination$iv$iv).contains(singleInputValue)) {
                        this.connectionStringCache.add(singleInputValue, endpoint);
                        this.newEnvironmentPage.recalculateItems();
                    }
                }
                this.getEnvironments().setValue((Object)((LoadableState)this.getEnvironments().getValue()).useValue((Object)CollectionsKt.listOf((Object)environment), (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, addEnvironment$lambda$1(com.jetbrains.toolbox.gateway.ssh.SshRemoteEnvironment java.util.List ), (Ljava/util/List;)Ljava/util/List;)((SshRemoteEnvironment)environment)));
                new LoadableState.Value((Object)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)environment), (Object)this.getEnvironments().getValue()));
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Job openEnvironmentPage(String environmentId) {
        return BuildersKt.launch$default((CoroutineScope)this.pluginScope, (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, environmentId, null){
            Object L$1;
            Object L$2;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SshRemoteProvider this$0;
            final /* synthetic */ String $environmentId;
            {
                this.this$0 = $receiver;
                this.$environmentId = $environmentId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 /* !! */  = ((LoadableState)this.this$0.getEnvironments().getValue()).takeIfValue();
                        if (v0 /* !! */  == null || (v0 /* !! */  = (List)v0 /* !! */ .getValue()) == null) break;
                        var3_4 = (Iterable)v0 /* !! */ ;
                        var4_5 /* !! */  = this.$environmentId;
                        var5_6 = var3_4;
                        for (T var7_11 : var5_6) {
                            it = (SshRemoteEnvironment)var7_11;
                            $i$a$-find-SshRemoteProvider$openEnvironmentPage$1$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)var4_5 /* !! */ )) continue;
                            v1 = var7_11;
                            ** GOTO lbl18
                        }
                        v1 = null;
lbl18:
                        // 2 sources

                        if ((v0 /* !! */  = (SshRemoteEnvironment)v1) == null) break;
                        var3_4 = v0 /* !! */ ;
                        var4_5 /* !! */  = this.this$0;
                        environment = var3_4;
                        $i$a$-let-SshRemoteProvider$openEnvironmentPage$1$2 = 0;
                        request = BuildersKt.async$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>((SshRemoteProvider)var4_5 /* !! */ , (SshRemoteEnvironment)environment, null){
                            int label;
                            final /* synthetic */ SshRemoteProvider this$0;
                            final /* synthetic */ SshRemoteEnvironment $environment;
                            {
                                this.this$0 = $receiver;
                                this.$environment = $environment;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = SshRemoteProvider.access$getEnvironmentUiPageManager$p(this.this$0).showEnvironmentPage(this.$environment.getId(), true, (Continuation)this);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((SshRemoteEnvironment)environment, null){
                            int label;
                            final /* synthetic */ SshRemoteEnvironment $environment;
                            {
                                this.$environment = $environment;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.$environment.connect((Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        SshRemoteProvider.access$refreshEnvironments((SshRemoteProvider)var4_5 /* !! */ );
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$launch);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)environment);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                        this.I$0 = $i$a$-let-SshRemoteProvider$openEnvironmentPage$1$2;
                        this.label = 1;
                        v2 = request.await((Continuation)this);
                        if (v2 == var10_3) {
                            return var10_3;
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-let-SshRemoteProvider$openEnvironmentPage$1$2 = this.I$0;
                        request = (Deferred)this.L$2;
                        environment = (SshRemoteEnvironment)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public UiPage getNewEnvironmentUiPage() {
        this.newEnvironmentPage.recalculateItems();
        return this.newEnvironmentPage;
    }

    public void refresh() {
        this.refreshEnvironments();
    }

    public final void removeEnvironment(@NotNull SshRemoteEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, environment, null){
            int label;
            final /* synthetic */ SshRemoteProvider this$0;
            final /* synthetic */ SshRemoteEnvironment $environment;
            {
                this.this$0 = $receiver;
                this.$environment = $environment;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.this$0.getEnvironments().setValue((Object)((LoadableState)this.this$0.getEnvironments().getValue()).map(arg_0 -> removeEnvironment.1.invokeSuspend$lambda$0(this.$environment, arg_0)));
                        SshRemoteProvider.access$refreshEnvironments(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final List invokeSuspend$lambda$0(SshRemoteEnvironment $environment, List envs) {
                return CollectionsKt.minus((Iterable)envs, (Object)((Object)$environment));
            }
        }), (int)3, null);
    }

    private final void refreshEnvironments() {
        this.refreshHints();
    }

    @NotNull
    public StateFlow<List<ActionDescription>> getAdditionalPluginActions() {
        List list2;
        RunnableActionDescription openSshSettingsAction2 = new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                this.label = SshRemoteProvider.access$getI18n$p($receiver).ptrl("SSH Settings");
            }

            public void run() {
                LocalizableString localizableString = SshRemoteProvider.access$getI18n$p(this.this$0).ptrl("SSH Timeout in seconds");
                String string = (String)SshRemoteProvider.access$getSettingsStore$p(this.this$0).get((Object)"timeoutSeconds");
                if (string == null) {
                    string = "10";
                }
                TextFieldMutable timeoutField = TextFieldKt.TextField$default((LocalizableString)localizableString, (String)string, (TextType)TextType.Integer, (boolean)false, null, null, additionalPluginActions.openSshSettingsAction.1::run$lambda$0, (int)56, null);
                Function1 validator = arg_0 -> additionalPluginActions.openSshSettingsAction.1.run$lambda$1(this.this$0, arg_0);
                String currentConfigPath = SshRemoteProvider.access$getSshConfigPathProvider$p(this.this$0).getConfigPath();
                TextFieldMutable configPathField = TextFieldKt.TextField$default((LocalizableString)SshRemoteProvider.access$getI18n$p(this.this$0).ptrl("Custom configuration file path: "), (String)currentConfigPath, null, (boolean)false, null, null, (Function1)validator, (int)60, null);
                LocalizableString localizableString2 = SshRemoteProvider.access$getI18n$p(this.this$0).ptrl("SSH Settings");
                ((ToolboxUi)SshRemoteProvider.access$getServiceLocator$p(this.this$0).getService(ToolboxUi.class)).showUiPage(new UiPage(timeoutField, configPathField, this.this$0, (Function1<? super String, ? extends ValidationResult>)validator, localizableString2){
                    private final StateFlow<List<UiField>> fields;
                    final /* synthetic */ TextFieldMutable $timeoutField;
                    final /* synthetic */ TextFieldMutable $configPathField;
                    final /* synthetic */ SshRemoteProvider this$0;
                    final /* synthetic */ Function1<String, ValidationResult> $validator;
                    {
                        this.$timeoutField = $timeoutField;
                        this.$configPathField = $configPathField;
                        this.this$0 = $receiver;
                        this.$validator = $validator;
                        super($super_call_param$1);
                        Object[] objectArray = new TextFieldMutable[]{$timeoutField, $configPathField};
                        this.fields = new SingleStateFlow<List>(CollectionsKt.listOf((Object[])objectArray));
                    }

                    public StateFlow<List<UiField>> getFields() {
                        return this.fields;
                    }

                    public void afterHide() {
                        Integer n = StringsKt.toIntOrNull((String)((String)this.$timeoutField.getContentState().getValue()));
                        if (n == null) {
                            return;
                        }
                        int timeoutInt = n;
                        ((Map)SshRemoteProvider.access$getSettingsStore$p(this.this$0)).put("timeoutSeconds", String.valueOf(timeoutInt));
                        String path2 = (String)this.$configPathField.getContentState().getValue();
                        if (!Intrinsics.areEqual((Object)this.$validator.invoke((Object)path2), (Object)ValidationResult.Valid.INSTANCE)) {
                            SshRemoteProvider.access$getSshConfigPathProvider$p(this.this$0).setConfigPath("");
                            SshRemoteProvider.access$refreshHints(this.this$0);
                        } else {
                            SshRemoteProvider.access$getSshConfigPathProvider$p(this.this$0).setConfigPath(path2);
                            SshRemoteProvider.access$refreshHints(this.this$0);
                        }
                        SshRemoteProvider.access$getNewEnvironmentPage$p(this.this$0).recalculateItems();
                        SshRemoteProvider.access$refreshTimeout(this.this$0);
                    }
                });
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            private static final ValidationResult run$lambda$0(String it) {
                ValidationResult validationResult;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Companion companion = SshRemoteProvider.Companion;
                String text$iv = it;
                boolean $i$f$validateIntField = false;
                try {
                    String it2 = text$iv;
                    boolean bl = false;
                    Integer.parseInt(it2);
                    validationResult = (ValidationResult)ValidationResult.Valid.INSTANCE;
                }
                catch (NumberFormatException numberFormatException) {
                    validationResult = (ValidationResult)new ValidationResult.Invalid((LocalizableString)LocalizableStringExKt.trl("Invalid number"));
                }
                return validationResult;
            }

            private static final ValidationResult run$lambda$1(SshRemoteProvider this$0, String v) {
                ValidationResult validationResult;
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                if (!StringsKt.isBlank((CharSequence)v)) {
                    Path path2 = Paths.get(v, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    Path path3 = path2;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        Path path4 = Paths.get(v, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                        path3 = path4;
                        linkOptionArray = new LinkOption[]{};
                        validationResult = Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? (ValidationResult)new ValidationResult.Invalid(SshRemoteProvider.access$getI18n$p(this$0).ptrl("Provided file is a directory")) : (ValidationResult)ValidationResult.Valid.INSTANCE;
                    } else {
                        validationResult = (ValidationResult)new ValidationResult.Invalid(SshRemoteProvider.access$getI18n$p(this$0).ptrl("Provided path doesn't exist"));
                    }
                } else {
                    validationResult = (ValidationResult)ValidationResult.Valid.INSTANCE;
                }
                return validationResult;
            }
        };
        RunnableActionDescription openSshConfigAction2 = new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.this$0 = $receiver;
                this.label = SshRemoteProvider.access$getI18n$p($receiver).ptrl("Open SSH config location");
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public void run() {
                LocalDesktopManager localDesktopManager = SshRemoteProvider.access$getLocalDesktopManager$p(this.this$0);
                Path path2 = Paths.get(SshRemoteProvider.access$getSshConfigPathProvider$p(this.this$0).getConfigPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                localDesktopManager.openPath(path2);
            }
        };
        List $this$_get_additionalPluginActions__u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$_get_additionalPluginActions__u24lambda_u240.add(openSshSettingsAction2);
        if (this.fileSystem.exists(Path.Companion.get$default((Path.Companion)okio.Path.Companion, (String)this.sshConfigPathProvider.getConfigPath(), (boolean)false, (int)1, null))) {
            $this$_get_additionalPluginActions__u24lambda_u240.add(openSshConfigAction2);
        }
        List list3 = CollectionsKt.build((List)list2);
        return new SingleStateFlow<List>(list3);
    }

    @Nullable
    protected Object handleCustomUri(@NotNull URI uri, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)this.pluginScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, this, null){
            Object L$0;
            int label;
            final /* synthetic */ URI $uri;
            final /* synthetic */ SshRemoteProvider this$0;
            {
                this.$uri = $uri;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                block11: {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = this.$uri.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPath(...)");
                            var3_3 /* !! */  = new String[]{"/"};
                            path = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)v0, (String[])var3_3 /* !! */ , (boolean)false, (int)0, (int)6, null));
                            var3_3 /* !! */  = path;
                            if (!Intrinsics.areEqual((Object)var3_3 /* !! */ , (Object)"environment")) break;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)path);
                            this.label = 1;
                            v1 = SshCustomLinkHandler.INSTANCE.createEnvironment(this.$uri, SshRemoteProvider.access$getDialogService$p(this.this$0), (Continuation<? super SshCustomLinkHandler.Result>)((Continuation)this));
                            ** if (v1 != var5_2) goto lbl18
lbl17:
                            // 1 sources

                            return var5_2;
lbl18:
                            // 1 sources

                            ** GOTO lbl25
                        }
                        case 1: {
                            path = (String)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl25:
                                // 2 sources

                                if ((result = (SshCustomLinkHandler.Result)v1) == null) {
                                    Logger.INSTANCE.info("User rejected the addition of environment from uri '" + this.$uri + "'");
                                    return Unit.INSTANCE;
                                }
                                SshRemoteProvider.access$getNewEnvironmentPage$p(this.this$0).setUserAndHost(result.getConnectionString());
                                SshRemoteProvider.access$getToolboxUi$p(this.this$0).showWindow();
                                SshRemoteProvider.access$getEnvironmentUiPageManager$p(this.this$0).showPluginEnvironmentsPage(true);
                                SshRemoteProvider.access$getNewEnvironmentPage$p(this.this$0).createEnvironment((Function1<? super String, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.jetbrains.toolbox.gateway.ssh.SshRemoteProvider com.jetbrains.toolbox.gateway.ssh.SshCustomLinkHandler$Result java.lang.String ), (Ljava/lang/String;)Lkotlin/Unit;)((SshRemoteProvider)this.this$0, (SshCustomLinkHandler.Result)result));
                            }
                            catch (IllegalArgumentException e) {
                                Logger.INSTANCE.warn((Throwable)e, "Error during handling link 'uri'.");
                            }
                            break block11;
                        }
                    }
                    if (Intrinsics.areEqual((Object)var3_3 /* !! */ , (Object)"ssh")) {
                        SshRemoteProvider.access$getToolboxUi$p(this.this$0).showWindow();
                        SshRemoteProvider.access$getEnvironmentUiPageManager$p(this.this$0).showPluginEnvironmentsPage();
                    } else {
                        Logger.INSTANCE.warn("Unhandled link: " + this.$uri);
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(SshRemoteProvider this$0, SshCustomLinkHandler.Result $result, String envId) {
                SshRemoteProvider.access$getClientHelper$p(this$0).connectToIde(envId, $result.getIdeHint(), $result.getProjectHint());
                return Unit.INSTANCE;
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshHints() {
        void $this$flatMapTo$iv$iv;
        ImportedSshConfigProvider importedSshConfigProvider = this.openSshImportedConfigsProviderFactory.create(this.sshConfigPathProvider.getConfigPath());
        Intrinsics.checkNotNullExpressionValue((Object)importedSshConfigProvider, (String)"create(...)");
        ImportedSshConfigProvider openSshImportProvider = importedSshConfigProvider;
        List<ImportedSshConfigs> list2 = openSshImportProvider.getImportedSshConfigs();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getImportedSshConfigs(...)");
        List<ImportedSshConfigs> openSshImports = list2;
        List<ImportedSshConfigs> list3 = this.intellijImportProvider.getImportedSshConfigs();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getImportedSshConfigs(...)");
        List<ImportedSshConfigs> intellijImports = list3;
        Iterable $this$flatMap$iv = CollectionsKt.plus((Collection)intellijImports, (Iterable)openSshImports);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ImportedSshConfigs configs = (ImportedSshConfigs)element$iv$iv;
            boolean bl = false;
            List<ImportedSshConfig> list4 = configs.configs();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"configs(...)");
            Iterable $this$map$iv = list4;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void config2;
                ImportedSshConfig importedSshConfig = (ImportedSshConfig)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String id = configs.source() + "_" + config2.id();
                collection.add(new EnvironmentHint(id, (ImportedSshConfig)config2, configs, this){
                    final /* synthetic */ String $id;
                    final /* synthetic */ ImportedSshConfig $config;
                    final /* synthetic */ ImportedSshConfigs $configs;
                    final /* synthetic */ SshRemoteProvider this$0;
                    {
                        this.$id = $id;
                        this.$config = $config;
                        this.$configs = $configs;
                        this.this$0 = $receiver;
                    }

                    public String getId() {
                        return this.$id;
                    }

                    public String getName() {
                        String string = this.$config.alias();
                        if (string == null) {
                            SshConnectionInfo sshConnectionInfo = this.$config.sshConnectionInfo();
                            Intrinsics.checkNotNullExpressionValue((Object)sshConnectionInfo, (String)"sshConnectionInfo(...)");
                            string = com.jetbrains.toolbox.gateway.ssh.presentation.UtilKt.defaultPresentableName(sshConnectionInfo);
                        }
                        return string;
                    }

                    public String getDescription() {
                        return "From " + this.$configs.source();
                    }

                    public List<ProjectStub> getProjectStubs() {
                        List<ProjectStub> list2 = this.$config.recentProjects();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"recentProjects(...)");
                        return list2;
                    }

                    public String getEnvironmentId() {
                        SshConnectionInfo sshConnectionInfo = this.$config.sshConnectionInfo();
                        Intrinsics.checkNotNullExpressionValue((Object)sshConnectionInfo, (String)"sshConnectionInfo(...)");
                        return SshRemoteEnvironment.Companion.toUsernameHostPortString(sshConnectionInfo);
                    }

                    public String getSource() {
                        String string = this.$configs.sourceLabel();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceLabel(...)");
                        return string;
                    }

                    public void accept() {
                        SshConnectionInfo sshConnectionInfo = this.$config.sshConnectionInfo();
                        Intrinsics.checkNotNullExpressionValue((Object)sshConnectionInfo, (String)"sshConnectionInfo(...)");
                        SshRemoteProvider.access$createEnvironment(this.this$0, null, UtilKt.toEndpoint(sshConnectionInfo, this.$config.alias()), refreshHints.hints.1.1.1::accept$lambda$0, (arg_0, arg_1) -> refreshHints.hints.1.1.1.accept$lambda$1(this.this$0, this.$config, arg_0, arg_1), false);
                    }

                    public void reject() {
                        SshRemoteProvider.access$getRejectedHintsCache$p(this.this$0).reject(this.$id);
                        SshRemoteProvider.access$refreshHints(this.this$0);
                    }

                    private static final Unit accept$lambda$0() {
                        return Unit.INSTANCE;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private static final Unit accept$lambda$1(SshRemoteProvider this$0, ImportedSshConfig $config, String id, EnvironmentError error2) {
                        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                        if (error2 == null) {
                            void $this$mapNotNullTo$iv$iv;
                            SshRemoteProvider.access$getRejectedHintsCache$p(this$0).reject(id);
                            SshRemoteProvider.access$refreshHints(this$0);
                            List<ProjectStub> list2 = $config.recentProjects();
                            Intrinsics.checkNotNullExpressionValue(list2, (String)"recentProjects(...)");
                            Iterable $this$mapNotNull$iv = list2;
                            boolean $i$f$mapNotNull = false;
                            Iterable iterable = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                            while (iterator2.hasNext()) {
                                String it$iv$iv;
                                T element$iv$iv$iv;
                                T element$iv$iv = element$iv$iv$iv = iterator2.next();
                                boolean bl = false;
                                ProjectStub it = (ProjectStub)element$iv$iv;
                                boolean bl2 = false;
                                if (it.getIdePath() == null) continue;
                                boolean bl3 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            List idePaths = (List)destination$iv$iv;
                            SshRemoteProvider.access$getIdePathService$p(this$0).registerIdePaths(id, idePaths);
                        }
                        return Unit.INSTANCE;
                    }
                });
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List hints2 = (List)destination$iv$iv;
        this.currentHintsAll.setValue((Object)hints2);
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setLenient(true);
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }

    private static final List addEnvironment$lambda$1(SshRemoteEnvironment $environment, List envs) {
        Intrinsics.checkNotNullParameter((Object)envs, (String)"envs");
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)$environment)), (Iterable)envs);
    }

    public static final /* synthetic */ void access$refreshHints(SshRemoteProvider $this) {
        $this.refreshHints();
    }

    public static final /* synthetic */ SshNewEnvPage access$getNewEnvironmentPage$p(SshRemoteProvider $this) {
        return $this.newEnvironmentPage;
    }

    public static final /* synthetic */ Json access$getJson$p(SshRemoteProvider $this) {
        return $this.json;
    }

    public static final /* synthetic */ PluginSettingsStore access$getSettingsStore$p(SshRemoteProvider $this) {
        return $this.settingsStore;
    }

    public static final /* synthetic */ MutableStateFlow access$getCurrentHintsAll$p(SshRemoteProvider $this) {
        return $this.currentHintsAll;
    }

    public static final /* synthetic */ RejectedHintsCache access$getRejectedHintsCache$p(SshRemoteProvider $this) {
        return $this.rejectedHintsCache;
    }

    public static final /* synthetic */ EnvironmentHintService access$getEnvironmentHintService$p(SshRemoteProvider $this) {
        return $this.environmentHintService;
    }

    public static final /* synthetic */ LocalizableStringFactory access$getI18n$p(SshRemoteProvider $this) {
        return $this.i18n;
    }

    public static final /* synthetic */ Object access$addEnvironment(SshRemoteProvider $this, SshRemoteEnvironment environment, String singleInputValue, Endpoint endpoint, boolean withValidation, Continuation $completion) {
        return $this.addEnvironment(environment, singleInputValue, endpoint, withValidation, (Continuation<? super EnvironmentError>)$completion);
    }

    public static final /* synthetic */ void access$refreshEnvironments(SshRemoteProvider $this) {
        $this.refreshEnvironments();
    }

    public static final /* synthetic */ EnvironmentUiPageManager access$getEnvironmentUiPageManager$p(SshRemoteProvider $this) {
        return $this.environmentUiPageManager;
    }

    public static final /* synthetic */ SshConfigPathProvider access$getSshConfigPathProvider$p(SshRemoteProvider $this) {
        return $this.sshConfigPathProvider;
    }

    public static final /* synthetic */ ServiceLocator access$getServiceLocator$p(SshRemoteProvider $this) {
        return $this.serviceLocator;
    }

    public static final /* synthetic */ void access$refreshTimeout(SshRemoteProvider $this) {
        $this.refreshTimeout();
    }

    public static final /* synthetic */ LocalDesktopManager access$getLocalDesktopManager$p(SshRemoteProvider $this) {
        return $this.localDesktopManager;
    }

    public static final /* synthetic */ DialogService access$getDialogService$p(SshRemoteProvider $this) {
        return $this.dialogService;
    }

    public static final /* synthetic */ ToolboxUi access$getToolboxUi$p(SshRemoteProvider $this) {
        return $this.toolboxUi;
    }

    public static final /* synthetic */ ClientHelper access$getClientHelper$p(SshRemoteProvider $this) {
        return $this.clientHelper;
    }

    public static final /* synthetic */ Job access$createEnvironment(SshRemoteProvider $this, String singleInputValue, Endpoint endpoint, Function0 onStart, Function2 onEnd, boolean withValidation) {
        return $this.createEnvironment(singleInputValue, endpoint, (Function0<Unit>)onStart, (Function2<? super String, ? super EnvironmentError, Unit>)onEnd, withValidation);
    }

    public static final /* synthetic */ IdePathsService access$getIdePathService$p(SshRemoteProvider $this) {
        return $this.idePathService;
    }

    public static final /* synthetic */ Job access$openEnvironmentPage(SshRemoteProvider $this, String environmentId) {
        return $this.openEnvironmentPage(environmentId);
    }

    public static final class Companion {
        private Companion() {
        }

        private final ValidationResult validateIntField(String text2, Function1<? super String, Unit> parser) {
            ValidationResult validationResult;
            boolean $i$f$validateIntField = false;
            try {
                parser.invoke((Object)text2);
                validationResult = (ValidationResult)ValidationResult.Valid.INSTANCE;
            }
            catch (NumberFormatException numberFormatException) {
                validationResult = (ValidationResult)new ValidationResult.Invalid((LocalizableString)LocalizableStringExKt.trl("Invalid number"));
            }
            return validationResult;
        }

        @NotNull
        public final ImageResource getSshLogo() {
            return sshLogo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

