/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.api.localization.LocalizableString;
import com.jetbrains.toolbox.api.localization.LocalizableStringFactory;
import com.jetbrains.toolbox.api.remoteDev.ssh.SshConnectionInfo;
import com.jetbrains.toolbox.api.ui.ToolboxUi;
import com.jetbrains.toolbox.api.ui.actions.RunnableActionDescription;
import com.jetbrains.toolbox.api.ui.components.ActionLinkFieldKt;
import com.jetbrains.toolbox.api.ui.components.ActionLinkFieldMutable;
import com.jetbrains.toolbox.api.ui.components.AutocompleteTextField;
import com.jetbrains.toolbox.api.ui.components.AutocompleteTextFieldKt;
import com.jetbrains.toolbox.api.ui.components.AutocompleteTextFieldMutable;
import com.jetbrains.toolbox.api.ui.components.BaseUiField;
import com.jetbrains.toolbox.api.ui.components.CallToActionFieldKt;
import com.jetbrains.toolbox.api.ui.components.CallToActionFieldMutable;
import com.jetbrains.toolbox.api.ui.components.FieldModifier;
import com.jetbrains.toolbox.api.ui.components.RowGroup;
import com.jetbrains.toolbox.api.ui.components.UiField;
import com.jetbrains.toolbox.api.ui.components.UiPage;
import com.jetbrains.toolbox.api.ui.components.ValidationErrorFieldKt;
import com.jetbrains.toolbox.api.ui.components.ValidationErrorFieldMutable;
import com.jetbrains.toolbox.api.ui.components.ValidationResult;
import com.jetbrains.toolbox.common.coroutines.flow.SingleStateFlow;
import com.jetbrains.toolbox.gateway.error.ConnectionError;
import com.jetbrains.toolbox.gateway.error.DuplicateEnvironmentError;
import com.jetbrains.toolbox.gateway.error.EnvironmentError;
import com.jetbrains.toolbox.gateway.ssh.EndpointCreationResult;
import com.jetbrains.toolbox.gateway.ssh.EndpointFactory;
import com.jetbrains.toolbox.gateway.ssh.SshConfigPathProvider;
import com.jetbrains.toolbox.gateway.ssh.SshNewEnvPage;
import com.jetbrains.toolbox.gateway.ssh.UtilKt;
import com.jetbrains.toolbox.gateway.ssh.autocompletion.AutocompletionData;
import com.jetbrains.toolbox.gateway.ssh.autocompletion.SshAutocompletionProvider;
import com.jetbrains.toolbox.gateway.ssh.autocompletion.SshAutocompletionProviderKt;
import com.jetbrains.toolbox.gateway.ssh.configImport.ImportedSshConfigProvider;
import com.jetbrains.toolbox.gateway.ssh.configImport.OpenSshImportedConfigsProviderFactory;
import com.jetbrains.toolbox.gateway.ssh.hints.IdePathsService;
import com.jetbrains.toolbox.gateway.ssh.model.Endpoint;
import com.jetbrains.toolbox.gateway.ssh.parser.ParsingResult;
import com.jetbrains.toolbox.gateway.ssh.parser.SshConnectionStringParser;
import com.jetbrains.toolbox.i18n.LocalizableStringEx;
import com.jetbrains.toolbox.i18n.LocalizableStringExKt;
import com.jetbrains.toolbox.platform.image.ImageResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.KotlinNothingValueException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.kotlin.Logger;

@SourceDebugExtension(value={"SMAP\nSshNewEnvPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshNewEnvPage.kt\ncom/jetbrains/toolbox/gateway/ssh/SshNewEnvPage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,364:1\n1#2:365\n1374#3:366\n1460#3,2:367\n1462#3,3:373\n1563#3:376\n1634#3,3:377\n808#3,11:380\n295#3,2:391\n1869#3,2:394\n126#4:369\n153#4,3:370\n205#5:393\n*S KotlinDebug\n*F\n+ 1 SshNewEnvPage.kt\ncom/jetbrains/toolbox/gateway/ssh/SshNewEnvPage\n*L\n102#1:366\n102#1:367,2\n102#1:373,3\n117#1:376\n117#1:377,3\n315#1:380,11\n315#1:391,2\n340#1:394,2\n104#1:369\n104#1:370,3\n327#1:393\n*E\n"})
public final class SshNewEnvPage
extends UiPage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ToolboxUi toolboxUi;
    @NotNull
    private final ImageResource iconResource;
    @NotNull
    private final SshAutocompletionProvider sshCacheAutocompletionProvider;
    @NotNull
    private final OpenSshImportedConfigsProviderFactory openSshImportedConfigsProviderFactory;
    @NotNull
    private final ImportedSshConfigProvider intellijImportedConfigProvider;
    @NotNull
    private final SshConfigPathProvider sshConfigPathProvider;
    @NotNull
    private final IdePathsService idePathsService;
    @NotNull
    private final Json json;
    @NotNull
    private final Function4<String, Endpoint, Function0<Unit>, Function2<? super String, ? super EnvironmentError, Unit>, Job> createEnvironment;
    @NotNull
    private final Function1<String, Job> openEnvironmentPage;
    @NotNull
    private final FileSystem fs;
    @NotNull
    private final CoroutineScope pluginScope;
    @NotNull
    private final LocalizableStringFactory i18n;
    @NotNull
    private final MutableStateFlow<Boolean> isBusy;
    @NotNull
    private String defaultUser;
    @NotNull
    private final String defaultHost;
    @NotNull
    private final MutableStateFlow<String> highlightEnvironmentId;
    @NotNull
    private final AtomicReference<Job> connectionJob;
    @NotNull
    private final Map<AutocompleteTextField.AutocompleteItem, AutocompletionData> mutableItems;
    @NotNull
    private final AutocompleteTextFieldMutable currUserHost;
    @NotNull
    private final ValidationErrorFieldMutable errorField;
    @NotNull
    private final ActionLinkFieldMutable errorActionLinkField;
    @NotNull
    private final RowGroup errorRow;
    @NotNull
    private final CallToActionFieldMutable existingEnvironmentField;
    @NotNull
    private final AtomicReference<Job> openingEnvironmentJob;
    @Nullable
    private Function1<? super Throwable, Unit> errorNotifier;
    @NotNull
    private final StateFlow<Boolean> isCancellable;
    @NotNull
    private final StateFlow<List<UiField>> fields;
    @NotNull
    private final createAction.1 createAction;
    @NotNull
    private final StateFlow<List<RunnableActionDescription>> actionButtons;
    @NotNull
    private final StateFlow<Boolean> isBusyCreatingNewEnvironment;
    @NotNull
    private final StateFlow<String> highlightElementId;
    @NotNull
    private static final LocalizableStringEx EMPTY_SSH_ERROR = LocalizableStringExKt.trl("Add the connection string");
    @NotNull
    private static final Companion.emptyRunnableAction.1 emptyRunnableAction = new RunnableActionDescription(){
        private final LocalizableStringEx label;
        {
            this.label = LocalizableStringExKt.trl("Empty");
        }

        public LocalizableStringEx getLabel() {
            return this.label;
        }

        public void run() {
        }
    };

    public SshNewEnvPage(@NotNull ToolboxUi toolboxUi, @NotNull ImageResource iconResource, @NotNull SshAutocompletionProvider sshCacheAutocompletionProvider, @NotNull OpenSshImportedConfigsProviderFactory openSshImportedConfigsProviderFactory, @NotNull ImportedSshConfigProvider intellijImportedConfigProvider, @NotNull SshConfigPathProvider sshConfigPathProvider, @NotNull IdePathsService idePathsService, @NotNull Json json2, @NotNull Function4<? super String, ? super Endpoint, ? super Function0<Unit>, ? super Function2<? super String, ? super EnvironmentError, Unit>, ? extends Job> createEnvironment2, @NotNull Function1<? super String, ? extends Job> openEnvironmentPage2, @NotNull FileSystem fs, @NotNull CoroutineScope pluginScope, @NotNull LocalizableStringFactory i18n) {
        Object[] it;
        Object[] objectArray;
        String string;
        Intrinsics.checkNotNullParameter((Object)toolboxUi, (String)"toolboxUi");
        Intrinsics.checkNotNullParameter((Object)iconResource, (String)"iconResource");
        Intrinsics.checkNotNullParameter((Object)sshCacheAutocompletionProvider, (String)"sshCacheAutocompletionProvider");
        Intrinsics.checkNotNullParameter((Object)openSshImportedConfigsProviderFactory, (String)"openSshImportedConfigsProviderFactory");
        Intrinsics.checkNotNullParameter((Object)intellijImportedConfigProvider, (String)"intellijImportedConfigProvider");
        Intrinsics.checkNotNullParameter((Object)sshConfigPathProvider, (String)"sshConfigPathProvider");
        Intrinsics.checkNotNullParameter((Object)idePathsService, (String)"idePathsService");
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter(createEnvironment2, (String)"createEnvironment");
        Intrinsics.checkNotNullParameter(openEnvironmentPage2, (String)"openEnvironmentPage");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        super(i18n.ptrl("New SSH Connection"));
        this.toolboxUi = toolboxUi;
        this.iconResource = iconResource;
        this.sshCacheAutocompletionProvider = sshCacheAutocompletionProvider;
        this.openSshImportedConfigsProviderFactory = openSshImportedConfigsProviderFactory;
        this.intellijImportedConfigProvider = intellijImportedConfigProvider;
        this.sshConfigPathProvider = sshConfigPathProvider;
        this.idePathsService = idePathsService;
        this.json = json2;
        this.createEnvironment = createEnvironment2;
        this.openEnvironmentPage = openEnvironmentPage2;
        this.fs = fs;
        this.pluginScope = pluginScope;
        this.i18n = i18n;
        this.isBusy = StateFlowKt.MutableStateFlow((Object)false);
        String string2 = System.getProperty("user.name");
        if (string2 == null) {
            string2 = this.defaultUser = "";
        }
        if ((string = System.getenv("TOOLBOX_GATEWAY_SSH_PLUGIN_DEFAULT_SSH_HOST")) == null) {
            string = "";
        }
        this.defaultHost = string;
        this.highlightEnvironmentId = StateFlowKt.MutableStateFlow(null);
        this.connectionJob = new AtomicReference<Object>(null);
        this.mutableItems = new LinkedHashMap();
        this.currUserHost = this.getUserAndHost((String)(((CharSequence)this.defaultUser).length() == 0 || ((CharSequence)this.defaultHost).length() == 0 ? "" : this.defaultUser + "@" + this.defaultHost));
        this.errorField = ValidationErrorFieldKt.ValidationErrorField((LocalizableString)this.i18n.pnotr(""));
        Object[] objectArray2 = objectArray = ActionLinkFieldKt.ActionLinkField((RunnableActionDescription)emptyRunnableAction);
        SshNewEnvPage sshNewEnvPage = this;
        boolean bl = false;
        it.getVisibility().setValue((Object)false);
        sshNewEnvPage.errorActionLinkField = objectArray;
        objectArray = new Object[]{new RowGroup.RowField((UiField)this.errorField, null, 2, null), new RowGroup.RowField((UiField)this.errorActionLinkField, null, 2, null)};
        it = objectArray = new RowGroup((RowGroup.RowField[])objectArray);
        sshNewEnvPage = this;
        boolean bl2 = false;
        it.getVisibility().setValue((Object)false);
        sshNewEnvPage.errorRow = objectArray;
        it = objectArray = CallToActionFieldKt.CallToActionField((LocalizableString)this.i18n.ptrl("The connection already exists"), (RunnableActionDescription)emptyRunnableAction);
        sshNewEnvPage = this;
        boolean bl3 = false;
        it.getVisibility().setValue((Object)false);
        sshNewEnvPage.existingEnvironmentField = objectArray;
        this.openingEnvironmentJob = new AtomicReference<Object>(null);
        BuildersKt.launch$default((CoroutineScope)this.pluginScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SshNewEnvPage this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.currUserHost.getContentState().collect(new FlowCollector(){

                            public final Object emit(String it, Continuation<? super Unit> $completion) {
                                if (((CharSequence)it).length() > 0) {
                                    this$0.resetExistingEnvironmentField();
                                }
                                this$0.resetErrors();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.recalculateItems();
        this.isCancellable = (StateFlow)StateFlowKt.MutableStateFlow((Object)true);
        objectArray = new BaseUiField[]{this.currUserHost, this.errorRow, this.existingEnvironmentField};
        this.fields = new SingleStateFlow<List>(CollectionsKt.listOfNotNull((Object[])objectArray));
        this.createAction = new RunnableActionDescription(this){
            private final LocalizableString label;
            final /* synthetic */ SshNewEnvPage this$0;
            {
                this.this$0 = $receiver;
                this.label = SshNewEnvPage.access$getI18n$p($receiver).ptrl("Create");
            }

            public boolean validate() {
                String userAndHostValue = (String)SshNewEnvPage.access$getCurrUserHost$p(this.this$0).getContentState().getValue();
                if (((CharSequence)userAndHostValue).length() == 0) {
                    SshNewEnvPage.access$updateValidationError(this.this$0, SshNewEnvPage.access$getEMPTY_SSH_ERROR$cp());
                    return false;
                }
                SshNewEnvPage.access$updateValidationError(this.this$0, null);
                Function1 function1 = (Function1)SshNewEnvPage.access$getCurrUserHost$p(this.this$0).getValidatorState().getValue();
                return function1 != null && (function1 = (ValidationResult)function1.invoke((Object)((Object)StringsKt.trim((CharSequence)userAndHostValue)).toString())) != null ? function1.getValid() : false;
            }

            public void run() {
                SshNewEnvPage.createEnvironment$default(this.this$0, null, 1, null);
            }

            public LocalizableString getLabel() {
                return this.label;
            }
        };
        this.actionButtons = new SingleStateFlow<List>(CollectionsKt.listOf((Object)this.createAction));
        this.isBusyCreatingNewEnvironment = (StateFlow)this.isBusy();
        this.highlightElementId = (StateFlow)this.highlightEnvironmentId;
    }

    @NotNull
    public ImageResource getIconResource() {
        return this.iconResource;
    }

    @NotNull
    public MutableStateFlow<Boolean> isBusy() {
        return this.isBusy;
    }

    public final void setUserAndHost(@NotNull String v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.currUserHost.getContentState().setValue((Object)v);
    }

    /*
     * WARNING - void declaration
     */
    public final void recalculateItems() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        ImportedSshConfigProvider importedSshConfigProvider = this.openSshImportedConfigsProviderFactory.create(this.sshConfigPathProvider.getConfigPath());
        Intrinsics.checkNotNullExpressionValue((Object)importedSshConfigProvider, (String)"create(...)");
        ImportedSshConfigProvider openSshImportedConfigProvider = importedSshConfigProvider;
        List providersFromImports = CollectionsKt.plus((Collection)SshAutocompletionProviderKt.toAutocompletionProviders(this.intellijImportedConfigProvider, this.idePathsService), (Iterable)SshAutocompletionProviderKt.toAutocompletionProviders(openSshImportedConfigProvider, this.idePathsService));
        List providers = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.sshCacheAutocompletionProvider), (Iterable)providersFromImports);
        Iterable $this$flatMap$iv = providers;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            SshAutocompletionProvider provider2 = (SshAutocompletionProvider)element$iv$iv;
            boolean bl = false;
            AutocompleteTextField.ItemGroup group = new AutocompleteTextField.ItemGroup(provider2.getName(), null);
            Map<String, AutocompletionData> $this$map$iv2 = provider2.getAutocompletions();
            boolean $i$f$map = false;
            Map<String, AutocompletionData> map2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String connectionString = (String)entry.getKey();
                AutocompletionData sshConfig = (AutocompletionData)entry.getValue();
                collection.add(TuplesKt.to((Object)new AutocompleteTextField.ValueItem(connectionString, group, provider2.canDelete() ? () -> SshNewEnvPage.recalculateItems$lambda$0$0$0(provider2, connectionString, this) : null), (Object)sshConfig));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List items2 = (List)destination$iv$iv;
        $this$flatMap$iv = items2;
        MutableStateFlow mutableStateFlow = this.currUserHost.getValuesState();
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((AutocompleteTextField.ValueItem)it.getFirst());
        }
        mutableStateFlow.setValue((Object)((List)destination$iv$iv));
        this.mutableItems.clear();
        MapsKt.putAll(this.mutableItems, (Iterable)items2);
    }

    private final AutocompleteTextFieldMutable getUserAndHost(String initialValue) {
        return AutocompleteTextFieldKt.AutocompleteTextField((LocalizableString)this.i18n.ptrl("Enter user@host, just host, or an SSH command line"), (String)initialValue, (List)CollectionsKt.emptyList(), (Float)Float.valueOf(1.0f), arg_0 -> SshNewEnvPage.getUserAndHost$lambda$0(this, arg_0));
    }

    private final RunnableActionDescription makeOpenEnvironmentAction(String environmentId) {
        return new RunnableActionDescription(this, environmentId){
            private final LocalizableString label;
            final /* synthetic */ SshNewEnvPage this$0;
            final /* synthetic */ String $environmentId;
            {
                this.this$0 = $receiver;
                this.$environmentId = $environmentId;
                this.label = SshNewEnvPage.access$getI18n$p($receiver).ptrl("Open");
            }

            public LocalizableString getLabel() {
                return this.label;
            }

            public void run() {
                this.this$0.openExistingEnvironment(this.$environmentId);
            }
        };
    }

    private final void setUserAndHostError(boolean isError) {
        if (isError) {
            this.currUserHost.getModifiers().setValue((Object)CollectionsKt.listOf((Object)new FieldModifier.LocalizableError(this.i18n.pnotr(""))));
        } else {
            this.currUserHost.getModifiers().setValue((Object)CollectionsKt.emptyList());
        }
    }

    private final void resetErrors() {
        this.setUserAndHostError(false);
        this.errorRow.getVisibility().setValue((Object)false);
    }

    private final void updateValidationError(LocalizableString message2) {
        block0: {
            this.setUserAndHostError(message2 != null);
            LocalizableString localizableString = message2;
            if (localizableString == null) break block0;
            LocalizableString it = localizableString;
            boolean bl = false;
            this.errorField.getTextState().setValue((Object)it);
            this.errorActionLinkField.getVisibility().setValue((Object)false);
            this.errorRow.getVisibility().setValue((Object)true);
        }
    }

    private final void updateConnectionError(EnvironmentError error2) {
        boolean bl;
        if (error2 == null) {
            this.errorRow.getVisibility().setValue((Object)false);
            bl = false;
        } else if (error2.getDescription() != null || error2 instanceof ConnectionError.CompositeError) {
            RunnableActionDescription showErrorDescription2 = new RunnableActionDescription(this, error2){
                private final LocalizableString label;
                final /* synthetic */ SshNewEnvPage this$0;
                final /* synthetic */ EnvironmentError $error;
                {
                    this.this$0 = $receiver;
                    this.$error = $error;
                    this.label = SshNewEnvPage.access$getI18n$p($receiver).ptrl("Details");
                }

                public LocalizableString getLabel() {
                    return this.label;
                }

                public void run() {
                    BuildersKt.launch$default((CoroutineScope)SshNewEnvPage.access$getPluginScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$error, null){
                        int label;
                        final /* synthetic */ SshNewEnvPage this$0;
                        final /* synthetic */ EnvironmentError $error;
                        {
                            this.this$0 = $receiver;
                            this.$error = $error;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = SshNewEnvPage.access$getToolboxUi$p(this.this$0).showErrorInfoPopup((Throwable)this.$error, (Continuation)this);
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            };
            this.errorField.getTextState().setValue((Object)error2.getLocalized());
            this.errorActionLinkField.getActionState().setValue((Object)showErrorDescription2);
            this.errorActionLinkField.getVisibility().setValue((Object)true);
            this.errorRow.getVisibility().setValue((Object)true);
            bl = true;
        } else {
            this.errorField.getTextState().setValue((Object)error2.getLocalized());
            this.errorActionLinkField.getVisibility().setValue((Object)false);
            this.errorRow.getVisibility().setValue((Object)true);
            bl = true;
        }
        boolean hasError2 = bl;
        this.setUserAndHostError(hasError2);
    }

    private final void setExistingEnvironmentField(String environmentId) {
        this.existingEnvironmentField.getActionState().setValue((Object)this.makeOpenEnvironmentAction(environmentId));
        this.existingEnvironmentField.getVisibility().setValue((Object)true);
        this.highlightEnvironmentId.setValue((Object)environmentId);
    }

    private final void resetExistingEnvironmentField() {
        this.existingEnvironmentField.getVisibility().setValue((Object)false);
        this.highlightEnvironmentId.setValue(null);
    }

    @NotNull
    public StateFlow<Boolean> isCancellable() {
        return this.isCancellable;
    }

    private final void onCreatingEnvironment() {
        this.resetErrors();
        this.resetExistingEnvironmentField();
        this.isBusy().setValue((Object)true);
    }

    private final void onCreatedEnvironment(String id, EnvironmentError error2) {
        block2: {
            block3: {
                EnvironmentError environmentError;
                block1: {
                    this.isBusy().setValue((Object)false);
                    environmentError = error2;
                    if (!(environmentError instanceof ConnectionError)) break block1;
                    this.updateConnectionError(error2);
                    break block2;
                }
                if (!(environmentError instanceof DuplicateEnvironmentError)) break block3;
                this.setExistingEnvironmentField(id);
                break block2;
            }
            if (this.errorNotifier == null || error2 == null) break block2;
            Function1<? super Throwable, Unit> function1 = this.errorNotifier;
            if (function1 != null) {
                function1.invoke((Object)error2);
            }
        }
    }

    public void beforeShow() {
        this.recalculateItems();
    }

    public void afterHide() {
        this.cancel();
        this.resetErrors();
        this.currUserHost.getContentState().setValue((Object)"");
        this.resetExistingEnvironmentField();
    }

    @NotNull
    public StateFlow<List<UiField>> getFields() {
        return this.fields;
    }

    public final void addNewEnvironment(@Nullable String singleInputValue, @NotNull Endpoint endpoint, @NotNull Function1<? super String, Unit> additionalOnCreatedEnvironment) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter(additionalOnCreatedEnvironment, (String)"additionalOnCreatedEnvironment");
        this.connectionJob.updateAndGet(arg_0 -> SshNewEnvPage.addNewEnvironment$lambda$1(this, singleInputValue, endpoint, additionalOnCreatedEnvironment, arg_0));
    }

    public static /* synthetic */ void addNewEnvironment$default(SshNewEnvPage sshNewEnvPage, String string, Endpoint endpoint, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = SshNewEnvPage::addNewEnvironment$lambda$0;
        }
        sshNewEnvPage.addNewEnvironment(string, endpoint, (Function1<? super String, Unit>)function1);
    }

    public final void openExistingEnvironment(@NotNull String environmentId) {
        Intrinsics.checkNotNullParameter((Object)environmentId, (String)"environmentId");
        this.openingEnvironmentJob.updateAndGet(arg_0 -> SshNewEnvPage.openExistingEnvironment$lambda$0(this, environmentId, arg_0));
    }

    public void cancel() {
        Job ongoingJob;
        Job job2 = ongoingJob = this.connectionJob.get();
        if (job2 != null) {
            Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
        }
        this.isBusy().setValue((Object)false);
    }

    /*
     * WARNING - void declaration
     */
    public final void createEnvironment(@NotNull Function1<? super String, Unit> onEnd) {
        AutocompletionData configEntry;
        Object object;
        AutocompletionData autocompletionData;
        Object v0;
        String singleInputValue;
        block14: {
            Iterator $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(onEnd, (String)"onEnd");
            singleInputValue = (String)this.currUserHost.getContentState().getValue();
            if (((CharSequence)singleInputValue).length() == 0) {
                return;
            }
            Iterable $this$filterIsInstance$iv = this.mutableItems.keySet();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof AutocompleteTextField.ValueItem)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AutocompleteTextField.ValueItem it = (AutocompleteTextField.ValueItem)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getValue(), (Object)singleInputValue)) continue;
                v0 = element$iv;
                break block14;
            }
            v0 = null;
        }
        AutocompleteTextField.ValueItem valueItem = v0;
        if (valueItem != null) {
            AutocompleteTextField.ValueItem it = valueItem;
            boolean bl = false;
            autocompletionData = this.mutableItems.get(it);
        } else {
            autocompletionData = null;
        }
        if ((object = (configEntry = autocompletionData)) == null || (object = ((AutocompletionData)object).getInfo()) == null || (object = UtilKt.toEndpoint$default((SshConnectionInfo)object, null, 1, null)) == null) {
            Object element$iv;
            EndpointCreationResult creationResult = EndpointFactory.INSTANCE.create(singleInputValue);
            if (creationResult instanceof EndpointCreationResult.Failure) {
                Logger.INSTANCE.warn("Failed to create environment: " + ((EndpointCreationResult.Failure)creationResult).getReason());
                element$iv = new Pair[]{TuplesKt.to((Object)"reason", (Object)((EndpointCreationResult.Failure)creationResult).getReason())};
                this.updateValidationError(this.i18n.ptrl("Failed to create environment: {{reason}}", element$iv));
                return;
            }
            if (creationResult instanceof EndpointCreationResult.Success) {
                void this_$iv;
                element$iv = this.json;
                Endpoint value$iv = ((EndpointCreationResult.Success)creationResult).getConnectionInfo();
                boolean $i$f$encodeToString = false;
                this_$iv.getSerializersModule();
                Logger.INSTANCE.info("Successfully converted connection string to endpoint info:\n" + this_$iv.encodeToString((SerializationStrategy)Endpoint.Companion.serializer(), (Object)value$iv));
                if (!((Collection)((EndpointCreationResult.Success)creationResult).getIgnoredOptions()).isEmpty()) {
                    Logger.INSTANCE.info("Ignored unused options: " + CollectionsKt.joinToString$default((Iterable)((EndpointCreationResult.Success)creationResult).getIgnoredOptions(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                }
                object = ((EndpointCreationResult.Success)creationResult).getConnectionInfo();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object endpoint = object;
        String string = ((Endpoint)endpoint).getSshConfigPath();
        if (string != null) {
            String path2 = string;
            boolean bl = false;
            if (!this.fs.exists(Path.Companion.get$default((Path.Companion)Path.Companion, (String)path2, (boolean)false, (int)1, null))) {
                Pair[] value$iv = new Pair[]{TuplesKt.to((Object)"path", (Object)path2)};
                this.updateValidationError(this.i18n.ptrl("Config file at path: '{{path}}' doesn't exist", value$iv));
                return;
            }
        }
        List<String> list2 = ((Endpoint)endpoint).getPrivateKeyPaths();
        if (list2 != null) {
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String path3 = (String)element$iv;
                boolean bl = false;
                if (this.fs.exists(Path.Companion.get$default((Path.Companion)Path.Companion, (String)path3, (boolean)false, (int)1, null))) continue;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"path", (Object)path3)};
                this.updateValidationError(this.i18n.ptrl("Key file at path: '{{path}}' doesn't exist", pairArray));
                return;
            }
        }
        this.addNewEnvironment(singleInputValue, (Endpoint)endpoint, (Function1<? super String, Unit>)((Function1)arg_0 -> SshNewEnvPage.createEnvironment$lambda$5(configEntry, this, onEnd, arg_0)));
        this.updateValidationError(null);
    }

    public static /* synthetic */ void createEnvironment$default(SshNewEnvPage sshNewEnvPage, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = SshNewEnvPage::createEnvironment$lambda$0;
        }
        sshNewEnvPage.createEnvironment((Function1<? super String, Unit>)function1);
    }

    @NotNull
    public StateFlow<List<RunnableActionDescription>> getActionButtons() {
        return this.actionButtons;
    }

    public void setActionErrorNotifier(@Nullable Function1<? super Throwable, Unit> notifier) {
        this.errorNotifier = notifier;
    }

    @NotNull
    public StateFlow<Boolean> isBusyCreatingNewEnvironment() {
        return this.isBusyCreatingNewEnvironment;
    }

    @NotNull
    public StateFlow<String> getHighlightElementId() {
        return this.highlightElementId;
    }

    private static final void recalculateItems$lambda$0$0$0(SshAutocompletionProvider $provider, String $connectionString, SshNewEnvPage this$0) {
        $provider.delete($connectionString);
        this$0.recalculateItems();
    }

    private static final ValidationResult getUserAndHost$lambda$0(SshNewEnvPage this$0, String newValue) {
        ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)newValue)).toString();
        ParsingResult parsed = SshConnectionStringParser.INSTANCE.parse(trimmedValue);
        if (parsed instanceof ParsingResult.Success) {
            validationResult = (ValidationResult)ValidationResult.Valid.INSTANCE;
        } else if (parsed instanceof ParsingResult.Failure) {
            validationResult = (ValidationResult)new ValidationResult.Invalid(this$0.i18n.pnotr(((ParsingResult.Failure)parsed).getReason()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ValidationResult result2 = validationResult;
        this$0.updateValidationError(result2.getErrorMessage());
        return result2;
    }

    private static final Unit addNewEnvironment$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Job addNewEnvironment$lambda$1(SshNewEnvPage this$0, String $singleInputValue, Endpoint $endpoint, Function1 $additionalOnCreatedEnvironment, Job previousJob) {
        Job job2;
        Job job3 = previousJob;
        boolean bl = job3 != null ? job3.isActive() : false;
        if (bl) {
            job2 = previousJob;
        } else {
            Job newJob2 = (Job)this$0.createEnvironment.invoke((Object)$singleInputValue, (Object)$endpoint, (Object)new Function0<Unit>((Object)this$0){

                public final void invoke() {
                    SshNewEnvPage.access$onCreatingEnvironment((SshNewEnvPage)((Object)this.receiver));
                }
            }, (arg_0, arg_1) -> SshNewEnvPage.addNewEnvironment$lambda$1$0(this$0, $additionalOnCreatedEnvironment, arg_0, arg_1));
            newJob2.invokeOnCompletion(arg_0 -> SshNewEnvPage.addNewEnvironment$lambda$1$1(this$0, newJob2, arg_0));
            job2 = newJob2;
        }
        return job2;
    }

    private static final Unit addNewEnvironment$lambda$1$0(SshNewEnvPage this$0, Function1 $additionalOnCreatedEnvironment, String id, EnvironmentError error2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this$0.onCreatedEnvironment(id, error2);
        $additionalOnCreatedEnvironment.invoke((Object)id);
        return Unit.INSTANCE;
    }

    private static final Unit addNewEnvironment$lambda$1$1(SshNewEnvPage this$0, Job $newJob, Throwable it) {
        this$0.connectionJob.compareAndSet($newJob, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Job openExistingEnvironment$lambda$0(SshNewEnvPage this$0, String $environmentId, Job previousJob) {
        Job job2;
        Job job3 = previousJob;
        boolean bl = job3 != null ? job3.isActive() : false;
        if (bl) {
            job2 = previousJob;
        } else {
            void var3_3;
            Job newJob2 = (Job)this$0.openEnvironmentPage.invoke((Object)$environmentId);
            newJob2.invokeOnCompletion(arg_0 -> SshNewEnvPage.openExistingEnvironment$lambda$0$0(this$0, newJob2, arg_0));
            job2 = var3_3;
        }
        return job2;
    }

    private static final Unit openExistingEnvironment$lambda$0$0(SshNewEnvPage this$0, Job $newJob, Throwable it) {
        this$0.resetExistingEnvironmentField();
        this$0.openingEnvironmentJob.compareAndSet($newJob, null);
        return Unit.INSTANCE;
    }

    private static final Unit createEnvironment$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit createEnvironment$lambda$5(AutocompletionData $configEntry, SshNewEnvPage this$0, Function1 $onEnd, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Function1<String, Unit> function1 = $configEntry;
        if (function1 != null && (function1 = function1.getOnCreate()) != null) {
            function1.invoke((Object)it);
        }
        if (!((Boolean)this$0.errorRow.getVisibility().getValue()).booleanValue()) {
            this$0.currUserHost.getContentState().setValue((Object)"");
        }
        $onEnd.invoke((Object)it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ LocalizableStringFactory access$getI18n$p(SshNewEnvPage $this) {
        return $this.i18n;
    }

    public static final /* synthetic */ CoroutineScope access$getPluginScope$p(SshNewEnvPage $this) {
        return $this.pluginScope;
    }

    public static final /* synthetic */ ToolboxUi access$getToolboxUi$p(SshNewEnvPage $this) {
        return $this.toolboxUi;
    }

    public static final /* synthetic */ void access$onCreatingEnvironment(SshNewEnvPage $this) {
        $this.onCreatingEnvironment();
    }

    public static final /* synthetic */ void access$updateValidationError(SshNewEnvPage $this, LocalizableString message2) {
        $this.updateValidationError(message2);
    }

    public static final /* synthetic */ LocalizableStringEx access$getEMPTY_SSH_ERROR$cp() {
        return EMPTY_SSH_ERROR;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

