/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.gateway.ssh;

import com.jetbrains.toolbox.api.remoteDev.deploy.DiagnosticInfoCollector;
import com.jetbrains.toolbox.gateway.DevEnvironmentId;
import com.jetbrains.toolbox.gateway.ssh.SshOutputDumpImpl;
import java.util.List;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nSshDiagnosticInfoCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshDiagnosticInfoCollector.kt\ncom/jetbrains/toolbox/gateway/ssh/SshDiagnosticInfoCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,24:1\n1869#2,2:25\n*S KotlinDebug\n*F\n+ 1 SshDiagnosticInfoCollector.kt\ncom/jetbrains/toolbox/gateway/ssh/SshDiagnosticInfoCollector\n*L\n15#1:25,2\n*E\n"})
public final class SshDiagnosticInfoCollector
implements DiagnosticInfoCollector {
    @NotNull
    private final DevEnvironmentId devEnvironmentId;
    @NotNull
    private final SshOutputDumpImpl sshOutputDumpImpl;
    @NotNull
    private final FileSystem fileSystem;

    public SshDiagnosticInfoCollector(@NotNull DevEnvironmentId devEnvironmentId, @NotNull SshOutputDumpImpl sshOutputDumpImpl, @NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)devEnvironmentId, (String)"devEnvironmentId");
        Intrinsics.checkNotNullParameter((Object)sshOutputDumpImpl, (String)"sshOutputDumpImpl");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.devEnvironmentId = devEnvironmentId;
        this.sshOutputDumpImpl = sshOutputDumpImpl;
        this.fileSystem = fileSystem;
    }

    @Nullable
    public Object collectAdditionalDiagnostics(@NotNull java.nio.file.Path logsRootFolder, @NotNull Continuation<? super Unit> $completion) {
        List<Path> sshOutputs = this.sshOutputDumpImpl.getFilesForEnvironment(this.devEnvironmentId);
        if (sshOutputs.isEmpty()) {
            return Unit.INSTANCE;
        }
        Path targetPath = Path.Companion.get$default((Path.Companion)Path.Companion, (java.nio.file.Path)logsRootFolder, (boolean)false, (int)1, null).resolve("sshOutputs");
        this.fileSystem.createDirectory(targetPath);
        Iterable $this$forEach$iv = sshOutputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path sshOutputFile = (Path)element$iv;
            boolean bl = false;
            this.fileSystem.copy(sshOutputFile, targetPath.resolve(sshOutputFile.name()));
        }
        return Unit.INSTANCE;
    }
}

